/*
 * Decompiled with CFR 0.152.
 */
import com.apple.mrj.MRJAboutHandler;
import com.apple.mrj.MRJApplicationUtils;
import com.apple.mrj.MRJFileUtils;
import com.apple.mrj.MRJOSType;
import com.apple.mrj.MRJPrefsHandler;
import com.apple.mrj.MRJQuitHandler;
import java.awt.Adjustable;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;

public final class Hauptdialog
extends AFrame
implements ComponentListener,
MRJQuitHandler,
MRJAboutHandler,
MRJPrefsHandler,
KursReceiver {
    private static final String FENSTERTITEL = "AktienMan 1.99";
    public static final int MINBREITE = 620;
    public static final int MINHOEHE = 300;
    public Window backWindow;
    private static final String CHARTSTR_1D = "1 Tag";
    private static final String CHARTSTR_5D = "5 Tage";
    private static final String CHARTSTR_10D = "10 Tage";
    private static final String CHARTSTR_3M = "3 Monate";
    private static final String CHARTSTR_6M = "6 Monate";
    private static final String CHARTSTR_1Y = "1 Jahr";
    private static final String CHARTSTR_2Y = "2 Jahre";
    private static final String CHARTSTR_3Y = "3 Jahre";
    private static final String CHARTSTR_5Y = "5 Jahre";
    private static final String CHARTSTR_MAX = "max.";
    private int locked = 0;
    private boolean abenabled = false;
    private BenutzerListe benutzerliste;
    private Button buttonVerkaufen;
    private Button buttonAendern;
    private Button buttonMaxkurs;
    private Button buttonInfo;
    private Button buttonAktualisieren;
    private ScrollPane pane;
    private Panel panelText;
    private Panel panelGewinn;
    private Panel panelIndex;
    private Listenbereich panelListe;
    private PopupMenu aktienpopup;
    private MenuItem menuVerkaufen;
    private MenuItem menuAendern;
    private MenuItem menuLoeschen;
    private MenuItem menuInfo;
    private MenuItem menuMaxkurs;
    private MenuItem menuSplitten;
    private MenuItem popVerkaufen;
    private MenuItem popMaxkurs;
    private MenuItem popSplitten;
    private MenuItem popAktualisieren;
    private MenuItem pofoRename;
    private MenuItem pofoDelete;
    private MenuItem menuAkt;
    private Menu menuAktAlle;
    private Menu menuExport;
    private ChartMenu menuChart;
    private ChartMenu popChart;
    private ChartMenu pofoChart;
    private Choice chErloes;
    private Choice buttonChart;
    private Choice lwaehrung;
    private Choice sortby;
    private Choice aktChoice;
    private ProgressCanvas progressCanvas;

    public Hauptdialog() {
        super(FENSTERTITEL);
    }

    public synchronized void setPortfolioTitle(String string) {
        this.setTitle(FENSTERTITEL + string);
    }

    public synchronized void setPortfolioFile(String string) {
        this.benutzerliste.setPortfolioFile(string);
    }

    public synchronized void Lock() {
        ++this.locked;
        this.checkLockButtons();
        this.checkListButtons();
    }

    public synchronized void Unlock() {
        --this.locked;
        this.checkLockButtons();
        this.checkListButtons();
    }

    public synchronized boolean isLocked(boolean bl) {
        if (this.locked > 0) {
            if (bl) {
                this.getToolkit().beep();
            }
            return true;
        }
        return false;
    }

    private synchronized void resolutionCheck() {
        AktienMan.screenSize = this.getToolkit().getScreenSize();
    }

    public synchronized void loadPortfolio(boolean bl) {
        if (this.isLocked(true)) {
            return;
        }
        KursDemon.deleteKursDemon();
        RedrawDemon.getRedrawDemon().clearAllRequests();
        if (this.benutzerliste != null) {
            if (bl) {
                this.saveBenutzerAktien();
            }
            this.benutzerliste.destroy();
        }
        this.loadBenutzerAktien();
        this.benutzerliste.erloesToWaehrung(Waehrungen.getListenWaehrung());
        this.checkListButtons();
        this.disableAktienButtons();
        this.sortby.select(this.getSortBy());
        this.listeUpdate(false, false, true, true);
        this.setErloes(this.getErloes(), false);
        if (AktienMan.properties.getBoolean("Konfig.KursTimeout")) {
            KursDemon.createKursDemon();
        }
    }

    public synchronized void saveBenutzerAktien() {
        BenutzerListe.store(this.benutzerliste);
    }

    private synchronized void loadBenutzerAktien() {
        this.benutzerliste = BenutzerListe.restore(Portfolios.getCurrentFile());
    }

    public void display() {
        this.loadBenutzerAktien();
        this.addErloes(false, 0L);
        this.pack();
        this.setupSize();
        this.listeRedraw(false);
        this.checkListButtons();
        this.sortby.select(this.getSortBy());
        if (SysUtil.isAMac()) {
            MRJApplicationUtils.registerAboutHandler(this);
        }
        if (SysUtil.isMacOSX()) {
            MRJApplicationUtils.registerQuitHandler(this);
            MRJApplicationUtils.registerPrefsHandler(this);
        }
    }

    public void handleAbout() {
        this.callAbout();
    }

    public void handleQuit() {
        this.saveAndExit();
    }

    public void handlePrefs() {
        this.callKonfiguration();
    }

    public void setupFrame() {
        this.resolutionCheck();
        this.addComponentListener(this);
        this.setResizable(true);
    }

    public void setupElements() {
        Serializable serializable;
        this.setLayout(this.gridbag);
        Panel panel = new Panel(this.gridbag);
        Panel panel2 = new Panel(this.gridbag);
        Panel panel3 = new Panel(this.gridbag);
        this.panelIndex = new Panel(this.gridbag);
        this.panelListe = new Listenbereich(this.gridbag);
        this.panelText = new Panel(this.gridbag);
        this.panelGewinn = new Panel(this.gridbag);
        IndexQuelle.addIndices(this.panelIndex);
        this.buttonAktualisieren = new Button(" Aktualisieren ");
        Button button = new Button(" DAX-Kamera ");
        this.buttonAktualisieren.addActionListener(new 1());
        button.addActionListener(new 2());
        this.aktChoice = AktienMan.boersenliste.getChoiceNoFonds();
        this.aktChoice.insert("Alle aktualisieren an:", 0);
        this.aktChoice.addItemListener(new 3());
        AFrame.constrain(panel, this.buttonAktualisieren, 0, 0, 2, 1, 2, 11, 1.0, 0.0, 0, 0, 0, 10);
        AFrame.constrain(panel, this.aktChoice, 2, 0, 1, 1, 2, 11, 1.0, 0.0, 0, 0, 0, 10);
        AFrame.constrain(panel, button, 3, 0, 1, 1, 2, 11, 0.7, 0.0, 0, 10, 0, 0);
        AFrame.constrain(panel2, new Label("W\u00e4hrung:"), 0, 0, 1, 1, 0, 17, 0.0, 0.0, 0, 0, 0, 0);
        this.lwaehrung = Waehrungen.getChoice();
        this.lwaehrung.select(Waehrungen.getListenWaehrung());
        this.lwaehrung.addItemListener(new 4());
        AFrame.constrain(panel2, this.lwaehrung, 1, 0, 1, 1, 0, 17, 1.0, 0.0, 0, 4, 0, 0);
        AFrame.constrain(panel2, new Label("Sortieren:"), 0, 1, 1, 1, 0, 17, 0.0, 0.0, 0, 0, 0, 0);
        this.sortby = new Choice();
        this.sortby.addItem("Name");
        this.sortby.addItem("%absolut");
        this.sortby.addItem("Differenz");
        this.sortby.addItem("Kaufdatum");
        this.sortby.addItem("fix. Datum");
        this.sortby.addItemListener(new 5());
        AFrame.constrain(panel2, this.sortby, 1, 1, 1, 1, 0, 17, 1.0, 0.0, 0, 4, 0, 0);
        Button button2 = new Button(" Aktie kaufen... ");
        this.buttonVerkaufen = new Button(" Aktie verkaufen... ");
        this.buttonAendern = new Button(" Aktie \u00e4ndern... ");
        button2.addActionListener(new 6());
        this.buttonVerkaufen.addActionListener(new 7());
        this.buttonAendern.addActionListener(new 8());
        this.buttonChart = new Choice();
        this.buttonChart.addItemListener(new 9());
        this.buttonMaxkurs = new Button(" Maximalkurs ");
        this.buttonMaxkurs.addActionListener(new 10());
        this.buttonInfo = new Button(" Aktie Info ");
        this.buttonInfo.addActionListener(new 11());
        this.setChartChoice();
        AFrame.constrain(panel3, button2, 0, 0, 1, 1, 2, 13, 1.0, 0.0, 0, 0, 6, 0);
        AFrame.constrain(panel3, this.buttonInfo, 1, 0, 1, 1, 2, 17, 1.0, 0.0, 0, 10, 6, 0);
        AFrame.constrain(panel3, this.buttonChart, 2, 0, 1, 1, 2, 17, 1.0, 0.0, 0, 10, 6, 0);
        AFrame.constrain(panel3, this.buttonVerkaufen, 0, 1, 1, 1, 2, 13, 1.0, 0.0, 0, 0, 0, 0);
        AFrame.constrain(panel3, this.buttonAendern, 1, 1, 1, 1, 2, 17, 1.0, 0.0, 0, 10, 0, 0);
        AFrame.constrain(panel3, this.buttonMaxkurs, 2, 1, 1, 1, 2, 17, 1.0, 0.0, 0, 10, 0, 0);
        BenutzerAktie.addSummen(this.panelText, "-----", "-----", "", false);
        this.pane = new ScrollPane(0);
        this.pane.add(this.panelListe);
        Adjustable adjustable = this.pane.getVAdjustable();
        adjustable.setUnitIncrement(8);
        Adjustable adjustable2 = this.pane.getHAdjustable();
        adjustable2.setUnitIncrement(16);
        AFrame.constrain(this, panel, 0, 0, 3, 1, 2, 18, 1.0, 0.0, 10, 10, 5, 10);
        this.addIndexPanelAndPane(false);
        AFrame.constrain(this, this.panelText, 0, 3, 3, 1, 2, 17, 1.0, 0.0, 5, 10, 0, 10);
        this.progressCanvas = new ProgressCanvas();
        AFrame.constrain(this, this.progressCanvas, 0, 4, 1, 1, 0, 17, 0.0, 0.0, 0, 10, 5, 10);
        AFrame.constrain(this, this.panelGewinn, 1, 4, 2, 1, 2, 13, 1.0, 0.0, 0, 10, 5, 10);
        AFrame.constrain(this, panel2, 0, 5, 1, 1, 0, 16, 0.0, 0.0, 5, 10, 15, 5);
        AFrame.constrain(this, panel3, 1, 5, 2, 1, 0, 15, 0.0, 0.0, 5, 5, 15, 10);
        this.aktienpopup = new PopupMenu();
        MenuItem menuItem = new MenuItem("Info");
        menuItem.addActionListener(new 12());
        this.aktienpopup.add(menuItem);
        this.popChart = new ChartMenu();
        this.aktienpopup.add(this.popChart);
        this.popMaxkurs = new MenuItem("Maximalkurs");
        this.popMaxkurs.addActionListener(new 13());
        this.aktienpopup.add(this.popMaxkurs);
        this.popAktualisieren = new MenuItem("Aktualisieren");
        this.popAktualisieren.addActionListener(new 14());
        this.aktienpopup.add(this.popAktualisieren);
        this.aktienpopup.addSeparator();
        this.aktienpopup.add(Portfolios.getPopupCopy(this));
        this.aktienpopup.add(Portfolios.getPopupMove(this));
        this.aktienpopup.addSeparator();
        this.popVerkaufen = new MenuItem("Verkaufen...");
        this.popVerkaufen.addActionListener(new 15());
        this.aktienpopup.add(this.popVerkaufen);
        menuItem = new MenuItem("\u00c4ndern...");
        menuItem.addActionListener(new 16());
        this.aktienpopup.add(menuItem);
        this.popSplitten = new MenuItem("Splitten...");
        this.popSplitten.addActionListener(new 17());
        this.aktienpopup.add(this.popSplitten);
        this.aktienpopup.addSeparator();
        menuItem = new MenuItem("L\u00f6schen...");
        menuItem.addActionListener(new 18());
        this.aktienpopup.add(menuItem);
        this.add(this.aktienpopup);
        MenuBar menuBar = new MenuBar();
        this.setMenuBar(menuBar);
        Menu menu = new Menu(Lang.FILEMENUTITLE, true);
        menuBar.add(menu);
        Menu menu2 = new Menu("Bearbeiten", true);
        menuBar.add(menu2);
        Menu menu3 = new Menu("Aktualisieren", true);
        menuBar.add(menu3);
        Menu menu4 = new Menu("Aktie", true);
        menuBar.add(menu4);
        Menu menu5 = new Menu("Portfolio", true);
        menuBar.add(menu5);
        this.menuExport = new Menu("Liste exportieren");
        MenuItem menuItem2 = new MenuItem("als CSV-Datei...");
        menuItem2.addActionListener(new 19());
        this.menuExport.add(menuItem2);
        MenuItem menuItem3 = new MenuItem("als HTML-Datei...", new MenuShortcut(69));
        menuItem3.addActionListener(new 20());
        this.menuExport.add(menuItem3);
        menu.add(this.menuExport);
        if (!SysUtil.isMacOSX()) {
            menu.addSeparator();
            menuItem = new MenuItem("Beenden", new MenuShortcut(81));
            menuItem.addActionListener(new 21());
            menu.add(menuItem);
        }
        menuItem = new MenuItem("Warnungen...");
        menuItem.addActionListener(new 22());
        menu2.add(menuItem);
        menuItem = new MenuItem("Indizes...");
        menuItem.addActionListener(new 23());
        menu2.add(menuItem);
        menuItem = new MenuItem("Voreinstellungen...");
        menuItem.addActionListener(new 24());
        menu2.add(menuItem);
        menu2.addSeparator();
        menuItem = new MenuItem("Wechselkurse...");
        menuItem.addActionListener(new 25());
        menu2.add(menuItem);
        menu2.addSeparator();
        menuItem = new MenuItem("Nach Updates suchen...");
        menuItem.addActionListener(new 26());
        menu2.add(menuItem);
        this.menuAkt = new MenuItem("An der jeweiligen B\u00f6rse", new MenuShortcut(65));
        this.menuAkt.addActionListener(new 27());
        menu3.add(this.menuAkt);
        menu3.addSeparator();
        this.menuAktAlle = new Menu("Alle Aktien an");
        int n = 0;
        while (n < AktienMan.boersenliste.size() - 1) {
            serializable = AktienMan.boersenliste.getAt(n);
            menuItem = new MenuItem(((Listeneintrag)serializable).toString());
            menuItem.addActionListener(new BoersenListener(n));
            this.menuAktAlle.add(menuItem);
            ++n;
        }
        menu3.add(this.menuAktAlle);
        menu3.addSeparator();
        menuItem = new MenuItem("DAX-Kamera", new MenuShortcut(68));
        menuItem.addActionListener(new 28());
        menu3.add(menuItem);
        menuItem = new MenuItem("Kaufen...", new MenuShortcut(75));
        menuItem.addActionListener(new 29());
        menu4.add(menuItem);
        this.menuVerkaufen = new MenuItem("Verkaufen...");
        this.menuVerkaufen.addActionListener(new 30());
        menu4.add(this.menuVerkaufen);
        this.menuAendern = new MenuItem("\u00c4ndern...");
        this.menuAendern.addActionListener(new 31());
        menu4.add(this.menuAendern);
        this.menuSplitten = new MenuItem("Splitten...");
        this.menuSplitten.addActionListener(new 32());
        menu4.add(this.menuSplitten);
        menu4.addSeparator();
        this.menuLoeschen = new MenuItem("L\u00f6schen...");
        this.menuLoeschen.addActionListener(new 33());
        menu4.add(this.menuLoeschen);
        menu4.addSeparator();
        this.menuInfo = new MenuItem("Info", new MenuShortcut(73));
        this.menuInfo.addActionListener(new 34());
        menu4.add(this.menuInfo);
        this.menuChart = new ChartMenu();
        menu4.add(this.menuChart);
        this.menuMaxkurs = new MenuItem("Maximalkurs", new MenuShortcut(77));
        this.menuMaxkurs.addActionListener(new 35());
        menu4.add(this.menuMaxkurs);
        menu4.addSeparator();
        menu4.add(Portfolios.getMenuCopy(this));
        menu4.add(Portfolios.getMenuMove(this));
        menuItem = new MenuItem("Neu...");
        menuItem.addActionListener(new 36());
        menu5.add(menuItem);
        menu5.add(Portfolios.getMenu(this));
        menu5.addSeparator();
        this.pofoChart = new PofoChartMenu();
        menu5.add(this.pofoChart);
        menu5.addSeparator();
        this.pofoRename = new MenuItem("Umbenennen...");
        this.pofoRename.addActionListener(new 37());
        menu5.add(this.pofoRename);
        menu5.addSeparator();
        this.pofoDelete = new MenuItem("L\u00f6schen...");
        this.pofoDelete.addActionListener(new 38());
        menu5.add(this.pofoDelete);
        if (!SysUtil.isAMac()) {
            serializable = new Menu("Hilfe", true);
            menuBar.add((Menu)serializable);
            menuBar.setHelpMenu((Menu)serializable);
            menuItem = new MenuItem("\u00dcber AktienMan...");
            menuItem.addActionListener(new 39());
            ((Menu)serializable).add(menuItem);
        }
        this.disableAktienButtons();
        Portfolios.updateMenu();
    }

    private void setChartChoice() {
        this.buttonChart.removeAll();
        this.buttonChart.add("Chart:");
        if (ChartQuellen.hasAnyTime(0)) {
            this.buttonChart.add(CHARTSTR_1D);
        }
        if (ChartQuellen.hasAnyTime(1)) {
            this.buttonChart.add(CHARTSTR_5D);
        }
        if (ChartQuellen.hasAnyTime(2)) {
            this.buttonChart.add(CHARTSTR_10D);
        }
        if (ChartQuellen.hasAnyTime(3)) {
            this.buttonChart.add(CHARTSTR_3M);
        }
        if (ChartQuellen.hasAnyTime(4)) {
            this.buttonChart.add(CHARTSTR_6M);
        }
        if (ChartQuellen.hasAnyTime(5)) {
            this.buttonChart.add(CHARTSTR_1Y);
        }
        if (ChartQuellen.hasAnyTime(6)) {
            this.buttonChart.add(CHARTSTR_2Y);
        }
        if (ChartQuellen.hasAnyTime(7)) {
            this.buttonChart.add(CHARTSTR_3Y);
        }
        if (ChartQuellen.hasAnyTime(8)) {
            this.buttonChart.add(CHARTSTR_5Y);
        }
        if (ChartQuellen.hasAnyTime(9)) {
            this.buttonChart.add(CHARTSTR_MAX);
        }
    }

    public long getErloes() {
        return this.benutzerliste.getErloes();
    }

    public int getErloesWaehrung() {
        return this.benutzerliste.getErloesWaehrung();
    }

    private void addErloes(boolean bl, long l) {
        if (bl) {
            this.panelGewinn.removeAll();
        }
        this.benutzerliste.addToErloes(l);
        long l2 = this.getErloes();
        Label label = new Label("Gesamtaufwand:", 2);
        if (l2 < 0L) {
            label.setForeground(Color.red);
        }
        AFrame.constrain(this.panelGewinn, label, 0, 0, 1, 1, 2, 13, 1.0, 0.0, 0, 0, 0, 0);
        this.chErloes = new Choice();
        this.chErloes.add(" " + Waehrungen.getString(l2, this.getErloesWaehrung()));
        this.chErloes.add("Setzen...");
        if (l2 != 0L) {
            this.chErloes.add("L\u00f6schen...");
        }
        this.chErloes.addItemListener(new 40());
        AFrame.constrain(this.panelGewinn, this.chErloes, 1, 0, 1, 1, 0, 13, 0.0, 0.0, 0, 10, 0, 0);
        if (bl) {
            this.panelGewinn.validate();
            this.panelGewinn.paintAll(this.getGraphics());
        }
    }

    public synchronized void setErloes(long l, boolean bl) {
        this.benutzerliste.clearErloes();
        this.addErloes(true, l);
        if (bl) {
            RedrawDemon.getRedrawDemon().incSaveRequests();
        }
    }

    public synchronized void setErloes(long l) {
        this.setErloes(l, true);
    }

    public synchronized void clearErloes() {
        this.benutzerliste.clearErloes();
        this.addErloes(true, 0L);
        RedrawDemon.getRedrawDemon().incSaveRequests();
    }

    public synchronized int getSortBy() {
        return this.benutzerliste.getSortBy();
    }

    public synchronized void setSortBy(int n) {
        this.benutzerliste.setSortBy(n);
    }

    public void setupSize() {
        int n = 4 * AktienMan.screenSize.width / 5;
        int n2 = AktienMan.screenSize.height / 2;
        if (n < 620) {
            n = 620;
        }
        if (n2 < 300) {
            n2 = 300;
        }
        int n3 = (AktienMan.screenSize.width - n) / 2;
        int n4 = (AktienMan.screenSize.height - n2) / 2;
        int n5 = AktienMan.properties.getInt("Haupt.X");
        int n6 = AktienMan.properties.getInt("Haupt.Y");
        int n7 = AktienMan.properties.getInt("Haupt.Breite");
        int n8 = AktienMan.properties.getInt("Haupt.Hoehe");
        if (n5 < 0 || n6 < 0 || n7 <= 0 || n8 <= 0) {
            ((Component)this).setBounds(n3, n4, n, n2);
        } else {
            ((Component)this).setBounds(n5, n6, n7, n8);
        }
    }

    public synchronized void callAbout() {
        if (AktienMan.about == null) {
            AktienMan.about = new About();
        } else {
            AktienMan.about.toFront();
        }
    }

    public synchronized void callWechselkurse() {
        if (AktienMan.wechselkurse == null) {
            AktienMan.wechselkurse = new Wechselkurse();
        } else {
            AktienMan.wechselkurse.toFront();
        }
    }

    private synchronized void callKonfiguration() {
        if (AktienMan.konfiguration == null) {
            AktienMan.konfiguration = new Konfiguration();
        } else {
            AktienMan.konfiguration.toFront();
        }
    }

    private synchronized void callKonfigurationWarnungen() {
        if (AktienMan.konfigurationWarnungen == null) {
            AktienMan.konfigurationWarnungen = new KonfigurationWarnungen();
        } else {
            AktienMan.konfigurationWarnungen.toFront();
        }
    }

    private synchronized void callKonfigurationIndizes() {
        if (AktienMan.konfigurationIndizes == null) {
            AktienMan.konfigurationIndizes = new KonfigurationIndizes();
        } else {
            AktienMan.konfigurationIndizes.toFront();
        }
    }

    private synchronized void callNeueAktie() {
        if (AktienMan.neueaktie == null) {
            if (!this.isLocked(true)) {
                AktienMan.neueaktie = new NeueAktie();
            }
        } else {
            AktienMan.neueaktie.toFront();
        }
    }

    private synchronized void waehrungWechseln() {
        int n = this.lwaehrung.getSelectedIndex();
        if (n != Waehrungen.getListenWaehrung()) {
            Waehrungen.setListenWaehrung(n);
            this.benutzerliste.erloesToWaehrung(n);
            this.listeUpdate(false, true, true, false);
            this.setErloes(this.getErloes());
            AktienMan.properties.saveParameters();
        }
    }

    private synchronized void sortByWechseln() {
        int n = this.sortby.getSelectedIndex();
        if (n != this.getSortBy()) {
            this.setSortBy(n);
            this.listeUpdate(false, true, true, false);
            AktienMan.properties.saveParameters();
        }
    }

    private void disableAktienButtons() {
        this.abenabled = false;
        this.checkAktienButtons(null);
        Portfolios.disableMoveCopyMenus();
    }

    private void enableAktienButtons(BenutzerAktie benutzerAktie) {
        this.abenabled = true;
        this.checkAktienButtons(benutzerAktie);
        Portfolios.enableMoveCopyMenus();
    }

    private void checkAktienButtons(BenutzerAktie benutzerAktie) {
        if (this.abenabled) {
            if (benutzerAktie.getStueckzahl() > 0L && benutzerAktie.getKurs() > 0L && !benutzerAktie.nurBeobachten()) {
                this.buttonVerkaufen.setEnabled(true);
                this.menuVerkaufen.setEnabled(true);
            } else {
                this.buttonVerkaufen.setEnabled(false);
                this.menuVerkaufen.setEnabled(false);
            }
            if (benutzerAktie.getKurs() > 0L) {
                this.setChartChoice();
                this.buttonChart.setEnabled(true);
                this.menuChart.checkTypes();
                this.menuChart.setEnabled(true);
            } else {
                this.buttonChart.setEnabled(false);
                this.menuChart.setEnabled(false);
            }
            this.buttonAendern.setEnabled(true);
            this.buttonInfo.setEnabled(true);
            this.menuAendern.setEnabled(true);
            this.menuLoeschen.setEnabled(true);
            this.menuInfo.setEnabled(true);
            if (benutzerAktie.isFonds()) {
                this.buttonMaxkurs.setEnabled(false);
                this.menuMaxkurs.setEnabled(false);
                this.menuSplitten.setEnabled(false);
            } else {
                this.buttonMaxkurs.setEnabled(true);
                this.menuMaxkurs.setEnabled(true);
                this.menuSplitten.setEnabled(true);
            }
        } else {
            this.buttonVerkaufen.setEnabled(false);
            this.buttonAendern.setEnabled(false);
            this.buttonChart.setEnabled(false);
            this.buttonMaxkurs.setEnabled(false);
            this.buttonInfo.setEnabled(false);
            this.menuVerkaufen.setEnabled(false);
            this.menuAendern.setEnabled(false);
            this.menuSplitten.setEnabled(false);
            this.menuLoeschen.setEnabled(false);
            this.menuChart.setEnabled(false);
            this.menuMaxkurs.setEnabled(false);
            this.menuInfo.setEnabled(false);
        }
    }

    private void checkLockButtons() {
        if (this.isLocked(false)) {
            this.menuAkt.setEnabled(false);
            this.menuAktAlle.setEnabled(false);
            this.aktChoice.setEnabled(false);
            this.buttonAktualisieren.setEnabled(false);
        } else {
            this.menuAkt.setEnabled(true);
            this.menuAktAlle.setEnabled(true);
            this.aktChoice.setEnabled(true);
            this.buttonAktualisieren.setEnabled(true);
        }
    }

    public void checkPortfolioMenu() {
        if (Portfolios.isDefault()) {
            this.pofoRename.setEnabled(false);
            this.pofoDelete.setEnabled(false);
        } else {
            this.pofoRename.setEnabled(true);
            this.pofoDelete.setEnabled(true);
        }
    }

    public synchronized long getAnzahlAktien() {
        return this.benutzerliste.size();
    }

    public synchronized BenutzerAktie getAktieNr(int n) {
        return this.benutzerliste.getAt(n);
    }

    private void checkListButtons() {
        if (this.isLocked(false)) {
            this.lwaehrung.setEnabled(false);
            this.sortby.setEnabled(false);
            this.menuExport.setEnabled(false);
            this.pofoChart.setEnabled(false);
        } else {
            this.lwaehrung.setEnabled(true);
            this.sortby.setEnabled(true);
            if (this.getAnzahlAktien() > 0L) {
                this.menuExport.setEnabled(true);
                this.pofoChart.setEnabled(true);
                this.pofoChart.checkTypes();
            } else {
                this.menuExport.setEnabled(false);
                this.pofoChart.setEnabled(false);
                this.benutzerliste.clearDate();
            }
        }
    }

    public synchronized void preferencesChanged() {
        this.pofoChart.checkTypes();
    }

    public synchronized void callKamera() {
        if (AktienMan.daxKamera == null) {
            AktienMan.daxKamera = new DAXKamera();
        }
        if (AktienMan.daxKamera != null) {
            AktienMan.daxKamera.showKamera();
        }
        IndexQuelle.call();
    }

    private synchronized void listeAktualisierenAnQuelle(long l) {
        this.listeAktualisieren("", KursQuellen.getKursQuelle(l));
    }

    public synchronized void listeAktualisieren() {
        this.listeAktualisieren("", null);
    }

    public synchronized void listeAktualisieren(int n, KursQuelle kursQuelle) {
        this.listeAktualisieren(AktienMan.boersenliste.getAt(n).getKurz(), kursQuelle);
    }

    private boolean nochNichtAngefordert(String string, int n, String string2) {
        int n2 = 0;
        while (n2 < n) {
            BenutzerAktie benutzerAktie = this.getAktieNr(n2);
            if (!benutzerAktie.doNotUpdate() && string.equalsIgnoreCase(benutzerAktie.getRequest(string2))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public synchronized void listeAktualisieren(String string, KursQuelle kursQuelle) {
        if (!KursDemon.canCallKursDemon(string, kursQuelle)) {
            this.listeAktualisierenAusfuehren(string, kursQuelle);
        }
        IndexQuelle.call();
    }

    public synchronized void listeAktualisierenAusfuehren(String string, KursQuelle kursQuelle) {
        Object object;
        if (this.isLocked(true)) {
            return;
        }
        String string2 = string;
        if (kursQuelle != null) {
            if (string2.length() > 0) {
                string2 = String.valueOf(string2) + "; ";
            }
            string2 = String.valueOf(string2) + kursQuelle.getName();
        }
        this.benutzerliste.setDate(string, string2);
        int n = 0;
        while ((long)n < this.getAnzahlAktien()) {
            object = this.getAktieNr(n);
            if (!((BenutzerAktie)object).doNotUpdate()) {
                ((BenutzerAktie)object).setStatusRequestingAndRepaint();
            }
            ++n;
        }
        object = KursQuellen.getFondsQuelle();
        if (kursQuelle == null) {
            kursQuelle = KursQuellen.getKursQuelle();
        }
        int n2 = 0;
        int n3 = 0;
        while ((long)n3 < this.getAnzahlAktien()) {
            BenutzerAktie benutzerAktie = this.getAktieNr(n3);
            String string3 = benutzerAktie.getRequest(string);
            if (this.nochNichtAngefordert(string3, n3, string) && !benutzerAktie.doNotUpdate()) {
                ++n2;
                if (benutzerAktie.isFonds()) {
                    ((KursQuelle)object).sendRequest(this, string3, benutzerAktie.getWKNString(), benutzerAktie.getBoerse());
                } else {
                    kursQuelle.sendRequest(this, string3, benutzerAktie.getWKNString(), benutzerAktie.getBoerse());
                }
            }
            ++n3;
        }
        kursQuelle.flush();
        ((KursQuelle)object).flush();
        this.progressCanvas.addMax(n2);
        BenutzerAktie.setLastUpdateAndRepaint(this.benutzerliste.getDateString());
        AktienMan.doOnlineChecks();
    }

    private synchronized void listeSelektierteAktieAktualisieren() {
        int n = 0;
        while ((long)n < this.getAnzahlAktien()) {
            BenutzerAktie benutzerAktie = this.getAktieNr(n);
            if (benutzerAktie.isSelected() && !benutzerAktie.doNotUpdate()) {
                benutzerAktie.setStatusRequestingAndRepaint();
                this.progressCanvas.addMax(1);
                if (benutzerAktie.isFonds()) {
                    KursQuellen.getFondsQuelle().sendSingleRequest(this, benutzerAktie.getRequest(), benutzerAktie.getWKNString(), benutzerAktie.getBoerse());
                    break;
                }
                KursQuellen.getKursQuelle().sendSingleRequest(this, benutzerAktie.getRequest(), benutzerAktie.getWKNString(), benutzerAktie.getBoerse());
                break;
            }
            ++n;
        }
    }

    public synchronized void listeNeuerAktienkurs(String string, String string2, String string3, String string4, String string5, long l, String string6, long l2, long l3, long l4, long l5, long l6, int n, boolean bl) {
        if (string.length() == 0) {
            return;
        }
        if (string4.length() == 0) {
            return;
        }
        boolean bl2 = false;
        boolean bl3 = this.benutzerliste.getFesteBoerse().length() == 0;
        int n2 = 0;
        while ((long)n2 < this.getAnzahlAktien()) {
            BenutzerAktie benutzerAktie = this.getAktieNr(n2);
            if (benutzerAktie.hasWKN(string)) {
                benutzerAktie.setSymbol(string3);
            }
            if (benutzerAktie.isEqual(string, string3, string4, bl3) && !benutzerAktie.doNotUpdate()) {
                benutzerAktie.setValues(string5, string2, l, string6, l2, l3, l4, l5, l6, n);
                bl2 = true;
            }
            ++n2;
        }
        if (bl2) {
            this.listeUpdate(true, false, bl, false);
            this.progressCanvas.inc();
        }
    }

    public synchronized void listeAktienkursNA(String string, String string2, String string3, String string4, boolean bl) {
        if (string.length() == 0) {
            return;
        }
        if (string3.length() == 0) {
            return;
        }
        boolean bl2 = false;
        boolean bl3 = this.benutzerliste.getFesteBoerse().length() == 0;
        int n = 0;
        while ((long)n < this.getAnzahlAktien()) {
            BenutzerAktie benutzerAktie = this.getAktieNr(n);
            if (benutzerAktie.isEqual(string, string2, string3, bl3) && !benutzerAktie.doNotUpdate()) {
                benutzerAktie.setValues(string4, -2L);
                bl2 = true;
            }
            ++n;
        }
        if (bl2) {
            this.listeUpdate(true, false, bl, false);
            this.progressCanvas.inc();
        }
    }

    public synchronized void listeAnfrageFehler(String string, String string2, String string3, boolean bl, KursQuelle kursQuelle, KursQuelle kursQuelle2) {
        long l = KursQuellen.getNextID(kursQuelle, kursQuelle2);
        System.out.println("Fehler beim Einlesen der Kursdaten von " + string2 + "." + string3 + "  -> " + l);
        if (l == -1L) {
            if (string2.length() == 0) {
                return;
            }
            if (string3.length() == 0) {
                return;
            }
            boolean bl2 = false;
            boolean bl3 = this.benutzerliste.getFesteBoerse().length() == 0;
            int n = 0;
            while ((long)n < this.getAnzahlAktien()) {
                BenutzerAktie benutzerAktie = this.getAktieNr(n);
                if (benutzerAktie.isEqual(string2, string3, bl3) && !benutzerAktie.doNotUpdate()) {
                    benutzerAktie.setStatusErrorAndRepaint();
                    bl2 = true;
                }
                ++n;
            }
            if (bl2) {
                this.progressCanvas.inc();
            }
        } else {
            KursQuellen.getKursQuelle(l).sendSingleRequest(this, string, string2, string3, bl, kursQuelle);
        }
    }

    public synchronized void listeNeueAktie(BenutzerAktie benutzerAktie) {
        if (this.main() || this.getAnzahlAktien() < 3L) {
            this.benutzerliste.add(benutzerAktie);
            this.listeUpdate(true, false, true, false);
            this.checkListButtons();
        }
        if (this.getAnzahlAktien() == 1L) {
            41 var2_2 = new 41();
            var2_2.start();
        }
    }

    public void listeSelect(Component component, int n, int n2, int n3, int n4, boolean bl) {
        if (n >= 0) {
            BenutzerAktie benutzerAktie;
            Hauptdialog hauptdialog = this;
            synchronized (hauptdialog) {
                if (this.isLocked(true)) {
                    Object var9_8 = null;
                    return;
                }
                benutzerAktie = this.getAktieNr(n);
                if (benutzerAktie.isSelected()) {
                    if (!bl) {
                        benutzerAktie.Unselect();
                        this.disableAktienButtons();
                    }
                } else {
                    int n5 = 0;
                    while ((long)n5 < this.getAnzahlAktien()) {
                        this.getAktieNr(n5).Unselect();
                        ++n5;
                    }
                    benutzerAktie.Select();
                    this.enableAktienButtons(benutzerAktie);
                }
            }
            if (bl) {
                this.aktienPopup(benutzerAktie, component, n2, n3);
            }
        }
    }

    private void aktienPopup(BenutzerAktie benutzerAktie, Component component, int n, int n2) {
        Object object = this;
        synchronized (object) {
            if (benutzerAktie.getStueckzahl() > 0L && benutzerAktie.getKurs() > 0L && !benutzerAktie.nurBeobachten()) {
                this.popVerkaufen.setEnabled(true);
            } else {
                this.popVerkaufen.setEnabled(false);
            }
            if (benutzerAktie.getKurs() > 0L) {
                this.popChart.setEnabled(true);
                this.popChart.checkTypes();
            } else {
                this.popChart.setEnabled(false);
            }
            if (benutzerAktie.isFonds()) {
                this.popMaxkurs.setEnabled(false);
                this.popSplitten.setEnabled(false);
            } else {
                this.popMaxkurs.setEnabled(true);
                this.popSplitten.setEnabled(true);
            }
            this.popAktualisieren.setEnabled(benutzerAktie.doNotUpdate() ^ true);
        }
        object = new 42(component, n, n2, this);
        ((Thread)object).start();
    }

    private synchronized void portfolioNeu() {
        if (AktienMan.portfolioneu != null) {
            AktienMan.portfolioneu.toFront();
            return;
        }
        if (this.isLocked(true)) {
            return;
        }
        AktienMan.portfolioneu = new PortfolioNeu();
        this.windowToFront(AktienMan.portfolioneu);
    }

    public synchronized void portfolioIntradayCharts(int n) {
        new MultiChartFrame(n, 1);
    }

    private synchronized void portfolioUmbenennen() {
        if (AktienMan.portfolioumbenennen != null) {
            AktienMan.portfolioumbenennen.toFront();
            return;
        }
        if (this.isLocked(true)) {
            return;
        }
        AktienMan.portfolioumbenennen = new PortfolioUmbenennen();
        this.windowToFront(AktienMan.portfolioumbenennen);
    }

    private synchronized void portfolioLoeschen() {
        if (AktienMan.portfolioloeschen != null) {
            AktienMan.portfolioloeschen.toFront();
            return;
        }
        if (this.isLocked(true)) {
            return;
        }
        AktienMan.portfolioloeschen = new PortfolioLoeschen();
        this.windowToFront(AktienMan.portfolioloeschen);
    }

    private synchronized void portfolioCopyKaufkurs() {
        if (AktienMan.portfoliocopykaufkurs != null) {
            AktienMan.portfoliocopykaufkurs.toFront();
            return;
        }
        if (this.isLocked(true)) {
            return;
        }
        AktienMan.portfoliocopykaufkurs = new PortfolioCopyKaufkurs();
        this.windowToFront(AktienMan.portfoliocopykaufkurs);
    }

    public synchronized void listeCopyKaufkurs() {
        int n = new ADate().getSerialDate() - 1;
        int n2 = 0;
        while ((long)n2 < this.getAnzahlAktien()) {
            BenutzerAktie benutzerAktie = this.getAktieNr(n2);
            if (benutzerAktie.nurBeobachten()) {
                benutzerAktie.changeKaufkurs(benutzerAktie.getKurs(), benutzerAktie.getKurswaehrung(), new ADate(n));
            }
            ++n2;
        }
        this.listeUpdate(true, true, true, false);
    }

    public synchronized void listeUpdate(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        RedrawDemon.getRedrawDemon().incRedrawRequests(bl4);
        if (bl) {
            RedrawDemon.getRedrawDemon().incSaveRequests();
        }
        if (bl2) {
            RedrawDemon.getRedrawDemon().incInfoRequests();
        }
        if (bl3) {
            RedrawDemon.getRedrawDemon().interrupt();
        }
    }

    public synchronized void listeRedraw(boolean bl) {
        this.disableAktienButtons();
        this.panelListe.setVisible(false);
        this.panelListe.removeAll();
        this.panelText.removeAll();
        if (this.getAnzahlAktien() > 0L) {
            boolean bl2 = BenutzerListe.useShortNames();
            boolean bl3 = BenutzerListe.useSteuerfrei();
            boolean bl4 = BenutzerListe.calcProzJahr() ^ true;
            this.benutzerliste.sort(bl2);
            int n = BenutzerAktie.addHeadingsToPanel(this.panelListe, this.benutzerliste.getDateString());
            int n2 = 0;
            while ((long)n2 < this.getAnzahlAktien()) {
                this.getAktieNr(n2).addToPanel(this.panelListe, n2 + n, bl2, bl3, bl4);
                ++n2;
            }
            BenutzerAktie.addFooterToPanel(this.panelListe, n2 + n, this.panelText);
        }
        this.panelText.validate();
        this.panelListe.validate();
        this.pane.validate();
        if (bl || this.getAnzahlAktien() < 1L) {
            this.pane.setScrollPosition(new Point(0, 0));
        }
        this.panelListe.setVisible(true);
        this.panelText.paintAll(this.getGraphics());
        this.pane.paintAll(this.getGraphics());
    }

    public synchronized void listeUpdateInfo() {
        if (this.getAnzahlAktien() > 0L) {
            int n = 0;
            while ((long)n < this.getAnzahlAktien()) {
                this.getAktieNr(n).infoDialogSetValues(true);
                ++n;
            }
        }
    }

    public synchronized void addIndexPanelAndPane(boolean bl) {
        Dimension dimension = null;
        if (bl) {
            dimension = this.getSize();
            this.panelListe.setVisible(false);
            this.panelIndex.invalidate();
            this.pane.invalidate();
            this.invalidate();
        }
        if (!bl || !SysUtil.isMacOSX()) {
            AFrame.constrain(this, this.panelIndex, 0, 1, 3, 1, 2, 17, 1.0, 0.0, 5, 10, 5, 10);
            AFrame.constrain(this, this.pane, 0, 2, 3, 1, 1, 10, 1.0, 1.0, 5, 10, 5, 10);
        }
        if (bl) {
            this.pack();
            this.validate();
            this.panelListe.setVisible(true);
            this.repaint();
            ((Component)this).setSize(dimension);
        }
    }

    public synchronized void windowToFront(Window window) {
        this.backWindow = window;
        43 var2_2 = new 43();
        var2_2.start();
    }

    private synchronized void listeSelektierteAktieMaxkurs() {
        int n = 0;
        while ((long)n < this.getAnzahlAktien()) {
            if (this.getAktieNr(n).isSelected()) {
                new AktieMaximalkurs(this.getAktieNr(n));
                break;
            }
            ++n;
        }
    }

    public synchronized void listeSelektierteAktieChart(int n) {
        int n2 = 0;
        while ((long)n2 < this.getAnzahlAktien()) {
            BenutzerAktie benutzerAktie = this.getAktieNr(n2);
            if (benutzerAktie.isSelected()) {
                ChartQuellen.displayChart(benutzerAktie.getWKNString(), benutzerAktie.getBoerse(), n, 1);
                break;
            }
            ++n2;
        }
    }

    private synchronized void listeSelektierteAktieInfo() {
        int n = 0;
        while ((long)n < this.getAnzahlAktien()) {
            if (this.getAktieNr(n).isSelected()) {
                this.getAktieNr(n).infoDialogOpen();
                break;
            }
            ++n;
        }
    }

    private synchronized void listeSelektierteAktieAendern() {
        if (AktienMan.aktieaendern != null) {
            AktienMan.aktieaendern.toFront();
            return;
        }
        if (this.isLocked(true)) {
            return;
        }
        int n = 0;
        while ((long)n < this.getAnzahlAktien()) {
            if (this.getAktieNr(n).isSelected()) {
                AktienMan.aktieaendern = new AktieAendern(n, this.getAktieNr(n));
                this.windowToFront(AktienMan.aktieaendern);
                break;
            }
            ++n;
        }
    }

    private synchronized void listeSelektierteAktieVerkaufen() {
        if (AktienMan.aktieverkaufen != null) {
            AktienMan.aktieverkaufen.toFront();
            return;
        }
        if (this.isLocked(true)) {
            return;
        }
        int n = 0;
        while ((long)n < this.getAnzahlAktien()) {
            if (this.getAktieNr(n).isSelected()) {
                AktienMan.aktieverkaufen = new AktieVerkaufen(n, this.getAktieNr(n));
                this.windowToFront(AktienMan.aktieverkaufen);
                break;
            }
            ++n;
        }
    }

    public synchronized void listeSelektierteAktieCopyMove(int n, boolean bl) {
        if (this.isLocked(true)) {
            return;
        }
        int n2 = 0;
        while ((long)n2 < this.getAnzahlAktien()) {
            if (this.getAktieNr(n2).isSelected()) {
                this.listeAktieCopyMove(n2, n, bl);
                break;
            }
            ++n2;
        }
    }

    private synchronized void listeAktieCopyMove(int n, int n2, boolean bl) {
        if (n2 == -1) {
            return;
        }
        BenutzerAktie benutzerAktie = (BenutzerAktie)this.getAktieNr(n).clone();
        if (benutzerAktie == null) {
            return;
        }
        BenutzerListe benutzerListe = BenutzerListe.restore(Portfolios.getFileByIndex(n2));
        benutzerListe.add(benutzerAktie);
        boolean bl2 = BenutzerListe.store(benutzerListe);
        if (bl && !bl2) {
            this.listeAktieLoeschen(n);
        }
    }

    public synchronized void listeAktieVerkaufen(int n, long l, long l2, long l3, boolean bl, boolean bl2, String string, ADate aDate) {
        BenutzerAktie benutzerAktie;
        if (bl) {
            this.addErloes(true, l * Waehrungen.exchange(l2, Waehrungen.getVerkaufsWaehrung(), this.getErloesWaehrung()) - Waehrungen.exchange(l3, Waehrungen.getVerkaufsWaehrung(), this.getErloesWaehrung()));
        }
        if (l >= (benutzerAktie = this.getAktieNr(n)).getStueckzahl()) {
            if (bl2) {
                benutzerAktie.fixAktie(aDate, l2, Waehrungen.getVerkaufsWaehrung());
                this.listeAktieCopyMove(n, Portfolios.getIndexByName(string), true);
            } else {
                this.listeAktieLoeschen(n);
            }
        } else {
            BenutzerAktie benutzerAktie2;
            int n2;
            if (bl2 && (n2 = Portfolios.getIndexByName(string)) != -1 && (benutzerAktie2 = (BenutzerAktie)benutzerAktie.clone()) != null) {
                benutzerAktie2.setStueckzahl(l);
                benutzerAktie2.fixAktie(aDate, l2, Waehrungen.getVerkaufsWaehrung());
                BenutzerListe benutzerListe = BenutzerListe.restore(Portfolios.getFileByIndex(n2));
                benutzerListe.add(benutzerAktie2);
                BenutzerListe.store(benutzerListe);
            }
            benutzerAktie.decStueckzahl(l);
            this.listeUpdate(true, false, true, false);
            this.checkListButtons();
        }
    }

    public synchronized void listeSelektierteAktieSplitten() {
        if (AktienMan.aktiesplitten != null) {
            AktienMan.aktiesplitten.toFront();
            return;
        }
        if (this.isLocked(true)) {
            return;
        }
        int n = 0;
        while ((long)n < this.getAnzahlAktien()) {
            if (this.getAktieNr(n).isSelected()) {
                AktienMan.aktiesplitten = new AktieSplitten(n, this.getAktieNr(n));
                this.windowToFront(AktienMan.aktiesplitten);
                break;
            }
            ++n;
        }
    }

    private synchronized void listeSelektierteAktieLoeschen() {
        if (AktienMan.aktieloeschen != null) {
            AktienMan.aktieloeschen.toFront();
            return;
        }
        if (this.isLocked(true)) {
            return;
        }
        int n = 0;
        while ((long)n < this.getAnzahlAktien()) {
            if (this.getAktieNr(n).isSelected()) {
                AktienMan.aktieloeschen = new AktieLoeschen(n, this.getAktieNr(n));
                this.windowToFront(AktienMan.aktieloeschen);
                break;
            }
            ++n;
        }
    }

    public synchronized void listeAktieLoeschen(int n) {
        this.benutzerliste.removeAt(n);
        this.listeUpdate(true, false, true, false);
        this.checkListButtons();
    }

    public synchronized void listeAusdrucken() {
        if (this.isLocked(true)) {
            return;
        }
        PrintJob printJob = this.getToolkit().getPrintJob(this, "AktienMan - Liste drucken", AktienMan.properties);
        if (printJob == null) {
            return;
        }
        Graphics graphics = printJob.getGraphics();
        Dimension dimension = this.panelListe.getSize();
        Dimension dimension2 = printJob.getPageDimension();
        graphics.translate((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
        graphics.drawRect(-1, -1, dimension.width + 1, dimension.height + 1);
        graphics.setClip(0, 0, dimension.width, dimension.height);
        this.panelListe.printAll(graphics);
        graphics.dispose();
        printJob.end();
    }

    private synchronized void listeSpeichernHTML() {
        block27: {
            String[] stringArray;
            Object object;
            if (this.isLocked(true)) {
                return;
            }
            FileDialog fileDialog = new FileDialog((Frame)this, "AktienMan - HTML-Datei exportieren...", 1);
            String string = Portfolios.isDefault() ? "Meine Aktien" : Portfolios.getCurrentName();
            fileDialog.setFile(String.valueOf(string) + ".html");
            ((Component)fileDialog).setVisible(true);
            String string2 = fileDialog.getDirectory();
            String string3 = fileDialog.getFile();
            if (string2 == null || string3 == null) break block27;
            BufferedWriter bufferedWriter = null;
            if (SysUtil.isAMac()) {
                MRJFileUtils.setDefaultFileType(new MRJOSType("????"));
                MRJFileUtils.setDefaultFileCreator(new MRJOSType("????"));
            }
            boolean bl = BenutzerListe.useShortNames();
            boolean bl2 = BenutzerListe.useSteuerfrei();
            boolean bl3 = BenutzerListe.calcProzJahr() ^ true;
            String string4 = String.valueOf(string2) + string3;
            if (string4.endsWith(".")) {
                string4 = String.valueOf(string4) + "html";
            } else {
                object = string4.toUpperCase();
                if (!((String)object).endsWith(".HTM") && !((String)object).endsWith(".HTML")) {
                    string4 = String.valueOf(string4) + ".html";
                }
            }
            object = new File(string4);
            if (((File)object).exists()) {
                stringArray = new File(String.valueOf(string4) + ".bak");
                if (stringArray.exists()) {
                    stringArray.delete();
                }
                ((File)object).renameTo((File)stringArray);
                object = new File(string4);
            }
            try {
                try {
                    bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream((File)object), "ISO-8859-15"));
                    String string5 = AktienMan.properties.getString("Key.Nachname");
                    String string6 = AktienMan.properties.getString("Key.Vorname");
                    bufferedWriter.write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0//EN\"");
                    bufferedWriter.newLine();
                    bufferedWriter.write("    \"http://www.w3.org/TR/REC-html40/strict.dtd\">");
                    bufferedWriter.newLine();
                    bufferedWriter.write("<HTML>");
                    bufferedWriter.newLine();
                    bufferedWriter.write("<HEAD>");
                    bufferedWriter.newLine();
                    bufferedWriter.write("<TITLE>");
                    bufferedWriter.write("AktienMan (");
                    if (string5.length() > 1 && string6.length() > 1) {
                        bufferedWriter.write(String.valueOf(string6) + " " + string5);
                    } else {
                        bufferedWriter.write("DEMOVERSION");
                    }
                    bufferedWriter.write(")</TITLE>");
                    bufferedWriter.newLine();
                    bufferedWriter.write("<META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html; charset=ISO-8859-15\">");
                    bufferedWriter.newLine();
                    bufferedWriter.write("</HEAD>");
                    bufferedWriter.newLine();
                    bufferedWriter.write("<BODY BGCOLOR=\"#ffffff\">");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("<H2>AktienMan");
                    String string7 = Portfolios.getCurrentWindowTitle();
                    if (string7.length() == 0) {
                        string7 = " - Standardportfolio";
                    }
                    bufferedWriter.write(String.valueOf(string7) + "</H2>");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("<TABLE BORDER>");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    BenutzerAktie.saveHeaderHTML(bufferedWriter, this.benutzerliste.getDateString());
                    int n = 0;
                    while ((long)n < this.getAnzahlAktien()) {
                        this.getAktieNr(n).saveHTML(bufferedWriter, bl, bl2, bl3);
                        ++n;
                    }
                    BenutzerAktie.saveFooterHTML(bufferedWriter);
                    bufferedWriter.write("</TABLE>");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("</BODY>");
                    bufferedWriter.newLine();
                    bufferedWriter.write("</HTML>");
                    bufferedWriter.newLine();
                    bufferedWriter.flush();
                }
                catch (IOException iOException) {
                }
                Object var12_18 = null;
            }
            catch (Throwable throwable) {
                Object var12_19 = null;
                try {
                    if (bufferedWriter != null) {
                        bufferedWriter.close();
                    }
                }
                catch (IOException iOException) {}
                bufferedWriter = null;
                throw throwable;
            }
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
            }
            catch (IOException iOException) {}
            bufferedWriter = null;
            if (!SysUtil.isAMac()) break block27;
            try {
                MRJFileUtils.setFileTypeAndCreator((File)object, new MRJOSType("TEXT"), new MRJOSType("iCAB"));
            }
            catch (Exception exception) {}
            try {
                MRJFileUtils.openURL(((File)object).toString());
            }
            catch (Exception exception) {
                try {
                    stringArray = new String[]{"open", ((File)object).toString()};
                    Runtime.getRuntime().exec(stringArray);
                }
                catch (Exception exception2) {
                    System.out.println(exception2);
                }
            }
        }
    }

    private synchronized void listeSpeichernCSV() {
        block20: {
            Object object;
            if (this.isLocked(true)) {
                return;
            }
            FileDialog fileDialog = new FileDialog((Frame)this, "AktienMan - CSV-Datei exportieren...", 1);
            String string = Portfolios.isDefault() ? "Meine Aktien" : Portfolios.getCurrentName();
            fileDialog.setFile(String.valueOf(string) + ".csv");
            ((Component)fileDialog).setVisible(true);
            String string2 = fileDialog.getDirectory();
            String string3 = fileDialog.getFile();
            if (string2 == null || string3 == null) break block20;
            BufferedWriter bufferedWriter = null;
            if (SysUtil.isAMac()) {
                MRJFileUtils.setDefaultFileType(new MRJOSType("????"));
                MRJFileUtils.setDefaultFileCreator(new MRJOSType("????"));
            }
            boolean bl = BenutzerListe.useShortNames();
            boolean bl2 = BenutzerListe.calcProzJahr() ^ true;
            String string4 = String.valueOf(string2) + string3;
            if (string4.endsWith(".")) {
                string4 = String.valueOf(string4) + "csv";
            } else {
                object = string4.toUpperCase();
                if (!((String)object).endsWith(".CSV")) {
                    string4 = String.valueOf(string4) + ".csv";
                }
            }
            object = new File(string4);
            if (((File)object).exists()) {
                File file = new File(String.valueOf(string4) + ".bak");
                if (file.exists()) {
                    file.delete();
                }
                ((File)object).renameTo(file);
                object = new File(string4);
            }
            try {
                try {
                    bufferedWriter = new BufferedWriter(new FileWriter((File)object));
                    bufferedWriter.write("\"Aktienname\";\"St\u00fcck\";\"Kaufkurs\";\"akt. Kurs\";;\"akt. Wert\";\"Differenz\";\"%absolut\";\"%Jahr\";\"Kaufdatum\";\"ISIN\";\"WKN\";\"B\u00f6rse\"");
                    bufferedWriter.newLine();
                    int n = 0;
                    while ((long)n < this.getAnzahlAktien()) {
                        this.getAktieNr(n).saveCSV(bufferedWriter, bl, bl2);
                        ++n;
                    }
                    bufferedWriter.write("\"W\u00e4hrung: " + Waehrungen.getKuerzel(Waehrungen.getListenWaehrung()) + "\"");
                    bufferedWriter.newLine();
                    bufferedWriter.flush();
                }
                catch (IOException iOException) {
                }
                Object var11_13 = null;
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                try {
                    if (bufferedWriter != null) {
                        bufferedWriter.close();
                    }
                }
                catch (IOException iOException) {}
                bufferedWriter = null;
                throw throwable;
            }
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
            }
            catch (IOException iOException) {}
            bufferedWriter = null;
            if (!SysUtil.isAMac()) break block20;
            try {
                MRJFileUtils.setFileTypeAndCreator((File)object, new MRJOSType("TEXT"), new MRJOSType("XCEL"));
            }
            catch (Exception exception) {}
        }
    }

    public void waitProgress() {
        if (this.progressCanvas != null) {
            this.progressCanvas.setWaiting();
        }
    }

    public void resetProgress() {
        if (this.progressCanvas != null) {
            this.progressCanvas.reset();
        }
    }

    public boolean canCancel() {
        return true;
    }

    public boolean canOK() {
        return false;
    }

    public boolean main() {
        char[] cArray = AktienMan.properties.getString("Key.3").toCharArray();
        if (!AktienMan.properties.getString("Key.1").equalsIgnoreCase("AMD")) {
            return false;
        }
        int n = 3;
        if (cArray.length != 4) {
            return false;
        }
        long l = 0L;
        try {
            l = Long.parseLong(AktienMan.properties.getString("Key.2"));
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        if (cArray[0] == (char)((l * 31L + 1L) % 26L + 65L)) {
            --n;
        }
        if (cArray[1] == (char)(l % 11L * 2L + 65L)) {
            --n;
        }
        if (cArray[2] == (char)(l % 9L * 3L + (l + 1L) % 2L + 65L)) {
            --n;
        }
        if (cArray[3] == (char)(l % 13L + l % 11L + l % 3L + 65L)) {
            --n;
        }
        return n < 0;
    }

    public boolean mainr() {
        if (this.main()) {
            long l = 0L;
            try {
                l = Long.parseLong(AktienMan.properties.getString("Key.2"));
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            boolean bl = AktienMan.url.isValidNr(l);
            if (!bl) {
                AktienMan.main(bl ^ true);
            }
            return bl;
        }
        return true;
    }

    private void saveAndExit() {
        if (AktienMan.daxKamera != null) {
            AktienMan.daxKamera.savePos();
        }
        Rectangle rectangle = this.getBounds();
        AktienMan.properties.setInt("Haupt.X", rectangle.x);
        AktienMan.properties.setInt("Haupt.Y", rectangle.y);
        AktienMan.properties.setInt("Haupt.Breite", rectangle.width);
        AktienMan.properties.setInt("Haupt.Hoehe", rectangle.height);
        this.saveBenutzerAktien();
        AktienMan.properties.saveParameters();
        System.exit(0);
    }

    public void closed() {
        this.saveAndExit();
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.pane.paintAll(this.getGraphics());
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    private final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if ((actionEvent.getModifiers() & 1) > 0) {
                Hauptdialog.this.portfolioCopyKaufkurs();
            } else {
                Hauptdialog.this.listeAktualisieren();
            }
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Hauptdialog.this.callKamera();
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            int n = Hauptdialog.this.aktChoice.getSelectedIndex();
            int n2 = AktienMan.boersenliste.getCountNoFonds();
            if (n > 0) {
                if (n <= n2) {
                    Hauptdialog.this.listeAktualisieren(n - 1, KursQuellen.getPlatzKursQuelle());
                }
                Hauptdialog.this.aktChoice.select(0);
            }
        }

        /* synthetic */ 3() {
        }
    }

    private final class 4
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            Hauptdialog.this.waehrungWechseln();
        }

        /* synthetic */ 4() {
        }
    }

    private final class 5
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            Hauptdialog.this.sortByWechseln();
        }

        /* synthetic */ 5() {
        }
    }

    private final class 6
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Hauptdialog.this.callNeueAktie();
        }

        /* synthetic */ 6() {
        }
    }

    private final class 7
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Hauptdialog.this.listeSelektierteAktieVerkaufen();
        }

        /* synthetic */ 7() {
        }
    }

    private final class 8
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Hauptdialog.this.listeSelektierteAktieAendern();
        }

        /* synthetic */ 8() {
        }
    }

    private final class 9
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            int n = Hauptdialog.this.buttonChart.getSelectedIndex();
            if (n != 0) {
                String string = Hauptdialog.this.buttonChart.getItem(n);
                if (string.equals(Hauptdialog.CHARTSTR_1D)) {
                    Hauptdialog.this.listeSelektierteAktieChart(0);
                } else if (string.equals(Hauptdialog.CHARTSTR_5D)) {
                    Hauptdialog.this.listeSelektierteAktieChart(1);
                } else if (string.equals(Hauptdialog.CHARTSTR_10D)) {
                    Hauptdialog.this.listeSelektierteAktieChart(2);
                } else if (string.equals(Hauptdialog.CHARTSTR_3M)) {
                    Hauptdialog.this.listeSelektierteAktieChart(3);
                } else if (string.equals(Hauptdialog.CHARTSTR_6M)) {
                    Hauptdialog.this.listeSelektierteAktieChart(4);
                } else if (string.equals(Hauptdialog.CHARTSTR_1Y)) {
                    Hauptdialog.this.listeSelektierteAktieChart(5);
                } else if (string.equals(Hauptdialog.CHARTSTR_2Y)) {
                    Hauptdialog.this.listeSelektierteAktieChart(6);
                } else if (string.equals(Hauptdialog.CHARTSTR_3Y)) {
                    Hauptdialog.this.listeSelektierteAktieChart(7);
                } else if (string.equals(Hauptdialog.CHARTSTR_5Y)) {
                    Hauptdialog.this.listeSelektierteAktieChart(8);
                } else if (string.equals(Hauptdialog.CHARTSTR_MAX)) {
                    Hauptdialog.this.listeSelektierteAktieChart(9);
                }
                Hauptdialog.this.buttonChart.select(0);
            }
        }

        /* synthetic */ 9() {
        }
    }

    private final class 10
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Hauptdialog.this.listeSelektierteAktieMaxkurs();
        }

        /* synthetic */ 10() {
        }
    }

    private final class 11
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Hauptdialog.this.listeSelektierteAktieInfo();
        }

        /* synthetic */ 11() {
        }
    }

    private final class 12
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Hauptdialog.this.listeSelektierteAktieInfo();
        }

        /* synthetic */ 12() {
        }
    }

    private final class 13
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Hauptdialog.this.listeSelektierteAktieMaxkurs();
        }

        /* synthetic */ 13() {
        }
    }

    private final class 14
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Hauptdialog.this.listeSelektierteAktieAktualisieren();
        }

        /* synthetic */ 14() {
        }
    }

    private final class 15
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Hauptdialog.this.listeSelektierteAktieVerkaufen();
        }

        /* synthetic */ 15() {
        }
    }

    private final class 16
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Hauptdialog.this.listeSelektierteAktieAendern();
        }

        /* synthetic */ 16() {
        }
    }

    private final class 17
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Hauptdialog.this.listeSelektierteAktieSplitten();
        }

        /* synthetic */ 17() {
        }
    }

    private final class 18
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Hauptdialog.this.listeSelektierteAktieLoeschen();
        }

        /* synthetic */ 18() {
        }
    }

    private final class 19
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Hauptdialog.this.listeSpeichernCSV();
        }

        /* synthetic */ 19() {
        }
    }

    private final class 20
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Hauptdialog.this.listeSpeichernHTML();
        }

        /* synthetic */ 20() {
        }
    }

    private final class 21
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Hauptdialog.this.doCancel();
        }

        /* synthetic */ 21() {
        }
    }

    private final class 22
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Hauptdialog.this.callKonfigurationWarnungen();
        }

        /* synthetic */ 22() {
        }
    }

    private final class 23
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Hauptdialog.this.callKonfigurationIndizes();
        }

        /* synthetic */ 23() {
        }
    }

    private final class 24
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Hauptdialog.this.callKonfiguration();
        }

        /* synthetic */ 24() {
        }
    }

    private final class 25
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Hauptdialog.this.callWechselkurse();
        }

        /* synthetic */ 25() {
        }
    }

    private final class 26
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            UpdateManager.checkForUpdates(true);
        }

        /* synthetic */ 26() {
        }
    }

    private final class 27
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Hauptdialog.this.listeAktualisieren();
        }

        /* synthetic */ 27() {
        }
    }

    private final class 28
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Hauptdialog.this.callKamera();
        }

        /* synthetic */ 28() {
        }
    }

    private final class 29
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Hauptdialog.this.callNeueAktie();
        }

        /* synthetic */ 29() {
        }
    }

    private final class 30
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Hauptdialog.this.listeSelektierteAktieVerkaufen();
        }

        /* synthetic */ 30() {
        }
    }

    private final class 31
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Hauptdialog.this.listeSelektierteAktieAendern();
        }

        /* synthetic */ 31() {
        }
    }

    private final class 32
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Hauptdialog.this.listeSelektierteAktieSplitten();
        }

        /* synthetic */ 32() {
        }
    }

    private final class 33
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Hauptdialog.this.listeSelektierteAktieLoeschen();
        }

        /* synthetic */ 33() {
        }
    }

    private final class 34
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Hauptdialog.this.listeSelektierteAktieInfo();
        }

        /* synthetic */ 34() {
        }
    }

    private final class 35
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Hauptdialog.this.listeSelektierteAktieMaxkurs();
        }

        /* synthetic */ 35() {
        }
    }

    private final class 36
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Hauptdialog.this.portfolioNeu();
        }

        /* synthetic */ 36() {
        }
    }

    private final class 37
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Hauptdialog.this.portfolioUmbenennen();
        }

        /* synthetic */ 37() {
        }
    }

    private final class 38
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Hauptdialog.this.portfolioLoeschen();
        }

        /* synthetic */ 38() {
        }
    }

    private final class 39
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Hauptdialog.this.callAbout();
        }

        /* synthetic */ 39() {
        }
    }

    private final class 40
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            int n = Hauptdialog.this.chErloes.getSelectedIndex();
            if (n == 1) {
                if (AktienMan.erloessetzen == null) {
                    if (!Hauptdialog.this.isLocked(true)) {
                        AktienMan.erloessetzen = new VerkaufserloesSetzen();
                    }
                } else {
                    AktienMan.erloessetzen.toFront();
                }
            } else if (n == 2) {
                if (AktienMan.erloesloeschen == null) {
                    if (!Hauptdialog.this.isLocked(true)) {
                        AktienMan.erloesloeschen = new VerkaufserloesLoeschen();
                    }
                } else {
                    AktienMan.erloesloeschen.toFront();
                }
            }
            if (n != 0) {
                Hauptdialog.this.chErloes.select(0);
            }
        }

        /* synthetic */ 40() {
        }
    }

    private final class 41
    extends Thread {
        public synchronized void run() {
            try {
                this.wait(200L);
            }
            catch (InterruptedException interruptedException) {}
            AktienMan.hauptdialog.listeUpdate(false, false, true, false);
        }

        /* synthetic */ 41() {
        }
    }

    private static final class 42
    extends Thread {
        private final /* synthetic */ int val$mY;
        private final /* synthetic */ int val$mX;
        private final /* synthetic */ Component val$bal;
        private final /* synthetic */ Hauptdialog this$0;

        public synchronized void run() {
            try {
                this.wait(200L);
            }
            catch (InterruptedException interruptedException) {}
            this.this$0.aktienpopup.show(this.val$bal, this.val$mX, this.val$mY);
        }

        /* synthetic */ 42(Component component, int n, int n2, Hauptdialog hauptdialog) {
            this.val$bal = component;
            this.val$mX = n;
            this.val$mY = n2;
            this.this$0 = hauptdialog;
        }
    }

    private final class 43
    extends Thread {
        public synchronized void run() {
            try {
                this.wait(200L);
            }
            catch (InterruptedException interruptedException) {}
            Hauptdialog.this.backWindow.toFront();
        }

        /* synthetic */ 43() {
        }
    }
}

