#include "idct.h"

#define IDCT_CLIP_TABLE_OFFSET 512

static float ref_dct_matrix[8][8] = {
	{    // [0][0-7]
		 3.5355339059327379e-001,  3.5355339059327379e-001,
		 3.5355339059327379e-001,  3.5355339059327379e-001,
		 3.5355339059327379e-001,  3.5355339059327379e-001,
		 3.5355339059327379e-001,  3.5355339059327379e-001,
	}, { // [1][0-7]
		 4.9039264020161522e-001,  4.1573480615127262e-001,
		 2.7778511650980114e-001,  9.7545161008064166e-002,
		-9.7545161008064096e-002, -2.7778511650980098e-001,
		-4.1573480615127267e-001, -4.9039264020161522e-001,
	}, { // [2][0-7]
		 4.6193976625564337e-001,  1.9134171618254492e-001,
		-1.9134171618254486e-001, -4.6193976625564337e-001,
		-4.6193976625564342e-001, -1.9134171618254517e-001,
		 1.9134171618254500e-001,  4.6193976625564326e-001,
	}, { // [3][0-7]
		 4.1573480615127262e-001, -9.7545161008064096e-002,
		-4.9039264020161522e-001, -2.7778511650980109e-001,
		 2.7778511650980092e-001,  4.9039264020161522e-001,
		 9.7545161008064388e-002, -4.1573480615127256e-001,
	}, { // [4][0-7]
		 3.5355339059327379e-001, -3.5355339059327373e-001,
		-3.5355339059327384e-001,  3.5355339059327368e-001,
		 3.5355339059327384e-001, -3.5355339059327334e-001,
		-3.5355339059327356e-001,  3.5355339059327329e-001,
	}, { // [5][0-7]
		 2.7778511650980114e-001, -4.9039264020161522e-001,
		 9.7545161008064152e-002,  4.1573480615127273e-001,
		-4.1573480615127256e-001, -9.7545161008064013e-002,
		 4.9039264020161533e-001, -2.7778511650980076e-001,
	}, { // [6][0-7]
		 1.9134171618254492e-001, -4.6193976625564342e-001,
		 4.6193976625564326e-001, -1.9134171618254495e-001,
		-1.9134171618254528e-001,  4.6193976625564337e-001,
		-4.6193976625564320e-001,  1.9134171618254478e-001,
	}, { // [7][0-7]
		 9.7545161008064166e-002, -2.7778511650980109e-001,
		 4.1573480615127273e-001, -4.9039264020161533e-001,
		 4.9039264020161522e-001, -4.1573480615127251e-001,
		 2.7778511650980076e-001, -9.7545161008064291e-002,
	},
};


static short idct_clip_table[1024] = {
	-256,-256,-256,-256,-256,-256,-256,-256,
	-256,-256,-256,-256,-256,-256,-256,-256,
	-256,-256,-256,-256,-256,-256,-256,-256,
	-256,-256,-256,-256,-256,-256,-256,-256,
	-256,-256,-256,-256,-256,-256,-256,-256,
	-256,-256,-256,-256,-256,-256,-256,-256,
	-256,-256,-256,-256,-256,-256,-256,-256,
	-256,-256,-256,-256,-256,-256,-256,-256,
	-256,-256,-256,-256,-256,-256,-256,-256,
	-256,-256,-256,-256,-256,-256,-256,-256,
	-256,-256,-256,-256,-256,-256,-256,-256,
	-256,-256,-256,-256,-256,-256,-256,-256,
	-256,-256,-256,-256,-256,-256,-256,-256,
	-256,-256,-256,-256,-256,-256,-256,-256,
	-256,-256,-256,-256,-256,-256,-256,-256,
	-256,-256,-256,-256,-256,-256,-256,-256,
	-256,-256,-256,-256,-256,-256,-256,-256,
	-256,-256,-256,-256,-256,-256,-256,-256,
	-256,-256,-256,-256,-256,-256,-256,-256,
	-256,-256,-256,-256,-256,-256,-256,-256,
	-256,-256,-256,-256,-256,-256,-256,-256,
	-256,-256,-256,-256,-256,-256,-256,-256,
	-256,-256,-256,-256,-256,-256,-256,-256,
	-256,-256,-256,-256,-256,-256,-256,-256,
	-256,-256,-256,-256,-256,-256,-256,-256,
	-256,-256,-256,-256,-256,-256,-256,-256,
	-256,-256,-256,-256,-256,-256,-256,-256,
	-256,-256,-256,-256,-256,-256,-256,-256,
	-256,-256,-256,-256,-256,-256,-256,-256,
	-256,-256,-256,-256,-256,-256,-256,-256,
	-256,-256,-256,-256,-256,-256,-256,-256,
	-256,-256,-256,-256,-256,-256,-256,-256,
	-256,-255,-254,-253,-252,-251,-250,-249,
	-248,-247,-246,-245,-244,-243,-242,-241,
	-240,-239,-238,-237,-236,-235,-234,-233,
	-232,-231,-230,-229,-228,-227,-226,-225,
	-224,-223,-222,-221,-220,-219,-218,-217,
	-216,-215,-214,-213,-212,-211,-210,-209,
	-208,-207,-206,-205,-204,-203,-202,-201,
	-200,-199,-198,-197,-196,-195,-194,-193,
	-192,-191,-190,-189,-188,-187,-186,-185,
	-184,-183,-182,-181,-180,-179,-178,-177,
	-176,-175,-174,-173,-172,-171,-170,-169,
	-168,-167,-166,-165,-164,-163,-162,-161,
	-160,-159,-158,-157,-156,-155,-154,-153,
	-152,-151,-150,-149,-148,-147,-146,-145,
	-144,-143,-142,-141,-140,-139,-138,-137,
	-136,-135,-134,-133,-132,-131,-130,-129,
	-128,-127,-126,-125,-124,-123,-122,-121,
	-120,-119,-118,-117,-116,-115,-114,-113,
	-112,-111,-110,-109,-108,-107,-106,-105,
	-104,-103,-102,-101,-100, -99, -98, -97,
	 -96, -95, -94, -93, -92, -91, -90, -89,
	 -88, -87, -86, -85, -84, -83, -82, -81,
	 -80, -79, -78, -77, -76, -75, -74, -73,
	 -72, -71, -70, -69, -68, -67, -66, -65,
	 -64, -63, -62, -61, -60, -59, -58, -57,
	 -56, -55, -54, -53, -52, -51, -50, -49,
	 -48, -47, -46, -45, -44, -43, -42, -41,
	 -40, -39, -38, -37, -36, -35, -34, -33,
	 -32, -31, -30, -29, -28, -27, -26, -25,
	 -24, -23, -22, -21, -20, -19, -18, -17,
	 -16, -15, -14, -13, -12, -11, -10,  -9,
	  -8,  -7,  -6,  -5,  -4,  -3,  -2,  -1,
	   0,   1,   2,   3,   4,   5,   6,   7,
	   8,   9,  10,  11,  12,  13,  14,  15,
	  16,  17,  18,  19,  20,  21,  22,  23,
	  24,  25,  26,  27,  28,  29,  30,  31,
	  32,  33,  34,  35,  36,  37,  38,  39,
	  40,  41,  42,  43,  44,  45,  46,  47,
	  48,  49,  50,  51,  52,  53,  54,  55,
	  56,  57,  58,  59,  60,  61,  62,  63,
	  64,  65,  66,  67,  68,  69,  70,  71,
	  72,  73,  74,  75,  76,  77,  78,  79,
	  80,  81,  82,  83,  84,  85,  86,  87,
	  88,  89,  90,  91,  92,  93,  94,  95,
	  96,  97,  98,  99, 100, 101, 102, 103,
	 104, 105, 106, 107, 108, 109, 110, 111,
	 112, 113, 114, 115, 116, 117, 118, 119,
	 120, 121, 122, 123, 124, 125, 126, 127,
	 128, 129, 130, 131, 132, 133, 134, 135,
	 136, 137, 138, 139, 140, 141, 142, 143,
	 144, 145, 146, 147, 148, 149, 150, 151,
	 152, 153, 154, 155, 156, 157, 158, 159,
	 160, 161, 162, 163, 164, 165, 166, 167,
	 168, 169, 170, 171, 172, 173, 174, 175,
	 176, 177, 178, 179, 180, 181, 182, 183,
	 184, 185, 186, 187, 188, 189, 190, 191,
	 192, 193, 194, 195, 196, 197, 198, 199,
	 200, 201, 202, 203, 204, 205, 206, 207,
	 208, 209, 210, 211, 212, 213, 214, 215,
	 216, 217, 218, 219, 220, 221, 222, 223,
	 224, 225, 226, 227, 228, 229, 230, 231,
	 232, 233, 234, 235, 236, 237, 238, 239,
	 240, 241, 242, 243, 244, 245, 246, 247,
	 248, 249, 250, 251, 252, 253, 254, 255,
	 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255,
};

void IDCT_reference(short *block)
{
  int len = 8;
  int i, j, k, v;
  
  float partial_product, tmp[64];
  
  for (i = 0; i < len; i++)
    {
      for (j = 0; j < len; j++)
	{
	  partial_product = 0.0f;
	  
	  for (k = 0; k < 8; k++)
	    partial_product += ref_dct_matrix[k][j] * block[8 * i + k];
	  
	  tmp[8 * i + j] = partial_product;
	}
    }
  // Transpose operation is integrated into address mapping by switching loop order of i and j
  for (j = 0; j < len; j++)
    {
      for (i = 0; i < len; i++){
	partial_product = 0.0;
	
	for (k = 0; k < 8; k++)
	  partial_product += ref_dct_matrix[k][i] * tmp[8 * k + j];
	
	v = (int) floor(partial_product + 0.5);
	block[8 * i + j] = idct_clip_table[IDCT_CLIP_TABLE_OFFSET + v];
      }
    }
}

void IDCT_init()
{
}
