/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.common.JobCollection;
import net.sourceforge.dvb.projectx.common.Keys;
import net.sourceforge.dvb.projectx.common.Resource;
import net.sourceforge.dvb.projectx.gui.ColumnLayout;
import net.sourceforge.dvb.projectx.gui.CommonGui;

public class FilterPanel
extends JPanel {
    private CPComboBoxIndexListener _ComboBoxIndexListener = new CPComboBoxIndexListener();
    private CPComboBoxItemListener _ComboBoxItemListener = new CPComboBoxItemListener();
    private CPCheckBoxListener _CheckBoxListener = new CPCheckBoxListener();
    private CPTextFieldListener _TextFieldListener = new CPTextFieldListener();
    private CPTextFieldKeyListener _TextFieldKeyListener = new CPTextFieldKeyListener();
    private JobCollection collection;
    private JPanel container;
    private JPanel tabPanel;
    private JList includeList;
    private boolean actionDenied = false;
    private boolean hasChanged = false;
    private String[][] objects = new String[][]{Keys.KEY_WriteOptions_writeVideo, Keys.KEY_WriteOptions_writeAudio, Keys.KEY_OptionHorizontalResolution, Keys.KEY_OptionDAR, Keys.KEY_Streamtype_MpgVideo, Keys.KEY_Streamtype_MpgAudio, Keys.KEY_Streamtype_Ac3Audio, Keys.KEY_Streamtype_PcmAudio, Keys.KEY_Streamtype_Teletext, Keys.KEY_Streamtype_Subpicture, Keys.KEY_Streamtype_Vbi, Keys.KEY_useAutoPidFilter};
    private JComboBox combobox_34;
    private JComboBox combobox_24;
    private JCheckBox[] box = new JCheckBox[this.objects.length];

    public FilterPanel() {
        int n = 0;
        while (n < this.objects.length) {
            this.box[n] = new JCheckBox(Resource.getString(this.objects[n][0]));
            this.box[n].setToolTipText(Resource.getString(String.valueOf(this.objects[n][0]) + ".Tip"));
            this.box[n].setActionCommand(this.objects[n][0]);
            this.box[n].addActionListener(this._CheckBoxListener);
            ++n;
        }
        this.combobox_34 = new JComboBox<Object>(Keys.ITEMS_ExportHorizontalResolution);
        this.combobox_24 = new JComboBox<Object>(Keys.ITEMS_ExportDAR);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(this.buildPidPanel());
        jPanel.add(this.buildLimitPanel());
        jPanel.add(this.buildWritePanel());
        jPanel.add(this.buildStreamtypePanel());
        new Clock().start();
        this.add(jPanel);
        this.setVisible(true);
    }

    protected JPanel buildLimitPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new ColumnLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder("Filter Options"));
        jPanel.add(this.box[11]);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        this.box[2].setPreferredSize(new Dimension(110, 20));
        this.box[2].setMaximumSize(new Dimension(110, 20));
        jPanel2.add(this.box[2]);
        this.combobox_34 = new JComboBox<Object>(Keys.ITEMS_ExportHorizontalResolution);
        this.combobox_34.setMaximumRowCount(7);
        this.combobox_34.setPreferredSize(new Dimension(90, 20));
        this.combobox_34.setMaximumSize(new Dimension(90, 20));
        this.combobox_34.setActionCommand(Keys.KEY_ExportHorizontalResolution[0]);
        this.combobox_34.setEditable(true);
        this.combobox_34.addActionListener(this._ComboBoxItemListener);
        jPanel2.add(this.combobox_34);
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        this.box[3].setPreferredSize(new Dimension(80, 20));
        this.box[3].setMaximumSize(new Dimension(80, 20));
        jPanel3.add(this.box[3]);
        this.combobox_24 = new JComboBox<Object>(Keys.ITEMS_ExportDAR);
        this.combobox_24.setMaximumRowCount(7);
        this.combobox_24.setPreferredSize(new Dimension(120, 20));
        this.combobox_24.setMaximumSize(new Dimension(120, 20));
        this.combobox_24.setActionCommand(Keys.KEY_ExportDAR[0]);
        this.combobox_24.addActionListener(this._ComboBoxIndexListener);
        jPanel3.add(this.combobox_24);
        jPanel.add(jPanel3);
        jPanel.add(Box.createRigidArea(new Dimension(1, 10)));
        JButton jButton = new JButton(Resource.getString("FilterPanel.ResetAll"));
        jButton.setPreferredSize(new Dimension(180, 24));
        jButton.setMaximumSize(new Dimension(180, 24));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (FilterPanel.this.collection != null) {
                    FilterPanel.this.collection.setSettings(null);
                }
            }
        });
        jPanel.add(jButton);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(1, 1));
        jPanel4.add(jPanel);
        return jPanel4;
    }

    protected JPanel buildPidPanel() {
        this.includeList = new JList();
        this.includeList.setToolTipText(Resource.getString("CollectionPanel.PidList.Tip2"));
        this.includeList.setBackground(new Color(190, 225, 255));
        this.setPIDs();
        final JTextField jTextField = new JTextField("");
        jTextField.setPreferredSize(new Dimension(80, 25));
        jTextField.setMaximumSize(new Dimension(80, 25));
        jTextField.setEditable(true);
        jTextField.setActionCommand("ID");
        jTextField.setToolTipText(Resource.getString("CollectionPanel.PidList.Tip1"));
        jTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                this.getCollection();
                if (collection == null) {
                    return;
                }
                if (collection.isActive()) {
                    return;
                }
                String string = actionEvent.getActionCommand();
                try {
                    String string2 = jTextField.getText();
                    if (!string2.equals("")) {
                        if (!string2.startsWith("0x")) {
                            string2 = "0x" + Integer.toHexString(0x1FFF & Integer.parseInt(string2));
                        }
                        string2 = string2.toUpperCase().replace('X', 'x');
                        collection.addPID(string2);
                        includeList.setListData(collection.getPIDs());
                        includeList.ensureIndexIsVisible(collection.getPIDs().length - 1);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    Common.setOSDErrorMessage(Resource.getString("cutlistener.wrongnumber"));
                }
                jTextField.setText("");
            }
        });
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setPreferredSize(new Dimension(80, 96));
        jScrollPane.setMaximumSize(new Dimension(80, 96));
        jScrollPane.setViewportView(this.includeList);
        this.includeList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                FilterPanel.this.getCollection();
                if (FilterPanel.this.collection == null) {
                    return;
                }
                if (mouseEvent.getClickCount() >= 2) {
                    Object[] objectArray = FilterPanel.this.includeList.getSelectedValues();
                    FilterPanel.this.collection.removePID(objectArray);
                    FilterPanel.this.setPIDs();
                }
            }
        });
        JButton jButton = new JButton(CommonGui.loadIcon("trans.gif"));
        jButton.setPreferredSize(new Dimension(80, 22));
        jButton.setMaximumSize(new Dimension(80, 22));
        jButton.setActionCommand("transferPIDs");
        jButton.setToolTipText(Resource.getString("CollectionPanel.transferPids1.Tip"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FilterPanel.this.getCollection();
                if (FilterPanel.this.collection == null) {
                    return;
                }
                if (FilterPanel.this.collection.isActive()) {
                    return;
                }
                String string = actionEvent.getActionCommand();
                try {
                    Object[] objectArray = FilterPanel.this.includeList.getSelectedValues();
                    if (objectArray.length > 0) {
                        JobCollection jobCollection = Common.addCollection(FilterPanel.this.collection.getNewInstance());
                        FilterPanel.this.collection.removePID(objectArray);
                        jobCollection.clearPIDs();
                        jobCollection.addPID(objectArray);
                        jobCollection.determinePrimaryFileSegments();
                        FilterPanel.this.setPIDs();
                    }
                }
                catch (Exception exception) {
                    Common.setExceptionMessage(exception);
                }
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new ColumnLayout());
        jPanel.add(jTextField);
        jPanel.add(Box.createRigidArea(new Dimension(1, 40)));
        jPanel.add(jButton);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setBorder(BorderFactory.createTitledBorder(Resource.getString("CollectionPanel.PidList")));
        jPanel2.add(jPanel);
        jPanel2.add(Box.createRigidArea(new Dimension(10, 1)));
        jPanel2.add(jScrollPane);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(1, 1));
        jPanel3.add(jPanel2);
        return jPanel3;
    }

    protected JPanel buildStreamtypePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(Resource.getString("ExportPanel.StreamtypePanel")));
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setToolTipText(Resource.getString("ExportPanel.StreamtypePanel.Tip"));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new ColumnLayout());
        int n = 4;
        while (n < 8) {
            jPanel2.add(this.box[n]);
            ++n;
        }
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new ColumnLayout());
        int n2 = 8;
        while (n2 < 11) {
            jPanel3.add(this.box[n2]);
            ++n2;
        }
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(1, 1));
        jPanel4.add(jPanel);
        return jPanel4;
    }

    protected JPanel buildWritePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new ColumnLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(Resource.getString("ExportPanel.WriteOptions")));
        jPanel.setToolTipText(Resource.getString("ExportPanel.WriteOptions.Tip"));
        jPanel.add(this.box[0]);
        jPanel.add(this.box[1]);
        jPanel.add(Box.createRigidArea(new Dimension(1, 25)));
        JButton jButton = new JButton(Resource.getString("FilterPanel.MoreSettings"));
        jButton.setPreferredSize(new Dimension(180, 24));
        jButton.setMaximumSize(new Dimension(180, 24));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (FilterPanel.this.collection != null) {
                    CommonGui.getCollectionProperties().open(Common.getCollection(), Common.getActiveCollection());
                }
            }
        });
        jPanel.add(jButton);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 1));
        jPanel2.add(jPanel);
        return jPanel2;
    }

    private boolean getBooleanProperty(String[] stringArray) {
        boolean bl = false;
        if (this.collection == null) {
            return bl;
        }
        bl = this.collection.getSettings().getBooleanProperty(stringArray);
        return bl;
    }

    private void getCollection() {
        this.collection = Common.getCollection();
    }

    private void getCollectionAndSettings() {
        this.getCollection();
        if (this.collection != null && !this.collection.hasSettings()) {
            this.collection.setSettings(Common.getSettings());
        }
    }

    private int getIntProperty(String[] stringArray) {
        int n = 0;
        if (this.collection == null) {
            return n;
        }
        n = this.collection.getSettings().getIntProperty(stringArray);
        return n;
    }

    private Object[] getPIDs() {
        this.getCollection();
        if (this.collection == null) {
            return new Object[0];
        }
        return this.collection.getPIDs();
    }

    private String getProperty(String[] stringArray) {
        String string = "";
        if (this.collection == null) {
            return string;
        }
        string = this.collection.getSettings().getProperty(stringArray);
        return string;
    }

    private boolean performAction() {
        boolean bl = true;
        if (this.actionDenied) {
            return bl ^ true;
        }
        this.getCollectionAndSettings();
        if (this.collection == null) {
            return bl ^ true;
        }
        this.hasChanged = bl;
        return bl;
    }

    private void setBooleanProperty(String string, boolean bl) {
        if (!this.performAction()) {
            return;
        }
        this.collection.getSettings().setBooleanProperty(string, bl);
    }

    private void setCollectionProperties() {
        this.actionDenied = true;
        this.getCollection();
        int n = 0;
        while (n < this.box.length) {
            this.box[n].setSelected(this.getBooleanProperty(this.objects[n]));
            ++n;
        }
        this.combobox_34.setSelectedItem(this.getProperty(Keys.KEY_ExportHorizontalResolution));
        this.combobox_24.setSelectedIndex(this.getIntProperty(Keys.KEY_ExportDAR));
        this.actionDenied = false;
    }

    private void setPIDs() {
        if (this.includeList != null) {
            this.includeList.setListData(this.getPIDs());
        }
    }

    private void setProperty(String string, Object object) {
        if (!this.performAction()) {
            return;
        }
        this.collection.getSettings().setProperty(string, object);
    }

    private void setProperty(String string, String string2) {
        if (!this.performAction()) {
            return;
        }
        this.collection.getSettings().setProperty(string, string2);
    }

    class Clock
    implements Runnable {
        private Thread clockThread = null;
        private int last_collection = 0;

        Clock() {
        }

        public void run() {
            Thread thread = Thread.currentThread();
            while (this.clockThread == thread) {
                this.update();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public void start() {
            if (this.clockThread == null) {
                this.clockThread = new Thread((Runnable)this, "Clock_6");
                this.clockThread.setPriority(1);
                this.clockThread.start();
            }
        }

        public void stop() {
            this.clockThread = null;
        }

        private void update() {
            if (Common.getCollection() == null) {
                return;
            }
            if (Common.getCollection().hashCode() == this.last_collection) {
                if (FilterPanel.this.hasChanged && FilterPanel.this.collection.hasSettings()) {
                    return;
                }
                FilterPanel.this.hasChanged = false;
            }
            this.last_collection = Common.getCollection().hashCode();
            this.updatePidList();
            this.updateProperties();
        }

        private void updatePidList() {
            FilterPanel.this.setPIDs();
        }

        private void updateProperties() {
            FilterPanel.this.setCollectionProperties();
        }
    }

    class CPCheckBoxListener
    implements ActionListener {
        CPCheckBoxListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
            FilterPanel.this.setBooleanProperty(string, jCheckBox.isSelected());
        }
    }

    class CPComboBoxIndexListener
    implements ActionListener {
        CPComboBoxIndexListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            FilterPanel.this.setProperty(string, String.valueOf(jComboBox.getSelectedIndex()));
        }
    }

    class CPComboBoxItemListener
    implements ActionListener {
        CPComboBoxItemListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.indexOf(46) < 0) {
                return;
            }
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            FilterPanel.this.setProperty(string, jComboBox.getSelectedItem());
        }
    }

    class CPTextFieldKeyListener
    extends KeyAdapter {
        CPTextFieldKeyListener() {
        }

        public void keyReleased(KeyEvent keyEvent) {
            JTextField jTextField = (JTextField)keyEvent.getSource();
            jTextField.postActionEvent();
        }
    }

    class CPTextFieldListener
    implements ActionListener {
        CPTextFieldListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            JTextField jTextField = (JTextField)actionEvent.getSource();
            FilterPanel.this.setProperty(string, jTextField.getText());
        }
    }
}

