/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jlgui.player.amp.util.ini;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javazoom.jlgui.player.amp.util.ini.Alphabetizer;
import javazoom.jlgui.player.amp.util.ini.Array;

public class SortedStrings
extends Alphabetizer
implements Cloneable {
    public static final int DEFAULT_SIZE = 32;
    private String[] strings;
    private int string_count;
    private double growth_rate = 2.0;

    public SortedStrings() {
        this.clear();
    }

    public SortedStrings(int n) {
        this.clear(n);
    }

    public SortedStrings(DataInput dataInput) throws IOException {
        int n = this.string_count = dataInput.readInt();
        this.strings = new String[n];
        String[] stringArray = this.strings;
        for (int i = 0; i < n; ++i) {
            stringArray[i] = dataInput.readUTF();
        }
    }

    public SortedStrings(String[] stringArray) {
        this(stringArray.length);
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            this.add(stringArray[i]);
        }
    }

    public Object clone() {
        try {
            SortedStrings sortedStrings = (SortedStrings)super.clone();
            sortedStrings.strings = (String[])this.strings.clone();
            return sortedStrings;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void emit(DataOutput dataOutput) throws IOException {
        int n = this.string_count;
        String[] stringArray = this.strings;
        dataOutput.writeInt(n);
        for (int i = 0; i < n; ++i) {
            dataOutput.writeUTF(stringArray[i]);
        }
    }

    public SortedStrings merge(SortedStrings sortedStrings) {
        int n = this.string_count;
        int n2 = sortedStrings.string_count;
        String[] stringArray = this.strings;
        String[] stringArray2 = sortedStrings.strings;
        int n3 = 0;
        int n4 = 0;
        SortedStrings sortedStrings2 = new SortedStrings(n + n2);
        while (n3 < n && n4 < n2) {
            String string = stringArray[n3];
            String string2 = stringArray2[n4];
            if (SortedStrings.compare(string, string2) < 0) {
                sortedStrings2.add(string);
                ++n3;
                continue;
            }
            if (SortedStrings.compare(string2, string) < 0) {
                sortedStrings2.add(string2);
                ++n4;
                continue;
            }
            sortedStrings2.add(string);
            ++n3;
            ++n4;
        }
        if (n3 < n) {
            while (n3 < n) {
                sortedStrings2.add(stringArray[n3]);
                ++n3;
            }
        } else {
            while (n4 < n2) {
                sortedStrings2.add(stringArray2[n4]);
                ++n4;
            }
        }
        return sortedStrings2;
    }

    public SortedStrings diff(SortedStrings sortedStrings) {
        int n = this.string_count;
        int n2 = sortedStrings.string_count;
        String[] stringArray = this.strings;
        String[] stringArray2 = sortedStrings.strings;
        int n3 = 0;
        int n4 = 0;
        SortedStrings sortedStrings2 = new SortedStrings(n);
        while (n3 < n && n4 < n2) {
            String string = stringArray[n3];
            String string2 = stringArray2[n4];
            if (SortedStrings.compare(string, string2) < 0) {
                sortedStrings2.add(string);
                ++n3;
                continue;
            }
            if (SortedStrings.compare(string2, string) < 0) {
                ++n4;
                continue;
            }
            ++n3;
            ++n4;
        }
        if (n3 < n) {
            while (n3 < n) {
                sortedStrings2.add(stringArray[n3]);
                ++n3;
            }
        }
        return sortedStrings2;
    }

    public void clear() {
        this.clear(32);
    }

    public void clear(int n) {
        this.strings = new String[n];
        this.string_count = 0;
    }

    public void add(String string) {
        if (this.string_count == 0 || SortedStrings.greaterThan(string, this.strings[this.string_count - 1])) {
            if (this.string_count == this.strings.length) {
                this.strings = Array.grow(this.strings, this.growth_rate);
            }
            this.strings[this.string_count] = string;
            ++this.string_count;
        } else {
            this.insert(this.search(string), string);
        }
    }

    private void insert(int n, String string) {
        if (this.strings[n] == string) {
            return;
        }
        if (this.string_count == this.strings.length) {
            this.strings = Array.grow(this.strings, this.growth_rate);
        }
        System.arraycopy(this.strings, n, this.strings, n + 1, this.string_count - n);
        this.strings[n] = string;
        ++this.string_count;
    }

    public void remove(String string) {
        int n = this.search(string);
        if (n < this.string_count && SortedStrings.equalTo(this.strings[n], string)) {
            this.removeIndex(n);
        }
    }

    public void removeIndex(int n) {
        if (n < this.string_count) {
            System.arraycopy(this.strings, n + 1, this.strings, n, this.string_count - n - 1);
            --this.string_count;
        }
    }

    public boolean contains(String string) {
        int n = this.search(string);
        return n < this.string_count && SortedStrings.equalTo(this.strings[this.search(string)], string);
    }

    public int stringCount() {
        return this.string_count;
    }

    public int indexOf(String string) {
        int n = this.search(string);
        return n < this.string_count && SortedStrings.equalTo(this.strings[n], string) ? n : -1;
    }

    public String stringAt(int n) {
        return this.strings[n];
    }

    protected int search(String string) {
        int n;
        String[] stringArray = this.strings;
        int n2 = 0;
        int n3 = this.string_count;
        while (true) {
            if (n2 >= n3 - 1) {
                if (n2 < this.string_count && !SortedStrings.greaterThan(string, stringArray[n2])) {
                    return n2;
                }
                return n2 + 1;
            }
            n = (n2 + n3) / 2;
            String string2 = stringArray[n];
            if (SortedStrings.greaterThan(string, string2)) {
                n2 = n + 1;
                continue;
            }
            if (!SortedStrings.lessThan(string, string2)) break;
            n3 = n;
        }
        return n;
    }

    public String[] toStringArray() {
        String[] stringArray = new String[this.string_count];
        System.arraycopy(this.strings, 0, stringArray, 0, this.string_count);
        return stringArray;
    }

    public static String[] sort(String[] stringArray) {
        SortedStrings sortedStrings = new SortedStrings(stringArray);
        return sortedStrings.toStringArray();
    }
}

