/*
 * Decompiled with CFR 0.152.
 */
package davaguine.jmac.info;

import davaguine.jmac.info.InputSource;
import davaguine.jmac.info.RiffChunkHeader;
import davaguine.jmac.info.WaveFormat;
import davaguine.jmac.tools.ByteBuffer;
import davaguine.jmac.tools.File;
import davaguine.jmac.tools.IntegerPointer;
import davaguine.jmac.tools.JMACException;
import java.io.IOException;

public class WAVInputSource
extends InputSource {
    private File m_spIO;
    private boolean m_bOwnsInputIO;
    private WaveFormat m_wfeSource = new WaveFormat();
    private int m_nHeaderBytes;
    private int m_nDataBytes;
    private int m_nTerminatingBytes;
    private int m_nFileBytes;
    private boolean m_bIsValid = false;

    public WAVInputSource(File pIO, WaveFormat pwfeSource, IntegerPointer pTotalBlocks, IntegerPointer pHeaderBytes, IntegerPointer pTerminatingBytes) throws IOException {
        super(pIO, pwfeSource, pTotalBlocks, pHeaderBytes, pTerminatingBytes);
        if (pIO == null || pwfeSource == null) {
            throw new JMACException("Bad Parameters");
        }
        this.m_spIO = pIO;
        this.m_bOwnsInputIO = false;
        this.AnalyzeSource();
        pwfeSource = this.m_wfeSource;
        if (pTotalBlocks != null) {
            pTotalBlocks.value = this.m_nDataBytes / this.m_wfeSource.nBlockAlign;
        }
        if (pHeaderBytes != null) {
            pHeaderBytes.value = this.m_nHeaderBytes;
        }
        if (pTerminatingBytes != null) {
            pTerminatingBytes.value = this.m_nTerminatingBytes;
        }
        this.m_bIsValid = true;
    }

    public WAVInputSource(String pSourceName, WaveFormat pwfeSource, IntegerPointer pTotalBlocks, IntegerPointer pHeaderBytes, IntegerPointer pTerminatingBytes) throws IOException {
        super(pSourceName, pwfeSource, pTotalBlocks, pHeaderBytes, pTerminatingBytes);
        if (pSourceName == null || pwfeSource == null) {
            throw new JMACException("Bad Parameters");
        }
        this.m_spIO = File.createFile(pSourceName, "r");
        this.m_bOwnsInputIO = true;
        this.AnalyzeSource();
        pwfeSource.wFormatTag = this.m_wfeSource.wFormatTag;
        pwfeSource.nChannels = this.m_wfeSource.nChannels;
        pwfeSource.nSamplesPerSec = this.m_wfeSource.nSamplesPerSec;
        pwfeSource.nAvgBytesPerSec = this.m_wfeSource.nAvgBytesPerSec;
        pwfeSource.nBlockAlign = this.m_wfeSource.nBlockAlign;
        pwfeSource.wBitsPerSample = this.m_wfeSource.wBitsPerSample;
        if (pTotalBlocks != null) {
            pTotalBlocks.value = this.m_nDataBytes / this.m_wfeSource.nBlockAlign;
        }
        if (pHeaderBytes != null) {
            pHeaderBytes.value = this.m_nHeaderBytes;
        }
        if (pTerminatingBytes != null) {
            pTerminatingBytes.value = this.m_nTerminatingBytes;
        }
        this.m_bIsValid = true;
    }

    public void Close() throws IOException {
        if (this.m_bIsValid && this.m_bOwnsInputIO && this.m_spIO != null) {
            this.m_spIO.close();
        }
        this.m_spIO = null;
    }

    protected void finalize() {
        try {
            this.Close();
        }
        catch (IOException e) {
            throw new JMACException("Error while closing input stream.");
        }
    }

    public int GetData(ByteBuffer pBuffer, int nBlocks) throws IOException {
        if (!this.m_bIsValid) {
            throw new JMACException("Undefined Error");
        }
        int nBytes = this.m_wfeSource.nBlockAlign * nBlocks;
        int nBytesRead = this.m_spIO.read(pBuffer.getBytes(), pBuffer.getIndex(), nBytes);
        return nBytesRead / this.m_wfeSource.nBlockAlign;
    }

    public void GetHeaderData(byte[] pBuffer) throws IOException {
        if (!this.m_bIsValid) {
            throw new JMACException("Undefined Error");
        }
        if (this.m_nHeaderBytes > 0) {
            long nOriginalFileLocation = this.m_spIO.getFilePointer();
            this.m_spIO.seek(0L);
            if (this.m_spIO.read(pBuffer, 0, this.m_nHeaderBytes) != this.m_nHeaderBytes) {
                throw new JMACException("Undefined Error");
            }
            this.m_spIO.seek(nOriginalFileLocation);
        }
    }

    public void GetTerminatingData(byte[] pBuffer) throws IOException {
        if (!this.m_bIsValid) {
            throw new JMACException("Undefined Error");
        }
        if (this.m_nTerminatingBytes > 0) {
            long nOriginalFileLocation = this.m_spIO.getFilePointer();
            this.m_spIO.seek(this.m_spIO.length() - (long)this.m_nTerminatingBytes);
            if (this.m_spIO.read(pBuffer, 0, this.m_nTerminatingBytes) != this.m_nTerminatingBytes) {
                throw new JMACException("Undefined Error");
            }
            this.m_spIO.seek(nOriginalFileLocation);
        }
    }

    private void AnalyzeSource() throws IOException {
        this.m_spIO.seek(0L);
        this.m_nFileBytes = (int)this.m_spIO.length();
        int riffSignature = this.m_spIO.readInt();
        int goalSignature = 1380533830;
        if (riffSignature != goalSignature) {
            throw new JMACException("Invalid Input File");
        }
        this.m_spIO.readInt();
        int dataTypeSignature = this.m_spIO.readInt();
        goalSignature = 1463899717;
        if (dataTypeSignature != goalSignature) {
            throw new JMACException("Invalid Input File");
        }
        RiffChunkHeader RIFFChunkHeader = new RiffChunkHeader();
        RIFFChunkHeader.read(this.m_spIO);
        goalSignature = 544501094;
        while (RIFFChunkHeader.cChunkLabel != goalSignature) {
            this.m_spIO.seek(this.m_spIO.getFilePointer() + RIFFChunkHeader.nChunkBytes);
            RIFFChunkHeader.read(this.m_spIO);
        }
        WaveFormat WAVFormatHeader = new WaveFormat();
        WAVFormatHeader.readHeader(this.m_spIO);
        if (WAVFormatHeader.wFormatTag != 1) {
            throw new JMACException("Invalid Input File");
        }
        WaveFormat.FillWaveFormatEx(this.m_wfeSource, WAVFormatHeader.nSamplesPerSec, WAVFormatHeader.wBitsPerSample, WAVFormatHeader.nChannels);
        int nWAVFormatHeaderExtra = (int)(RIFFChunkHeader.nChunkBytes - 16L);
        if (nWAVFormatHeaderExtra < 0) {
            throw new JMACException("Invalid Input File");
        }
        this.m_spIO.seek(this.m_spIO.getFilePointer() + (long)nWAVFormatHeaderExtra);
        RIFFChunkHeader.read(this.m_spIO);
        goalSignature = 1635017060;
        while (RIFFChunkHeader.cChunkLabel != goalSignature) {
            this.m_spIO.seek(this.m_spIO.getFilePointer() + RIFFChunkHeader.nChunkBytes);
            RIFFChunkHeader.read(this.m_spIO);
        }
        this.m_nHeaderBytes = (int)this.m_spIO.getFilePointer();
        this.m_nDataBytes = (int)RIFFChunkHeader.nChunkBytes;
        if (this.m_nDataBytes < 0) {
            this.m_nDataBytes = this.m_nFileBytes - this.m_nHeaderBytes;
        }
        if (this.m_nDataBytes % this.m_wfeSource.nBlockAlign != 0) {
            throw new JMACException("Invalid Input File");
        }
        this.m_nTerminatingBytes = this.m_nFileBytes - this.m_nDataBytes - this.m_nHeaderBytes;
    }
}

