/*
 * Decompiled with CFR 0.152.
 */
package kj.dsp;

import java.util.ArrayList;
import javax.sound.sampled.SourceDataLine;
import kj.audio.KJAudioDataConsumer;
import kj.dsp.KJDigitalSignalProcessor;

public class KJDigitalSignalProcessingAudioDataConsumer
implements KJAudioDataConsumer {
    private static final int DEFAULT_SAMPLE_SIZE = 2048;
    private static final int DEFAULT_FPS = 70;
    public static final int SAMPLE_TYPE_EIGHT_BIT = 1;
    public static final int SAMPLE_TYPE_SIXTEEN_BIT = 2;
    public static final int CHANNEL_MODE_MONO = 1;
    public static final int CHANNEL_MODE_STEREO = 2;
    private Object readWriteLock = new Object();
    private SourceDataLine sourceDataLine;
    private int sampleSize;
    private long fpsAsNS;
    private long desiredFpsAsNS;
    private byte[] audioDataBuffer;
    private float[] left;
    private float[] right;
    private int position;
    private long offset;
    private SignalProcessor signalProcessor;
    private ArrayList dsps = new ArrayList();
    private int sampleType;
    private int channelMode;

    public KJDigitalSignalProcessingAudioDataConsumer() {
        this(2048, 70);
    }

    public KJDigitalSignalProcessingAudioDataConsumer(int pSampleSize, int pFramesPerSecond) {
        this(pSampleSize, pFramesPerSecond, 2, 2);
    }

    public KJDigitalSignalProcessingAudioDataConsumer(int pSampleSize, int pFramesPerSecond, int pSampleType, int pChannelMode) {
        this.sampleSize = pSampleSize;
        this.fpsAsNS = this.desiredFpsAsNS = 1000000000L / (long)pFramesPerSecond;
        this.setSampleType(pSampleType);
        this.setChannelMode(pChannelMode);
    }

    public void add(KJDigitalSignalProcessor pSignalProcessor) {
        this.dsps.add(pSignalProcessor);
    }

    public void remove(KJDigitalSignalProcessor pSignalProcessor) {
        this.dsps.remove(pSignalProcessor);
    }

    public void setChannelMode(int pChannelMode) {
        this.channelMode = pChannelMode;
    }

    public void setSampleType(int pSampleType) {
        this.sampleType = pSampleType;
    }

    public synchronized void start(SourceDataLine pSdl) {
        if (this.signalProcessor != null) {
            this.stop();
        }
        if (this.signalProcessor == null) {
            this.sourceDataLine = pSdl;
            this.audioDataBuffer = new byte[pSdl.getBufferSize() << 1];
            this.left = new float[this.sampleSize];
            this.right = new float[this.sampleSize];
            this.position = 0;
            this.offset = 0L;
            this.signalProcessor = new SignalProcessor();
            new Thread(this.signalProcessor).start();
        }
    }

    public synchronized void stop() {
        if (this.signalProcessor != null) {
            this.signalProcessor.stop();
            this.signalProcessor = null;
            this.audioDataBuffer = null;
            this.sourceDataLine = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeAudioData(byte[] pAudioData, int pOffset, int pLength) {
        Object object = this.readWriteLock;
        synchronized (object) {
            if (this.audioDataBuffer == null) {
                return;
            }
            int wOverrun = 0;
            if (this.position + pLength > this.audioDataBuffer.length - 1) {
                wOverrun = this.position + pLength - this.audioDataBuffer.length;
                pLength = this.audioDataBuffer.length - this.position;
            }
            System.arraycopy(pAudioData, pOffset, this.audioDataBuffer, this.position, pLength);
            if (wOverrun > 0) {
                System.arraycopy(pAudioData, pOffset + pLength, this.audioDataBuffer, 0, wOverrun);
                this.position = wOverrun;
            } else {
                this.position += pLength;
            }
        }
    }

    public void writeAudioData(byte[] pAudioData) {
        this.storeAudioData(pAudioData, 0, pAudioData.length);
    }

    public void writeAudioData(byte[] pAudioData, int pOffset, int pLength) {
        this.storeAudioData(pAudioData, pOffset, pLength);
    }

    private class SignalProcessor
    implements Runnable {
        boolean process = true;
        long lfp = 0L;
        int frameSize;

        public SignalProcessor() {
            this.frameSize = KJDigitalSignalProcessingAudioDataConsumer.this.sourceDataLine.getFormat().getFrameSize();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int calculateSamplePosition() {
            Object object = KJDigitalSignalProcessingAudioDataConsumer.this.readWriteLock;
            synchronized (object) {
                long wFp = KJDigitalSignalProcessingAudioDataConsumer.this.sourceDataLine.getLongFramePosition();
                long wNfp = this.lfp;
                this.lfp = wFp;
                int wSdp = (int)(wNfp * (long)this.frameSize - (long)KJDigitalSignalProcessingAudioDataConsumer.this.audioDataBuffer.length * KJDigitalSignalProcessingAudioDataConsumer.this.offset);
                return wSdp;
            }
        }

        private void processSamples(int pPosition) {
            block9: {
                int c;
                block11: {
                    block10: {
                        block8: {
                            c = pPosition;
                            if (KJDigitalSignalProcessingAudioDataConsumer.this.channelMode != 1 || KJDigitalSignalProcessingAudioDataConsumer.this.sampleType != 1) break block8;
                            int a = 0;
                            while (a < KJDigitalSignalProcessingAudioDataConsumer.this.sampleSize) {
                                if (c >= KJDigitalSignalProcessingAudioDataConsumer.this.audioDataBuffer.length) {
                                    KJDigitalSignalProcessingAudioDataConsumer kJDigitalSignalProcessingAudioDataConsumer = KJDigitalSignalProcessingAudioDataConsumer.this;
                                    kJDigitalSignalProcessingAudioDataConsumer.offset = kJDigitalSignalProcessingAudioDataConsumer.offset + 1L;
                                    c -= KJDigitalSignalProcessingAudioDataConsumer.this.audioDataBuffer.length;
                                }
                                ((KJDigitalSignalProcessingAudioDataConsumer)KJDigitalSignalProcessingAudioDataConsumer.this).left[a] = (float)KJDigitalSignalProcessingAudioDataConsumer.this.audioDataBuffer[c] / 128.0f;
                                ((KJDigitalSignalProcessingAudioDataConsumer)KJDigitalSignalProcessingAudioDataConsumer.this).right[a] = KJDigitalSignalProcessingAudioDataConsumer.this.left[a];
                                ++a;
                                ++c;
                            }
                            break block9;
                        }
                        if (KJDigitalSignalProcessingAudioDataConsumer.this.channelMode != 2 || KJDigitalSignalProcessingAudioDataConsumer.this.sampleType != 1) break block10;
                        int a = 0;
                        while (a < KJDigitalSignalProcessingAudioDataConsumer.this.sampleSize) {
                            if (c >= KJDigitalSignalProcessingAudioDataConsumer.this.audioDataBuffer.length) {
                                KJDigitalSignalProcessingAudioDataConsumer kJDigitalSignalProcessingAudioDataConsumer = KJDigitalSignalProcessingAudioDataConsumer.this;
                                kJDigitalSignalProcessingAudioDataConsumer.offset = kJDigitalSignalProcessingAudioDataConsumer.offset + 1L;
                                c -= KJDigitalSignalProcessingAudioDataConsumer.this.audioDataBuffer.length;
                            }
                            ((KJDigitalSignalProcessingAudioDataConsumer)KJDigitalSignalProcessingAudioDataConsumer.this).left[a] = (float)KJDigitalSignalProcessingAudioDataConsumer.this.audioDataBuffer[c] / 128.0f;
                            ((KJDigitalSignalProcessingAudioDataConsumer)KJDigitalSignalProcessingAudioDataConsumer.this).right[a] = (float)KJDigitalSignalProcessingAudioDataConsumer.this.audioDataBuffer[c + 1] / 128.0f;
                            ++a;
                            c += 2;
                        }
                        break block9;
                    }
                    if (KJDigitalSignalProcessingAudioDataConsumer.this.channelMode != 1 || KJDigitalSignalProcessingAudioDataConsumer.this.sampleType != 2) break block11;
                    int a = 0;
                    while (a < KJDigitalSignalProcessingAudioDataConsumer.this.sampleSize) {
                        if (c >= KJDigitalSignalProcessingAudioDataConsumer.this.audioDataBuffer.length) {
                            KJDigitalSignalProcessingAudioDataConsumer kJDigitalSignalProcessingAudioDataConsumer = KJDigitalSignalProcessingAudioDataConsumer.this;
                            kJDigitalSignalProcessingAudioDataConsumer.offset = kJDigitalSignalProcessingAudioDataConsumer.offset + 1L;
                            c -= KJDigitalSignalProcessingAudioDataConsumer.this.audioDataBuffer.length;
                        }
                        ((KJDigitalSignalProcessingAudioDataConsumer)KJDigitalSignalProcessingAudioDataConsumer.this).left[a] = (float)((KJDigitalSignalProcessingAudioDataConsumer.this.audioDataBuffer[c + 1] << 8) + KJDigitalSignalProcessingAudioDataConsumer.this.audioDataBuffer[c]) / 32767.0f;
                        ((KJDigitalSignalProcessingAudioDataConsumer)KJDigitalSignalProcessingAudioDataConsumer.this).right[a] = KJDigitalSignalProcessingAudioDataConsumer.this.left[a];
                        ++a;
                        c += 2;
                    }
                    break block9;
                }
                if (KJDigitalSignalProcessingAudioDataConsumer.this.channelMode != 2 || KJDigitalSignalProcessingAudioDataConsumer.this.sampleType != 2) break block9;
                int a = 0;
                while (a < KJDigitalSignalProcessingAudioDataConsumer.this.sampleSize) {
                    if (c >= KJDigitalSignalProcessingAudioDataConsumer.this.audioDataBuffer.length) {
                        KJDigitalSignalProcessingAudioDataConsumer kJDigitalSignalProcessingAudioDataConsumer = KJDigitalSignalProcessingAudioDataConsumer.this;
                        kJDigitalSignalProcessingAudioDataConsumer.offset = kJDigitalSignalProcessingAudioDataConsumer.offset + 1L;
                        c -= KJDigitalSignalProcessingAudioDataConsumer.this.audioDataBuffer.length;
                    }
                    ((KJDigitalSignalProcessingAudioDataConsumer)KJDigitalSignalProcessingAudioDataConsumer.this).left[a] = (float)((KJDigitalSignalProcessingAudioDataConsumer.this.audioDataBuffer[c + 1] << 8) + KJDigitalSignalProcessingAudioDataConsumer.this.audioDataBuffer[c]) / 32767.0f;
                    ((KJDigitalSignalProcessingAudioDataConsumer)KJDigitalSignalProcessingAudioDataConsumer.this).right[a] = (float)((KJDigitalSignalProcessingAudioDataConsumer.this.audioDataBuffer[c + 3] << 8) + KJDigitalSignalProcessingAudioDataConsumer.this.audioDataBuffer[c + 2]) / 32767.0f;
                    ++a;
                    c += 4;
                }
            }
        }

        public void run() {
            while (this.process) {
                try {
                    long wStn = System.nanoTime();
                    int wSdp = this.calculateSamplePosition();
                    if (wSdp > 0) {
                        this.processSamples(wSdp);
                    }
                    int a = 0;
                    while (a < KJDigitalSignalProcessingAudioDataConsumer.this.dsps.size()) {
                        float wFrr = (float)KJDigitalSignalProcessingAudioDataConsumer.this.fpsAsNS / (float)KJDigitalSignalProcessingAudioDataConsumer.this.desiredFpsAsNS;
                        try {
                            ((KJDigitalSignalProcessor)KJDigitalSignalProcessingAudioDataConsumer.this.dsps.get(a)).process(KJDigitalSignalProcessingAudioDataConsumer.this.left, KJDigitalSignalProcessingAudioDataConsumer.this.right, wFrr);
                        }
                        catch (Exception pEx) {
                            System.err.println("-- DSP Exception: ");
                            pEx.printStackTrace();
                        }
                        ++a;
                    }
                    long wDelay = KJDigitalSignalProcessingAudioDataConsumer.this.fpsAsNS - (System.nanoTime() - wStn);
                    if (KJDigitalSignalProcessingAudioDataConsumer.this.dsps.isEmpty()) {
                        wDelay = 1000000000L;
                    }
                    if (wDelay > 0L) {
                        try {
                            Thread.sleep(wDelay / 1000000L, (int)wDelay % 1000000);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (KJDigitalSignalProcessingAudioDataConsumer.this.fpsAsNS > KJDigitalSignalProcessingAudioDataConsumer.this.desiredFpsAsNS) {
                            KJDigitalSignalProcessingAudioDataConsumer kJDigitalSignalProcessingAudioDataConsumer = KJDigitalSignalProcessingAudioDataConsumer.this;
                            kJDigitalSignalProcessingAudioDataConsumer.fpsAsNS = kJDigitalSignalProcessingAudioDataConsumer.fpsAsNS - wDelay;
                            continue;
                        }
                        KJDigitalSignalProcessingAudioDataConsumer.this.fpsAsNS = KJDigitalSignalProcessingAudioDataConsumer.this.desiredFpsAsNS;
                        continue;
                    }
                    KJDigitalSignalProcessingAudioDataConsumer kJDigitalSignalProcessingAudioDataConsumer = KJDigitalSignalProcessingAudioDataConsumer.this;
                    kJDigitalSignalProcessingAudioDataConsumer.fpsAsNS = kJDigitalSignalProcessingAudioDataConsumer.fpsAsNS + -wDelay;
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (Exception pEx) {
                    System.err.println("- DSP Exception: ");
                    pEx.printStackTrace();
                }
            }
        }

        public void stop() {
            this.process = false;
        }
    }
}

