/*
 * Decompiled with CFR 0.152.
 */
package net.n3.nanoxml;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PushbackInputStream;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Stack;
import net.n3.nanoxml.IXMLReader;

public class StdXMLReader
implements IXMLReader {
    private Stack pbreaders;
    private Stack linereaders;
    private Stack systemIds;
    private Stack publicIds;
    private PushbackReader currentPbReader;
    private LineNumberReader currentLineReader;
    private URL currentSystemID;
    private String currentPublicID;

    public static IXMLReader stringReader(String str) {
        return new StdXMLReader(new StringReader(str));
    }

    public static IXMLReader fileReader(String filename) throws FileNotFoundException, IOException {
        StdXMLReader reader = new StdXMLReader(new FileInputStream(filename));
        reader.setSystemID(filename);
        return reader;
    }

    public StdXMLReader(String publicID, String systemID) throws MalformedURLException, FileNotFoundException, IOException {
        URL systemIDasURL = null;
        try {
            systemIDasURL = new URL(systemID);
        }
        catch (MalformedURLException e) {
            systemID = "file:" + systemID;
            try {
                systemIDasURL = new URL(systemID);
            }
            catch (MalformedURLException e2) {
                throw e;
            }
        }
        Reader reader = this.openStream(publicID, systemIDasURL.toString());
        this.currentLineReader = new LineNumberReader(reader);
        this.currentPbReader = new PushbackReader(this.currentLineReader, 2);
        this.pbreaders = new Stack();
        this.linereaders = new Stack();
        this.publicIds = new Stack();
        this.systemIds = new Stack();
        this.currentPublicID = publicID;
        this.currentSystemID = systemIDasURL;
    }

    public StdXMLReader(Reader reader) {
        this.currentLineReader = new LineNumberReader(reader);
        this.currentPbReader = new PushbackReader(this.currentLineReader, 2);
        this.pbreaders = new Stack();
        this.linereaders = new Stack();
        this.publicIds = new Stack();
        this.systemIds = new Stack();
        this.currentPublicID = "";
        try {
            this.currentSystemID = new URL("file:.");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    protected void finalize() throws Throwable {
        this.currentLineReader = null;
        this.currentPbReader = null;
        this.pbreaders.clear();
        this.pbreaders = null;
        this.linereaders.clear();
        this.linereaders = null;
        this.publicIds.clear();
        this.publicIds = null;
        this.systemIds.clear();
        this.systemIds = null;
        this.currentPublicID = null;
        super.finalize();
    }

    protected String getEncoding(String str) {
        if (!str.startsWith("<?xml")) {
            return null;
        }
        int index = 5;
        while (index < str.length()) {
            char delimiter;
            int index2;
            StringBuffer key = new StringBuffer();
            while (index < str.length() && str.charAt(index) <= ' ') {
                ++index;
            }
            while (index < str.length() && str.charAt(index) >= 'a' && str.charAt(index) <= 'z') {
                key.append(str.charAt(index));
                ++index;
            }
            while (index < str.length() && str.charAt(index) <= ' ') {
                ++index;
            }
            if (index >= str.length() || str.charAt(index) != '=') break;
            while (index < str.length() && str.charAt(index) != '\'' && str.charAt(index) != '\"') {
                ++index;
            }
            if (index >= str.length() || (index2 = str.indexOf(delimiter = str.charAt(index), ++index)) < 0) break;
            if (key.toString().equals("encoding")) {
                return str.substring(index, index2);
            }
            index = index2 + 1;
        }
        return null;
    }

    protected Reader stream2reader(InputStream stream, StringBuffer charsRead) throws IOException {
        PushbackInputStream pbstream = new PushbackInputStream(stream);
        int b = pbstream.read();
        switch (b) {
            case 0: 
            case 254: 
            case 255: {
                pbstream.unread(b);
                return new InputStreamReader((InputStream)pbstream, "UTF-16");
            }
            case 239: {
                for (int i = 0; i < 2; ++i) {
                    pbstream.read();
                }
                return new InputStreamReader((InputStream)pbstream, "UTF-8");
            }
            case 60: {
                String encoding;
                b = pbstream.read();
                charsRead.append('<');
                while (b > 0 && b != 62) {
                    charsRead.append((char)b);
                    b = pbstream.read();
                }
                if (b > 0) {
                    charsRead.append((char)b);
                }
                if ((encoding = this.getEncoding(charsRead.toString())) == null) {
                    return new InputStreamReader((InputStream)pbstream, "UTF-8");
                }
                charsRead.setLength(0);
                try {
                    return new InputStreamReader((InputStream)pbstream, encoding);
                }
                catch (UnsupportedEncodingException e) {
                    return new InputStreamReader((InputStream)pbstream, "UTF-8");
                }
            }
        }
        charsRead.append((char)b);
        return new InputStreamReader((InputStream)pbstream, "UTF-8");
    }

    public StdXMLReader(InputStream stream) throws IOException {
        StringBuffer charsRead = new StringBuffer();
        Reader reader = this.stream2reader(stream, charsRead);
        this.currentLineReader = new LineNumberReader(reader);
        this.currentPbReader = new PushbackReader(this.currentLineReader, 2);
        this.pbreaders = new Stack();
        this.linereaders = new Stack();
        this.publicIds = new Stack();
        this.systemIds = new Stack();
        this.currentPublicID = "";
        try {
            this.currentSystemID = new URL("file:.");
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        this.startNewStream(new StringReader(charsRead.toString()));
    }

    public char read() throws IOException {
        int ch = this.currentPbReader.read();
        while (ch < 0) {
            if (this.pbreaders.empty()) {
                throw new IOException("Unexpected EOF");
            }
            this.currentPbReader.close();
            this.currentPbReader = (PushbackReader)this.pbreaders.pop();
            this.currentLineReader = (LineNumberReader)this.linereaders.pop();
            this.currentSystemID = (URL)this.systemIds.pop();
            this.currentPublicID = (String)this.publicIds.pop();
            ch = this.currentPbReader.read();
        }
        if (ch == 13) {
            ch = this.currentPbReader.read();
            if (ch != 10 && ch > 0) {
                this.currentPbReader.unread(ch);
            }
            return '\n';
        }
        return (char)ch;
    }

    public boolean atEOFOfCurrentStream() throws IOException {
        int ch = this.currentPbReader.read();
        if (ch < 0) {
            return true;
        }
        this.currentPbReader.unread(ch);
        return false;
    }

    public boolean atEOF() throws IOException {
        int ch = this.currentPbReader.read();
        while (ch < 0) {
            if (this.pbreaders.empty()) {
                return true;
            }
            this.currentPbReader.close();
            this.currentPbReader = (PushbackReader)this.pbreaders.pop();
            this.currentLineReader = (LineNumberReader)this.linereaders.pop();
            this.currentSystemID = (URL)this.systemIds.pop();
            this.currentPublicID = (String)this.publicIds.pop();
            ch = this.currentPbReader.read();
        }
        this.currentPbReader.unread(ch);
        return false;
    }

    public void unread(char ch) throws IOException {
        this.currentPbReader.unread(ch);
    }

    public Reader openStream(String publicID, String systemID) throws MalformedURLException, FileNotFoundException, IOException {
        URL url = new URL(this.currentSystemID, systemID);
        StringBuffer charsRead = new StringBuffer();
        Reader reader = this.stream2reader(url.openStream(), charsRead);
        if (charsRead.length() == 0) {
            return reader;
        }
        String charsReadStr = charsRead.toString();
        PushbackReader pbreader = new PushbackReader(reader, charsReadStr.length());
        for (int i = charsReadStr.length() - 1; i >= 0; --i) {
            pbreader.unread(charsReadStr.charAt(i));
        }
        return pbreader;
    }

    public void startNewStream(Reader reader) {
        this.pbreaders.push(this.currentPbReader);
        this.linereaders.push(this.currentLineReader);
        this.systemIds.push(this.currentSystemID);
        this.publicIds.push(this.currentPublicID);
        this.currentLineReader = new LineNumberReader(reader);
        this.currentPbReader = new PushbackReader(this.currentLineReader, 2);
    }

    public int getLineNr() {
        return this.currentLineReader.getLineNumber() + 1;
    }

    public void setSystemID(String systemID) throws MalformedURLException {
        this.currentSystemID = new URL(this.currentSystemID, systemID);
    }

    public void setPublicID(String publicID) {
        this.currentPublicID = publicID;
    }

    public String getSystemID() {
        return this.currentSystemID.toString();
    }

    public String getPublicID() {
        return this.currentPublicID;
    }
}

