/*
 * Decompiled with CFR 0.152.
 */
package xtrememp.visualization.spectrum;

import java.nio.FloatBuffer;

public class FFT {
    private float[] xre;
    private float[] xim;
    private float[] mag;
    private float[] fftSin;
    private float[] fftCos;
    private int[] fftBr;
    private int ss;
    private int ss2;
    private int nu;

    public FFT(int sampleSize) {
        this.nu = (int)Math.ceil(Math.log(sampleSize) / Math.log(2.0));
        this.ss = (int)Math.pow(2.0, this.nu);
        this.ss2 = this.ss >> 1;
        this.xre = new float[this.ss];
        this.xim = new float[this.ss];
        this.mag = new float[this.ss2];
        this.fftSin = new float[this.nu * this.ss2];
        this.fftCos = new float[this.nu * this.ss2];
        this.prepareTables();
    }

    private int bitrev(int j, int nu) {
        int j1 = j;
        int k = 0;
        for (int i = 0; i < nu; ++i) {
            int j2 = j1 >> 1;
            k = (k << 1) + j1 - (j2 << 1);
            j1 = j2;
        }
        return k;
    }

    public float[] calculate(FloatBuffer sample) {
        int a;
        int n2 = this.ss2;
        int len = sample.capacity();
        for (a = 0; a < len; ++a) {
            this.xre[a] = sample.get(a);
            this.xim[a] = 0.0f;
        }
        for (a = sample.capacity(); a < this.ss; ++a) {
            this.xre[a] = 0.0f;
            this.xim[a] = 0.0f;
        }
        int x = 0;
        for (int l = 0; l < this.nu; ++l) {
            for (int k = 0; k < this.ss; k += n2) {
                for (int i = 0; i < n2; ++i) {
                    float c = this.fftCos[x];
                    float s = this.fftSin[x];
                    int kn2 = k + n2;
                    float tr = this.xre[kn2] * c + this.xim[kn2] * s;
                    float ti = this.xim[kn2] * c - this.xre[kn2] * s;
                    this.xre[kn2] = this.xre[k] - tr;
                    this.xim[kn2] = this.xim[k] - ti;
                    int n = k;
                    this.xre[n] = this.xre[n] + tr;
                    int n3 = k++;
                    this.xim[n3] = this.xim[n3] + ti;
                    ++x;
                }
            }
            n2 >>= 1;
        }
        for (int k = 0; k < this.ss; ++k) {
            int r = this.fftBr[k];
            if (r <= k) continue;
            float tr = this.xre[k];
            this.xre[k] = this.xre[r];
            this.xre[r] = tr;
            float ti = this.xim[k];
            this.xim[k] = this.xim[r];
            this.xim[r] = ti;
        }
        for (int i = 0; i < this.ss2; ++i) {
            this.mag[i] = Math.abs((float)Math.sqrt(this.xre[i] * this.xre[i] + this.xim[i] * this.xim[i]) / (float)this.ss);
        }
        return this.mag;
    }

    public float[] calculateFrequencyTable(float sampleRate) {
        float fr = sampleRate / 2.0f;
        float bw = fr / (float)this.ss2;
        float[] ft = new float[this.ss2];
        int b = 0;
        for (float fp = bw / 2.0f; fp <= fr; fp += bw) {
            ft[b] = fp;
            ++b;
        }
        return ft;
    }

    public int getInputSampleSize() {
        return this.ss;
    }

    public int getOutputSampleSize() {
        return this.ss2;
    }

    private void prepareTables() {
        int n2 = this.ss2;
        int nu1 = this.nu - 1;
        int k = 0;
        int x = 0;
        for (int l = 0; l < this.nu; ++l) {
            while (k < this.ss) {
                for (int i = 0; i < n2; ++i) {
                    double p = this.bitrev(k >> nu1, this.nu);
                    double arg = Math.PI * p * 2.0 / (double)this.ss;
                    this.fftSin[x] = (float)Math.sin(arg);
                    this.fftCos[x] = (float)Math.cos(arg);
                    ++k;
                    ++x;
                }
                k += n2;
            }
            k = 0;
            --nu1;
            n2 >>= 1;
        }
        this.fftBr = new int[this.ss];
        for (k = 0; k < this.ss; ++k) {
            this.fftBr[k] = this.bitrev(k, this.nu);
        }
    }
}

