/*
 * Decompiled with CFR 0.152.
 */
package xtrememp.visualization;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Point;
import java.nio.FloatBuffer;
import javax.sound.sampled.SourceDataLine;
import xtrememp.player.dsp.DssContext;
import xtrememp.visualization.Visualization;

public final class VolumeMeter
extends Visualization {
    public static final String NAME = "Volume Meter";
    public static final float DEFAULT_VU_METER_DECAY = 0.02f;
    private LinearGradientPaint lgp;
    private float oldLeft;
    private float oldRight;
    private float decay = 0.02f;

    @Override
    public void init(int sampleSize, SourceDataLine sourceDataLine) {
    }

    @Override
    public String getDisplayName() {
        return NAME;
    }

    @Override
    public synchronized void render(DssContext dssContext, Graphics2D g2d, int width, int height) {
        float leftLevel = 0.0f;
        float rightLevel = 0.0f;
        int sampleSize = dssContext.getSampleSize();
        FloatBuffer[] channelsBuffer = dssContext.getDataNormalized();
        for (int i = 0; i < sampleSize; ++i) {
            leftLevel += Math.abs(channelsBuffer[0].get(i));
            rightLevel += Math.abs(channelsBuffer[1].get(i));
        }
        leftLevel = leftLevel * 2.0f / (float)sampleSize;
        rightLevel = rightLevel * 2.0f / (float)sampleSize;
        if (leftLevel > 1.0f) {
            leftLevel = 1.0f;
        }
        if (rightLevel > 1.0f) {
            rightLevel = 1.0f;
        }
        if (leftLevel >= this.oldLeft - this.decay) {
            this.oldLeft = leftLevel;
        } else {
            this.oldLeft -= this.decay;
            if (this.oldLeft < 0.0f) {
                this.oldLeft = 0.0f;
            }
        }
        if (rightLevel >= this.oldRight - this.decay) {
            this.oldRight = rightLevel;
        } else {
            this.oldRight -= this.decay;
            if (this.oldRight < 0.0f) {
                this.oldRight = 0.0f;
            }
        }
        g2d.setColor(this.backgroundColor);
        g2d.fillRect(0, 0, width, height);
        if (this.lgp == null || this.lgp.getEndPoint().getX() != (double)width) {
            Point start = new Point(0, 0);
            Point end = new Point(width, 0);
            float[] dist = new float[]{0.0f, 0.25f, 0.75f, 1.0f};
            Color[] colors = new Color[]{Color.green.darker().darker(), Color.green, Color.yellow, Color.red};
            this.lgp = new LinearGradientPaint(start, end, dist, colors, MultipleGradientPaint.CycleMethod.REPEAT);
        }
        g2d.setPaint(this.lgp);
        int wHeight = (height >> 1) - 8;
        g2d.fillRect(8, 6, (int)(this.oldLeft * (float)(width - 32)), wHeight);
        g2d.fillRect(8, wHeight + 10, (int)(this.oldRight * (float)(width - 32)), wHeight);
    }
}

