/*
 * Decompiled with CFR 0.152.
 */
package xtrememp.update;

import xtrememp.util.Utilities;

public class Version
implements Comparable<Version> {
    private int majorNumber;
    private int minorNumber;
    private int microNumber;
    private VersionType versionType = VersionType.FINAL;
    private String codename;
    private String releaseDate;
    private String downloadURL;

    public Version() {
    }

    public Version(int majorNumber, int minorNumber, int microNumber, VersionType versionType, String codename, String date, String downloadURL) {
        this.majorNumber = majorNumber;
        this.minorNumber = minorNumber;
        this.microNumber = microNumber;
        this.versionType = versionType;
        this.codename = codename;
        this.releaseDate = date;
        this.downloadURL = downloadURL;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Version) {
            return this.compareTo((Version)obj) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public int compareTo(Version version) {
        if (version == null) {
            throw new IllegalArgumentException();
        }
        if (this.majorNumber > version.getMajorNumber()) {
            return 1;
        }
        if (this.majorNumber < version.getMajorNumber()) {
            return -1;
        }
        if (this.minorNumber > version.getMinorNumber()) {
            return 1;
        }
        if (this.minorNumber < version.getMinorNumber()) {
            return -1;
        }
        if (this.microNumber > version.getMicroNumber()) {
            return 1;
        }
        if (this.microNumber < version.getMicroNumber()) {
            return -1;
        }
        return this.versionType.compareTo(version.getVersionType());
    }

    public int getMajorNumber() {
        return this.majorNumber;
    }

    public int getMinorNumber() {
        return this.minorNumber;
    }

    public int getMicroNumber() {
        return this.microNumber;
    }

    public VersionType getVersionType() {
        return this.versionType;
    }

    public String getCodename() {
        return this.codename;
    }

    public String getReleaseDate() {
        return this.releaseDate;
    }

    public String getDownloadURL() {
        return this.downloadURL;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.majorNumber);
        sb.append(".");
        sb.append(this.minorNumber);
        sb.append(".");
        sb.append(this.microNumber);
        if (this.versionType != VersionType.FINAL) {
            sb.append(" ");
            sb.append((Object)this.versionType);
        }
        return sb.toString();
    }

    protected void setMajorNumber(int majorNumber) {
        this.majorNumber = majorNumber;
    }

    protected void setMinorNumber(int minorNumber) {
        this.minorNumber = minorNumber;
    }

    protected void setMicroNumber(int microNumber) {
        this.microNumber = microNumber;
    }

    protected void setVersionType(VersionType versionType) {
        this.versionType = versionType;
    }

    protected void setCodename(String codename) {
        this.codename = codename;
    }

    protected void setReleaseDate(String date) {
        this.releaseDate = date;
    }

    protected void setDownloadURL(String downloadURL) {
        this.downloadURL = downloadURL;
    }

    public static Version getCurrentVersion() {
        int majorNumber = Integer.parseInt(Utilities.tr("Application.version.majorNumber"));
        int minorNumber = Integer.parseInt(Utilities.tr("Application.version.minorNumber"));
        int microNumber = Integer.parseInt(Utilities.tr("Application.version.microNumber"));
        VersionType versionType = VersionType.FINAL;
        String codename = Utilities.tr("Application.version.codename");
        String releaseDate = Utilities.tr("Application.version.releaseDate");
        String downloadURL = Utilities.tr("Application.homepage");
        return new Version(majorNumber, minorNumber, microNumber, versionType, codename, releaseDate, downloadURL);
    }

    public static enum VersionType {
        DEV("Dev"),
        BETA("Beta"),
        BETA1("Beta 1"),
        BETA2("Beta 2"),
        RC("RC"),
        RC1("RC 1"),
        RC2("RC 2"),
        FINAL("Final");

        private String vtString;

        private VersionType(String vtString) {
            this.vtString = vtString;
        }

        public String toString() {
            return this.vtString;
        }
    }
}

