/*
 * Decompiled with CFR 0.152.
 */
package xtrememp.ui.table;

import java.awt.Color;
import java.awt.Component;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.skin.SkinChangeListener;
import xtrememp.playlist.PlaylistItem;
import xtrememp.ui.table.PlaylistColumn;
import xtrememp.ui.table.SortOrderIcon;

public class PlaylistTableColumn
extends TableColumn
implements TableCellRenderer,
SkinChangeListener {
    private Icon UP_ICON;
    private Icon DOWN_ICON;
    private PlaylistColumn playlistColumn;
    private JLabel headerLabel;
    private boolean sortOrderUp = false;

    public PlaylistTableColumn(PlaylistColumn playlistColumn, int index) {
        super(index);
        this.playlistColumn = playlistColumn;
        this.setPreferredWidth(playlistColumn.getWidth());
        this.setHeaderRenderer(this);
        Border headerBorder = UIManager.getBorder("TableHeader.cellBorder");
        this.headerLabel = new JLabel(playlistColumn.getDisplayName(), 0);
        this.headerLabel.setBorder(headerBorder);
        this.setHeaderValue(this.headerLabel);
        this.skinChanged();
        SubstanceLookAndFeel.registerSkinChangeListener((SkinChangeListener)this);
    }

    public String getName() {
        return this.playlistColumn.getDisplayName();
    }

    public PlaylistColumn getPlaylistColumn() {
        return this.playlistColumn;
    }

    public boolean isSortOrderUp() {
        return this.sortOrderUp;
    }

    public void setSortOrderUp(boolean sortOrderUp) {
        this.sortOrderUp = sortOrderUp;
        if (sortOrderUp) {
            this.headerLabel.setIcon(this.UP_ICON);
        } else {
            this.headerLabel.setIcon(this.DOWN_ICON);
        }
    }

    public Comparator<PlaylistItem> getComparator() {
        Comparator<PlaylistItem> comparator = this.getPlaylistColumn().getComparator();
        return this.sortOrderUp ? comparator : Collections.reverseOrder(comparator);
    }

    public void reset() {
        this.headerLabel.setIcon(null);
        this.sortOrderUp = false;
    }

    @Override
    public void setWidth(int width) {
        super.setWidth(width);
        this.playlistColumn.setWidth(width);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return (JComponent)value;
    }

    public final void skinChanged() {
        Color iconColor = SubstanceLookAndFeel.getCurrentSkin().getColorScheme((Component)this.headerLabel, ComponentState.ENABLED).getForegroundColor();
        this.UP_ICON = new SortOrderIcon(iconColor, true);
        this.DOWN_ICON = new SortOrderIcon(iconColor, false);
        if (this.headerLabel.getIcon() != null) {
            if (this.sortOrderUp) {
                this.headerLabel.setIcon(this.UP_ICON);
            } else {
                this.headerLabel.setIcon(this.DOWN_ICON);
            }
        }
    }
}

