/*
 * Decompiled with CFR 0.152.
 */
package xtrememp.ui.slider;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import javax.swing.JSlider;
import javax.swing.plaf.SliderUI;
import javax.swing.plaf.basic.BasicSliderUI;
import xtrememp.ControlListener;

public class SeekSlider
extends JSlider {
    private final ControlListener listener;
    private volatile int oldValue = 0;
    private volatile boolean seekPressed = false;

    public SeekSlider(ControlListener controlListener) {
        super(0, 0, 0);
        MouseMotionListener[] ssMouseMotionListeners;
        MouseListener[] ssMouseListeners;
        this.listener = controlListener;
        for (MouseListener ml : ssMouseListeners = this.getMouseListeners()) {
            if (!(ml instanceof BasicSliderUI.TrackListener)) continue;
            this.removeMouseListener(ml);
        }
        for (MouseMotionListener mml : ssMouseMotionListeners = this.getMouseMotionListeners()) {
            if (!(mml instanceof BasicSliderUI.TrackListener)) continue;
            this.removeMouseMotionListener(mml);
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                SeekSlider.this.seekPressed = true;
                SeekSlider.this.updateValue(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                SeekSlider.this.listener.acSeek();
                SeekSlider.this.seekPressed = false;
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                SeekSlider.this.updateValue(e);
            }
        });
    }

    protected void updateValue(MouseEvent e) {
        SliderUI sliderUI = this.getUI();
        if (this.isEnabled() && sliderUI instanceof BasicSliderUI) {
            BasicSliderUI basicSliderUI = (BasicSliderUI)sliderUI;
            if (this.getOrientation() == 0) {
                this.setValue(basicSliderUI.valueForXPosition(e.getX()));
            } else {
                this.setValue(basicSliderUI.valueForYPosition(e.getY()));
            }
            this.oldValue = this.getValue();
            this.listener.acUpdateTime(this.oldValue);
        }
    }

    public void reset() {
        this.oldValue = 0;
        this.setValue(0);
        this.setMinimum(0);
        this.setMaximum(0);
    }

    public boolean isPressed() {
        return this.seekPressed;
    }

    public int getOldValue() {
        return this.oldValue;
    }
}

