/*
 * Decompiled with CFR 0.152.
 */
package xtrememp.ui.button;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class PopupButton
extends JToggleButton {
    private JPopupMenu popupMenu;
    private boolean shouldHandlePopupWillBecomeInvisible = true;

    public PopupButton() {
        this.setFocusable(false);
        this.addMouseListener(this.createButtonMouseListener());
        this.popupMenu = new JPopupMenu();
        this.popupMenu.addPopupMenuListener(this.createPopupMenuListener());
        JComboBox box = new JComboBox();
        Object preventHide = box.getClientProperty("doNotCancelPopup");
        this.putClientProperty("doNotCancelPopup", preventHide);
    }

    public PopupButton(Icon icon) {
        this();
        this.setIcon(icon);
    }

    private MouseListener createButtonMouseListener() {
        return new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (PopupButton.this.popupMenu.isShowing()) {
                    PopupButton.this.hidePopupMenu();
                } else {
                    PopupButton.this.showPopupMenu();
                }
            }
        };
    }

    private PopupMenuListener createPopupMenuListener() {
        return new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                if (PopupButton.this.shouldHandlePopupWillBecomeInvisible) {
                    PopupButton.this.setSelected(false);
                }
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                PopupButton.this.setSelected(false);
            }
        };
    }

    private void hidePopupMenu() {
        this.shouldHandlePopupWillBecomeInvisible = false;
        this.popupMenu.setVisible(false);
        this.shouldHandlePopupWillBecomeInvisible = true;
    }

    private void showPopupMenu() {
        this.popupMenu.show(this, 0, this.getHeight());
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }
}

