/*
 * Decompiled with CFR 0.152.
 */
package xtrememp.tag;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.apache.commons.io.FilenameUtils;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.AudioFileIO;
import org.jaudiotagger.audio.AudioHeader;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.exceptions.InvalidAudioFrameException;
import org.jaudiotagger.audio.exceptions.ReadOnlyFileException;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagException;
import xtrememp.tag.TagInfo;
import xtrememp.util.Utilities;

public class GenericInfo
extends TagInfo {
    protected int bitspersample = -1;
    protected int framesize = -1;

    @Override
    public void load(File input) throws IOException, UnsupportedAudioFileException {
        this.size = input.length();
        this.location = input.getPath();
        this.title = FilenameUtils.getBaseName(input.getName());
        try {
            Tag tag;
            AudioFile audioFile = AudioFileIO.read((File)input);
            AudioHeader audioHeader = audioFile.getAudioHeader();
            if (audioHeader != null) {
                this.encodingType = audioHeader.getEncodingType();
                this.format = audioHeader.getFormat();
                this.sampleRate = audioHeader.getSampleRate();
                this.sampleRateAsNumber = audioHeader.getSampleRateAsNumber();
                this.bitRate = audioHeader.getBitRate();
                this.bitRateAsNumber = audioHeader.getBitRateAsNumber();
                this.duration = audioHeader.getTrackLength();
                this.channels = audioHeader.getChannels();
            }
            if ((tag = audioFile.getTag()) != null) {
                this.title = tag.getFirst(FieldKey.TITLE);
                this.artist = tag.getFirst(FieldKey.ARTIST);
                this.album = tag.getFirst(FieldKey.ALBUM);
                this.year = tag.getFirst(FieldKey.YEAR);
                this.genre = tag.getFirst(FieldKey.GENRE);
                this.track = tag.getFirst(FieldKey.TRACK);
                this.comment = tag.getFirst(FieldKey.COMMENT);
                this.artwork = tag.getFirstArtwork();
            }
        }
        catch (CannotReadException ex) {
            throw new IOException(ex);
        }
        catch (TagException ex) {
            throw new UnsupportedAudioFileException(ex.getMessage());
        }
        catch (ReadOnlyFileException ex) {
            throw new IOException(ex);
        }
        catch (InvalidAudioFrameException ex) {
            throw new UnsupportedAudioFileException(ex.getMessage());
        }
    }

    @Override
    public void load(URL input) throws IOException, UnsupportedAudioFileException {
        this.location = input.toString();
        AudioFileFormat aff = AudioSystem.getAudioFileFormat(input);
        this.loadInfo(aff);
    }

    @Override
    public void load(InputStream input) throws IOException, UnsupportedAudioFileException {
        AudioFileFormat aff = AudioSystem.getAudioFileFormat(input);
        this.loadInfo(aff);
    }

    protected void loadInfo(AudioFileFormat aff) throws UnsupportedAudioFileException {
        this.encodingType = aff.getType().toString();
        AudioFormat audioFormat = aff.getFormat();
        this.channelsAsNumber = audioFormat.getChannels();
        this.sampleRateAsNumber = (int)audioFormat.getSampleRate();
        this.bitspersample = audioFormat.getSampleSizeInBits();
        this.framesize = audioFormat.getFrameSize();
        this.bitRateAsNumber = Math.round(this.bitspersample * this.sampleRateAsNumber * this.channelsAsNumber / 1000);
    }

    @Override
    public String getCodecDetails() {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><b>Encoding Type: </b>");
        sb.append(this.getEncodingType().toUpperCase());
        sb.append("<br><b>Format: </b>").append(this.getFormat());
        sb.append("<br><b>Sampling rate: </b>");
        sb.append(this.getSampleRate()).append(" Hz");
        sb.append("<br><b>Bitrate: </b>");
        sb.append(this.getBitRate()).append(" Kbps");
        sb.append("<br><b>Channels: </b>");
        sb.append(this.getChannels());
        if (this.size != -1L) {
            sb.append("<br><b>Size: </b>");
            sb.append(Utilities.byteCountToDisplaySize(this.size));
        }
        sb.append("</html>");
        return sb.toString();
    }
}

