/*
 * Decompiled with CFR 0.152.
 */
package xtrememp.player.dsp;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.SourceDataLine;

public class DssContext {
    private SourceDataLine sourceDataLine;
    private AudioFormat audioFormat;
    private FloatBuffer[] channelsBuffer;
    private int offset;
    private int sampleSize;
    private int channels;
    private int frameSize;
    private int ssib;
    private int channelSize;
    private float audioSampleSize;

    public DssContext(SourceDataLine sourceDataLine, int sampleSize) {
        this.sourceDataLine = sourceDataLine;
        this.audioFormat = sourceDataLine.getFormat();
        this.sampleSize = sampleSize;
        this.channels = this.audioFormat.getChannels();
        this.frameSize = this.audioFormat.getFrameSize();
        this.ssib = this.audioFormat.getSampleSizeInBits();
        this.channelSize = this.frameSize / this.channels;
        this.audioSampleSize = 1 << this.ssib - 1;
        this.channelsBuffer = new FloatBuffer[this.channels];
        for (int ch = 0; ch < this.channels; ++ch) {
            this.channelsBuffer[ch] = FloatBuffer.allocate(sampleSize);
        }
    }

    public void normalizeData(ByteBuffer audioDataBuffer) {
        long lfp = this.sourceDataLine.getLongFramePosition();
        this.offset = (int)(lfp * (long)this.frameSize % (long)audioDataBuffer.capacity());
        int sp = 0;
        int pos = this.offset;
        while (sp < this.sampleSize) {
            if (pos >= audioDataBuffer.capacity()) {
                pos = 0;
            }
            int ch = 0;
            int cdp = 0;
            while (ch < this.channels) {
                float sm = (float)(audioDataBuffer.get(pos + cdp) & 0xFF) - 128.0f;
                int bp = 1;
                for (int bt = 8; bt < this.ssib; bt += 8) {
                    sm += (float)(audioDataBuffer.get(pos + cdp + bp) << bt);
                    ++bp;
                }
                this.channelsBuffer[ch].put(sp, sm / this.audioSampleSize);
                ++ch;
                cdp += this.channelSize;
            }
            ++sp;
            pos += this.frameSize;
        }
    }

    public FloatBuffer[] getDataNormalized() {
        return this.channelsBuffer;
    }

    public int getSampleSize() {
        return this.sampleSize;
    }

    public int getOffset() {
        return this.offset;
    }

    public SourceDataLine getSourceDataLine() {
        return this.sourceDataLine;
    }
}

