/*
 * Decompiled with CFR 0.152.
 */
package xtrememp;

import com.melloware.jintellitype.IntellitypeListener;
import com.melloware.jintellitype.JIntellitype;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.pushingpixels.lafwidget.animation.AnimationConfigurationManager;
import org.pushingpixels.lafwidget.animation.AnimationFacet;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SubstanceConstants;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xtrememp.ControlListener;
import xtrememp.MultipleInstancesHandler;
import xtrememp.PlaylistManager;
import xtrememp.PreferencesDialog;
import xtrememp.Settings;
import xtrememp.VisualizationManager;
import xtrememp.player.audio.AudioPlayer;
import xtrememp.player.audio.PlaybackEvent;
import xtrememp.player.audio.PlaybackListener;
import xtrememp.player.audio.PlayerException;
import xtrememp.playlist.Playlist;
import xtrememp.playlist.PlaylistEvent;
import xtrememp.playlist.PlaylistException;
import xtrememp.playlist.PlaylistIO;
import xtrememp.playlist.PlaylistItem;
import xtrememp.playlist.PlaylistListener;
import xtrememp.tag.TagInfo;
import xtrememp.ui.button.NextButton;
import xtrememp.ui.button.PlayPauseButton;
import xtrememp.ui.button.PreviousButton;
import xtrememp.ui.button.StopButton;
import xtrememp.ui.button.VolumeButton;
import xtrememp.ui.label.BusyLabel;
import xtrememp.ui.skin.GFXUIListener;
import xtrememp.ui.slider.SeekSlider;
import xtrememp.update.SoftwareUpdate;
import xtrememp.update.Version;
import xtrememp.util.AbstractSwingWorker;
import xtrememp.util.LanguageBundle;
import xtrememp.util.OSUtils;
import xtrememp.util.Utilities;
import xtrememp.util.file.AudioFileFilter;
import xtrememp.util.file.PlaylistFileFilter;

public final class XtremeMP
implements ActionListener,
ControlListener,
PlaybackListener,
PlaylistListener,
IntellitypeListener,
GFXUIListener {
    private static final Logger logger = LoggerFactory.getLogger(XtremeMP.class);
    private final AudioFileFilter audioFileFilter = AudioFileFilter.INSTANCE;
    private final PlaylistFileFilter playlistFileFilter = PlaylistFileFilter.INSTANCE;
    private final Version currentVersion = Version.getCurrentVersion();
    private static XtremeMP instance;
    private JFrame mainFrame;
    private JMenuBar menuBar;
    private JMenu fileMenu;
    private JMenu playerMenu;
    private JMenu playModeSubMenu;
    private JMenu viewMenu;
    private JMenu helpMenu;
    private JMenuItem openMenuItem;
    private JMenuItem openURLMenuItem;
    private JMenuItem openPlaylistMenuItem;
    private JMenuItem savePlaylistMenuItem;
    private JMenuItem preferencesMenuItem;
    private JMenuItem exitMenuItem;
    private JMenuItem nextMenuItem;
    private JMenuItem playPauseMenuItem;
    private JMenuItem stopMenuItem;
    private JMenuItem previousMenuItem;
    private JMenuItem randomizePlaylistMenuItem;
    private JRadioButtonMenuItem playlistManagerMenuItem;
    private JRadioButtonMenuItem visualizationMenuItem;
    private JRadioButtonMenuItem playModeRepeatNoneMenuItem;
    private JRadioButtonMenuItem playModeRepeatOneMenuItem;
    private JRadioButtonMenuItem playModeRepeatAllMenuItem;
    private JRadioButtonMenuItem playModeShuffleMenuItem;
    private JMenuItem updateMenuItem;
    private JMenuItem aboutMenuItem;
    private BusyLabel busyLabel;
    private JPanel mainPanel;
    private VisualizationManager visualizationManager;
    private JPanel controlPanel;
    private AudioPlayer audioPlayer;
    private Playlist playlist;
    private PlaylistManager playlistManager;
    private StopButton stopButton;
    private PreviousButton previousButton;
    private PlayPauseButton playPauseButton;
    private NextButton nextButton;
    private VolumeButton volumeButton;
    private JSlider volumeSlider;
    private JLabel timeLabel;
    private JLabel statusLabel;
    private JLabel playModeLabel;
    private SeekSlider seekSlider;
    private PlaylistItem currentPli;

    private XtremeMP() {
    }

    public static XtremeMP getInstance() {
        if (instance == null) {
            instance = new XtremeMP();
        }
        return instance;
    }

    public JFrame getMainFrame() {
        return this.mainFrame;
    }

    public BusyLabel getBusyLabel() {
        return this.busyLabel;
    }

    public AudioPlayer getAudioPlayer() {
        return this.audioPlayer;
    }

    public void init(String[] args) {
        OptionBuilder.withArgName("URL");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Open from URL");
        Option urlOption = OptionBuilder.create("url");
        Options options = new Options();
        options.addOption("help", false, "print help information");
        options.addOption("version", false, "print the version information");
        options.addOption(urlOption);
        PosixParser parser = new PosixParser();
        try {
            final CommandLine line = parser.parse(options, args);
            if (line.hasOption("h") || line.hasOption("help")) {
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp("xtrememp", options);
                System.exit(0);
            }
            if (line.hasOption("version")) {
                StringBuilder appVersion = new StringBuilder(Utilities.tr("Application.title"));
                appVersion.append(" ").append(this.currentVersion);
                appVersion.append(" [").append(Utilities.tr("Dialog.About.Codename"));
                appVersion.append(" ").append(Utilities.tr("Application.version.codename"));
                appVersion.append("]");
                System.out.println(appVersion.toString());
                System.exit(0);
            }
            if (OSUtils.IS_OS_WINDOWS) {
                String libraryLocation = OSUtils.IS_ARCH_X64 ? "\\native\\JIntellitype64.dll" : "\\native\\JIntellitype.dll";
                JIntellitype.setLibraryLocation((String)(OSUtils.USER_DIR + libraryLocation));
                if (JIntellitype.isJIntellitypeSupported()) {
                    JIntellitype.getInstance().addIntellitypeListener((IntellitypeListener)this);
                }
            }
            this.audioPlayer = new AudioPlayer();
            this.audioPlayer.addPlaybackListener(this);
            String mixerName = Settings.getMixerName();
            if (!Utilities.isNullOrEmpty(mixerName)) {
                this.audioPlayer.setMixerName(mixerName);
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!OSUtils.IS_OS_WINDOWS_7 && !OSUtils.IS_OS_WINDOWS_VISTA) {
                        JFrame.setDefaultLookAndFeelDecorated(true);
                        JDialog.setDefaultLookAndFeelDecorated(true);
                    }
                    UIManager.put("substancelaf.focusKind", SubstanceConstants.FocusKind.NONE);
                    SubstanceLookAndFeel.setSkin((String)Settings.getSkin());
                    XtremeMP.this.guiEffectsStateChanged(Settings.isUIEffectsEnabled());
                    StringBuilder appTitle = new StringBuilder(Utilities.tr("Application.title"));
                    appTitle.append(" ").append(XtremeMP.this.currentVersion);
                    XtremeMP.this.mainFrame = new JFrame(appTitle.toString());
                    XtremeMP.this.mainFrame.setIconImages(Utilities.getIconImages());
                    Rectangle boundsRect = Settings.getMainFrameBounds();
                    if (boundsRect.x <= 0 || boundsRect.y <= 0) {
                        XtremeMP.this.mainFrame.setSize(boundsRect.width, boundsRect.height);
                        XtremeMP.this.mainFrame.setLocationRelativeTo(null);
                    } else {
                        XtremeMP.this.mainFrame.setBounds(boundsRect);
                    }
                    XtremeMP.this.mainFrame.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent ev) {
                            XtremeMP.this.exit();
                        }
                    });
                    XtremeMP.this.createMenuBar();
                    XtremeMP.this.createMainPanels();
                    XtremeMP.this.mainFrame.setMinimumSize(new Dimension(((XtremeMP)XtremeMP.this).controlPanel.getPreferredSize().width + 50, 200));
                    XtremeMP.this.playlist = XtremeMP.this.playlistManager.getPlaylist();
                    XtremeMP.this.playlist.addPlaylistListener(XtremeMP.this);
                    XtremeMP.this.playlist.setPlayMode(Settings.getPlayMode());
                    List<String> argList = Arrays.asList(line.getArgs());
                    ArrayList<File> fileList = new ArrayList<File>();
                    if (argList.isEmpty()) {
                        File playlistFile = new File(Settings.getCacheDir(), "default.xspf");
                        if (playlistFile.exists()) {
                            XtremeMP.this.playlistManager.loadPlaylist(playlistFile.getAbsolutePath());
                        }
                    } else {
                        XtremeMP.this.playlistManager.setFirstLoad(true);
                        if (argList.size() == 1) {
                            File file = new File(argList.get(0));
                            if (XtremeMP.this.audioFileFilter.accept(file)) {
                                fileList.add(file);
                                XtremeMP.this.playlistManager.addFiles(fileList);
                            } else if (XtremeMP.this.playlistFileFilter.accept(file)) {
                                XtremeMP.this.playlistManager.loadPlaylist(file.getAbsolutePath());
                            }
                        } else {
                            for (String arg : argList) {
                                File file = new File(arg);
                                if (!XtremeMP.this.audioFileFilter.accept(file)) continue;
                                fileList.add(file);
                            }
                            XtremeMP.this.playlistManager.addFiles(fileList);
                        }
                    }
                    XtremeMP.this.mainFrame.setVisible(true);
                }
            });
        }
        catch (ParseException exp) {
            logger.error("Parsing failed.", (Object)exp.getMessage());
        }
    }

    public static void main(String ... args) throws Exception {
        Settings.loadSettings();
        Settings.configureLogback();
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                logger.error(t.getName(), e);
            }
        });
        System.err.close();
        if (!MultipleInstancesHandler.getInstance().isFirstInstance()) {
            MultipleInstancesHandler.getInstance().sendArgumentsToFirstInstance(args);
        } else {
            Locale locale = Utilities.getLanguages()[Settings.getLanguageIndex()];
            Locale.setDefault(locale);
            LanguageBundle.setLanguage(locale);
            AnimationConfigurationManager.getInstance().disallowAnimations(AnimationFacet.ICON_GLOW, JTable.class);
            AnimationConfigurationManager.getInstance().disallowAnimations(AnimationFacet.ROLLOVER, JTable.class);
            AnimationConfigurationManager.getInstance().disallowAnimations(AnimationFacet.SELECTION, JTable.class);
            XtremeMP.getInstance().init(args);
            if (Settings.isAutomaticUpdatesEnabled()) {
                SoftwareUpdate.scheduleCheckForUpdates(5000L);
            }
        }
    }

    protected void exit() {
        Settings.setMainFrameBounds(this.mainFrame.getBounds());
        Settings.setPlaylistPosition(this.playlist.getCursorPosition());
        Settings.setPlaylistColumns(this.playlistManager.getPlaylistColums());
        Settings.storeSettings();
        try {
            File playlistFile = new File(Settings.getCacheDir(), "default.xspf");
            PlaylistIO.saveXSPF(this.playlist, playlistFile.getAbsolutePath());
        }
        catch (PlaylistException ex) {
            logger.error("Can't save default playlist", (Throwable)ex);
        }
        this.audioPlayer.stop();
        if (JIntellitype.isJIntellitypeSupported()) {
            JIntellitype.getInstance().cleanUp();
        }
        MultipleInstancesHandler.getInstance().dispose();
        logger.info("Exit application...");
        System.exit(0);
    }

    protected void createMenuBar() {
        this.menuBar = new JMenuBar();
        String fileMenuStr = Utilities.tr("MainFrame.Menu.File");
        this.fileMenu = new JMenu(fileMenuStr);
        this.fileMenu.setMnemonic(fileMenuStr.charAt(0));
        this.openMenuItem = new JMenuItem(Utilities.tr("MainFrame.Menu.File.OpenFile"));
        this.openMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 128));
        this.openMenuItem.setIcon(Utilities.FOLDER_ICON);
        this.openMenuItem.addActionListener(this);
        this.fileMenu.add(this.openMenuItem);
        this.openURLMenuItem = new JMenuItem(Utilities.tr("MainFrame.Menu.File.OpenURL"));
        this.openURLMenuItem.setAccelerator(KeyStroke.getKeyStroke(85, 128));
        this.openURLMenuItem.setIcon(Utilities.FOLDER_REMOTE_ICON);
        this.openURLMenuItem.addActionListener(this);
        this.fileMenu.add(this.openURLMenuItem);
        this.fileMenu.addSeparator();
        this.openPlaylistMenuItem = new JMenuItem(Utilities.tr("MainFrame.Menu.File.OpenPlaylist"));
        this.openPlaylistMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 192));
        this.openPlaylistMenuItem.setIcon(Utilities.DOCUMENT_OPEN_ICON);
        this.openPlaylistMenuItem.addActionListener(this);
        this.fileMenu.add(this.openPlaylistMenuItem);
        this.savePlaylistMenuItem = new JMenuItem(Utilities.tr("MainFrame.Menu.File.SavePlaylist"));
        this.savePlaylistMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 192));
        this.savePlaylistMenuItem.setIcon(Utilities.DOCUMENT_SAVE_ICON);
        this.savePlaylistMenuItem.addActionListener(this);
        this.fileMenu.add(this.savePlaylistMenuItem);
        this.fileMenu.addSeparator();
        this.preferencesMenuItem = new JMenuItem(Utilities.tr("MainFrame.Menu.File.Preferences"));
        this.preferencesMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, 128));
        this.preferencesMenuItem.addActionListener(this);
        this.fileMenu.add(this.preferencesMenuItem);
        this.fileMenu.addSeparator();
        this.exitMenuItem = new JMenuItem(Utilities.tr("MainFrame.Menu.File.Exit"));
        this.exitMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 128));
        this.exitMenuItem.addActionListener(this);
        this.fileMenu.add(this.exitMenuItem);
        this.menuBar.add(this.fileMenu);
        String playerMenuStr = Utilities.tr("MainFrame.Menu.Player");
        this.playerMenu = new JMenu(playerMenuStr);
        this.playerMenu.setMnemonic(playerMenuStr.charAt(0));
        this.playPauseMenuItem = new JMenuItem(Utilities.tr("MainFrame.Menu.Player.Play"));
        this.playPauseMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, 128));
        this.playPauseMenuItem.addActionListener(this);
        this.playerMenu.add(this.playPauseMenuItem);
        this.stopMenuItem = new JMenuItem(Utilities.tr("MainFrame.Menu.Player.Stop"));
        this.stopMenuItem.setAccelerator(KeyStroke.getKeyStroke(66, 128));
        this.stopMenuItem.setEnabled(false);
        this.stopMenuItem.addActionListener(this);
        this.playerMenu.add(this.stopMenuItem);
        this.previousMenuItem = new JMenuItem(Utilities.tr("MainFrame.Menu.Player.Previous"));
        this.previousMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 128));
        this.previousMenuItem.setEnabled(false);
        this.previousMenuItem.addActionListener(this);
        this.playerMenu.add(this.previousMenuItem);
        this.nextMenuItem = new JMenuItem(Utilities.tr("MainFrame.Menu.Player.Next"));
        this.nextMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 128));
        this.nextMenuItem.setEnabled(false);
        this.nextMenuItem.addActionListener(this);
        this.playerMenu.add(this.nextMenuItem);
        this.playerMenu.addSeparator();
        String playModeSubMenuStr = Utilities.tr("MainFrame.Menu.Player.PlayMode");
        this.playModeSubMenu = new JMenu(playModeSubMenuStr);
        this.playModeRepeatNoneMenuItem = new JRadioButtonMenuItem(Utilities.tr("MainFrame.Menu.Player.PlayMode.RepeatNone"));
        this.playModeRepeatNoneMenuItem.setIcon(Utilities.PLAYLIST_REPEAT_NONE_ICON);
        this.playModeRepeatNoneMenuItem.addActionListener(this);
        this.playModeSubMenu.add(this.playModeRepeatNoneMenuItem);
        this.playModeRepeatOneMenuItem = new JRadioButtonMenuItem(Utilities.tr("MainFrame.Menu.Player.PlayMode.RepeatOne"));
        this.playModeRepeatOneMenuItem.setIcon(Utilities.PLAYLIST_REPEAT_ONE_ICON);
        this.playModeRepeatOneMenuItem.addActionListener(this);
        this.playModeSubMenu.add(this.playModeRepeatOneMenuItem);
        this.playModeRepeatAllMenuItem = new JRadioButtonMenuItem(Utilities.tr("MainFrame.Menu.Player.PlayMode.RepeatAll"));
        this.playModeRepeatAllMenuItem.setIcon(Utilities.PLAYLIST_REPEAT_ALL_ICON);
        this.playModeRepeatAllMenuItem.addActionListener(this);
        this.playModeSubMenu.add(this.playModeRepeatAllMenuItem);
        this.playModeShuffleMenuItem = new JRadioButtonMenuItem(Utilities.tr("MainFrame.Menu.Player.PlayMode.Shuffle"));
        this.playModeShuffleMenuItem.setIcon(Utilities.PLAYLIST_SHUFFLE_ICON);
        this.playModeShuffleMenuItem.addActionListener(this);
        this.playModeSubMenu.add(this.playModeShuffleMenuItem);
        ButtonGroup playModeBG = new ButtonGroup();
        playModeBG.add(this.playModeRepeatNoneMenuItem);
        playModeBG.add(this.playModeRepeatOneMenuItem);
        playModeBG.add(this.playModeRepeatAllMenuItem);
        playModeBG.add(this.playModeShuffleMenuItem);
        this.playerMenu.add(this.playModeSubMenu);
        this.playerMenu.addSeparator();
        this.randomizePlaylistMenuItem = new JMenuItem(Utilities.tr("MainFrame.Menu.Player.Randomize"));
        this.randomizePlaylistMenuItem.setAccelerator(KeyStroke.getKeyStroke(82, 128));
        this.randomizePlaylistMenuItem.setEnabled(false);
        this.randomizePlaylistMenuItem.addActionListener(this);
        this.playerMenu.add(this.randomizePlaylistMenuItem);
        this.menuBar.add(this.playerMenu);
        String viewMenuStr = Utilities.tr("MainFrame.Menu.View");
        this.viewMenu = new JMenu(viewMenuStr);
        this.viewMenu.setMnemonic(viewMenuStr.charAt(0));
        this.playlistManagerMenuItem = new JRadioButtonMenuItem(Utilities.tr("MainFrame.Menu.View.PlaylistManager"));
        this.playlistManagerMenuItem.setAccelerator(KeyStroke.getKeyStroke(76, 128));
        this.playlistManagerMenuItem.addActionListener(this);
        this.viewMenu.add(this.playlistManagerMenuItem);
        this.visualizationMenuItem = new JRadioButtonMenuItem(Utilities.tr("MainFrame.Menu.View.Visualizations"));
        this.visualizationMenuItem.setAccelerator(KeyStroke.getKeyStroke(75, 128));
        this.visualizationMenuItem.addActionListener(this);
        this.viewMenu.add(this.visualizationMenuItem);
        ButtonGroup viewBG = new ButtonGroup();
        viewBG.add(this.playlistManagerMenuItem);
        viewBG.add(this.visualizationMenuItem);
        this.menuBar.add(this.viewMenu);
        String helpMenuStr = Utilities.tr("MainFrame.Menu.Help");
        this.helpMenu = new JMenu(helpMenuStr);
        this.helpMenu.setMnemonic(helpMenuStr.charAt(0));
        this.updateMenuItem = new JMenuItem(Utilities.tr("MainFrame.Menu.Help.CheckForUpdates"));
        this.updateMenuItem.addActionListener(this);
        this.helpMenu.add(this.updateMenuItem);
        this.helpMenu.addSeparator();
        this.aboutMenuItem = new JMenuItem(Utilities.tr("MainFrame.Menu.Help.About"));
        this.aboutMenuItem.addActionListener(this);
        this.helpMenu.add(this.aboutMenuItem);
        this.menuBar.add(this.helpMenu);
        this.menuBar.add(Box.createHorizontalGlue());
        this.busyLabel = new BusyLabel(new Dimension(20, 20));
        this.menuBar.add(this.busyLabel);
        this.menuBar.add(Box.createHorizontalStrut(8));
        this.mainFrame.setJMenuBar(this.menuBar);
    }

    protected void createMainPanels() {
        this.mainPanel = new JPanel(new CardLayout());
        this.playlistManager = new PlaylistManager(this);
        this.visualizationManager = new VisualizationManager(this.audioPlayer.getDSS());
        if (Settings.getLastView().equals("VISUALIZATION_PANEL")) {
            this.visualizationManager.setDssEnabled(true);
            this.mainPanel.add((Component)this.visualizationManager, "VISUALIZATION_PANEL");
            this.mainPanel.add((Component)this.playlistManager, "PLAYLIST_MANAGER");
            this.visualizationMenuItem.setSelected(true);
        } else {
            this.mainPanel.add((Component)this.playlistManager, "PLAYLIST_MANAGER");
            this.mainPanel.add((Component)this.visualizationManager, "VISUALIZATION_PANEL");
            this.playlistManagerMenuItem.setSelected(true);
        }
        JPanel framePanel = new JPanel((LayoutManager)new MigLayout("fill"));
        framePanel.add((Component)this.mainPanel, "grow");
        JPanel southPanel = new JPanel((LayoutManager)new MigLayout("fill", "[center]"));
        this.seekSlider = new SeekSlider(this);
        this.seekSlider.setEnabled(false);
        southPanel.add((Component)this.seekSlider, "north, gap 4 4 1 0");
        this.controlPanel = new JPanel((LayoutManager)new MigLayout("gap 0, ins 0", "[center]"));
        this.stopButton = new StopButton();
        this.stopButton.setEnabled(false);
        this.stopButton.addActionListener(this);
        this.controlPanel.add(this.stopButton);
        this.previousButton = new PreviousButton();
        this.previousButton.setEnabled(false);
        this.previousButton.addActionListener(this);
        this.controlPanel.add(this.previousButton);
        this.playPauseButton = new PlayPauseButton();
        this.playPauseButton.addActionListener(this);
        this.controlPanel.add((Component)this.playPauseButton, "height pref!");
        this.nextButton = new NextButton();
        this.nextButton.setEnabled(false);
        this.nextButton.addActionListener(this);
        this.controlPanel.add(this.nextButton);
        this.volumeButton = new VolumeButton(Settings.isMuted());
        this.volumeButton.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                try {
                    int volumeValue = XtremeMP.this.volumeSlider.getValue() - 5 * e.getWheelRotation();
                    if (volumeValue < 0) {
                        volumeValue = 0;
                    } else if (volumeValue > 100) {
                        volumeValue = 100;
                    }
                    XtremeMP.this.volumeButton.setVolumeIcon(volumeValue);
                    XtremeMP.this.audioPlayer.setGain((float)volumeValue / 100.0f);
                    Settings.setGain(volumeValue);
                    XtremeMP.this.volumeSlider.setValue(volumeValue);
                }
                catch (PlayerException ex) {
                    logger.debug(ex.getMessage(), (Throwable)ex);
                }
            }
        });
        JPopupMenu volumePopupMenu = this.volumeButton.getPopupMenu();
        this.volumeSlider = new JSlider(1, 0, 100, Settings.getGain());
        this.volumeSlider.setMajorTickSpacing(25);
        this.volumeSlider.setMinorTickSpacing(5);
        this.volumeSlider.setPaintTicks(true);
        this.volumeSlider.setPaintLabels(true);
        this.volumeSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Object source = e.getSource();
                if (source == XtremeMP.this.volumeSlider && XtremeMP.this.volumeSlider.getValueIsAdjusting()) {
                    try {
                        int volumeValue = XtremeMP.this.volumeSlider.getValue();
                        XtremeMP.this.volumeButton.setVolumeIcon(volumeValue);
                        XtremeMP.this.audioPlayer.setGain((float)volumeValue / 100.0f);
                        Settings.setGain(volumeValue);
                    }
                    catch (PlayerException ex) {
                        logger.debug(ex.getMessage(), (Throwable)ex);
                    }
                }
            }
        });
        this.volumeSlider.setEnabled(!Settings.isMuted());
        JPanel volumePanel = new JPanel((LayoutManager)new MigLayout("fill"));
        JLabel volumeLabel = new JLabel(Utilities.tr("MainFrame.Menu.Player.Volume"), 0);
        volumeLabel.setFont(volumeLabel.getFont().deriveFont(1));
        volumePanel.add((Component)volumeLabel, "north");
        volumePanel.add(this.volumeSlider);
        JCheckBox muteCheckBox = new JCheckBox(Utilities.tr("MainFrame.Menu.Player.Mute"));
        muteCheckBox.setSelected(Settings.isMuted());
        muteCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    if (e.getStateChange() == 1) {
                        XtremeMP.this.volumeSlider.setEnabled(false);
                        XtremeMP.this.volumeButton.setVolumeMutedIcon();
                        XtremeMP.this.audioPlayer.setMuted(true);
                        Settings.setMuted(true);
                    } else {
                        XtremeMP.this.volumeSlider.setEnabled(true);
                        XtremeMP.this.volumeButton.setVolumeIcon(Settings.getGain());
                        XtremeMP.this.audioPlayer.setMuted(false);
                        Settings.setMuted(false);
                    }
                }
                catch (PlayerException ex) {
                    logger.debug(ex.getMessage(), (Throwable)ex);
                }
            }
        });
        volumePanel.add((Component)muteCheckBox, "south");
        volumePopupMenu.add(volumePanel);
        this.controlPanel.add(this.volumeButton);
        southPanel.add((Component)this.controlPanel, "gap 0 0 2 5");
        JPanel statusBar = new JPanel((LayoutManager)new MigLayout("ins 2 0 2 0"));
        SubstanceLookAndFeel.setDecorationType((JComponent)statusBar, (DecorationAreaType)DecorationAreaType.FOOTER);
        this.timeLabel = new JLabel("00:00 / 00:00");
        this.timeLabel.setFont(this.timeLabel.getFont().deriveFont(1));
        statusBar.add((Component)this.timeLabel, "gap 6 6 0 0, west");
        statusBar.add((Component)new JSeparator(1), "hmin 16");
        this.statusLabel = new JLabel();
        statusBar.add((Component)this.statusLabel, "gap 0 2 0 0, wmin 0, push");
        statusBar.add((Component)new JSeparator(1), "hmin 16");
        this.playModeLabel = new JLabel();
        this.playModeLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Playlist.PlayMode[] playModes = Playlist.PlayMode.values();
                Playlist.PlayMode playMode = XtremeMP.this.playlist.getPlayMode();
                int ordinal = playMode.ordinal();
                XtremeMP.this.playlist.setPlayMode(playModes[ordinal == playModes.length - 1 ? 0 : ordinal + 1]);
            }
        });
        statusBar.add((Component)this.playModeLabel, "east");
        southPanel.add((Component)statusBar, "south");
        framePanel.add((Component)southPanel, "south");
        this.mainFrame.setContentPane(framePanel);
    }

    protected void addToPlaylistAndPlay(List<PlaylistItem> pliList) {
        this.playlistManager.clearPlaylist();
        this.playlistManager.add(pliList);
        this.playlist.begin();
        this.acOpenAndPlay();
    }

    protected void setTime(final String timeText, final int seekSliderValue) {
        if (EventQueue.isDispatchThread()) {
            this.seekSlider.setValue(seekSliderValue);
            this.timeLabel.setText(timeText);
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    XtremeMP.this.seekSlider.setValue(seekSliderValue);
                    XtremeMP.this.timeLabel.setText(timeText);
                }
            });
        }
    }

    protected void setStatus(String text) {
        String status;
        String string = status = text != null ? text : "";
        if (EventQueue.isDispatchThread()) {
            this.statusLabel.setText(status);
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    XtremeMP.this.statusLabel.setText(status);
                }
            });
        }
    }

    protected void enableControlButtons(boolean flag) {
        this.previousButton.setEnabled(flag);
        this.previousMenuItem.setEnabled(flag);
        this.nextButton.setEnabled(flag);
        this.nextMenuItem.setEnabled(flag);
        this.randomizePlaylistMenuItem.setEnabled(flag);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.openMenuItem) {
            JFileChooser fileChooser = new JFileChooser(Settings.getLastDir());
            fileChooser.setAcceptAllFileFilterUsed(false);
            fileChooser.addChoosableFileFilter(this.playlistFileFilter);
            fileChooser.addChoosableFileFilter(this.audioFileFilter);
            fileChooser.setMultiSelectionEnabled(false);
            if (fileChooser.showOpenDialog(this.mainFrame) == 0) {
                File file = fileChooser.getSelectedFile();
                FileFilter fileFilter = fileChooser.getFileFilter();
                if (fileFilter == this.playlistFileFilter) {
                    this.playlistManager.clearPlaylist();
                    this.acStop();
                    this.playlistManager.loadPlaylist(file.getPath());
                } else if (fileFilter == this.audioFileFilter) {
                    String fileName = file.getName().substring(0, file.getName().lastIndexOf(".")).trim();
                    PlaylistItem newPli = new PlaylistItem(fileName, file.getAbsolutePath(), -1L, true);
                    this.playlistManager.add(newPli);
                    this.playlist.setCursor(newPli);
                }
                this.acOpenAndPlay();
                Settings.setLastDir(file.getParent());
            }
        } else if (source == this.openURLMenuItem) {
            String url = JOptionPane.showInputDialog(this.mainFrame, Utilities.tr("Dialog.OpenURL.Message"), Utilities.tr("Dialog.OpenURL"), 1);
            if (url != null && Utilities.startWithProtocol(url)) {
                boolean isPlaylistFile = false;
                for (String ext : PlaylistFileFilter.PlaylistFileExt) {
                    if (!url.endsWith(ext)) continue;
                    isPlaylistFile = true;
                }
                if (isPlaylistFile) {
                    this.playlistManager.clearPlaylist();
                    this.playlistManager.loadPlaylist(url);
                    this.playlist.begin();
                } else {
                    PlaylistItem newPli = new PlaylistItem(url, url, -1L, false);
                    this.playlistManager.add(newPli);
                    this.playlist.setCursor(newPli);
                }
                this.acOpenAndPlay();
            }
        } else if (source == this.openPlaylistMenuItem) {
            this.playlistManager.openPlaylist();
        } else if (source == this.savePlaylistMenuItem) {
            this.playlistManager.savePlaylistDialog();
        } else if (source == this.preferencesMenuItem) {
            PreferencesDialog preferencesDialog = new PreferencesDialog(this.audioPlayer, this);
            preferencesDialog.setVisible(true);
        } else if (source == this.exitMenuItem) {
            this.exit();
        } else if (source == this.playPauseMenuItem || source == this.playPauseButton) {
            this.acPlayPause();
        } else if (source == this.previousMenuItem || source == this.previousButton) {
            this.acPrevious();
        } else if (source == this.nextMenuItem || source == this.nextButton) {
            this.acNext();
        } else if (source == this.randomizePlaylistMenuItem) {
            this.playlistManager.randomizePlaylist();
        } else if (source == this.stopMenuItem || source == this.stopButton) {
            this.acStop();
        } else if (source == this.playlistManagerMenuItem) {
            if (this.visualizationManager.isVisible()) {
                this.visualizationManager.setDssEnabled(false);
                CardLayout cardLayout = (CardLayout)this.mainPanel.getLayout();
                cardLayout.show(this.mainPanel, "PLAYLIST_MANAGER");
                this.playlistManagerMenuItem.setSelected(true);
                Settings.setLastView("PLAYLIST_MANAGER");
            }
        } else if (source == this.visualizationMenuItem) {
            if (this.playlistManager.isVisible()) {
                this.visualizationManager.setDssEnabled(true);
                CardLayout cardLayout = (CardLayout)this.mainPanel.getLayout();
                cardLayout.show(this.mainPanel, "VISUALIZATION_PANEL");
                this.visualizationMenuItem.setSelected(true);
                Settings.setLastView("VISUALIZATION_PANEL");
            }
        } else if (source == this.updateMenuItem) {
            SoftwareUpdate.checkForUpdates(true);
            SoftwareUpdate.showCheckForUpdatesDialog();
        } else if (source == this.aboutMenuItem) {
            Object[] options = new Object[]{Utilities.tr("Button.Close")};
            Desktop desktop = null;
            if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
                options = new Object[]{Utilities.tr("Button.Close"), Utilities.tr("Button.Website")};
            }
            StringBuffer message = new StringBuffer();
            message.append("<html><b><font color='red' size='5'>").append(Utilities.tr("Application.title"));
            message.append("</font></b><br>").append(Utilities.tr("Application.description"));
            message.append("<br>Copyright \u00a9 2005-2010 The Xtreme Media Player Project");
            message.append("<br><br><b>").append(Utilities.tr("Dialog.About.Author")).append(": </b>").append(Utilities.tr("Application.author"));
            message.append("<br><b>").append(Utilities.tr("Dialog.About.Version")).append(": </b>").append(this.currentVersion);
            message.append("<br><b>").append(Utilities.tr("Dialog.About.Codename")).append(": </b>").append(this.currentVersion.getCodename());
            message.append("<br><b>").append(Utilities.tr("Dialog.About.ReleaseDate")).append(": </b>").append(this.currentVersion.getReleaseDate());
            message.append("<br><b>").append(Utilities.tr("Dialog.About.Homepage")).append(": </b>").append(Utilities.tr("Application.homepage"));
            message.append("<br><br><b>").append(Utilities.tr("Dialog.About.JavaVersion")).append(": </b>").append(System.getProperty("java.version"));
            message.append("<br><b>").append(Utilities.tr("Dialog.About.JavaVendor")).append(": </b>").append(System.getProperty("java.vendor"));
            message.append("<br><b>").append(Utilities.tr("Dialog.About.JavaHome")).append(": </b>").append(System.getProperty("java.home"));
            message.append("<br><b>").append(Utilities.tr("Dialog.About.OSName")).append(": </b>").append(System.getProperty("os.name"));
            message.append("<br><b>").append(Utilities.tr("Dialog.About.OSArch")).append(": </b>").append(System.getProperty("os.arch"));
            message.append("<br><b>").append(Utilities.tr("Dialog.About.UserName")).append(": </b>").append(System.getProperty("user.name"));
            message.append("<br><b>").append(Utilities.tr("Dialog.About.UserHome")).append(": </b>").append(System.getProperty("user.home"));
            message.append("<br><b>").append(Utilities.tr("Dialog.About.UserDir")).append(": </b>").append(System.getProperty("user.dir"));
            message.append("</html>");
            int n = JOptionPane.showOptionDialog(this.mainFrame, message, Utilities.tr("Dialog.About"), 2, -1, Utilities.APP_256_ICON, options, options[0]);
            if (n == 1 && desktop != null) {
                try {
                    URL url = new URL(Utilities.tr("Application.homepage"));
                    desktop.browse(url.toURI());
                }
                catch (Exception ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
            }
        } else if (source.equals(this.playModeRepeatNoneMenuItem)) {
            this.playlist.setPlayMode(Playlist.PlayMode.REPEAT_NONE);
        } else if (source.equals(this.playModeRepeatOneMenuItem)) {
            this.playlist.setPlayMode(Playlist.PlayMode.REPEAT_ONE);
        } else if (source.equals(this.playModeRepeatAllMenuItem)) {
            this.playlist.setPlayMode(Playlist.PlayMode.REPEAT_ALL);
        } else if (source.equals(this.playModeShuffleMenuItem)) {
            this.playlist.setPlayMode(Playlist.PlayMode.SHUFFLE);
        }
    }

    @Override
    public void playbackBuffering(PlaybackEvent pe) {
        this.setStatus(Utilities.tr("MainFrame.StatusBar.Buffering"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void playbackOpened(PlaybackEvent pe) {
        try {
            this.audioPlayer.setGain((float)Settings.getGain() / 100.0f);
            this.audioPlayer.setMuted(Settings.isMuted());
        }
        catch (PlayerException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        finally {
            if (this.currentPli != null) {
                if (!this.currentPli.isFile()) {
                    this.currentPli.getTagInfo();
                }
                this.setStatus(this.currentPli.getFormattedName());
            }
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                XtremeMP.this.stopButton.setEnabled(true);
                XtremeMP.this.stopMenuItem.setEnabled(true);
            }
        });
    }

    @Override
    public void playbackEndOfMedia(PlaybackEvent pe) {
        if (this.playlist.isEmpty()) {
            this.acStop();
        } else {
            switch (this.playlist.getPlayMode()) {
                case REPEAT_NONE: {
                    if (this.playlist.getCursorPosition() == this.playlist.size() - 1) {
                        this.acStop();
                        break;
                    }
                    this.acNext();
                    break;
                }
                case REPEAT_ONE: {
                    this.acStop();
                    this.acPlayPause();
                    break;
                }
                case REPEAT_ALL: {
                    this.acNext();
                    break;
                }
                case SHUFFLE: {
                    this.acNext();
                }
            }
        }
    }

    @Override
    public void playbackPlaying(PlaybackEvent pe) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                XtremeMP.this.playPauseButton.setPauseIcon();
                XtremeMP.this.playPauseMenuItem.setText(Utilities.tr("MainFrame.Menu.Player.Pause"));
            }
        });
    }

    @Override
    public void playbackProgress(PlaybackEvent pe) {
        if (this.currentPli != null && !this.seekSlider.getValueIsAdjusting() && !this.seekSlider.isPressed() && this.mainFrame.isVisible()) {
            this.acUpdateTime(this.seekSlider.getOldValue() + Math.round((float)pe.getPosition() / 1000.0f));
            Map properties = pe.getProperties();
            String streamTitleKey = "mp3.shoutcast.metadata.StreamTitle";
            if (!this.currentPli.isFile() && properties.containsKey(streamTitleKey)) {
                String streamTitle = ((String)properties.get(streamTitleKey)).trim();
                TagInfo tagInfo = this.currentPli.getTagInfo();
                if (!streamTitle.isEmpty() && tagInfo != null) {
                    String sTitle = " (" + tagInfo.getTitle() + ")";
                    if (!this.currentPli.getFormattedName().equals(streamTitle + sTitle)) {
                        this.currentPli.setFormattedName(streamTitle + sTitle);
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                XtremeMP.this.playlistManager.refreshRow(XtremeMP.this.playlist.indexOf(XtremeMP.this.currentPli));
                                XtremeMP.this.setStatus(XtremeMP.this.currentPli.getFormattedName());
                            }
                        });
                    }
                }
            }
        }
    }

    @Override
    public void playbackPaused(PlaybackEvent pe) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                XtremeMP.this.playPauseButton.setPlayIcon();
                XtremeMP.this.playPauseMenuItem.setText(Utilities.tr("MainFrame.Menu.Player.Play"));
            }
        });
    }

    @Override
    public void playbackStopped(PlaybackEvent pe) {
        this.currentPli = null;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                XtremeMP.this.playPauseButton.setPlayIcon();
                XtremeMP.this.stopButton.setEnabled(false);
                XtremeMP.this.playPauseMenuItem.setText(Utilities.tr("MainFrame.Menu.Player.Play"));
                XtremeMP.this.stopMenuItem.setEnabled(false);
                XtremeMP.this.acUpdateTime(0);
                XtremeMP.this.statusLabel.setText("");
            }
        });
    }

    @Override
    public void acOpen() {
        PlayerLauncher playerLauncher = new PlayerLauncher(false);
        playerLauncher.execute();
    }

    @Override
    public void acOpenAndPlay() {
        PlayerLauncher playerLauncher = new PlayerLauncher(true);
        playerLauncher.execute();
    }

    @Override
    public void acPrevious() {
        if (!this.playlist.isEmpty()) {
            this.playlist.previousCursor();
            this.acOpenAndPlay();
        }
    }

    @Override
    public void acNext() {
        if (!this.playlist.isEmpty()) {
            this.playlist.nextCursor();
            this.acOpenAndPlay();
        }
    }

    @Override
    public void acPlayPause() {
        try {
            if (this.playlist.isEmpty()) {
                if (this.audioPlayer.getState() == -1 || this.audioPlayer.getState() == 4) {
                    this.playlistManager.addFilesDialog();
                }
            } else if (this.audioPlayer.getState() != 1 && this.audioPlayer.getState() != 2 && this.playlist.getCursorPosition() == -1) {
                this.playlist.begin();
            }
            switch (this.audioPlayer.getState()) {
                case 1: {
                    this.audioPlayer.pause();
                    break;
                }
                case 0: {
                    this.audioPlayer.play();
                    break;
                }
                case 2: {
                    this.audioPlayer.play();
                    break;
                }
                default: {
                    this.acOpenAndPlay();
                    break;
                }
            }
        }
        catch (PlayerException ex) {
            logger.error(ex.getMessage());
        }
    }

    @Override
    public void acStop() {
        this.audioPlayer.stop();
    }

    @Override
    public void acUpdateTime(int value) {
        StringBuilder timeText = new StringBuilder();
        if (this.currentPli != null) {
            String formattedLength = this.currentPli.getFormattedLength();
            long duration = TimeUnit.MILLISECONDS.toSeconds(value);
            if (Utilities.isNullOrEmpty(formattedLength)) {
                timeText.append(this.currentPli.getFormattedLength(duration));
            } else {
                timeText.append(this.currentPli.getFormattedLength(duration));
                timeText.append(" / ");
                timeText.append(formattedLength);
            }
        } else {
            timeText.append("00:00 / 00:00");
        }
        this.setTime(timeText.toString(), this.currentPli == null ? 0 : value);
    }

    @Override
    public void acSeek() {
        try {
            if (this.seekSlider.isEnabled()) {
                this.audioPlayer.seek(Math.round((double)this.audioPlayer.getByteLength() * (double)this.seekSlider.getValue() / (double)this.seekSlider.getMaximum()));
            }
        }
        catch (PlayerException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public void playlistItemAdded(PlaylistEvent e) {
        if (!this.playlist.isEmpty() && !this.previousButton.isEnabled()) {
            this.enableControlButtons(true);
        }
    }

    @Override
    public void playlistItemRemoved(PlaylistEvent e) {
        if (this.playlist.isEmpty()) {
            if (this.audioPlayer.getState() != 1 && this.audioPlayer.getState() != 2) {
                this.audioPlayer.stop();
            }
            this.enableControlButtons(false);
        }
    }

    @Override
    public void playModeChanged(PlaylistEvent e) {
        Playlist.PlayMode playMode = this.playlist.getPlayMode();
        Settings.setPlayMode(playMode);
        StringBuilder toolTipMessage = new StringBuilder("<html><b>");
        toolTipMessage.append(Utilities.tr("MainFrame.Menu.Player.PlayMode"));
        toolTipMessage.append("</b><br>");
        switch (playMode) {
            case REPEAT_NONE: {
                this.playModeLabel.setIcon(Utilities.PLAYLIST_REPEAT_NONE_ICON);
                this.playModeRepeatNoneMenuItem.setSelected(true);
                toolTipMessage.append(Utilities.tr("MainFrame.Menu.Player.PlayMode.RepeatNone"));
                break;
            }
            case REPEAT_ONE: {
                this.playModeLabel.setIcon(Utilities.PLAYLIST_REPEAT_ONE_ICON);
                this.playModeRepeatOneMenuItem.setSelected(true);
                toolTipMessage.append(Utilities.tr("MainFrame.Menu.Player.PlayMode.RepeatOne"));
                break;
            }
            case REPEAT_ALL: {
                this.playModeLabel.setIcon(Utilities.PLAYLIST_REPEAT_ALL_ICON);
                this.playModeRepeatAllMenuItem.setSelected(true);
                toolTipMessage.append(Utilities.tr("MainFrame.Menu.Player.PlayMode.RepeatAll"));
                break;
            }
            case SHUFFLE: {
                this.playModeLabel.setIcon(Utilities.PLAYLIST_SHUFFLE_ICON);
                this.playModeShuffleMenuItem.setSelected(true);
                toolTipMessage.append(Utilities.tr("MainFrame.Menu.Player.PlayMode.Shuffle"));
                break;
            }
            default: {
                this.playModeLabel.setIcon(null);
            }
        }
        toolTipMessage.append("</html>");
        this.playModeLabel.setToolTipText(toolTipMessage.toString());
    }

    public void onIntellitype(int command) {
        switch (command) {
            case 14: {
                logger.debug("APPCOMMAND_MEDIA_PLAY_PAUSE command received: " + Integer.toString(command));
                this.acPlayPause();
                break;
            }
            case 12: {
                logger.debug("APPCOMMAND_MEDIA_PREVIOUSTRACK command received: " + Integer.toString(command));
                this.acPrevious();
                break;
            }
            case 11: {
                logger.debug("APPCOMMAND_MEDIA_NEXTTRACK command received: " + Integer.toString(command));
                this.acNext();
                break;
            }
            case 13: {
                logger.debug("APPCOMMAND_MEDIA_STOP command received: " + Integer.toString(command));
                this.acStop();
                break;
            }
            default: {
                logger.debug("Undefined INTELLITYPE command received: " + Integer.toString(command));
            }
        }
    }

    @Override
    public void guiEffectsStateChanged(boolean flag) {
        if (flag) {
            AnimationConfigurationManager.getInstance().allowAnimations(AnimationFacet.GHOSTING_BUTTON_PRESS);
            AnimationConfigurationManager.getInstance().allowAnimations(AnimationFacet.GHOSTING_ICON_ROLLOVER);
            AnimationConfigurationManager.getInstance().allowAnimations(AnimationFacet.ICON_GLOW);
        } else {
            AnimationConfigurationManager.getInstance().disallowAnimations(AnimationFacet.GHOSTING_BUTTON_PRESS);
            AnimationConfigurationManager.getInstance().disallowAnimations(AnimationFacet.GHOSTING_ICON_ROLLOVER);
            AnimationConfigurationManager.getInstance().disallowAnimations(AnimationFacet.ICON_GLOW);
        }
    }

    private class PlayerLauncher
    extends AbstractSwingWorker<Boolean, Void> {
        private boolean play = false;
        private boolean isFile = false;
        private int duration = -1;

        public PlayerLauncher(boolean play) {
            this.play = play;
        }

        @Override
        protected Boolean doInBackground() throws PlayerException, MalformedURLException {
            PlaylistItem pli = XtremeMP.this.playlist.getCursor();
            if (pli != null) {
                XtremeMP.this.currentPli = pli;
                this.isFile = pli.isFile();
                if (this.isFile) {
                    XtremeMP.this.audioPlayer.open(new File(pli.getLocation()));
                    this.duration = Math.round(XtremeMP.this.audioPlayer.getDuration() / 1000L);
                } else {
                    XtremeMP.this.audioPlayer.open(new URL(pli.getLocation()));
                }
                if (this.play) {
                    XtremeMP.this.audioPlayer.play();
                }
                return Boolean.TRUE;
            }
            XtremeMP.this.currentPli = null;
            return Boolean.FALSE;
        }

        @Override
        protected void done() {
            block8: {
                if (XtremeMP.this.currentPli != null) {
                    try {
                        if (((Boolean)this.get()).booleanValue()) {
                            XtremeMP.this.seekSlider.reset();
                            XtremeMP.this.playlistManager.colorizeRow();
                            if (this.isFile) {
                                if (this.duration > 0) {
                                    XtremeMP.this.seekSlider.setMaximum(this.duration);
                                    XtremeMP.this.seekSlider.setEnabled(true);
                                } else {
                                    XtremeMP.this.seekSlider.setMaximum((int)(XtremeMP.this.currentPli.getDuration() * 1000L));
                                    XtremeMP.this.seekSlider.setEnabled(false);
                                }
                            } else {
                                XtremeMP.this.seekSlider.setEnabled(false);
                            }
                        }
                    }
                    catch (Exception ex) {
                        if (!(ex.getCause() instanceof PlayerException)) break block8;
                        XtremeMP.this.acStop();
                        XtremeMP.this.setStatus("An error occurred...");
                        logger.error(ex.getMessage(), (Throwable)ex);
                        if (!(ex.getCause().getCause() instanceof FileNotFoundException)) break block8;
                        String msg = "<html><b>" + XtremeMP.this.currentPli.getFormattedLength() + "</b> could not be used<br>because the original file could not be found.<html>";
                        JOptionPane.showMessageDialog(XtremeMP.this.mainFrame, msg, "Message", 0);
                    }
                }
            }
        }
    }
}

