/*
 * Decompiled with CFR 0.152.
 */
package xtrememp;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import xtrememp.Settings;
import xtrememp.player.dsp.DigitalSignalSynchronizer;
import xtrememp.ui.button.PopupButton;
import xtrememp.util.Utilities;
import xtrememp.visualization.Visualization;
import xtrememp.visualization.VisualizationChangeListener;
import xtrememp.visualization.VisualizationEvent;
import xtrememp.visualization.VisualizationPanel;

public final class VisualizationManager
extends JPanel
implements ActionListener,
VisualizationChangeListener {
    private final String PREV_VIS_ACTION = "prevVisAction";
    private final String NEXT_VIS_ACTION = "nextVisAction";
    private DigitalSignalSynchronizer dss;
    private JPopupMenu selectionMenu;
    private JButton fullScreenButton;
    private JButton prevVisButton;
    private JButton nextVisButton;
    private PopupButton visMenuButton;
    private ButtonGroup visButtonGroup;
    private VisualizationPanel visPanel;
    private Map<String, Visualization> visMap;

    public VisualizationManager(DigitalSignalSynchronizer dss) {
        super(new BorderLayout());
        this.dss = dss;
        this.initComponents();
    }

    private void initComponents() {
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        this.fullScreenButton = new JButton(Utilities.VIEW_FULLSCREEN_ICON);
        this.fullScreenButton.setToolTipText(Utilities.tr("MainFrame.VisualizationManager.ViewFullscreen"));
        this.fullScreenButton.addActionListener(this);
        toolBar.add(this.fullScreenButton);
        toolBar.addSeparator();
        this.prevVisButton = new JButton(Utilities.GO_PREVIOUS_ICON);
        this.prevVisButton.setToolTipText(Utilities.tr("MainFrame.VisualizationManager.PreviousVisualization"));
        this.prevVisButton.addActionListener(this);
        this.prevVisButton.getInputMap(2).put(KeyStroke.getKeyStroke(37, 64), "prevVisAction");
        this.prevVisButton.getActionMap().put("prevVisAction", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VisualizationManager.this.visPanel.prevVisualization();
            }
        });
        toolBar.add(this.prevVisButton);
        this.nextVisButton = new JButton(Utilities.GO_NEXT_ICON);
        this.nextVisButton.setToolTipText(Utilities.tr("MainFrame.VisualizationManager.NextVisualization"));
        this.nextVisButton.addActionListener(this);
        this.nextVisButton.getInputMap(2).put(KeyStroke.getKeyStroke(39, 64), "nextVisAction");
        this.nextVisButton.getActionMap().put("nextVisAction", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VisualizationManager.this.visPanel.nextVisualization();
            }
        });
        toolBar.add(this.nextVisButton);
        toolBar.addSeparator();
        this.visMenuButton = new PopupButton(Utilities.MENU_ICON);
        this.visMenuButton.setToolTipText(Utilities.tr("MainFrame.VisualizationManager.VisualizationsMenu"));
        this.selectionMenu = this.visMenuButton.getPopupMenu();
        this.visButtonGroup = new ButtonGroup();
        this.visPanel = new VisualizationPanel();
        this.visPanel.addVisualizationChangeListener(this);
        this.visMap = new HashMap<String, Visualization>();
        for (Visualization vis : this.visPanel.getVisualizationSet()) {
            String visDisplayName = vis.getDisplayName();
            this.visMap.put(visDisplayName, vis);
            JRadioButtonMenuItem menuItem = new JRadioButtonMenuItem(visDisplayName);
            menuItem.setSelected(visDisplayName.equals(Settings.getVisualization()));
            menuItem.addActionListener(this);
            this.visButtonGroup.add(menuItem);
            this.selectionMenu.add(menuItem);
        }
        toolBar.add(this.visMenuButton);
        this.add((Component)toolBar, "North");
        this.add((Component)this.visPanel, "Center");
    }

    public void setDssEnabled(boolean flag) {
        if (flag) {
            this.dss.add(this.visPanel);
        } else {
            this.dss.remove(this.visPanel);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source.equals(this.fullScreenButton)) {
            this.visPanel.setFullScreen(true);
        } else if (source.equals(this.prevVisButton)) {
            this.visPanel.prevVisualization();
        } else if (source.equals(this.nextVisButton)) {
            this.visPanel.nextVisualization();
        } else {
            this.visPanel.showVisualization(this.visMap.get(e.getActionCommand()), false);
        }
    }

    @Override
    public void visualizationChanged(VisualizationEvent e) {
        String visDisplayName = e.getVisualization().getDisplayName();
        Enumeration<AbstractButton> abEnum = this.visButtonGroup.getElements();
        while (abEnum.hasMoreElements()) {
            AbstractButton aButton = abEnum.nextElement();
            if (!aButton.getText().equals(visDisplayName)) continue;
            aButton.setSelected(true);
            break;
        }
    }
}

