/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.sidplay.libsidplay.components.xsid;

import de.quippy.sidplay.libsidplay.common.C64Env;
import de.quippy.sidplay.libsidplay.common.SIDEmu;
import de.quippy.sidplay.libsidplay.components.xsid.XSID;

public class C64XSID
extends XSID {
    private C64Env m_env;
    private SIDEmu m_sid;
    private long m_gain;

    @Override
    protected short readMemByte(int n) {
        short s = this.m_env.readMemRamByte(n);
        this.m_env.sid2crc(s);
        return s;
    }

    @Override
    protected void writeMemByte(short s) {
        this.m_sid.write((short)24, s);
    }

    public C64XSID(C64Env c64Env, SIDEmu sIDEmu) {
        super(c64Env.context());
        this.m_env = c64Env;
        this.m_sid = sIDEmu;
        this.m_gain = 100L;
    }

    @Override
    public final String error() {
        return "";
    }

    @Override
    public void reset() {
        super.reset();
    }

    @Override
    public void reset(short s) {
        super.reset(s);
        this.m_sid.reset(s);
    }

    @Override
    public short read(short s) {
        return this.m_sid.read(s);
    }

    @Override
    public void write(short s, short s2) {
        if (s == 24) {
            super.storeSidData0x18(s2);
        } else {
            this.m_sid.write(s, s2);
        }
    }

    public void write16(int n, short s) {
        super.write(n, s);
    }

    @Override
    public long output(short s) {
        return this.m_sid.output(s) + super.output(s) * this.m_gain / 100L;
    }

    @Override
    public void voice(short s, short s2, boolean bl) {
        if (s == 3) {
            super.mute(bl);
        } else {
            this.m_sid.voice(s, s2, bl);
        }
    }

    @Override
    public void gain(short s) {
        this.m_gain = s;
        this.m_gain += 100L;
        if (this.m_gain > 200L) {
            this.m_gain = 200L;
        }
    }

    public void emulation(SIDEmu sIDEmu) {
        this.m_sid = sIDEmu;
    }

    public SIDEmu emulation() {
        return this.m_sid;
    }
}

