/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.ogg.jorbis;

import de.quippy.ogg.jogg.Buffer;
import de.quippy.ogg.jorbis.StaticCodeBook;
import de.quippy.ogg.jorbis.Util;

class CodeBook {
    int dim;
    int entries;
    StaticCodeBook c = new StaticCodeBook();
    float[] valuelist;
    DecodeAux decode_tree;
    private int[] t = new int[15];

    CodeBook() {
    }

    int errorv(float[] fArray) {
        int n = this.best(fArray, 1);
        int n2 = 0;
        while (n2 < this.dim) {
            fArray[n2] = this.valuelist[n * this.dim + n2];
            ++n2;
        }
        return n;
    }

    synchronized int decodevs_add(float[] fArray, int n, Buffer buffer, int n2) {
        int n3 = n2 / this.dim;
        if (this.t.length < n3) {
            this.t = new int[n3];
        }
        int n4 = 0;
        while (n4 < n3) {
            int n5 = this.decode(buffer);
            if (n5 == -1) {
                return -1;
            }
            this.t[n4] = n5 * this.dim;
            ++n4;
        }
        n4 = 0;
        int n6 = 0;
        while (n4 < this.dim) {
            int n7 = 0;
            while (n7 < n3) {
                int n8 = n + n6 + n7;
                fArray[n8] = fArray[n8] + this.valuelist[this.t[n7] + n4];
                ++n7;
            }
            ++n4;
            n6 += n3;
        }
        return 0;
    }

    int decodev_add(float[] fArray, int n, Buffer buffer, int n2) {
        if (this.dim > 8) {
            int n3 = 0;
            while (n3 < n2) {
                int n4 = this.decode(buffer);
                if (n4 == -1) {
                    return -1;
                }
                int n5 = n4 * this.dim;
                int n6 = 0;
                while (n6 < this.dim) {
                    int n7 = n + n3++;
                    fArray[n7] = fArray[n7] + this.valuelist[n5 + n6++];
                }
            }
        } else {
            int n8 = 0;
            while (n8 < n2) {
                int n9 = this.decode(buffer);
                if (n9 == -1) {
                    return -1;
                }
                int n10 = n9 * this.dim;
                int n11 = 0;
                switch (this.dim) {
                    case 8: {
                        int n12 = n + n8++;
                        fArray[n12] = fArray[n12] + this.valuelist[n10 + n11++];
                    }
                    case 7: {
                        int n13 = n + n8++;
                        fArray[n13] = fArray[n13] + this.valuelist[n10 + n11++];
                    }
                    case 6: {
                        int n14 = n + n8++;
                        fArray[n14] = fArray[n14] + this.valuelist[n10 + n11++];
                    }
                    case 5: {
                        int n15 = n + n8++;
                        fArray[n15] = fArray[n15] + this.valuelist[n10 + n11++];
                    }
                    case 4: {
                        int n16 = n + n8++;
                        fArray[n16] = fArray[n16] + this.valuelist[n10 + n11++];
                    }
                    case 3: {
                        int n17 = n + n8++;
                        fArray[n17] = fArray[n17] + this.valuelist[n10 + n11++];
                    }
                    case 2: {
                        int n18 = n + n8++;
                        fArray[n18] = fArray[n18] + this.valuelist[n10 + n11++];
                    }
                    case 1: {
                        int n19 = n + n8++;
                        fArray[n19] = fArray[n19] + this.valuelist[n10 + n11++];
                    }
                }
            }
        }
        return 0;
    }

    int decodev_set(float[] fArray, int n, Buffer buffer, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            int n4 = this.decode(buffer);
            if (n4 == -1) {
                return -1;
            }
            int n5 = n4 * this.dim;
            int n6 = 0;
            while (n6 < this.dim) {
                fArray[n + n3++] = this.valuelist[n5 + n6++];
            }
        }
        return 0;
    }

    int decodevv_add(float[][] fArray, int n, int n2, Buffer buffer, int n3) {
        int n4 = 0;
        int n5 = n / n2;
        while (n5 < (n + n3) / n2) {
            int n6 = this.decode(buffer);
            if (n6 == -1) {
                return -1;
            }
            int n7 = n6 * this.dim;
            int n8 = 0;
            while (n8 < this.dim) {
                float[] fArray2 = fArray[n4++];
                int n9 = n5++;
                fArray2[n9] = fArray2[n9] + this.valuelist[n7 + n8];
                if (n4 == n2) {
                    n4 = 0;
                }
                ++n8;
            }
        }
        return 0;
    }

    int decode(Buffer buffer) {
        int n = 0;
        DecodeAux decodeAux = this.decode_tree;
        int n2 = buffer.look(decodeAux.tabn);
        if (n2 >= 0) {
            n = decodeAux.tab[n2];
            buffer.adv(decodeAux.tabl[n2]);
            if (n <= 0) {
                return -n;
            }
        }
        do {
            switch (buffer.read1()) {
                case 0: {
                    n = decodeAux.ptr0[n];
                    break;
                }
                case 1: {
                    n = decodeAux.ptr1[n];
                    break;
                }
                default: {
                    return -1;
                }
            }
        } while (n > 0);
        return -n;
    }

    int decodevs(float[] fArray, int n, Buffer buffer, int n2, int n3) {
        int n4 = this.decode(buffer);
        if (n4 == -1) {
            return -1;
        }
        switch (n3) {
            case -1: {
                int n5 = 0;
                int n6 = 0;
                while (n5 < this.dim) {
                    fArray[n + n6] = this.valuelist[n4 * this.dim + n5];
                    ++n5;
                    n6 += n2;
                }
                break;
            }
            case 0: {
                int n7 = 0;
                int n8 = 0;
                while (n7 < this.dim) {
                    int n9 = n + n8;
                    fArray[n9] = fArray[n9] + this.valuelist[n4 * this.dim + n7];
                    ++n7;
                    n8 += n2;
                }
                break;
            }
            case 1: {
                int n10 = 0;
                int n11 = 0;
                while (n10 < this.dim) {
                    int n12 = n + n11;
                    fArray[n12] = fArray[n12] * this.valuelist[n4 * this.dim + n10];
                    ++n10;
                    n11 += n2;
                }
                break;
            }
        }
        return n4;
    }

    int best(float[] fArray, int n) {
        int n2 = -1;
        float f = 0.0f;
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.entries) {
            if (this.c.lengthlist[n4] > 0) {
                float f2 = CodeBook.dist(this.dim, this.valuelist, n3, fArray, n);
                if (n2 == -1 || f2 < f) {
                    f = f2;
                    n2 = n4;
                }
            }
            n3 += this.dim;
            ++n4;
        }
        return n2;
    }

    int besterror(float[] fArray, int n, int n2) {
        int n3 = this.best(fArray, n);
        switch (n2) {
            case 0: {
                int n4 = 0;
                int n5 = 0;
                while (n4 < this.dim) {
                    int n6 = n5;
                    fArray[n6] = fArray[n6] - this.valuelist[n3 * this.dim + n4];
                    ++n4;
                    n5 += n;
                }
                break;
            }
            case 1: {
                int n7 = 0;
                int n8 = 0;
                while (n7 < this.dim) {
                    float f = this.valuelist[n3 * this.dim + n7];
                    if (f == 0.0f) {
                        fArray[n8] = 0.0f;
                    } else {
                        int n9 = n8;
                        fArray[n9] = fArray[n9] / f;
                    }
                    ++n7;
                    n8 += n;
                }
                break;
            }
        }
        return n3;
    }

    void clear() {
    }

    private static float dist(int n, float[] fArray, int n2, float[] fArray2, int n3) {
        float f = 0.0f;
        int n4 = 0;
        while (n4 < n) {
            float f2 = fArray[n2 + n4] - fArray2[n4 * n3];
            f += f2 * f2;
            ++n4;
        }
        return f;
    }

    int init_decode(StaticCodeBook staticCodeBook) {
        this.c = staticCodeBook;
        this.entries = staticCodeBook.entries;
        this.dim = staticCodeBook.dim;
        this.valuelist = staticCodeBook.unquantize();
        this.decode_tree = this.make_decode_tree();
        if (this.decode_tree == null) {
            this.clear();
            return -1;
        }
        return 0;
    }

    static int[] make_words(int[] nArray, int n) {
        int n2;
        int n3;
        int[] nArray2 = new int[33];
        int[] nArray3 = new int[n];
        int n4 = 0;
        while (n4 < n) {
            n3 = nArray[n4];
            if (n3 > 0) {
                n2 = nArray2[n3];
                if (n3 < 32 && n2 >>> n3 != 0) {
                    return null;
                }
                nArray3[n4] = n2;
                int n5 = n3;
                while (n5 > 0) {
                    if ((nArray2[n5] & 1) != 0) {
                        if (n5 == 1) {
                            nArray2[1] = nArray2[1] + 1;
                            break;
                        }
                        nArray2[n5] = nArray2[n5 - 1] << 1;
                        break;
                    }
                    int n6 = n5--;
                    nArray2[n6] = nArray2[n6] + 1;
                }
                n5 = n3 + 1;
                while (n5 < 33) {
                    if (nArray2[n5] >>> 1 != n2) break;
                    n2 = nArray2[n5];
                    nArray2[n5] = nArray2[n5 - 1] << 1;
                    ++n5;
                }
            }
            ++n4;
        }
        n4 = 0;
        while (n4 < n) {
            n3 = 0;
            n2 = 0;
            while (n2 < nArray[n4]) {
                n3 <<= 1;
                n3 |= nArray3[n4] >>> n2 & 1;
                ++n2;
            }
            nArray3[n4] = n3;
            ++n4;
        }
        return nArray3;
    }

    DecodeAux make_decode_tree() {
        int n;
        int n2;
        int n3;
        int n4 = 0;
        DecodeAux decodeAux = new DecodeAux();
        decodeAux.ptr0 = new int[this.entries * 2];
        int[] nArray = decodeAux.ptr0;
        decodeAux.ptr1 = new int[this.entries * 2];
        int[] nArray2 = decodeAux.ptr1;
        int[] nArray3 = CodeBook.make_words(this.c.lengthlist, this.c.entries);
        if (nArray3 == null) {
            return null;
        }
        int n5 = 0;
        while (n5 < this.entries) {
            if (this.c.lengthlist[n5] > 0) {
                n3 = 0;
                n2 = 0;
                while (n2 < this.c.lengthlist[n5] - 1) {
                    n = nArray3[n5] >>> n2 & 1;
                    if (n == 0) {
                        if (nArray[n3] == 0) {
                            nArray[n3] = ++n4;
                        }
                        n3 = nArray[n3];
                    } else {
                        if (nArray2[n3] == 0) {
                            nArray2[n3] = ++n4;
                        }
                        n3 = nArray2[n3];
                    }
                    ++n2;
                }
                if ((nArray3[n5] >>> n2 & 1) == 0) {
                    nArray[n3] = -n5;
                } else {
                    nArray2[n3] = -n5;
                }
            }
            ++n5;
        }
        decodeAux.tabn = Util.ilog(this.entries) - 4;
        if (decodeAux.tabn < 5) {
            decodeAux.tabn = 5;
        }
        n5 = 1 << decodeAux.tabn;
        decodeAux.tab = new int[n5];
        decodeAux.tabl = new int[n5];
        n3 = 0;
        while (n3 < n5) {
            n2 = 0;
            n = 0;
            n = 0;
            while (n < decodeAux.tabn && (n2 > 0 || n == 0)) {
                n2 = (n3 & 1 << n) != 0 ? nArray2[n2] : nArray[n2];
                ++n;
            }
            decodeAux.tab[n3] = n2;
            decodeAux.tabl[n3] = n;
            ++n3;
        }
        return decodeAux;
    }

    private static class DecodeAux {
        int[] tab;
        int[] tabl;
        int tabn;
        int[] ptr0;
        int[] ptr1;

        private DecodeAux() {
        }
    }
}

