/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.system;

public class FastMath {
    private static final double B = 1.2732395447351628;
    private static final double C = -0.4052847345693511;
    private static final double P = 0.218;
    private static final double hPI = 1.5707963267948966;
    private static final double PI2 = Math.PI * 2;
    private static final double sPI = 4.71238898038469;
    private static final double atan2_coeff_1 = 0.7853981633974483;
    private static final double atan2_coeff_2 = 2.356194490192345;

    public static double wrap(double d) {
        if ((d %= Math.PI * 2) > Math.PI) {
            d -= Math.PI * 2;
        } else if (d < -Math.PI) {
            d += Math.PI * 2;
        }
        if (d < -Math.PI || d > Math.PI) {
            throw new IllegalArgumentException("Wrong angel : " + d);
        }
        return d;
    }

    public static double fastSin(double d) {
        return FastMath.fastSin0(FastMath.wrap(d));
    }

    public static double fastCos(double d) {
        return FastMath.fastSin0(FastMath.wrap(d + 1.5707963267948966));
    }

    public static double fastSin0(double d) {
        double d2 = 1.2732395447351628 * d + -0.4052847345693511 * d * Math.abs(d);
        d2 = 0.218 * (d2 * Math.abs(d2) - d2) + d2;
        return d2;
    }

    public static double fastCos0(double d) {
        d = d > 1.5707963267948966 ? (d -= 4.71238898038469) : (d += 1.5707963267948966);
        return FastMath.fastSin0(d);
    }

    public static double exp(double d) {
        long l = (long)(1512775.0 * d + 1.072632447E9);
        return Double.longBitsToDouble(l << 32);
    }

    public static double log(double d) {
        return 6.0 * (d - 1.0) / (d + 1.0 + 4.0 * Math.sqrt(d));
    }

    public static double pow(double d, double d2) {
        int n = (int)(Double.doubleToLongBits(d) >> 32);
        int n2 = (int)(d2 * (double)(n - 1072632447) + 1.072632447E9);
        return Double.longBitsToDouble((long)n2 << 32);
    }

    public static float floor(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("Wrong value : " + f);
        }
        return (int)f;
    }

    public static double floor(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("Wrong value : " + d);
        }
        return (long)d;
    }

    public static double atan2(double d, double d2) {
        double d3;
        if (d == 0.0) {
            return 0.0;
        }
        if (d2 == 0.0) {
            return d > 0.0 ? 1.5707963267948966 : -1.5707963267948966;
        }
        double d4 = Math.abs(d);
        if (d2 > 0.0) {
            double d5 = (d2 - d4) / (d2 + d4);
            d3 = 0.7853981633974483 - 0.7853981633974483 * d5;
        } else {
            double d6 = (d2 + d4) / (d4 - d2);
            d3 = 2.356194490192345 - 0.7853981633974483 * d6;
        }
        return d >= 0.0 ? d3 : -d3;
    }

    public static double fastSqrt(double d) {
        long l = Double.doubleToLongBits(d) >> 32;
        double d2 = Double.longBitsToDouble(l + 1072632448L << 31);
        return d2;
    }

    public static double sqrt(double d) {
        long l = Double.doubleToLongBits(d) >> 32;
        double d2 = Double.longBitsToDouble(l + 1072632448L << 31);
        d2 = (d2 + d / d2) * 0.5;
        return d2;
    }
}

