/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.ogg;

import de.quippy.javamod.io.FileOrPackedInputStream;
import de.quippy.javamod.mixer.BasicMixer;
import de.quippy.javamod.system.Log;
import de.quippy.ogg.jogg.Packet;
import de.quippy.ogg.jogg.Page;
import de.quippy.ogg.jogg.StreamState;
import de.quippy.ogg.jogg.SyncState;
import de.quippy.ogg.jorbis.Block;
import de.quippy.ogg.jorbis.Comment;
import de.quippy.ogg.jorbis.DspState;
import de.quippy.ogg.jorbis.Info;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.AudioFormat;

public class OGGMixer
extends BasicMixer {
    private static final int STATE_INITIAL = 0;
    private static final int STATE_READHEADER = 1;
    private static final int STATE_PREPARE = 2;
    private static final int STATE_READFIRSTFRAME = 3;
    private static final int STATE_PROCESSPACKET = 4;
    private static final int STATE_NEEDMOREDATA = 5;
    private static final int STATE_CONVERTPCM = 6;
    private static final int STATE_EOS = 7;
    private static final int CHUNKSIZE = 4096;
    private boolean oggEOS;
    private int decoderState;
    private SyncState oggSyncState;
    private StreamState oggStreamState;
    private Page oggPage;
    private Packet oggPacket;
    private Info vorbisInfo;
    private Comment vorbisComment;
    private DspState vorbisDSPState;
    private Block vorbisBlock;
    private final float[][][] pcmFloatBuffer = new float[1][][];
    private int[] pcmGeneratorIndex;
    private int bufferSize;
    private byte[] output;
    private int samplesProcessed;
    private long currentSamplesWritten;
    private int lengthInMilliseconds;
    private InputStream inputStream;
    private URL oggFileUrl;

    public OGGMixer(URL uRL, int n) {
        this.oggFileUrl = uRL;
        this.lengthInMilliseconds = n;
    }

    private void initialize() {
        try {
            if (this.inputStream != null) {
                try {
                    this.inputStream.close();
                    this.inputStream = null;
                }
                catch (IOException iOException) {
                    Log.error("IGNORED", iOException);
                }
            }
            this.inputStream = new FileOrPackedInputStream(this.oggFileUrl);
            this.oggEOS = false;
            this.decoderState = 0;
            this.bufferSize = 0;
            this.output = null;
        }
        catch (Exception exception) {
            if (this.inputStream != null) {
                try {
                    this.inputStream.close();
                    this.inputStream = null;
                }
                catch (IOException iOException) {
                    Log.error("IGNORED", iOException);
                }
            }
            Log.error("[OGGMixer]", exception);
        }
    }

    @Override
    public int getChannelCount() {
        if (this.vorbisInfo != null) {
            return this.vorbisInfo.channels;
        }
        return 0;
    }

    @Override
    public int getCurrentKBperSecond() {
        if (this.vorbisInfo != null) {
            int n = this.vorbisInfo.bitrate();
            if (n == -1) {
                return 16 * this.vorbisInfo.rate * this.vorbisInfo.channels / 1000;
            }
            return n / 1000;
        }
        return 0;
    }

    @Override
    public int getCurrentSampleFrequency() {
        if (this.vorbisInfo != null) {
            return this.vorbisInfo.rate / 1000;
        }
        return 0;
    }

    @Override
    public long getLengthInMilliseconds() {
        return this.lengthInMilliseconds;
    }

    @Override
    public long getMillisecondPosition() {
        if (this.vorbisInfo != null && this.vorbisInfo.rate != 0) {
            return this.currentSamplesWritten * 1000L / (long)this.vorbisInfo.rate;
        }
        return 0L;
    }

    @Override
    public boolean isSeekSupported() {
        return true;
    }

    @Override
    protected void seek(long l) {
        try {
            if (l < this.getMillisecondPosition()) {
                this.cleanUp();
                this.initialize();
            }
            int n = 1;
            while (this.getMillisecondPosition() < l && n > 0) {
                n = this.decodeFrame();
            }
        }
        catch (Exception exception) {
            Log.error("[OGGMixer]", exception);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int decodeFrame() throws Exception {
        block10: while (true) {
            switch (this.decoderState) {
                case 7: {
                    return -1;
                }
                case 0: {
                    this.decoderState = this.doStateInitial();
                    continue block10;
                }
                case 1: {
                    this.decoderState = this.doStateReadHeader();
                    continue block10;
                }
                case 2: {
                    this.decoderState = this.doStatePrepare();
                    continue block10;
                }
                case 3: {
                    this.decoderState = 5;
                    continue block10;
                }
                case 5: {
                    this.decoderState = this.doStateNeedMoreData();
                    continue block10;
                }
                case 4: {
                    this.decoderState = this.doStateProcessPacket();
                    continue block10;
                }
                case 6: {
                    this.decoderState = this.doStateConvertPCM();
                    if (this.decoderState == 6) return this.samplesProcessed * 2 * this.vorbisInfo.channels;
                    continue block10;
                }
            }
            break;
        }
        throw new IOException("invalid decoder state " + this.decoderState);
    }

    private void fetchMoreData() throws IOException {
        if (!this.oggEOS) {
            int n = this.oggSyncState.buffer(4096);
            int n2 = this.inputStream.read(this.oggSyncState.data, n, 4096);
            if (n2 <= 0) {
                this.oggEOS = true;
            } else {
                this.oggSyncState.wrote(n2);
            }
        }
    }

    private int doStateConvertPCM() throws Exception {
        int n = 4;
        int n2 = this.vorbisDSPState.synthesis_pcmout(this.pcmFloatBuffer, this.pcmGeneratorIndex);
        if (n2 > 0) {
            this.samplesProcessed = n2 > this.bufferSize ? this.bufferSize : n2;
            int n3 = 0;
            while (n3 < this.vorbisInfo.channels) {
                int n4 = n3 << 1;
                int n5 = 0;
                while (n5 < this.samplesProcessed) {
                    int n6 = (int)(this.pcmFloatBuffer[0][n3][this.pcmGeneratorIndex[n3] + n5] * 32767.0f);
                    if (n6 > Short.MAX_VALUE) {
                        n6 = Short.MAX_VALUE;
                    } else if (n6 < Short.MIN_VALUE) {
                        n6 = Short.MIN_VALUE;
                    }
                    if (n6 < 0) {
                        n6 |= 0x8000;
                    }
                    this.output[n4] = (byte)(n6 & 0xFF);
                    this.output[n4 + 1] = (byte)(n6 >> 8 & 0xFF);
                    n4 += this.vorbisInfo.channels << 1;
                    ++n5;
                }
                ++n3;
            }
            this.currentSamplesWritten += (long)this.samplesProcessed;
            this.vorbisDSPState.synthesis_read(this.samplesProcessed);
            n = 6;
        }
        return n;
    }

    /*
     * Unable to fully structure code
     */
    private int doStateNeedMoreData() throws Exception {
        if (!this.oggEOS) ** GOTO lbl12
        return 7;
lbl-1000:
        // 2 sources

        {
            if ((var1_1 = this.oggSyncState.pageout(this.oggPage)) == 0) {
                this.fetchMoreData();
            }
            if (!this.oggEOS && var1_1 == 0) continue;
            if (var1_1 != -1) {
                this.oggStreamState.pagein(this.oggPage);
                if (this.oggPage.granulepos() != 0L) break;
                this.oggEOS = true;
                return 7;
            }
lbl12:
            // 3 sources

            if (this.oggEOS) break;
            ** while (true)
        }
        return 4;
    }

    private int doStateProcessPacket() throws Exception {
        int n = 4;
        int n2 = this.oggStreamState.packetout(this.oggPacket);
        if (n2 == 0) {
            if (!this.oggEOS) {
                this.oggEOS = this.oggPage.eos() != 0;
            }
            n = 5;
        } else if (n2 != -1) {
            if (this.vorbisBlock.synthesis(this.oggPacket) == 0) {
                this.vorbisDSPState.synthesis_blockin(this.vorbisBlock);
            }
            n = 6;
        }
        return n;
    }

    private int doStateInitial() throws Exception {
        this.oggSyncState = new SyncState();
        this.oggStreamState = new StreamState();
        this.oggPage = new Page();
        this.oggPacket = new Packet();
        this.vorbisInfo = new Info();
        this.vorbisComment = new Comment();
        this.vorbisDSPState = new DspState();
        this.vorbisBlock = new Block(this.vorbisDSPState);
        this.oggSyncState.init();
        this.oggEOS = false;
        return 1;
    }

    /*
     * Unable to fully structure code
     */
    private int doStateReadHeader() throws Exception {
        block13: {
            this.fetchMoreData();
            if (this.oggSyncState.pageout(this.oggPage) != 1) {
                throw new IOException("Input does not appear to be an Ogg bitstream");
            }
            this.oggStreamState.init(this.oggPage.serialno());
            this.oggStreamState.reset();
            if (this.oggStreamState.pagein(this.oggPage) < 0) {
                throw new IOException("Error reading first page of Ogg bitstream data");
            }
            if (this.oggStreamState.packetout(this.oggPacket) != 1) {
                throw new IOException("Error reading initial header packet");
            }
            this.vorbisInfo.init();
            this.vorbisComment.init();
            if (this.vorbisInfo.synthesis_headerin(this.vorbisComment, this.oggPacket) < 0) {
                throw new IOException("This Ogg bitstream does not contain Vorbis audio data");
            }
            var1_1 = 0;
            break block13;
            while ((var2_2 = this.oggSyncState.pageout(this.oggPage)) != 0) {
                if (var2_2 == 1) {
                    this.oggStreamState.pagein(this.oggPage);
                    while (var1_1 < 2) {
                        var2_2 = this.oggStreamState.packetout(this.oggPacket);
                        if (var2_2 != 0) {
                            if (var2_2 == -1) {
                                throw new IOException("Corrupt secondary header");
                            }
                            this.vorbisInfo.synthesis_headerin(this.vorbisComment, this.oggPacket);
                            ++var1_1;
                            continue;
                        }
                        break;
                    }
                } else {
                    throw new IOException("Unhandled pageout() return code " + var2_2);
                }
lbl34:
                // 2 sources

                ** while (var1_1 >= 2)
lbl35:
                // 1 sources

            }
lbl36:
            // 2 sources

            this.fetchMoreData();
            if (this.oggEOS) {
                throw new IOException("End of file before finding all Vorbis headers");
            }
        }
        if (var1_1 < 2) ** GOTO lbl34
        return 2;
    }

    private final int doStatePrepare() throws Exception {
        this.vorbisDSPState.synthesis_init(this.vorbisInfo);
        this.vorbisBlock.init(this.vorbisDSPState);
        this.pcmGeneratorIndex = new int[this.vorbisInfo.channels];
        this.currentSamplesWritten = 0L;
        this.bufferSize = 250 * this.vorbisInfo.channels * this.vorbisInfo.rate / 1000;
        this.bufferSize <<= 1;
        this.output = new byte[this.bufferSize];
        AudioFormat audioFormat = new AudioFormat(this.vorbisInfo.rate, 16, this.vorbisInfo.channels, true, false);
        this.setAudioFormat(audioFormat);
        this.openAudioDevice();
        return 3;
    }

    private void cleanUp() {
        if (this.oggStreamState != null) {
            this.oggStreamState.clear();
            this.oggStreamState = null;
        }
        if (this.vorbisBlock != null) {
            this.vorbisBlock.clear();
            this.vorbisBlock = null;
        }
        if (this.vorbisDSPState != null) {
            this.vorbisDSPState.clear();
            this.vorbisDSPState = null;
        }
        if (this.vorbisInfo != null) {
            this.vorbisInfo.clear();
            this.vorbisInfo = null;
        }
        if (this.oggSyncState != null) {
            this.oggSyncState.clear();
            this.oggSyncState = null;
        }
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
                this.inputStream = null;
            }
            catch (IOException iOException) {
                Log.error("IGNORED", iOException);
            }
        }
    }

    @Override
    public void startPlayback() {
        this.initialize();
        this.setIsPlaying();
        if (this.getSeekPosition() > 0L) {
            this.seek(this.getSeekPosition());
        }
        try {
            try {
                int n = 0;
                do {
                    if ((n = this.decodeFrame()) <= 0 || !this.isInitialized()) continue;
                    this.writeSampleDataToLine(this.output, 0, n);
                    if (this.isStopping()) {
                        this.setIsStopped();
                        break;
                    }
                    if (this.isPausing()) {
                        this.setIsPaused();
                        while (this.isPaused()) {
                            try {
                                Thread.sleep(1L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                    if (!this.isInSeeking()) continue;
                    this.setIsSeeking();
                    while (this.isInSeeking()) {
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                } while (n != -1);
                if (n <= 0) {
                    this.setHasFinished();
                }
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }
        finally {
            this.setIsStopped();
            this.closeAudioDevice();
            this.cleanUp();
        }
    }
}

