/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.mp3.id3;

import de.quippy.javamod.io.RandomAccessInputStream;
import de.quippy.javamod.multimedia.mp3.id3.NullsoftID3GenreTable;
import de.quippy.javamod.multimedia.mp3.id3.exceptions.ID3FieldDataException;
import de.quippy.javamod.system.Helpers;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class ID3v1Tag {
    private static final int TAG_SIZE = 128;
    private static final int TITLE_SIZE = 30;
    private static final int ARTIST_SIZE = 30;
    private static final int ALBUM_SIZE = 30;
    private static final int YEAR_SIZE = 4;
    private static final int COMMENT_SIZE = 29;
    private static final int TRACK_LOCATION = 126;
    private static final int GENRE_LOCATION = 127;
    private static final int MAX_GENRE = 255;
    private static final int MAX_TRACK = 255;
    private static final String ENC_TYPE = "ISO-8859-1";
    private static final String TAG_START = "TAG";
    private boolean headerExists = false;
    private String title = null;
    private String artist = null;
    private String album = null;
    private String year = null;
    private String comment = null;
    private int genre;
    private int track;

    public ID3v1Tag(RandomAccessInputStream randomAccessInputStream) throws FileNotFoundException, IOException {
        this.headerExists = this.checkHeader(randomAccessInputStream);
        if (this.headerExists) {
            this.readTag(randomAccessInputStream);
        }
    }

    private boolean checkHeader(RandomAccessInputStream randomAccessInputStream) throws FileNotFoundException, IOException {
        boolean bl = false;
        if (randomAccessInputStream.length() > 128L) {
            randomAccessInputStream.seek(randomAccessInputStream.length() - 128L);
            byte[] byArray = new byte[3];
            if (randomAccessInputStream.read(byArray) != 3) {
                throw new IOException("Error encountered reading ID3 header");
            }
            String string = new String(byArray, 0, 3, ENC_TYPE);
            bl = string.equals(TAG_START);
        }
        return bl;
    }

    private void readTag(RandomAccessInputStream randomAccessInputStream) throws FileNotFoundException, IOException {
        randomAccessInputStream.seek(randomAccessInputStream.length() - 128L);
        byte[] byArray = new byte[128];
        randomAccessInputStream.read(byArray, 0, 128);
        String string = new String(byArray, 0, 128, ENC_TYPE);
        int n = TAG_START.length();
        this.title = string.substring(n, n += 30);
        this.artist = string.substring(n, n += 30);
        this.album = string.substring(n, n += 30);
        this.year = string.substring(n, n += 4);
        this.comment = string.substring(n, n += 29);
        this.track = string.charAt(126);
        this.genre = string.charAt(127);
    }

    public void writeTag(RandomAccessFile randomAccessFile) throws FileNotFoundException, IOException {
        if (this.headerExists) {
            randomAccessFile.seek(randomAccessFile.length() - 128L);
        } else {
            randomAccessFile.seek(randomAccessFile.length());
        }
        randomAccessFile.write(Helpers.getBytesFromString(TAG_START, TAG_START.length(), ENC_TYPE));
        randomAccessFile.write(Helpers.getBytesFromString(this.title, 30, ENC_TYPE));
        randomAccessFile.write(Helpers.getBytesFromString(this.artist, 30, ENC_TYPE));
        randomAccessFile.write(Helpers.getBytesFromString(this.album, 30, ENC_TYPE));
        randomAccessFile.write(Helpers.getBytesFromString(this.year, 4, ENC_TYPE));
        randomAccessFile.write(Helpers.getBytesFromString(this.comment, 29, ENC_TYPE));
        randomAccessFile.write((byte)this.track);
        randomAccessFile.write((byte)this.genre);
        this.headerExists = true;
    }

    public void removeTag(RandomAccessFile randomAccessFile) throws FileNotFoundException, IOException {
        if (this.headerExists) {
            randomAccessFile.setLength(randomAccessFile.length() - 128L);
            this.headerExists = false;
        }
    }

    public String getGenreString() {
        return NullsoftID3GenreTable.getGenre(this.genre);
    }

    public boolean setGenreString(String string) {
        int n = NullsoftID3GenreTable.getGenre(string);
        boolean bl = false;
        if (n != -1) {
            this.genre = n;
            bl = true;
        }
        return bl;
    }

    public boolean tagExists() {
        return this.headerExists;
    }

    public String getTitle() {
        return this.title.trim();
    }

    public void setTitle(String string) {
        this.title = string.length() > 30 ? string.substring(0, 30) : string;
    }

    public String getArtist() {
        return this.artist.trim();
    }

    public void setArtist(String string) {
        this.artist = string.length() > 30 ? string.substring(0, 30) : string;
    }

    public String getAlbum() {
        return this.album.trim();
    }

    public void setAlbum(String string) {
        this.album = string.length() > 30 ? string.substring(0, 30) : string;
    }

    public String getYear() {
        return this.year.trim();
    }

    public void setYear(String string) {
        this.year = string.length() > 4 ? string.substring(0, 4) : string;
    }

    public String getComment() {
        return this.comment.trim();
    }

    public void setComment(String string) {
        this.comment = this.comment.length() > 29 ? string.substring(0, 29) : string;
    }

    public int getTrack() {
        return this.track;
    }

    public void setTrack(int n) {
        if (n <= 255 && n >= 0) {
            this.track = n;
        }
    }

    public int getGenre() {
        return this.genre;
    }

    public void setGenre(int n) throws ID3FieldDataException {
        if (n > 255 || n < 0) {
            throw new ID3FieldDataException("Invalid genre value.  Must be between 0 and 255.");
        }
        this.genre = n;
    }

    public int getSize() {
        int n = 0;
        if (this.headerExists) {
            n = 128;
        }
        return n;
    }

    public String toString() {
        return "ID3v1.0\nTagSize:\t\t\t" + this.getSize() + " bytes\nTitle:\t\t\t\t" + this.getTitle() + "\nArtist:\t\t\t\t" + this.getArtist() + "\nAlbum:\t\t\t\t" + this.getAlbum() + "\nYear:\t\t\t\t" + this.getYear() + "\nComment:\t\t\t" + this.getComment() + "\nTrack:\t\t\t\t" + this.getTrack() + "\nGenre:\t\t\t\t" + this.getGenreString();
    }
}

