/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.mp3;

import de.quippy.javamod.io.RandomAccessInputStreamImpl;
import de.quippy.javamod.mixer.Mixer;
import de.quippy.javamod.multimedia.MultimediaContainer;
import de.quippy.javamod.multimedia.MultimediaContainerEvent;
import de.quippy.javamod.multimedia.MultimediaContainerManager;
import de.quippy.javamod.multimedia.mp3.MP3InfoPanel;
import de.quippy.javamod.multimedia.mp3.MP3Mixer;
import de.quippy.javamod.multimedia.mp3.MP3StreamInfoPanel;
import de.quippy.javamod.multimedia.mp3.id3.MP3FileID3Controller;
import de.quippy.javamod.multimedia.mp3.streaming.TagParseEvent;
import de.quippy.javamod.multimedia.mp3.streaming.TagParseListener;
import de.quippy.javamod.system.Log;
import de.quippy.mp3.decoder.Bitstream;
import de.quippy.mp3.decoder.BitstreamException;
import de.quippy.mp3.decoder.Header;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import javax.swing.JPanel;

public class MP3Container
extends MultimediaContainer
implements TagParseListener {
    private static final String[] MP3FILEEXTENSION = new String[]{"mp1", "mp2", "mp3"};
    private MP3Mixer currentMixer;
    private MP3InfoPanel mp3InfoPanel;
    private MP3StreamInfoPanel mp3StreamInfoPanel;
    private MP3FileID3Controller mp3FileIDTags = null;
    private boolean isStreaming;

    static {
        MultimediaContainerManager.registerContainer(new MP3Container());
    }

    @Override
    public MultimediaContainer getInstance(URL uRL) {
        MultimediaContainer multimediaContainer = super.getInstance(uRL);
        boolean bl = this.isStreaming = !uRL.getProtocol().equalsIgnoreCase("file");
        if (!this.isStreaming) {
            this.mp3FileIDTags = new MP3FileID3Controller(uRL);
            ((MP3InfoPanel)this.getInfoPanel()).fillInfoPanelWith(this.mp3FileIDTags);
        } else {
            this.mp3FileIDTags = null;
            ((MP3StreamInfoPanel)this.getInfoPanel()).clearFields();
        }
        return multimediaContainer;
    }

    @Override
    public String getSongName() {
        if (this.mp3FileIDTags != null) {
            return this.mp3FileIDTags.getShortDescription();
        }
        return super.getSongName();
    }

    @Override
    public Object[] getSongInfosFor(URL uRL) {
        Long l;
        String string;
        block26: {
            string = MultimediaContainerManager.getSongNameFromURL(uRL);
            l = -1L;
            RandomAccessInputStreamImpl randomAccessInputStreamImpl = null;
            Bitstream bitstream = null;
            try {
                try {
                    if (uRL.getProtocol().equalsIgnoreCase("file")) {
                        randomAccessInputStreamImpl = new RandomAccessInputStreamImpl(uRL);
                        bitstream = new Bitstream(randomAccessInputStreamImpl);
                        Header header = bitstream.readFrame();
                        if (header != null) {
                            l = (long)((double)header.total_ms(randomAccessInputStreamImpl.available()) + 0.5);
                        }
                        this.mp3FileIDTags = new MP3FileID3Controller(randomAccessInputStreamImpl);
                        if (this.mp3FileIDTags != null) {
                            string = this.mp3FileIDTags.getShortDescription();
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (bitstream != null) {
                        try {
                            bitstream.close();
                        }
                        catch (BitstreamException bitstreamException) {
                            Log.error("IGNORED", bitstreamException);
                        }
                    }
                    if (randomAccessInputStreamImpl != null) {
                        try {
                            randomAccessInputStreamImpl.close();
                        }
                        catch (IOException iOException) {
                            Log.error("IGNORED", iOException);
                        }
                    }
                    break block26;
                }
            }
            catch (Throwable throwable) {
                if (bitstream != null) {
                    try {
                        bitstream.close();
                    }
                    catch (BitstreamException bitstreamException) {
                        Log.error("IGNORED", bitstreamException);
                    }
                }
                if (randomAccessInputStreamImpl != null) {
                    try {
                        randomAccessInputStreamImpl.close();
                    }
                    catch (IOException iOException) {
                        Log.error("IGNORED", iOException);
                    }
                }
                throw throwable;
            }
            if (bitstream != null) {
                try {
                    bitstream.close();
                }
                catch (BitstreamException bitstreamException) {
                    Log.error("IGNORED", bitstreamException);
                }
            }
            if (randomAccessInputStreamImpl != null) {
                try {
                    randomAccessInputStreamImpl.close();
                }
                catch (IOException iOException) {
                    Log.error("IGNORED", iOException);
                }
            }
        }
        return new Object[]{string, l};
    }

    @Override
    public boolean canExport() {
        return true;
    }

    @Override
    public JPanel getConfigPanel() {
        return null;
    }

    @Override
    public JPanel getInfoPanel() {
        if (this.isStreaming) {
            if (this.mp3StreamInfoPanel == null) {
                this.mp3StreamInfoPanel = new MP3StreamInfoPanel();
            }
            return this.mp3StreamInfoPanel;
        }
        if (this.mp3InfoPanel == null) {
            this.mp3InfoPanel = new MP3InfoPanel();
        }
        return this.mp3InfoPanel;
    }

    @Override
    public String[] getFileExtensionList() {
        return MP3FILEEXTENSION;
    }

    @Override
    public String getName() {
        return "MP3-File";
    }

    @Override
    public void configurationChanged(Properties properties) {
    }

    @Override
    public void configurationSave(Properties properties) {
    }

    @Override
    public Mixer createNewMixer() {
        this.currentMixer = new MP3Mixer(this.getFileURL());
        this.currentMixer.setTagParserListener(this);
        return this.currentMixer;
    }

    @Override
    public void tagParsed(TagParseEvent tagParseEvent) {
        JPanel jPanel = this.getInfoPanel();
        if (jPanel instanceof MP3StreamInfoPanel) {
            ((MP3StreamInfoPanel)jPanel).fillInfoPanelWith(tagParseEvent.getIcyTag());
            String string = ((MP3StreamInfoPanel)jPanel).getCurrentSongName();
            if (string != null && string.length() != 0) {
                this.fireMultimediaContainerEvent(new MultimediaContainerEvent(this, MultimediaContainerEvent.SONG_NAME_CHANGED, string));
            }
        }
    }
}

