/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.mod.mixer.interpolation;

public class WindowedFIR {
    private static final int WFIR_QUANTBITS = 15;
    private static final int WFIR_QUANTSCALE = 32768;
    public static final int WFIR_16BITSHIFT = 14;
    private static final int WFIR_FRACBITS = 10;
    private static final int WFIR_LUTLEN = 2049;
    private static final int WFIR_LOG2WIDTH = 3;
    private static final int WFIR_WIDTH = 8;
    private static final float WFIR_CUTOFF = 0.9f;
    private static final int WFIR_HANN = 0;
    private static final int WFIR_HAMMING = 1;
    private static final int WFIR_BLACKMANEXACT = 2;
    private static final int WFIR_BLACKMAN3T61 = 3;
    private static final int WFIR_BLACKMAN3T67 = 4;
    private static final int WFIR_BLACKMAN4T92 = 5;
    private static final int WFIR_BLACKMAN4T74 = 6;
    private static final int WFIR_KAISER4T = 7;
    private static final int WFIR_TYPE = 2;
    private static final double M_zEPS = 1.0E-8;
    public static final int WFIR_POSFRACMASK = 65535;
    public static final int WFIR_FRACSHIFT = 2;
    public static final int WFIR_FRACMASK = 32760;
    public static final int WFIR_FRACHALVE = 16;
    public static final int[] lut = new int[16392];

    static {
        WindowedFIR.initialize();
    }

    private WindowedFIR() {
    }

    private static double coef(int n, double d, double d2, int n2, int n3) {
        double d3;
        double d4;
        double d5 = n2 - 1;
        double d6 = 0.5 * d5;
        double d7 = (double)n - d;
        double d8 = d7 - d6;
        double d9 = Math.PI * 2 / d5;
        if (Math.abs(d8) < 1.0E-8) {
            d4 = 1.0;
            d3 = d2;
        } else {
            switch (n3) {
                case 0: {
                    d4 = 0.5 - 0.5 * Math.cos(d9 * d7);
                    break;
                }
                case 1: {
                    d4 = 0.54 - 0.46 * Math.cos(d9 * d7);
                    break;
                }
                case 2: {
                    d4 = 0.42 - 0.5 * Math.cos(d9 * d7) + 0.08 * Math.cos(2.0 * d9 * d7);
                    break;
                }
                case 3: {
                    d4 = 0.44959 - 0.49364 * Math.cos(d9 * d7) + 0.05677 * Math.cos(2.0 * d9 * d7);
                    break;
                }
                case 4: {
                    d4 = 0.42323 - 0.49755 * Math.cos(d9 * d7) + 0.07922 * Math.cos(2.0 * d9 * d7);
                    break;
                }
                case 5: {
                    d4 = 0.35875 - 0.48829 * Math.cos(d9 * d7) + 0.14128 * Math.cos(2.0 * d9 * d7) - 0.01168 * Math.cos(3.0 * d9 * d7);
                    break;
                }
                case 6: {
                    d4 = 0.40217 - 0.49703 * Math.cos(d9 * d7) + 0.09392 * Math.cos(2.0 * d9 * d7) - 0.00183 * Math.cos(3.0 * d9 * d7);
                    break;
                }
                case 7: {
                    d4 = 0.40243 - 0.49804 * Math.cos(d9 * d7) + 0.09831 * Math.cos(2.0 * d9 * d7) - 0.00122 * Math.cos(3.0 * d9 * d7);
                    break;
                }
                default: {
                    d4 = 1.0;
                }
            }
            d3 = Math.sin(d2 * (d8 *= Math.PI)) / d8;
        }
        return d4 * d3;
    }

    private static void initialize() {
        double d = 1024.0;
        double d2 = 1.0 / (2.0 * d);
        double d3 = 0.9f;
        double d4 = 32768.0;
        int n = 0;
        while (n < 2049) {
            double[] dArray = new double[8];
            double d5 = ((double)n - d) * d2;
            int n2 = n << 3;
            double d6 = 0.0;
            int n3 = 0;
            while (n3 < 8) {
                dArray[n3] = WindowedFIR.coef(n3, d5, d3, 8, 2);
                d6 += dArray[n3];
                ++n3;
            }
            d6 = 1.0 / d6;
            n3 = 0;
            while (n3 < 8) {
                double d7 = Math.floor(0.5 + d4 * dArray[n3] * d6);
                WindowedFIR.lut[n2 + n3] = (int)(d7 < -d4 ? -d4 : (d7 > d4 ? d4 : d7));
                ++n3;
            }
            ++n;
        }
    }
}

