/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.mod.loader.instrument;

public class Envelope {
    private int[] position;
    private int[] value;
    private int nPoints;
    private int sustainStartPoint;
    private int sustainEndPoint;
    private int loopStartPoint;
    private int loopEndPoint;
    public boolean on = false;
    public boolean sustain = false;
    public boolean loop = false;
    public boolean carry = false;
    public boolean filter = false;
    private static final int SHIFT = 3;
    private static final int MAXVALUE = 512;

    public int updatePosition(int n, boolean bl) {
        if (this.loop && ++n >= this.position[this.loopEndPoint]) {
            n = this.position[this.loopStartPoint];
        }
        if (this.sustain && n >= this.position[this.sustainEndPoint] && !bl) {
            n = this.position[this.sustainStartPoint];
        }
        return n;
    }

    public int getValueForPosition(int n) {
        int n2;
        int n3;
        int n4 = this.nPoints - 1;
        int n5 = 0;
        while (n5 < n4) {
            if (n <= this.position[n5]) {
                n4 = n5;
                break;
            }
            ++n5;
        }
        n5 = this.position[n4];
        if (n >= n5) {
            n3 = this.value[n4] << 3;
            n2 = n5;
        } else if (n4 > 0) {
            n3 = this.value[n4 - 1] << 3;
            n2 = this.position[n4 - 1];
        } else {
            n2 = 0;
            n3 = 0;
        }
        if (n > n5) {
            n = n5;
        }
        if (n5 > n2 && n > n2) {
            n3 += (n - n2) * ((this.value[n4] << 3) - n3) / (n5 - n2);
        }
        if (n3 < 0) {
            n3 = 0;
        } else if (n3 > 512) {
            n3 = 512;
        }
        return n3;
    }

    public void setXMType(int n) {
        this.on = (n & 1) != 0;
        this.sustain = (n & 2) != 0;
        this.loop = (n & 4) != 0;
        this.filter = false;
        this.carry = false;
    }

    public void setITType(int n) {
        this.on = (n & 1) != 0;
        this.loop = (n & 2) != 0;
        this.sustain = (n & 4) != 0;
        this.carry = (n & 8) != 0;
        this.filter = (n & 0x80) != 0;
    }

    public void setLoopEndPoint(int n) {
        this.loopEndPoint = n;
    }

    public void setLoopStartPoint(int n) {
        this.loopStartPoint = n;
    }

    public void setNPoints(int n) {
        this.nPoints = n;
    }

    public void setPosition(int[] nArray) {
        this.position = nArray;
    }

    public void setValue(int[] nArray) {
        this.value = nArray;
    }

    public void setSustainPoint(int n) {
        this.sustainStartPoint = this.sustainEndPoint = n;
    }

    public void setSustainEndPoint(int n) {
        this.sustainEndPoint = n;
    }

    public void setSustainStartPoint(int n) {
        this.sustainStartPoint = n;
    }
}

