/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia;

import de.quippy.javamod.multimedia.MultimediaContainer;
import de.quippy.javamod.multimedia.MultimediaContainerEventListener;
import de.quippy.javamod.system.Helpers;
import de.quippy.javamod.system.Log;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import javax.sound.sampled.UnsupportedAudioFileException;

public class MultimediaContainerManager {
    private static HashMap<String, MultimediaContainer> fileExtensionMap;
    private static ArrayList<MultimediaContainer> containerArray;
    private static Properties containerConfigs;

    private MultimediaContainerManager() {
    }

    public static HashMap<String, MultimediaContainer> getFileExtensionMap() {
        if (fileExtensionMap == null) {
            fileExtensionMap = new HashMap();
        }
        return fileExtensionMap;
    }

    public static ArrayList<MultimediaContainer> getContainerArray() {
        if (containerArray == null) {
            containerArray = new ArrayList();
        }
        return containerArray;
    }

    public static Properties getContainerConfigs() {
        if (containerConfigs == null) {
            containerConfigs = new Properties();
        }
        return containerConfigs;
    }

    public static void getContainerConfigs(Properties properties) {
        MultimediaContainerManager.fireConfiggurationSave();
        Enumeration<Object> enumeration = MultimediaContainerManager.getContainerConfigs().keys();
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            Object object2 = MultimediaContainerManager.getContainerConfigs().get(object);
            properties.put(object, object2);
        }
    }

    public static void configureContainer(Properties properties) {
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            Object object2 = properties.get(object);
            MultimediaContainerManager.getContainerConfigs().put(object, object2);
        }
        MultimediaContainerManager.fireConfiggurationChanged();
    }

    private static void fireConfiggurationChanged() {
        ArrayList<MultimediaContainer> arrayList = MultimediaContainerManager.getContainerArray();
        int n = 0;
        while (n < arrayList.size()) {
            arrayList.get(n).configurationChanged(MultimediaContainerManager.getContainerConfigs());
            ++n;
        }
    }

    private static void fireConfiggurationSave() {
        ArrayList<MultimediaContainer> arrayList = MultimediaContainerManager.getContainerArray();
        int n = 0;
        while (n < arrayList.size()) {
            arrayList.get(n).configurationSave(MultimediaContainerManager.getContainerConfigs());
            ++n;
        }
    }

    public static void registerContainer(MultimediaContainer multimediaContainer) {
        MultimediaContainerManager.getContainerArray().add(multimediaContainer);
        String[] stringArray = multimediaContainer.getFileExtensionList();
        int n = 0;
        while (n < stringArray.length) {
            MultimediaContainerManager.getFileExtensionMap().put(stringArray[n], multimediaContainer);
            ++n;
        }
    }

    public static void deregisterContainer(MultimediaContainer multimediaContainer) {
        MultimediaContainerManager.getContainerArray().remove(multimediaContainer);
        String[] stringArray = multimediaContainer.getFileExtensionList();
        int n = 0;
        while (n < stringArray.length) {
            MultimediaContainerManager.getFileExtensionMap().remove(stringArray[n]);
            ++n;
        }
    }

    public static void updateLookAndFeel() {
        ArrayList<MultimediaContainer> arrayList = MultimediaContainerManager.getContainerArray();
        int n = 0;
        while (n < arrayList.size()) {
            arrayList.get(n).updateLookAndFeel();
            ++n;
        }
    }

    public static String[] getSupportedFileExtensions() {
        Set<String> set = MultimediaContainerManager.getFileExtensionMap().keySet();
        String[] stringArray = new String[set.size()];
        return set.toArray(stringArray);
    }

    public static HashMap<String, String[]> getSupportedFileExtensionsPerContainer() {
        ArrayList<MultimediaContainer> arrayList = MultimediaContainerManager.getContainerArray();
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>(arrayList.size());
        int n = 0;
        while (n < arrayList.size()) {
            hashMap.put(arrayList.get(n).getName(), arrayList.get(n).getFileExtensionList());
            ++n;
        }
        return hashMap;
    }

    public static MultimediaContainer getMultimediaContainerForType(String string) throws UnsupportedAudioFileException {
        MultimediaContainer multimediaContainer = MultimediaContainerManager.getFileExtensionMap().get(string.toLowerCase());
        if (multimediaContainer == null) {
            throw new UnsupportedAudioFileException(string);
        }
        return multimediaContainer;
    }

    public static MultimediaContainer getMultimediaContainerSingleton(URL uRL) throws UnsupportedAudioFileException {
        String string = uRL.getPath();
        MultimediaContainer multimediaContainer = MultimediaContainerManager.getFileExtensionMap().get(Helpers.getExtensionFrom(string));
        if (multimediaContainer == null) {
            multimediaContainer = MultimediaContainerManager.getFileExtensionMap().get(Helpers.getPreceedingExtensionFrom(string));
        }
        if (multimediaContainer == null) {
            if (uRL.getProtocol().equalsIgnoreCase("file")) {
                throw new UnsupportedAudioFileException(string);
            }
            multimediaContainer = MultimediaContainerManager.getFileExtensionMap().get("mp3");
        }
        return multimediaContainer;
    }

    public static MultimediaContainer getMultimediaContainer(URL uRL) throws UnsupportedAudioFileException {
        MultimediaContainer multimediaContainer = MultimediaContainerManager.getMultimediaContainerSingleton(uRL);
        MultimediaContainer multimediaContainer2 = multimediaContainer.getInstance(uRL);
        if (multimediaContainer2 == null) {
            throw new UnsupportedAudioFileException(uRL.getPath());
        }
        return multimediaContainer2;
    }

    public static MultimediaContainer getMultimediaContainer(URI uRI) throws MalformedURLException, UnsupportedAudioFileException {
        return MultimediaContainerManager.getMultimediaContainer(uRI.toURL());
    }

    public static MultimediaContainer getMultimediaContainer(File file) throws MalformedURLException, UnsupportedAudioFileException {
        return MultimediaContainerManager.getMultimediaContainer(file.toURI());
    }

    public static MultimediaContainer getMultimediaContainer(String string) throws MalformedURLException, UnsupportedAudioFileException {
        return MultimediaContainerManager.getMultimediaContainer(new File(string));
    }

    public static void addMultimediaContainerEventListener(MultimediaContainerEventListener multimediaContainerEventListener) {
        ArrayList<MultimediaContainer> arrayList = MultimediaContainerManager.getContainerArray();
        int n = 0;
        while (n < arrayList.size()) {
            arrayList.get(n).addListener(multimediaContainerEventListener);
            ++n;
        }
    }

    public static void removeMultimediaContainerEventListener(MultimediaContainerEventListener multimediaContainerEventListener) {
        ArrayList<MultimediaContainer> arrayList = MultimediaContainerManager.getContainerArray();
        int n = 0;
        while (n < arrayList.size()) {
            arrayList.get(n).removeListener(multimediaContainerEventListener);
            ++n;
        }
    }

    public static String getSongNameFromURL(URL uRL) {
        if (uRL == null) {
            return "";
        }
        String string = Helpers.createStringFomURL(uRL);
        int n = string.lastIndexOf(47);
        int n2 = string.lastIndexOf(46);
        if (n2 == -1 || n2 < n) {
            n2 = string.length();
        }
        return string.substring(n + 1, n2);
    }

    public static Object[] getSongInfosFor(URL uRL) {
        try {
            MultimediaContainer multimediaContainer = MultimediaContainerManager.getMultimediaContainerSingleton(uRL);
            if (multimediaContainer != null) {
                return multimediaContainer.getSongInfosFor(uRL);
            }
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            Log.error("IGNORED", unsupportedAudioFileException);
        }
        return new Object[]{String.valueOf(MultimediaContainerManager.getSongNameFromURL(uRL)) + " UNSUPPORTED FILE", -1L};
    }
}

