/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.main.gui.tools;

import de.quippy.javamod.main.gui.tools.PlaylistDropListenerCallBack;
import de.quippy.javamod.main.playlist.PlayList;
import de.quippy.javamod.multimedia.MultimediaContainerManager;
import de.quippy.javamod.system.Log;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class PlaylistDropListener
extends DropTargetAdapter {
    private PlaylistDropListenerCallBack callBack;

    public PlaylistDropListener(PlaylistDropListenerCallBack playlistDropListenerCallBack) {
        this.callBack = playlistDropListenerCallBack;
    }

    private void fillWithPlayableFiles(ArrayList<URL> arrayList, File file) {
        String[] stringArray = file.list(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                File file2 = new File(String.valueOf(file.getAbsolutePath()) + File.separatorChar + string);
                if (file2.isDirectory()) {
                    return true;
                }
                try {
                    return MultimediaContainerManager.getMultimediaContainerSingleton(file2.toURI().toURL()) != null;
                }
                catch (Exception exception) {
                    return false;
                }
            }
        });
        int n = 0;
        while (n < stringArray.length) {
            File file2 = new File(String.valueOf(file.getAbsolutePath()) + File.separatorChar + stringArray[n]);
            if (file2.isDirectory()) {
                this.fillWithPlayableFiles(arrayList, file2);
            } else {
                try {
                    arrayList.add(file2.toURI().toURL());
                }
                catch (Exception exception) {}
            }
            ++n;
        }
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        try {
            try {
                URL uRL = null;
                Transferable transferable = dropTargetDropEvent.getTransferable();
                if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    dropTargetDropEvent.acceptDrop(3);
                    Object object = transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    if (object instanceof List) {
                        List list = (List)object;
                        ArrayList<URL> arrayList = new ArrayList<URL>(list.size());
                        int n = 0;
                        while (n < list.size()) {
                            String string = list.get(n).toString();
                            File file = new File(string);
                            if (file.isDirectory()) {
                                this.fillWithPlayableFiles(arrayList, file);
                            } else {
                                URL uRL2 = file.toURI().toURL();
                                if (list.size() == 1) {
                                    uRL = uRL2;
                                }
                                arrayList.add(uRL2);
                            }
                            ++n;
                        }
                        PlayList playList = PlayList.createNewListWithFiles(arrayList.toArray(new URL[arrayList.size()]), false, false);
                        this.callBack.playlistRecieved(dropTargetDropEvent, playList, uRL);
                    }
                }
            }
            catch (Exception exception) {
                Log.error("[MainForm::DropListener]", exception);
                dropTargetDropEvent.dropComplete(true);
            }
        }
        finally {
            dropTargetDropEvent.dropComplete(true);
        }
    }
}

