/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.main.gui.components;

import de.quippy.javamod.main.gui.components.MeterPanelBase;
import java.awt.Color;
import java.awt.Graphics;

public class VUMeterPanel
extends MeterPanelBase {
    private static final long serialVersionUID = -4587795218202329414L;
    private float currentLevel = 0.0f;
    private float currentMaxPeakLevel = 0.0f;
    private Color[] color;
    private Color[] colorLow;
    private float rampDownValue;
    private float maxPeakLevelRampDownValue;
    private float maxPeakLevelRampDownDelay;
    private int myAnzLines;

    public VUMeterPanel(int n) {
        super(n);
        this.startThread();
    }

    @Override
    protected synchronized void doThreadUpdate() {
        super.doThreadUpdate();
    }

    @Override
    protected void componentWasResized(int n, int n2, int n3, int n4) {
        this.rampDownValue = (float)this.getDesiredFPS() / 1000.0f;
        this.maxPeakLevelRampDownDelay = this.rampDownValue / 100.0f;
        this.maxPeakLevelRampDownValue = 0.0f;
        this.myAnzLines = n4 >> 1;
        this.color = new Color[this.myAnzLines];
        this.colorLow = new Color[this.myAnzLines];
        int n5 = 0;
        while (n5 < this.myAnzLines) {
            int n6 = n5 * 255 / this.myAnzLines;
            int n7 = 255 - n6;
            this.color[n5] = new Color(n6, n7, 0);
            this.colorLow[n5] = new Color(n6 >> 1, n7 >> 1, 0);
            ++n5;
        }
    }

    public void setVUMeter(float[] fArray) {
        if (fArray != null) {
            this.setVUMeter(fArray, fArray.length);
        }
    }

    public void setVUMeter(float[] fArray, int n) {
        float f = 0.0f;
        int n2 = 0;
        while (n2 < n) {
            float f2 = fArray[n2];
            if (f2 < 0.0f) {
                f2 *= -1.0f;
            }
            if (f2 > f) {
                f = f2;
            }
            ++n2;
        }
        if (f > this.currentLevel) {
            this.currentLevel = f;
        }
    }

    @Override
    protected void drawMeter(Graphics graphics, int n, int n2, int n3, int n4) {
        this.currentLevel -= this.rampDownValue;
        if (this.currentLevel < 0.0f) {
            this.currentLevel = 0.0f;
        }
        this.currentMaxPeakLevel -= this.maxPeakLevelRampDownValue;
        if (this.currentMaxPeakLevel < 0.0f) {
            this.currentMaxPeakLevel = 0.0f;
        } else {
            this.maxPeakLevelRampDownValue += this.maxPeakLevelRampDownDelay;
        }
        if (this.currentLevel > this.currentMaxPeakLevel) {
            this.currentMaxPeakLevel = this.currentLevel;
            this.maxPeakLevelRampDownValue = this.maxPeakLevelRampDownDelay;
        }
        if (graphics == null) {
            return;
        }
        int n5 = (int)((float)this.myAnzLines * this.currentLevel) - 1;
        int n6 = (int)((float)this.myAnzLines * this.currentMaxPeakLevel) - 1;
        int n7 = 0;
        while (n7 < this.myAnzLines) {
            graphics.setColor(n7 >= n5 && n7 != n6 ? this.colorLow[n7] : this.color[n7]);
            int n8 = n4 - (n7 << 1);
            graphics.drawLine(n2, n + n8, n2 + n3, n + n8);
            ++n7;
        }
    }
}

