/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.main.gui;

import de.quippy.javamod.io.GaplessSoundOutputStreamImpl;
import de.quippy.javamod.io.SoundOutputStream;
import de.quippy.javamod.main.gui.EffectsPanel;
import de.quippy.javamod.main.gui.JavaModAbout;
import de.quippy.javamod.main.gui.PlayThread;
import de.quippy.javamod.main.gui.PlayThreadEventListener;
import de.quippy.javamod.main.gui.PlayerConfigPanel;
import de.quippy.javamod.main.gui.SimpleTextViewerDialog;
import de.quippy.javamod.main.gui.UrlDialog;
import de.quippy.javamod.main.gui.components.LEDScrollPanel;
import de.quippy.javamod.main.gui.components.RoundSlider;
import de.quippy.javamod.main.gui.components.SAMeterPanel;
import de.quippy.javamod.main.gui.components.SeekBarPanel;
import de.quippy.javamod.main.gui.components.SeekBarPanelListener;
import de.quippy.javamod.main.gui.components.VUMeterPanel;
import de.quippy.javamod.main.gui.playlist.PlayListGUI;
import de.quippy.javamod.main.gui.playlist.PlaylistGUIChangeListener;
import de.quippy.javamod.main.gui.tools.FileChooserFilter;
import de.quippy.javamod.main.gui.tools.FileChooserResult;
import de.quippy.javamod.main.gui.tools.PlaylistDropListener;
import de.quippy.javamod.main.gui.tools.PlaylistDropListenerCallBack;
import de.quippy.javamod.main.playlist.PlayList;
import de.quippy.javamod.main.playlist.PlayListEntry;
import de.quippy.javamod.mixer.Mixer;
import de.quippy.javamod.mixer.dsp.AudioProcessor;
import de.quippy.javamod.mixer.dsp.DspProcessorCallBack;
import de.quippy.javamod.mixer.dsp.iir.GraphicEQ;
import de.quippy.javamod.mixer.dsp.iir.GraphicEqGUI;
import de.quippy.javamod.mixer.dsp.pitchshift.PitchShift;
import de.quippy.javamod.mixer.dsp.pitchshift.PitchShiftGUI;
import de.quippy.javamod.multimedia.MultimediaContainer;
import de.quippy.javamod.multimedia.MultimediaContainerEvent;
import de.quippy.javamod.multimedia.MultimediaContainerEventListener;
import de.quippy.javamod.multimedia.MultimediaContainerManager;
import de.quippy.javamod.system.Helpers;
import de.quippy.javamod.system.Log;
import de.quippy.javamod.system.LogMessageCallBack;
import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import javax.sound.sampled.AudioFileFormat;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;

public class MainForm
extends JFrame
implements LogMessageCallBack,
DspProcessorCallBack,
PlayThreadEventListener,
MultimediaContainerEventListener,
PlaylistGUIChangeListener,
PlaylistDropListenerCallBack {
    private static final long serialVersionUID = -2737074464335059959L;
    private static final String DEFAULTICONPATH = "/de/quippy/javamod/main/gui/ressources/quippy_the_kangaroo_icon.gif";
    public static final String BUTTONPLAY_INACTIVE = "/de/quippy/javamod/main/gui/ressources/play.gif";
    public static final String BUTTONPLAY_ACTIVE = "/de/quippy/javamod/main/gui/ressources/play_aktiv.gif";
    public static final String BUTTONPLAY_NORMAL = "/de/quippy/javamod/main/gui/ressources/play_normal.gif";
    public static final String BUTTONPAUSE_INACTIVE = "/de/quippy/javamod/main/gui/ressources/pause.gif";
    public static final String BUTTONPAUSE_ACTIVE = "/de/quippy/javamod/main/gui/ressources/pause_aktiv.gif";
    public static final String BUTTONPAUSE_NORMAL = "/de/quippy/javamod/main/gui/ressources/pause_normal.gif";
    public static final String BUTTONSTOP_INACTIVE = "/de/quippy/javamod/main/gui/ressources/stop.gif";
    public static final String BUTTONSTOP_ACTIVE = "/de/quippy/javamod/main/gui/ressources/stop_aktiv.gif";
    public static final String BUTTONSTOP_NORMAL = "/de/quippy/javamod/main/gui/ressources/stop_normal.gif";
    public static final String BUTTONPREV_INACTIVE = "/de/quippy/javamod/main/gui/ressources/prev.gif";
    public static final String BUTTONPREV_ACTIVE = "/de/quippy/javamod/main/gui/ressources/prev_aktiv.gif";
    public static final String BUTTONPREV_NORMAL = "/de/quippy/javamod/main/gui/ressources/prev_normal.gif";
    public static final String BUTTONNEXT_INACTIVE = "/de/quippy/javamod/main/gui/ressources/next.gif";
    public static final String BUTTONNEXT_ACTIVE = "/de/quippy/javamod/main/gui/ressources/next_aktiv.gif";
    public static final String BUTTONNEXT_NORMAL = "/de/quippy/javamod/main/gui/ressources/next_normal.gif";
    private static final String PROPERTYFILENAME = ".javamod.properties";
    private static final String PROPERTY_SEARCHPATH = "javamod.path.loadpath";
    private static final String PROPERTY_EXPORTPATH = "javamod.path.exportpath";
    private static final String PROPERTY_LOOKANDFEEL = "javamod.lookandfeel.classname";
    private static final String PROPERTY_LASTLOADED = "javamod.path.lastloaded";
    private static final String PROPERTY_SYSTEMTRAY = "javamod.systemtray";
    private static final String PROPERTY_MAINDIALOG_POS = "javamod.dialog.position.main";
    private static final String PROPERTY_SETUPDIALOG_POS = "javamod.dialog.position.setup";
    private static final String PROPERTY_PROPERTIESDIALOG_POS = "javamod.dialog.position.properties";
    private static final String PROPERTY_PLAYLISTDIALOG_POS = "javamod.dialog.position.playlist";
    private static final String PROPERTY_EFFECTDIALOG_POS = "javamod.dialog.position.equalizer";
    private static final String PROPERTY_MAINDIALOG_SIZE = "javamod.dialog.size.main";
    private static final String PROPERTY_SETUPDIALOG_SIZE = "javamod.dialog.size.setup";
    private static final String PROPERTY_PROPERTIESDIALOG_SIZE = "javamod.dialog.size.properties";
    private static final String PROPERTY_PLAYLISTDIALOG_SIZE = "javamod.dialog.size.playlist";
    private static final String PROPERTY_EFFECTDIALOG_SIZE = "javamod.dialog.size.equalizer";
    private static final String PROPERTY_VOLUME_VALUE = "javamod.dialog.volume.value";
    private static final String PROPERTY_BALANCE_VALUE = "javamod.dialog.balance.value";
    private static final String PROPERTY_SETUPDIALOG_VISABLE = "javamod.dialog.open.setup";
    private static final String PROPERTY_PROPERTIESDIALOG_VISABLE = "javamod.dialog.open.properties";
    private static final String PROPERTY_PLAYLIST_VISABLE = "javamod.dialog.open.playlist";
    private static final String PROPERTY_EFFECT_VISABLE = "javamod.dialog.open.equalizer";
    private static final String PROPERTY_EFFECTS_PASSTHROUGH = "javamod.player.effects.passthrough";
    private static final String PROPERTY_EQUALIZER_PREAMP = "javamod.player.equalizer.preamp";
    private static final String PROPERTY_EQUALIZER_BAND_PREFIX = "javamod.player.equalizer.band.";
    private static final String PROPERTY_EQUALIZER_ISACTIVE = "javamod.player.equalizer.isactive";
    private static final String PROPERTY_PITCHSHIFT_ISACTIVE = "javamod.player.pitchshift.isactive";
    private static final String PROPERTY_PITCHSHIFT_PITCH = "javamod.player.pitchshift.pitch";
    private static final String PROPERTY_PITCHSHIFT_SAMPLESCALE = "javamod.player.pitchshift.scale";
    private static final String PROPERTY_PITCHSHIFT_FRAMESIZE = "javamod.player.pitchshift.framesize";
    private static final String PROPERTY_PITCHSHIFT_OVERSAMPLING = "javamod.player.pitchshift.oversampling";
    private static final int PROPERTY_LASTLOADED_MAXENTRIES = 10;
    private static final String WINDOW_TITLE = "Java Mod Player V2.0";
    private static final String WINDOW_NAME = "JavaMod";
    private static FileFilter[] fileFilterExport;
    private static FileFilter[] fileFilterLoad;
    private ImageIcon buttonPlay_Active = null;
    private ImageIcon buttonPlay_Inactive = null;
    private ImageIcon buttonPlay_normal = null;
    private ImageIcon buttonPause_Active = null;
    private ImageIcon buttonPause_Inactive = null;
    private ImageIcon buttonPause_normal = null;
    private ImageIcon buttonStop_Active = null;
    private ImageIcon buttonStop_Inactive = null;
    private ImageIcon buttonStop_normal = null;
    private ImageIcon buttonPrev_Active = null;
    private ImageIcon buttonPrev_Inactive = null;
    private ImageIcon buttonPrev_normal = null;
    private ImageIcon buttonNext_Active = null;
    private ImageIcon buttonNext_Inactive = null;
    private ImageIcon buttonNext_normal = null;
    private JButton button_Play = null;
    private JButton button_Pause = null;
    private JButton button_Stop = null;
    private JButton button_Prev = null;
    private JButton button_Next = null;
    private RoundSlider volumeSlider = null;
    private JLabel volumeLabel = null;
    private RoundSlider balanceSlider = null;
    private JLabel balanceLabel = null;
    private JPanel baseContentPane = null;
    private JPanel mainContentPane = null;
    private JPanel musicDataPane = null;
    private JPanel playerControlPane = null;
    private JPanel playerDataPane = null;
    private JDialog modInfoDialog = null;
    private JDialog playerSetUpDialog = null;
    private JDialog playlistDialog = null;
    private JDialog equalizerDialog = null;
    private PlayerConfigPanel playerConfigPanel = null;
    private JPanel modInfoPane = null;
    private JPanel playerSetUpPane = null;
    private JPanel playlistPane = null;
    private JPanel effectPane = null;
    private Point mainDialogLocation = null;
    private Dimension mainDialogSize = null;
    private Point modInfoDialogLocation = null;
    private Dimension modInfoDialogSize = null;
    private boolean modInfoDialogVisable = false;
    private Point playerSetUpDialogLocation = null;
    private Dimension playerSetUpDialogSize = null;
    private boolean playerSetUpDialogVisable = false;
    private Point playlistDialogLocation = null;
    private Dimension playlistDialogSize = null;
    private boolean playlistDialogVisable = false;
    private Point effectsDialogLocation = null;
    private Dimension effectsDialogSize = null;
    private boolean effectDialogVisable = false;
    private JDialog downloadDialog = null;
    private JPanel downloadPane = null;
    private JProgressBar downloadProgressBar = null;
    private VUMeterPanel vuLMeterPanel = null;
    private VUMeterPanel vuRMeterPanel = null;
    private SAMeterPanel saLMeterPanel = null;
    private SAMeterPanel saRMeterPanel = null;
    private LEDScrollPanel ledScrollPanel = null;
    private SeekBarPanel seekBarPanel = null;
    private JTextField messages = null;
    private JMenuBar baseMenuBar = null;
    private JMenu menu_File = null;
    private JMenu menu_View = null;
    private JMenu menu_LookAndFeel = null;
    private JMenu menu_Help = null;
    private JMenu menu_File_RecentFiles = null;
    private JMenuItem menu_File_openMod = null;
    private JMenuItem menu_File_openURL = null;
    private JMenuItem menu_File_exportWave = null;
    private JMenuItem menu_File_Close = null;
    private JMenuItem menu_View_Info = null;
    private JMenuItem menu_View_Setup = null;
    private JMenuItem menu_View_Playlist = null;
    private JMenuItem menu_View_GraphicEQ = null;
    private JCheckBoxMenuItem menu_View_UseSystemTray = null;
    private JMenuItem menu_Help_CheckUpdate = null;
    private JMenuItem menu_Help_ShowVersionHistory = null;
    private JMenuItem menu_Help_About = null;
    private JCheckBoxMenuItem[] menu_LookAndFeel_Items = null;
    private MenuItem aboutItem = null;
    private MenuItem playItem = null;
    private MenuItem pauseItem = null;
    private MenuItem stopItem = null;
    private MenuItem prevItem = null;
    private MenuItem nextItem = null;
    private MenuItem closeItem = null;
    private TrayIcon javaModTrayIcon = null;
    private JavaModAbout about = null;
    private UrlDialog urlDialog = null;
    private SimpleTextViewerDialog simpleTextViewerDialog = null;
    private PlayListGUI playlistGUI = null;
    private EffectsPanel effectGUI = null;
    private GraphicEqGUI equalizerGUI = null;
    private PitchShiftGUI pitchShiftGUI = null;
    private MultimediaContainer currentContainer;
    private PlayThread playerThread;
    private PlayList currentPlayList = null;
    private GraphicEQ currentEqualizer;
    private PitchShift currentPitchShift;
    private ArrayList<DropTarget> dropTargetList;
    private AudioProcessor audioProcessor;
    private transient SoundOutputStream soundOutputStream;
    private String propertyFilePath;
    private String searchPath;
    private String exportPath;
    private String uiClassName;
    private boolean useSystemTray = false;
    private float currentVolume;
    private float currentBalance;
    private ArrayList<URL> lastLoaded;
    private boolean inExportMode;
    private final transient MakeMainWindowVisible makeMainWindowVisiable = new MakeMainWindowVisible();

    public MainForm() throws HeadlessException {
        this.propertyFilePath = Helpers.HOMEDIR;
        this.currentEqualizer = new GraphicEQ();
        this.currentPitchShift = new PitchShift();
        this.audioProcessor = new AudioProcessor(2048, 70);
        this.audioProcessor.addListener(this);
        this.audioProcessor.addEffectListener(this.currentEqualizer);
        this.audioProcessor.addEffectListener(this.currentPitchShift);
        this.inExportMode = false;
        this.initialize();
    }

    private void readPropertyFile() {
        Properties properties = new Properties();
        try {
            File file = new File(String.valueOf(this.propertyFilePath) + File.separator + PROPERTYFILENAME);
            if (file.exists()) {
                FileInputStream fileInputStream = null;
                try {
                    fileInputStream = new FileInputStream(file);
                    properties.load(fileInputStream);
                }
                finally {
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (IOException iOException) {
                            Log.error("IGNORED", iOException);
                        }
                    }
                }
            }
            this.searchPath = properties.getProperty(PROPERTY_SEARCHPATH, System.getProperty("user.home"));
            this.exportPath = properties.getProperty(PROPERTY_EXPORTPATH, System.getProperty("user.home"));
            this.uiClassName = properties.getProperty(PROPERTY_LOOKANDFEEL, UIManager.getSystemLookAndFeelClassName());
            this.useSystemTray = Boolean.parseBoolean(properties.getProperty(PROPERTY_SYSTEMTRAY, "FALSE"));
            this.currentVolume = Float.parseFloat(properties.getProperty(PROPERTY_VOLUME_VALUE, "1.0"));
            this.currentBalance = Float.parseFloat(properties.getProperty(PROPERTY_BALANCE_VALUE, "0.0"));
            this.lastLoaded = new ArrayList(10);
            boolean bl = false;
            while (bl < 10 != 0) {
                String string = properties.getProperty("javamod.path.lastloaded." + (int)(bl ? 1 : 0), null);
                if (string != null) {
                    this.lastLoaded.add(new URL(string));
                } else {
                    this.lastLoaded.add(null);
                }
                bl += 1;
            }
            this.setDSPEnabled(Boolean.parseBoolean(properties.getProperty(PROPERTY_EFFECTS_PASSTHROUGH, "FALSE")));
            this.mainDialogLocation = Helpers.getPointFromString(properties.getProperty(PROPERTY_MAINDIALOG_POS, "-1x-1"));
            this.mainDialogSize = Helpers.getDimensionFromString(properties.getProperty(PROPERTY_MAINDIALOG_SIZE, "320x410"));
            this.playerSetUpDialogLocation = Helpers.getPointFromString(properties.getProperty(PROPERTY_SETUPDIALOG_POS, "-1x-1"));
            this.playerSetUpDialogSize = Helpers.getDimensionFromString(properties.getProperty(PROPERTY_SETUPDIALOG_SIZE, "720x230"));
            this.playerSetUpDialogVisable = Boolean.parseBoolean(properties.getProperty(PROPERTY_SETUPDIALOG_VISABLE, "false"));
            this.modInfoDialogLocation = Helpers.getPointFromString(properties.getProperty(PROPERTY_PROPERTIESDIALOG_POS, "-1x-1"));
            this.modInfoDialogSize = Helpers.getDimensionFromString(properties.getProperty(PROPERTY_PROPERTIESDIALOG_SIZE, "520x630"));
            this.modInfoDialogVisable = Boolean.parseBoolean(properties.getProperty(PROPERTY_PROPERTIESDIALOG_VISABLE, "false"));
            this.playlistDialogLocation = Helpers.getPointFromString(properties.getProperty(PROPERTY_PLAYLISTDIALOG_POS, "-1x-1"));
            this.playlistDialogSize = Helpers.getDimensionFromString(properties.getProperty(PROPERTY_PLAYLISTDIALOG_SIZE, "400x400"));
            this.playlistDialogVisable = Boolean.parseBoolean(properties.getProperty(PROPERTY_PLAYLIST_VISABLE, "false"));
            this.effectsDialogLocation = Helpers.getPointFromString(properties.getProperty(PROPERTY_EFFECTDIALOG_POS, "-1x-1"));
            this.effectsDialogSize = Helpers.getDimensionFromString(properties.getProperty(PROPERTY_EFFECTDIALOG_SIZE, "560x470"));
            this.effectDialogVisable = Boolean.parseBoolean(properties.getProperty(PROPERTY_EFFECT_VISABLE, "false"));
            if (this.currentEqualizer != null) {
                bl = Boolean.parseBoolean(properties.getProperty(PROPERTY_EQUALIZER_ISACTIVE, "FALSE"));
                this.currentEqualizer.setIsActive(bl);
                float f = Float.parseFloat(properties.getProperty(PROPERTY_EQUALIZER_PREAMP, "0.0"));
                this.currentEqualizer.setPreAmp(f);
                int n = 0;
                while (n < this.currentEqualizer.getBandCount()) {
                    float f2 = Float.parseFloat(properties.getProperty(PROPERTY_EQUALIZER_BAND_PREFIX + Integer.toString(n), "0.0"));
                    this.currentEqualizer.setBand(n, f2);
                    ++n;
                }
            }
            if (this.currentPitchShift != null) {
                bl = Boolean.parseBoolean(properties.getProperty(PROPERTY_PITCHSHIFT_ISACTIVE, "FALSE"));
                this.currentPitchShift.setIsActive(bl);
                float f = Float.parseFloat(properties.getProperty(PROPERTY_PITCHSHIFT_PITCH, "1.0"));
                this.currentPitchShift.setPitchScale(f);
                float f3 = Float.parseFloat(properties.getProperty(PROPERTY_PITCHSHIFT_SAMPLESCALE, "1.0"));
                this.currentPitchShift.setSampleScale(f3);
                int n = Integer.parseInt(properties.getProperty(PROPERTY_PITCHSHIFT_OVERSAMPLING, "32"));
                this.currentPitchShift.setFFTOversampling(n);
                int n2 = Integer.parseInt(properties.getProperty(PROPERTY_PITCHSHIFT_FRAMESIZE, "8192"));
                this.currentPitchShift.setFFTFrameSize(n2);
            }
            MultimediaContainerManager.configureContainer(properties);
        }
        catch (Throwable throwable) {
            Log.error("[MainForm]", throwable);
        }
    }

    private void writePropertyFile() {
        try {
            File file;
            Object object;
            Properties properties = new Properties();
            MultimediaContainerManager.getContainerConfigs(properties);
            properties.setProperty(PROPERTY_SEARCHPATH, this.searchPath);
            properties.setProperty(PROPERTY_EXPORTPATH, this.exportPath);
            properties.setProperty(PROPERTY_LOOKANDFEEL, this.uiClassName);
            properties.setProperty(PROPERTY_SYSTEMTRAY, Boolean.toString(this.useSystemTray));
            properties.setProperty(PROPERTY_VOLUME_VALUE, Float.toString(this.currentVolume));
            properties.setProperty(PROPERTY_BALANCE_VALUE, Float.toString(this.currentBalance));
            int n = 0;
            while (n < 10) {
                object = this.lastLoaded.get(n);
                if (object != null) {
                    properties.setProperty("javamod.path.lastloaded." + n, ((URL)object).toString());
                }
                ++n;
            }
            properties.setProperty(PROPERTY_EFFECTS_PASSTHROUGH, Boolean.toString(this.isDSPEnabled()));
            properties.setProperty(PROPERTY_MAINDIALOG_POS, Helpers.getStringFromPoint(this.getLocation()));
            properties.setProperty(PROPERTY_MAINDIALOG_SIZE, Helpers.getStringFromDimension(this.getSize()));
            properties.setProperty(PROPERTY_SETUPDIALOG_POS, Helpers.getStringFromPoint(this.getPlayerSetUpDialog().getLocation()));
            properties.setProperty(PROPERTY_SETUPDIALOG_SIZE, Helpers.getStringFromDimension(this.getPlayerSetUpDialog().getSize()));
            properties.setProperty(PROPERTY_SETUPDIALOG_VISABLE, Boolean.toString(this.getPlayerSetUpDialog().isVisible()));
            properties.setProperty(PROPERTY_PROPERTIESDIALOG_POS, Helpers.getStringFromPoint(this.getModInfoDialog().getLocation()));
            properties.setProperty(PROPERTY_PROPERTIESDIALOG_SIZE, Helpers.getStringFromDimension(this.getModInfoDialog().getSize()));
            properties.setProperty(PROPERTY_PROPERTIESDIALOG_VISABLE, Boolean.toString(this.getModInfoDialog().isVisible()));
            properties.setProperty(PROPERTY_PLAYLISTDIALOG_POS, Helpers.getStringFromPoint(this.getPlaylistDialog().getLocation()));
            properties.setProperty(PROPERTY_PLAYLISTDIALOG_SIZE, Helpers.getStringFromDimension(this.getPlaylistDialog().getSize()));
            properties.setProperty(PROPERTY_PLAYLIST_VISABLE, Boolean.toString(this.getPlaylistDialog().isVisible()));
            properties.setProperty(PROPERTY_EFFECTDIALOG_POS, Helpers.getStringFromPoint(this.getEffectDialog().getLocation()));
            properties.setProperty(PROPERTY_EFFECTDIALOG_SIZE, Helpers.getStringFromDimension(this.getEffectDialog().getSize()));
            properties.setProperty(PROPERTY_EFFECT_VISABLE, Boolean.toString(this.getEffectDialog().isVisible()));
            if (this.currentEqualizer != null) {
                properties.setProperty(PROPERTY_EQUALIZER_ISACTIVE, Boolean.toString(this.currentEqualizer.isActive()));
                properties.setProperty(PROPERTY_EQUALIZER_PREAMP, Float.toString(this.currentEqualizer.getPreAmpDB()));
                n = 0;
                while (n < this.currentEqualizer.getBandCount()) {
                    properties.setProperty(PROPERTY_EQUALIZER_BAND_PREFIX + Integer.toString(n), Float.toString(this.currentEqualizer.getBand(n)));
                    ++n;
                }
            }
            if (this.currentPitchShift != null) {
                properties.setProperty(PROPERTY_PITCHSHIFT_ISACTIVE, Boolean.toString(this.currentPitchShift.isActive()));
                properties.setProperty(PROPERTY_PITCHSHIFT_PITCH, Float.toString(this.currentPitchShift.getPitchScale()));
                properties.setProperty(PROPERTY_PITCHSHIFT_SAMPLESCALE, Float.toString(this.currentPitchShift.getSampleScale()));
                properties.setProperty(PROPERTY_PITCHSHIFT_FRAMESIZE, Integer.toString(this.currentPitchShift.getFftFrameSize()));
                properties.setProperty(PROPERTY_PITCHSHIFT_OVERSAMPLING, Integer.toString(this.currentPitchShift.getFFTOversampling()));
            }
            if ((file = new File(String.valueOf(this.propertyFilePath) + File.separator + PROPERTYFILENAME)).exists()) {
                boolean bl = file.delete();
                if (bl) {
                    bl = file.createNewFile();
                }
                if (!bl) {
                    Log.error("Could not create property file: " + file.getCanonicalPath());
                }
            }
            object = null;
            try {
                object = new FileOutputStream(file);
                properties.store((OutputStream)object, WINDOW_TITLE);
            }
            finally {
                if (object != null) {
                    try {
                        ((FileOutputStream)object).close();
                    }
                    catch (IOException iOException) {
                        Log.error("IGNORED", iOException);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            Log.error("MainForm]", throwable);
        }
    }

    private UIManager.LookAndFeelInfo[] getInstalledLookAndFeels() {
        return UIManager.getInstalledLookAndFeels();
    }

    private void createFileFilter() {
        HashMap<String, String[]> hashMap = MultimediaContainerManager.getSupportedFileExtensionsPerContainer();
        ArrayList<FileChooserFilter> arrayList = new ArrayList<FileChooserFilter>(hashMap.size() + 1);
        String[] stringArray = MultimediaContainerManager.getSupportedFileExtensions();
        String[] stringArray2 = new String[stringArray.length + PlayList.SUPPORTEDPLAYLISTS.length];
        System.arraycopy(PlayList.SUPPORTEDPLAYLISTS, 0, stringArray2, 0, PlayList.SUPPORTEDPLAYLISTS.length);
        System.arraycopy(stringArray, 0, stringArray2, PlayList.SUPPORTEDPLAYLISTS.length, stringArray.length);
        arrayList.add(new FileChooserFilter(stringArray2, "All playable files"));
        Set<String> set = hashMap.keySet();
        for (String string : set) {
            String[] stringArray3 = hashMap.get(string);
            StringBuilder stringBuilder = new StringBuilder(string);
            stringBuilder.append(" (");
            int n = stringArray3.length - 1;
            int n2 = 0;
            while (n2 <= n) {
                stringBuilder.append("*.").append(stringArray3[n2]);
                if (n2 < n) {
                    stringBuilder.append(", ");
                }
                ++n2;
            }
            stringBuilder.append(')');
            arrayList.add(new FileChooserFilter(stringArray3, stringBuilder.toString()));
        }
        arrayList.add(PlayList.PLAYLIST_FILE_FILTER);
        fileFilterLoad = new FileFilter[arrayList.size()];
        arrayList.toArray(fileFilterLoad);
        fileFilterExport = new FileFilter[1];
        MainForm.fileFilterExport[0] = new FileChooserFilter(AudioFileFormat.Type.WAVE.getExtension(), AudioFileFormat.Type.WAVE.toString());
    }

    private void initialize() {
        Log.addLogListener(this);
        this.readPropertyFile();
        this.setSystemTray();
        this.setName(WINDOW_NAME);
        this.setTitle(WINDOW_TITLE);
        this.getTrayIcon().setToolTip(WINDOW_TITLE);
        URL uRL = MainForm.class.getResource(DEFAULTICONPATH);
        if (uRL != null) {
            this.setIconImage(Toolkit.getDefaultToolkit().getImage(uRL));
        }
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                MainForm.this.doClose();
            }

            @Override
            public void windowIconified(WindowEvent windowEvent) {
                if (MainForm.this.useSystemTray) {
                    MainForm.this.setVisible(false);
                }
            }

            @Override
            public void windowDeiconified(WindowEvent windowEvent) {
                if (MainForm.this.useSystemTray) {
                    MainForm.this.setVisible(true);
                }
            }
        });
        this.setSize(this.mainDialogSize);
        this.setPreferredSize(this.mainDialogSize);
        this.updateLookAndFeel(this.uiClassName);
        this.setJMenuBar(this.getBaseMenuBar());
        this.setContentPane(this.getBaseContentPane());
        this.setPlayListIcons();
        this.addMouseWheelListener(new MouseWheelVolumeControl());
        this.pack();
        if (this.mainDialogLocation == null || this.mainDialogLocation.getX() == -1.0 || this.mainDialogLocation.getY() == -1.0) {
            this.mainDialogLocation = Helpers.getFrameCenteredLocation(this, null);
        }
        this.setLocation(this.mainDialogLocation);
        this.getModInfoDialog().setVisible(this.modInfoDialogVisable);
        this.getPlaylistDialog().setVisible(this.playlistDialogVisable);
        this.getEffectDialog().setVisible(this.effectDialogVisable);
        this.getPlayerSetUpDialog().setVisible(this.playerSetUpDialogVisable);
        this.dropTargetList = new ArrayList();
        PlaylistDropListener playlistDropListener = new PlaylistDropListener(this);
        Helpers.registerDropListener(this.dropTargetList, this, playlistDropListener);
        MultimediaContainerManager.addMultimediaContainerEventListener(this);
        this.createFileFilter();
        this.currentContainer = null;
        this.showMessage("Ready...");
    }

    @Override
    public void playlistRecieved(DropTargetDropEvent dropTargetDropEvent, PlayList playList, URL uRL) {
        if (uRL != null) {
            this.addFileToLastLoaded(uRL);
        }
        if (playList != null) {
            this.doStopPlaying();
            this.currentPlayList = playList;
            this.getPlaylistGUI().setNewPlaylist(this.currentPlayList);
            boolean bl = this.doNextPlayListEntry();
            if (this.playerThread == null && bl) {
                this.doStartPlaying();
            }
        }
    }

    @Override
    public void playListChanged(PlayList playList) {
        if (playList != null) {
            if (playList != this.currentPlayList) {
                boolean bl = this.currentPlayList == null;
                this.currentPlayList = playList;
                if (bl) {
                    this.doNextPlayListEntry();
                }
            }
            this.setPlayListIcons();
        }
    }

    private void setLookAndFeel(String string) {
        try {
            UIManager.setLookAndFeel(string);
        }
        catch (Throwable throwable) {
            this.showMessage("The selected Look&Feel is not supported or not reachable through the classpath. Switching to system default...");
            try {
                string = UIManager.getSystemLookAndFeelClassName();
                UIManager.setLookAndFeel(string);
            }
            catch (Throwable throwable2) {
                Log.error("[MainForm]", throwable2);
            }
        }
    }

    private void updateLookAndFeel(String string) {
        this.setLookAndFeel(string);
        MultimediaContainerManager.updateLookAndFeel();
        SwingUtilities.updateComponentTreeUI(this);
        this.pack();
        SwingUtilities.updateComponentTreeUI(this.getJavaModAbout());
        this.getJavaModAbout().pack();
        SwingUtilities.updateComponentTreeUI(this.getModInfoDialog());
        this.getModInfoDialog().pack();
        SwingUtilities.updateComponentTreeUI(this.getPlayerSetUpDialog());
        this.getPlayerSetUpDialog().pack();
        SwingUtilities.updateComponentTreeUI(this.getURLDialog());
        this.getURLDialog().pack();
        SwingUtilities.updateComponentTreeUI(this.getShowVersion_Text());
        this.getShowVersion_Text().pack();
        SwingUtilities.updateComponentTreeUI(this.getPlaylistDialog());
        this.getPlaylistDialog().pack();
        SwingUtilities.updateComponentTreeUI(this.getEffectDialog());
        this.getEffectDialog().pack();
    }

    private void changeInfoPane() {
        this.getModInfoPane().removeAll();
        this.getModInfoPane().add((Component)this.getCurrentContainer().getInfoPanel(), "Center");
        this.getModInfoDialog().pack();
        this.getModInfoDialog().repaint();
    }

    private void changeConfigPane() {
        this.getPlayerConfigPanel().selectTabForContainer(this.getCurrentContainer());
    }

    private void changeExportMenu() {
        this.getMenu_File_exportWave().setEnabled(this.getCurrentContainer().canExport());
    }

    public boolean isDSPEnabled() {
        if (this.audioProcessor != null) {
            return this.audioProcessor.isDspEnabled();
        }
        return false;
    }

    public void setDSPEnabled(boolean bl) {
        if (this.audioProcessor != null) {
            this.audioProcessor.setDspEnabled(bl);
        }
    }

    public JMenuBar getBaseMenuBar() {
        if (this.baseMenuBar == null) {
            this.baseMenuBar = new JMenuBar();
            this.baseMenuBar.setName("baseMenuBar");
            this.baseMenuBar.add(this.getMenu_File());
            this.baseMenuBar.add(this.getMenu_View());
            this.baseMenuBar.add(this.getMenu_LookAndFeel());
            this.baseMenuBar.add(this.getMenu_Help());
        }
        return this.baseMenuBar;
    }

    public JMenu getMenu_File() {
        if (this.menu_File == null) {
            this.menu_File = new JMenu();
            this.menu_File.setName("menu_File");
            this.menu_File.setMnemonic('f');
            this.menu_File.setText("File");
            this.menu_File.setFont(Helpers.DIALOG_FONT);
            this.menu_File.add(this.getMenu_File_openMod());
            this.menu_File.add(this.getMenu_File_openURL());
            this.menu_File.add(this.getMenu_File_exportWave());
            this.menu_File.add(new JSeparator());
            this.menu_File.add(this.getMenu_File_RecentFiles());
            this.menu_File.add(new JSeparator());
            this.menu_File.add(this.getMenu_File_Close());
        }
        return this.menu_File;
    }

    public JMenu getMenu_View() {
        if (this.menu_View == null) {
            this.menu_View = new JMenu();
            this.menu_View.setName("menu_View");
            this.menu_View.setMnemonic('v');
            this.menu_View.setText("View");
            this.menu_View.setFont(Helpers.DIALOG_FONT);
            this.menu_View.add(this.getMenu_View_Info());
            this.menu_View.add(this.getMenu_View_Setup());
            this.menu_View.add(this.getMenu_View_Playlist());
            this.menu_View.add(this.getMenu_View_GraphicEQ());
            this.menu_View.add(new JSeparator());
            this.menu_View.add(this.getMenu_View_UseSystemTray());
        }
        return this.menu_View;
    }

    public JMenu getMenu_LookAndFeel() {
        if (this.menu_LookAndFeel == null) {
            this.menu_LookAndFeel = new JMenu();
            this.menu_LookAndFeel.setName("menu_LookAndFeel");
            this.menu_LookAndFeel.setMnemonic('l');
            this.menu_LookAndFeel.setText("Look&Feel");
            this.menu_LookAndFeel.setFont(Helpers.DIALOG_FONT);
            String string = UIManager.getLookAndFeel().getClass().getName();
            UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = this.getInstalledLookAndFeels();
            this.menu_LookAndFeel_Items = new JCheckBoxMenuItem[lookAndFeelInfoArray.length];
            int n = 0;
            while (n < lookAndFeelInfoArray.length) {
                this.menu_LookAndFeel_Items[n] = new JCheckBoxMenuItem();
                this.menu_LookAndFeel_Items[n].setName("newMenuItem_" + n);
                this.menu_LookAndFeel_Items[n].setText(lookAndFeelInfoArray[n].getName());
                this.menu_LookAndFeel_Items[n].setFont(Helpers.DIALOG_FONT);
                this.menu_LookAndFeel_Items[n].setToolTipText("Change to " + lookAndFeelInfoArray[n].getName() + " look and feel");
                String string2 = lookAndFeelInfoArray[n].getClassName();
                if (string2.equals(string)) {
                    this.menu_LookAndFeel_Items[n].setSelected(true);
                }
                this.menu_LookAndFeel_Items[n].addActionListener(new LookAndFeelChanger(this.menu_LookAndFeel_Items[n], string2));
                this.menu_LookAndFeel.add(this.menu_LookAndFeel_Items[n]);
                ++n;
            }
        }
        return this.menu_LookAndFeel;
    }

    private JMenu getMenu_Help() {
        if (this.menu_Help == null) {
            this.menu_Help = new JMenu();
            this.menu_Help.setName("menu_Help");
            this.menu_Help.setMnemonic('h');
            this.menu_Help.setText("Help");
            this.menu_Help.setFont(Helpers.DIALOG_FONT);
            this.menu_Help.add(this.getMenu_Help_CheckUpdate());
            this.menu_Help.add(this.getMenu_Help_ShowVersionHistory());
            this.menu_Help.add(new JSeparator());
            this.menu_Help.add(this.getMenu_Help_About());
        }
        return this.menu_Help;
    }

    private JMenuItem getMenu_File_openMod() {
        if (this.menu_File_openMod == null) {
            this.menu_File_openMod = new JMenuItem();
            this.menu_File_openMod.setName("menu_File_openMod");
            this.menu_File_openMod.setMnemonic('o');
            this.menu_File_openMod.setText("Open Sound File...");
            this.menu_File_openMod.setFont(Helpers.DIALOG_FONT);
            this.menu_File_openMod.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainForm.this.doOpenFile();
                }
            });
        }
        return this.menu_File_openMod;
    }

    private JMenuItem getMenu_File_openURL() {
        if (this.menu_File_openURL == null) {
            this.menu_File_openURL = new JMenuItem();
            this.menu_File_openURL.setName("menu_File_openURL");
            this.menu_File_openURL.setMnemonic('u');
            this.menu_File_openURL.setText("Open an URL...");
            this.menu_File_openURL.setFont(Helpers.DIALOG_FONT);
            this.menu_File_openURL.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainForm.this.doOpenURL();
                }
            });
        }
        return this.menu_File_openURL;
    }

    private JMenuItem getMenu_File_exportWave() {
        if (this.menu_File_exportWave == null) {
            this.menu_File_exportWave = new JMenuItem();
            this.menu_File_exportWave.setName("menu_File_exportWave");
            this.menu_File_exportWave.setMnemonic('e');
            this.menu_File_exportWave.setText("Export to wave...");
            this.menu_File_exportWave.setFont(Helpers.DIALOG_FONT);
            this.menu_File_exportWave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainForm.this.doExportToWave();
                }
            });
        }
        return this.menu_File_exportWave;
    }

    private JMenu getMenu_File_RecentFiles() {
        if (this.menu_File_RecentFiles == null) {
            this.menu_File_RecentFiles = new JMenu();
            this.menu_File_RecentFiles.setName("menu_File_RecentFiles");
            this.menu_File_RecentFiles.setMnemonic('r');
            this.menu_File_RecentFiles.setText("Recent files");
            this.menu_File_RecentFiles.setFont(Helpers.DIALOG_FONT);
            this.createRecentFileMenuItems();
        }
        return this.menu_File_RecentFiles;
    }

    private void createRecentFileMenuItems() {
        JMenu jMenu = this.getMenu_File_RecentFiles();
        jMenu.removeAll();
        int n = 0;
        int n2 = 1;
        while (n < 10) {
            URL uRL = this.lastLoaded.get(n);
            if (uRL != null) {
                Serializable serializable;
                String string = null;
                if (uRL.getProtocol().equalsIgnoreCase("file")) {
                    try {
                        serializable = new File(uRL.toURI());
                        string = ((File)serializable).getAbsolutePath();
                    }
                    catch (URISyntaxException uRISyntaxException) {}
                }
                if (string == null) {
                    string = this.lastLoaded.get(n).toString();
                }
                serializable = new JMenuItem();
                ((Component)serializable).setName("menu_File_RecentFiles_File" + n);
                ((AbstractButton)serializable).setText(String.valueOf(n2 < 10 ? "  " : "") + n2++ + " " + string);
                ((JComponent)serializable).setFont(Helpers.DIALOG_FONT);
                ((JComponent)serializable).setToolTipText(uRL.toString());
                ((AbstractButton)serializable).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            URL uRL = new URL(((JMenuItem)actionEvent.getSource()).getToolTipText());
                            MainForm.this.loadMultimediaOrPlayListFile(uRL);
                        }
                        catch (Exception exception) {
                            Log.error("Load recent error", exception);
                        }
                    }
                });
                jMenu.add((JMenuItem)serializable);
            }
            ++n;
        }
    }

    private JMenuItem getMenu_File_Close() {
        if (this.menu_File_Close == null) {
            this.menu_File_Close = new JMenuItem();
            this.menu_File_Close.setName("menu_File_Close");
            this.menu_File_Close.setMnemonic('c');
            this.menu_File_Close.setText("Close");
            this.menu_File_Close.setFont(Helpers.DIALOG_FONT);
            this.menu_File_Close.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainForm.this.doClose();
                }
            });
        }
        return this.menu_File_Close;
    }

    private JMenuItem getMenu_View_Info() {
        if (this.menu_View_Info == null) {
            this.menu_View_Info = new JMenuItem();
            this.menu_View_Info.setName("menu_View_Info");
            this.menu_View_Info.setMnemonic('p');
            this.menu_View_Info.setText("Properties...");
            this.menu_View_Info.setFont(Helpers.DIALOG_FONT);
            this.menu_View_Info.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainForm.this.getModInfoDialog().setVisible(true);
                }
            });
        }
        return this.menu_View_Info;
    }

    private JMenuItem getMenu_View_Setup() {
        if (this.menu_View_Setup == null) {
            this.menu_View_Setup = new JMenuItem();
            this.menu_View_Setup.setName("menu_View_Setup");
            this.menu_View_Setup.setMnemonic('s');
            this.menu_View_Setup.setText("Setup...");
            this.menu_View_Setup.setFont(Helpers.DIALOG_FONT);
            this.menu_View_Setup.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainForm.this.getPlayerSetUpDialog().setVisible(true);
                }
            });
        }
        return this.menu_View_Setup;
    }

    private JMenuItem getMenu_View_Playlist() {
        if (this.menu_View_Playlist == null) {
            this.menu_View_Playlist = new JMenuItem();
            this.menu_View_Playlist.setName("menu_View_Playlist");
            this.menu_View_Playlist.setMnemonic('p');
            this.menu_View_Playlist.setText("Playlist...");
            this.menu_View_Playlist.setFont(Helpers.DIALOG_FONT);
            this.menu_View_Playlist.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainForm.this.getPlaylistDialog().setVisible(true);
                }
            });
        }
        return this.menu_View_Playlist;
    }

    private JMenuItem getMenu_View_GraphicEQ() {
        if (this.menu_View_GraphicEQ == null) {
            this.menu_View_GraphicEQ = new JMenuItem();
            this.menu_View_GraphicEQ.setName("menu_View_GraphicEQ");
            this.menu_View_GraphicEQ.setMnemonic('e');
            this.menu_View_GraphicEQ.setText("Effect...");
            this.menu_View_GraphicEQ.setFont(Helpers.DIALOG_FONT);
            this.menu_View_GraphicEQ.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainForm.this.getEffectDialog().setVisible(true);
                }
            });
        }
        return this.menu_View_GraphicEQ;
    }

    private JCheckBoxMenuItem getMenu_View_UseSystemTray() {
        if (this.menu_View_UseSystemTray == null) {
            this.menu_View_UseSystemTray = new JCheckBoxMenuItem();
            this.menu_View_UseSystemTray.setName("menu_View_UseSystemTray");
            this.menu_View_UseSystemTray.setMnemonic('t');
            this.menu_View_UseSystemTray.setText("Use system tray");
            this.menu_View_UseSystemTray.setFont(Helpers.DIALOG_FONT);
            this.menu_View_UseSystemTray.setEnabled(SystemTray.isSupported());
            this.menu_View_UseSystemTray.setSelected(this.useSystemTray);
            this.menu_View_UseSystemTray.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainForm.this.useSystemTray = MainForm.this.getMenu_View_UseSystemTray().isSelected();
                    MainForm.this.setSystemTray();
                }
            });
        }
        return this.menu_View_UseSystemTray;
    }

    private JMenuItem getMenu_Help_CheckUpdate() {
        if (this.menu_Help_CheckUpdate == null) {
            this.menu_Help_CheckUpdate = new JMenuItem();
            this.menu_Help_CheckUpdate.setName("menu_Help_CheckUpdate");
            this.menu_Help_CheckUpdate.setMnemonic('c');
            this.menu_Help_CheckUpdate.setText("Check for update...");
            this.menu_Help_CheckUpdate.setFont(Helpers.DIALOG_FONT);
            this.menu_Help_CheckUpdate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainForm.this.doCheckUpdate();
                }
            });
        }
        return this.menu_Help_CheckUpdate;
    }

    private JMenuItem getMenu_Help_ShowVersionHistory() {
        if (this.menu_Help_ShowVersionHistory == null) {
            this.menu_Help_ShowVersionHistory = new JMenuItem();
            this.menu_Help_ShowVersionHistory.setName("menu_Help_showVersionHistory");
            this.menu_Help_ShowVersionHistory.setMnemonic('s');
            this.menu_Help_ShowVersionHistory.setText("Show version history...");
            this.menu_Help_ShowVersionHistory.setFont(Helpers.DIALOG_FONT);
            this.menu_Help_ShowVersionHistory.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SimpleTextViewerDialog simpleTextViewerDialog = MainForm.this.getShowVersion_Text();
                    simpleTextViewerDialog.setDisplayTextFromURL("http://www.quippy.de/download.php?file=./modplayer/javamod_version.txt");
                    simpleTextViewerDialog.setVisible(true);
                }
            });
        }
        return this.menu_Help_ShowVersionHistory;
    }

    private JMenuItem getMenu_Help_About() {
        if (this.menu_Help_About == null) {
            this.menu_Help_About = new JMenuItem();
            this.menu_Help_About.setName("menu_Help_About");
            this.menu_Help_About.setMnemonic('a');
            this.menu_Help_About.setText("About...");
            this.menu_Help_About.setFont(Helpers.DIALOG_FONT);
            this.menu_Help_About.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainForm.this.doShowAbout();
                }
            });
        }
        return this.menu_Help_About;
    }

    private MenuItem getAboutItem() {
        if (this.aboutItem == null) {
            this.aboutItem = new MenuItem("About");
            this.aboutItem.setFont(Helpers.DIALOG_FONT);
            this.aboutItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainForm.this.doShowAbout();
                }
            });
        }
        return this.aboutItem;
    }

    private MenuItem getPlayItem() {
        if (this.playItem == null) {
            this.playItem = new MenuItem("Play");
            this.playItem.setFont(Helpers.DIALOG_FONT);
            this.playItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainForm.this.doStartPlaying();
                }
            });
        }
        return this.playItem;
    }

    private MenuItem getPauseItem() {
        if (this.pauseItem == null) {
            this.pauseItem = new MenuItem("Pause");
            this.pauseItem.setFont(Helpers.DIALOG_FONT);
            this.pauseItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainForm.this.doPausePlaying();
                }
            });
        }
        return this.pauseItem;
    }

    private MenuItem getStopItem() {
        if (this.stopItem == null) {
            this.stopItem = new MenuItem("Stop");
            this.stopItem.setFont(Helpers.DIALOG_FONT);
            this.stopItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainForm.this.doStopPlaying();
                }
            });
        }
        return this.stopItem;
    }

    private MenuItem getPrevItem() {
        if (this.prevItem == null) {
            this.prevItem = new MenuItem("Previous");
            this.prevItem.setFont(Helpers.DIALOG_FONT);
            this.prevItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainForm.this.doPrevPlayListEntry();
                }
            });
        }
        return this.prevItem;
    }

    private MenuItem getNextItem() {
        if (this.nextItem == null) {
            this.nextItem = new MenuItem("Next");
            this.nextItem.setFont(Helpers.DIALOG_FONT);
            this.nextItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainForm.this.doNextPlayListEntry();
                }
            });
        }
        return this.nextItem;
    }

    private MenuItem getCloseItem() {
        if (this.closeItem == null) {
            this.closeItem = new MenuItem("Close");
            this.closeItem.setFont(Helpers.DIALOG_FONT);
            this.closeItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainForm.this.doClose();
                }
            });
        }
        return this.closeItem;
    }

    private TrayIcon getTrayIcon() {
        URL uRL;
        if (this.javaModTrayIcon == null && (uRL = MainForm.class.getResource(DEFAULTICONPATH)) != null) {
            this.javaModTrayIcon = new TrayIcon(Toolkit.getDefaultToolkit().getImage(uRL));
            this.javaModTrayIcon.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                        MainForm mainForm = MainForm.this;
                        mainForm.setVisible(true);
                        mainForm.setExtendedState(mainForm.getExtendedState() & 0xFFFFFFFE);
                    }
                }
            });
            PopupMenu popupMenu = new PopupMenu();
            popupMenu.add(this.getAboutItem());
            popupMenu.addSeparator();
            popupMenu.add(this.getPlayItem());
            popupMenu.add(this.getPauseItem());
            popupMenu.add(this.getStopItem());
            popupMenu.add(this.getPrevItem());
            popupMenu.add(this.getNextItem());
            popupMenu.addSeparator();
            popupMenu.add(this.getCloseItem());
            this.javaModTrayIcon.setPopupMenu(popupMenu);
        }
        return this.javaModTrayIcon;
    }

    private void setSystemTray() {
        if (SystemTray.isSupported()) {
            SystemTray systemTray = SystemTray.getSystemTray();
            try {
                systemTray.remove(this.getTrayIcon());
                if (this.useSystemTray) {
                    systemTray.add(this.getTrayIcon());
                }
            }
            catch (AWTException aWTException) {
                Log.error("TrayIcon could not be added.", aWTException);
            }
        }
    }

    public JPanel getBaseContentPane() {
        if (this.baseContentPane == null) {
            this.baseContentPane = new JPanel();
            this.baseContentPane.setName("baseContentPane");
            this.baseContentPane.setLayout(new BorderLayout());
            this.baseContentPane.add((Component)this.getMessages(), "South");
            this.baseContentPane.add((Component)this.getMainContentPane(), "Center");
        }
        return this.baseContentPane;
    }

    public JTextField getMessages() {
        if (this.messages == null) {
            this.messages = new JTextField();
            this.messages.setName("messages");
            this.messages.setEditable(false);
            this.messages.setFont(Helpers.DIALOG_FONT);
        }
        return this.messages;
    }

    public JPanel getMainContentPane() {
        if (this.mainContentPane == null) {
            this.mainContentPane = new JPanel();
            this.mainContentPane.setName("mainContentPane");
            this.mainContentPane.setLayout(new GridBagLayout());
            this.mainContentPane.add((Component)this.getMusicDataPane(), Helpers.getGridBagConstraint(0, 0, 1, 0, 1, 10, 0.0, 1.0));
            this.mainContentPane.add((Component)this.getPlayerDataPane(), Helpers.getGridBagConstraint(0, 1, 1, 0, 1, 10, 0.0, 1.0));
            this.mainContentPane.add((Component)this.getPlayerControlPane(), Helpers.getGridBagConstraint(0, 2, 1, 0, 1, 10, 0.0, 0.0));
        }
        return this.mainContentPane;
    }

    private JavaModAbout getJavaModAbout() {
        if (this.about == null) {
            this.about = new JavaModAbout((Frame)this, true);
            this.about.addWindowFocusListener(this.makeMainWindowVisiable);
        } else {
            this.about.setLocation(Helpers.getFrameCenteredLocation(this.about, this));
        }
        return this.about;
    }

    private UrlDialog getURLDialog() {
        if (this.urlDialog == null) {
            this.urlDialog = new UrlDialog(this, true, "");
            this.urlDialog.addWindowFocusListener(this.makeMainWindowVisiable);
        } else {
            this.urlDialog.setLocation(Helpers.getFrameCenteredLocation(this.urlDialog, this));
        }
        return this.urlDialog;
    }

    public JDialog getEffectDialog() {
        if (this.equalizerDialog == null) {
            this.equalizerDialog = new JDialog(this, "Effect", false);
            this.equalizerDialog.setName("equalizerDialog");
            this.equalizerDialog.setSize(this.effectsDialogSize);
            this.equalizerDialog.setPreferredSize(this.effectsDialogSize);
            this.equalizerDialog.setContentPane(this.getEffectPane());
            if (this.effectsDialogLocation == null || this.effectsDialogLocation.getX() == -1.0 || this.effectsDialogLocation.getY() == -1.0) {
                this.effectsDialogLocation = Helpers.getFrameCenteredLocation(this.equalizerDialog, null);
            }
            this.equalizerDialog.setLocation(this.effectsDialogLocation);
            this.equalizerDialog.addWindowFocusListener(this.makeMainWindowVisiable);
        }
        return this.equalizerDialog;
    }

    public JDialog getPlayerSetUpDialog() {
        if (this.playerSetUpDialog == null) {
            this.playerSetUpDialog = new JDialog(this, "Configuration", false);
            this.playerSetUpDialog.setName("playerSetUpDialog");
            this.playerSetUpDialog.setSize(this.playerSetUpDialogSize);
            this.playerSetUpDialog.setPreferredSize(this.playerSetUpDialogSize);
            this.playerSetUpDialog.setContentPane(this.getPlayerSetUpPane());
            if (this.playerSetUpDialogLocation == null || this.playerSetUpDialogLocation.getX() == -1.0 || this.playerSetUpDialogLocation.getY() == -1.0) {
                this.playerSetUpDialogLocation = Helpers.getFrameCenteredLocation(this.playerSetUpDialog, null);
            }
            this.playerSetUpDialog.setLocation(this.playerSetUpDialogLocation);
            this.playerSetUpDialog.addWindowFocusListener(this.makeMainWindowVisiable);
        }
        return this.playerSetUpDialog;
    }

    public JDialog getPlaylistDialog() {
        if (this.playlistDialog == null) {
            this.playlistDialog = new JDialog(this, "Playlist", false);
            this.playlistDialog.setName("playlistDialog");
            this.playlistDialog.setSize(this.playlistDialogSize);
            this.playlistDialog.setPreferredSize(this.playlistDialogSize);
            this.playlistDialog.setContentPane(this.getPlaylistPane());
            if (this.playlistDialogLocation == null || this.playlistDialogLocation.getX() == -1.0 || this.playlistDialogLocation.getY() == -1.0) {
                this.playlistDialogLocation = Helpers.getFrameCenteredLocation(this.playlistDialog, null);
            }
            this.playlistDialog.setLocation(this.playlistDialogLocation);
            this.playlistDialog.addWindowFocusListener(this.makeMainWindowVisiable);
        }
        return this.playlistDialog;
    }

    public JDialog getModInfoDialog() {
        if (this.modInfoDialog == null) {
            this.modInfoDialog = new JDialog(this, "File properties", false);
            this.modInfoDialog.setName("modInfoDialog");
            this.modInfoDialog.setSize(this.modInfoDialogSize);
            this.modInfoDialog.setPreferredSize(this.modInfoDialogSize);
            this.modInfoDialog.setContentPane(this.getModInfoPane());
            if (this.modInfoDialogLocation == null || this.modInfoDialogLocation.getX() == -1.0 || this.modInfoDialogLocation.getY() == -1.0) {
                this.modInfoDialogLocation = Helpers.getFrameCenteredLocation(this.modInfoDialog, null);
            }
            this.modInfoDialog.setLocation(this.modInfoDialogLocation);
            this.modInfoDialog.addWindowFocusListener(this.makeMainWindowVisiable);
        }
        return this.modInfoDialog;
    }

    public JPanel getModInfoPane() {
        if (this.modInfoPane == null) {
            this.modInfoPane = new JPanel();
            this.modInfoPane.setName("ModInfoPane");
            this.modInfoPane.setLayout(new BorderLayout());
            this.modInfoPane.setBorder(new TitledBorder(null, "Multimedia File Info", 4, 2, Helpers.DIALOG_FONT, null));
            this.changeInfoPane();
        }
        return this.modInfoPane;
    }

    public JPanel getPlaylistPane() {
        if (this.playlistPane == null) {
            this.playlistPane = new JPanel();
            this.playlistPane.setName("playlistPane");
            this.playlistPane.setLayout(new BorderLayout());
            this.playlistPane.setBorder(new TitledBorder(null, "Playlist", 4, 2, Helpers.DIALOG_FONT, null));
            this.playlistPane.add(this.getPlaylistGUI());
        }
        return this.playlistPane;
    }

    public PlayListGUI getPlaylistGUI() {
        if (this.playlistGUI == null) {
            this.playlistGUI = new PlayListGUI(this);
            this.playlistGUI.addPlaylistGUIChangeListener(this);
        }
        return this.playlistGUI;
    }

    public JPanel getEffectPane() {
        if (this.effectPane == null) {
            this.effectPane = new JPanel();
            this.effectPane.setName("effectPane");
            this.effectPane.setLayout(new BorderLayout());
            this.effectPane.setBorder(new TitledBorder(null, "Effects", 4, 2, Helpers.DIALOG_FONT, null));
            this.effectPane.add(this.getEffectsPanel());
        }
        return this.effectPane;
    }

    private GraphicEqGUI getEqualizerGui() {
        if (this.equalizerGUI == null) {
            this.equalizerGUI = new GraphicEqGUI(this.currentEqualizer);
        }
        return this.equalizerGUI;
    }

    private PitchShiftGUI getPitchShiftGui() {
        if (this.pitchShiftGUI == null) {
            this.pitchShiftGUI = new PitchShiftGUI(this.currentPitchShift);
        }
        return this.pitchShiftGUI;
    }

    public EffectsPanel getEffectsPanel() {
        if (this.effectGUI == null) {
            JPanel[] jPanelArray = new JPanel[]{this.getEqualizerGui(), this.getPitchShiftGui()};
            this.effectGUI = new EffectsPanel(jPanelArray, this.audioProcessor);
        }
        return this.effectGUI;
    }

    public JPanel getPlayerSetUpPane() {
        if (this.playerSetUpPane == null) {
            this.playerSetUpPane = new JPanel();
            this.playerSetUpPane.setName("playerSetUpPane");
            this.playerSetUpPane.setLayout(new BorderLayout());
            this.playerSetUpPane.setBorder(new TitledBorder(null, "Mixer Control", 4, 2, Helpers.DIALOG_FONT, null));
            this.playerSetUpPane.add(this.getPlayerConfigPanel());
            this.changeConfigPane();
        }
        return this.playerSetUpPane;
    }

    public PlayerConfigPanel getPlayerConfigPanel() {
        if (this.playerConfigPanel == null) {
            this.playerConfigPanel = new PlayerConfigPanel();
        }
        return this.playerConfigPanel;
    }

    public JDialog getDownloadDialog() {
        if (this.downloadDialog == null) {
            this.downloadDialog = new JDialog(this, "Download progress", false);
            this.downloadDialog.setName("downloadDialog");
            Dimension dimension = new Dimension(250, 55);
            this.downloadDialog.setSize(dimension);
            this.downloadDialog.setPreferredSize(dimension);
            this.downloadDialog.setContentPane(this.getDownloadPane());
            this.downloadDialog.setLocation(Helpers.getFrameCenteredLocation(this.downloadDialog, this));
            this.downloadDialog.pack();
        }
        return this.downloadDialog;
    }

    public JPanel getDownloadPane() {
        if (this.downloadPane == null) {
            this.downloadPane = new JPanel();
            this.downloadPane.setName("downloadPane");
            this.downloadPane.setLayout(new GridBagLayout());
            this.downloadPane.add((Component)this.getDownloadProgressBar(), Helpers.getGridBagConstraint(0, 0, 1, 0, 1, 10, 1.0, 1.0));
        }
        return this.downloadPane;
    }

    public JProgressBar getDownloadProgressBar() {
        if (this.downloadProgressBar == null) {
            this.downloadProgressBar = new JProgressBar();
            this.downloadProgressBar.setMinimum(0);
            this.downloadProgressBar.setMaximum(100);
            this.downloadProgressBar.setValue(0);
        }
        return this.downloadProgressBar;
    }

    public SAMeterPanel getSALMeterPanel() {
        if (this.saLMeterPanel == null) {
            this.saLMeterPanel = new SAMeterPanel(50, 25);
            Dimension dimension = new Dimension(104, 60);
            this.saLMeterPanel.setSize(dimension);
            this.saLMeterPanel.setMaximumSize(dimension);
            this.saLMeterPanel.setMinimumSize(dimension);
            this.saLMeterPanel.setPreferredSize(dimension);
            this.saLMeterPanel.setDoubleBuffered(true);
            this.saLMeterPanel.setBorder(new BevelBorder(1));
        }
        return this.saLMeterPanel;
    }

    public SAMeterPanel getSARMeterPanel() {
        if (this.saRMeterPanel == null) {
            this.saRMeterPanel = new SAMeterPanel(50, 25);
            Dimension dimension = new Dimension(104, 60);
            this.saRMeterPanel.setSize(dimension);
            this.saRMeterPanel.setMaximumSize(dimension);
            this.saRMeterPanel.setMinimumSize(dimension);
            this.saRMeterPanel.setPreferredSize(dimension);
            this.saRMeterPanel.setDoubleBuffered(true);
            this.saRMeterPanel.setBorder(new BevelBorder(1));
        }
        return this.saRMeterPanel;
    }

    public VUMeterPanel getVULMeterPanel() {
        if (this.vuLMeterPanel == null) {
            this.vuLMeterPanel = new VUMeterPanel(50);
            Dimension dimension = new Dimension(20, 100);
            this.vuLMeterPanel.setSize(dimension);
            this.vuLMeterPanel.setMaximumSize(dimension);
            this.vuLMeterPanel.setMinimumSize(dimension);
            this.vuLMeterPanel.setPreferredSize(dimension);
            this.vuLMeterPanel.setBorder(new BevelBorder(1));
        }
        return this.vuLMeterPanel;
    }

    public VUMeterPanel getVURMeterPanel() {
        if (this.vuRMeterPanel == null) {
            this.vuRMeterPanel = new VUMeterPanel(50);
            Dimension dimension = new Dimension(20, 100);
            this.vuRMeterPanel.setSize(dimension);
            this.vuRMeterPanel.setMaximumSize(dimension);
            this.vuRMeterPanel.setMinimumSize(dimension);
            this.vuRMeterPanel.setPreferredSize(dimension);
            this.vuRMeterPanel.setBorder(new BevelBorder(1));
        }
        return this.vuRMeterPanel;
    }

    public JPanel getMusicDataPane() {
        if (this.musicDataPane == null) {
            this.musicDataPane = new JPanel();
            this.musicDataPane.setName("musicDataPane");
            this.musicDataPane.setLayout(new GridBagLayout());
            this.musicDataPane.setBorder(new TitledBorder(null, "Name", 4, 2, Helpers.DIALOG_FONT, null));
            this.musicDataPane.add((Component)this.getLEDScrollPanel(), Helpers.getGridBagConstraint(0, 0, 1, 0, 0, 10, 0.0, 0.0));
        }
        return this.musicDataPane;
    }

    public LEDScrollPanel getLEDScrollPanel() {
        if (this.ledScrollPanel == null) {
            this.ledScrollPanel = new LEDScrollPanel(30, "Java Mod Player V2.0 \u00a9 by Daniel Becker since 2006                  ", 15, Color.GREEN, Color.GRAY);
            Dimension dimension = new Dimension(274, 28);
            this.ledScrollPanel.setSize(dimension);
            this.ledScrollPanel.setMaximumSize(dimension);
            this.ledScrollPanel.setMinimumSize(dimension);
            this.ledScrollPanel.setPreferredSize(dimension);
            this.ledScrollPanel.setBorder(new BevelBorder(1));
        }
        return this.ledScrollPanel;
    }

    public JPanel getPlayerDataPane() {
        if (this.playerDataPane == null) {
            this.playerDataPane = new JPanel();
            this.playerDataPane.setName("playerDataPane");
            this.playerDataPane.setLayout(new GridBagLayout());
            this.playerDataPane.setBorder(new TitledBorder(null, "Player Data", 4, 2, Helpers.DIALOG_FONT, null));
            this.playerDataPane.add((Component)this.getVULMeterPanel(), Helpers.getGridBagConstraint(0, 0, 1, 1, 0, 10, 0.0, 0.0));
            this.playerDataPane.add((Component)this.getSALMeterPanel(), Helpers.getGridBagConstraint(1, 0, 1, 1, 0, 10, 0.0, 0.0));
            this.playerDataPane.add((Component)this.getSARMeterPanel(), Helpers.getGridBagConstraint(2, 0, 1, 1, 0, 10, 0.0, 0.0));
            this.playerDataPane.add((Component)this.getVURMeterPanel(), Helpers.getGridBagConstraint(3, 0, 1, 0, 0, 10, 0.0, 0.0));
        }
        return this.playerDataPane;
    }

    public JPanel getPlayerControlPane() {
        if (this.playerControlPane == null) {
            this.playerControlPane = new JPanel();
            this.playerControlPane.setName("playerControlPane");
            this.playerControlPane.setLayout(new GridBagLayout());
            this.playerControlPane.setBorder(new TitledBorder(null, "Player Control", 4, 2, Helpers.DIALOG_FONT, null));
            this.playerControlPane.add((Component)this.getButton_Prev(), Helpers.getGridBagConstraint(0, 0, 2, 1, 0, 10, 0.0, 0.0));
            this.playerControlPane.add((Component)this.getButton_Play(), Helpers.getGridBagConstraint(1, 0, 2, 1, 0, 10, 0.0, 0.0));
            this.playerControlPane.add((Component)this.getButton_Next(), Helpers.getGridBagConstraint(2, 0, 2, 1, 0, 10, 0.0, 0.0));
            this.playerControlPane.add((Component)this.getButton_Pause(), Helpers.getGridBagConstraint(3, 0, 2, 1, 0, 10, 0.0, 0.0));
            this.playerControlPane.add((Component)this.getButton_Stop(), Helpers.getGridBagConstraint(4, 0, 2, 1, 0, 10, 0.0, 0.0));
            this.playerControlPane.add((Component)this.getVolumeSlider(), Helpers.getGridBagConstraint(5, 0, 1, 1, 3, 10, 0.0, 1.0));
            this.playerControlPane.add((Component)this.getBalanceSlider(), Helpers.getGridBagConstraint(6, 0, 1, 0, 3, 10, 0.0, 1.0));
            this.playerControlPane.add((Component)this.getVolumeLabel(), Helpers.getGridBagConstraint(5, 1, 1, 1, 0, 10, 0.0, 0.0));
            this.playerControlPane.add((Component)this.getBalanceLabel(), Helpers.getGridBagConstraint(6, 1, 1, 0, 0, 10, 0.0, 0.0));
            this.playerControlPane.add((Component)this.getSeekBarPanel(), Helpers.getGridBagConstraint(0, 2, 1, 0, 1, 10, 1.0, 1.0));
        }
        return this.playerControlPane;
    }

    private SeekBarPanel getSeekBarPanel() {
        if (this.seekBarPanel == null) {
            this.seekBarPanel = new SeekBarPanel(30, false);
            this.seekBarPanel.setName("SeekBarPanel");
            this.seekBarPanel.addListener(new SeekBarPanelListener(){

                @Override
                public void valuesChanged(long l) {
                    if (MainForm.this.currentPlayList != null && MainForm.this.playerThread != null && MainForm.this.playerThread.isRunning()) {
                        MainForm.this.currentPlayList.setCurrentElementByTimeIndex(l);
                    }
                }
            });
        }
        return this.seekBarPanel;
    }

    private JButton getButton_Play() {
        if (this.button_Play == null) {
            this.buttonPlay_normal = new ImageIcon(this.getClass().getResource(BUTTONPLAY_NORMAL));
            this.buttonPlay_Inactive = new ImageIcon(this.getClass().getResource(BUTTONPLAY_INACTIVE));
            this.buttonPlay_Active = new ImageIcon(this.getClass().getResource(BUTTONPLAY_ACTIVE));
            this.button_Play = new JButton();
            this.button_Play.setName("button_Play");
            this.button_Play.setText("");
            this.button_Play.setToolTipText("play");
            this.button_Play.setHorizontalTextPosition(0);
            this.button_Play.setVerticalTextPosition(3);
            this.button_Play.setIcon(this.buttonPlay_normal);
            this.button_Play.setDisabledIcon(this.buttonPlay_Inactive);
            this.button_Play.setPressedIcon(this.buttonPlay_Active);
            this.button_Play.setMargin(new Insets(4, 6, 4, 6));
            this.button_Play.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainForm.this.doStartPlaying();
                }
            });
        }
        return this.button_Play;
    }

    private JButton getButton_Pause() {
        if (this.button_Pause == null) {
            this.buttonPause_normal = new ImageIcon(this.getClass().getResource(BUTTONPAUSE_NORMAL));
            this.buttonPause_Inactive = new ImageIcon(this.getClass().getResource(BUTTONPAUSE_INACTIVE));
            this.buttonPause_Active = new ImageIcon(this.getClass().getResource(BUTTONPAUSE_ACTIVE));
            this.button_Pause = new JButton();
            this.button_Pause.setName("button_Pause");
            this.button_Pause.setText("");
            this.button_Pause.setToolTipText("pause");
            this.button_Pause.setHorizontalTextPosition(0);
            this.button_Pause.setVerticalTextPosition(3);
            this.button_Pause.setIcon(this.buttonPause_normal);
            this.button_Pause.setDisabledIcon(this.buttonPause_Inactive);
            this.button_Pause.setPressedIcon(this.buttonPause_Active);
            this.button_Pause.setMargin(new Insets(4, 6, 4, 6));
            this.button_Pause.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainForm.this.doPausePlaying();
                }
            });
        }
        return this.button_Pause;
    }

    private JButton getButton_Stop() {
        if (this.button_Stop == null) {
            this.buttonStop_normal = new ImageIcon(this.getClass().getResource(BUTTONSTOP_NORMAL));
            this.buttonStop_Inactive = new ImageIcon(this.getClass().getResource(BUTTONSTOP_INACTIVE));
            this.buttonStop_Active = new ImageIcon(this.getClass().getResource(BUTTONSTOP_ACTIVE));
            this.button_Stop = new JButton();
            this.button_Stop.setName("button_Stop");
            this.button_Stop.setText("");
            this.button_Stop.setToolTipText("stop");
            this.button_Stop.setHorizontalTextPosition(0);
            this.button_Stop.setVerticalTextPosition(3);
            this.button_Stop.setIcon(this.buttonStop_normal);
            this.button_Stop.setDisabledIcon(this.buttonStop_Inactive);
            this.button_Stop.setPressedIcon(this.buttonStop_Active);
            this.button_Stop.setMargin(new Insets(4, 6, 4, 6));
            this.button_Stop.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainForm.this.doStopPlaying();
                }
            });
        }
        return this.button_Stop;
    }

    private JButton getButton_Prev() {
        if (this.button_Prev == null) {
            this.buttonPrev_normal = new ImageIcon(this.getClass().getResource(BUTTONPREV_NORMAL));
            this.buttonPrev_Inactive = new ImageIcon(this.getClass().getResource(BUTTONPREV_INACTIVE));
            this.buttonPrev_Active = new ImageIcon(this.getClass().getResource(BUTTONPREV_ACTIVE));
            this.button_Prev = new JButton();
            this.button_Prev.setName("button_Prev");
            this.button_Prev.setText("");
            this.button_Prev.setToolTipText("previous");
            this.button_Prev.setHorizontalTextPosition(0);
            this.button_Prev.setVerticalTextPosition(3);
            this.button_Prev.setIcon(this.buttonPrev_normal);
            this.button_Prev.setDisabledIcon(this.buttonPrev_Inactive);
            this.button_Prev.setPressedIcon(this.buttonPrev_Active);
            this.button_Prev.setMargin(new Insets(4, 6, 4, 6));
            this.button_Prev.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainForm.this.doPrevPlayListEntry();
                }
            });
        }
        return this.button_Prev;
    }

    private JButton getButton_Next() {
        if (this.button_Next == null) {
            this.buttonNext_normal = new ImageIcon(this.getClass().getResource(BUTTONNEXT_NORMAL));
            this.buttonNext_Inactive = new ImageIcon(this.getClass().getResource(BUTTONNEXT_INACTIVE));
            this.buttonNext_Active = new ImageIcon(this.getClass().getResource(BUTTONNEXT_ACTIVE));
            this.button_Next = new JButton();
            this.button_Next.setName("button_Next");
            this.button_Next.setText("");
            this.button_Next.setToolTipText("next");
            this.button_Next.setHorizontalTextPosition(0);
            this.button_Next.setVerticalTextPosition(3);
            this.button_Next.setIcon(this.buttonNext_normal);
            this.button_Next.setDisabledIcon(this.buttonNext_Inactive);
            this.button_Next.setPressedIcon(this.buttonNext_Active);
            this.button_Next.setMargin(new Insets(4, 6, 4, 6));
            this.button_Next.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainForm.this.doNextPlayListEntry();
                }
            });
        }
        return this.button_Next;
    }

    public JLabel getVolumeLabel() {
        if (this.volumeLabel == null) {
            this.volumeLabel = new JLabel("Volume");
            this.volumeLabel.setFont(Helpers.DIALOG_FONT);
        }
        return this.volumeLabel;
    }

    public RoundSlider getVolumeSlider() {
        if (this.volumeSlider == null) {
            this.volumeSlider = new RoundSlider();
            this.volumeSlider.setSize(new Dimension(20, 20));
            this.volumeSlider.setMinimumSize(new Dimension(20, 20));
            this.volumeSlider.setMaximumSize(new Dimension(20, 20));
            this.volumeSlider.setPreferredSize(new Dimension(20, 20));
            this.volumeSlider.setValue(this.currentVolume);
            this.volumeSlider.setToolTipText(String.valueOf(Float.toString(this.currentVolume * 100.0f)) + '%');
            this.volumeSlider.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    RoundSlider roundSlider = (RoundSlider)mouseEvent.getSource();
                    if (mouseEvent.getClickCount() == 2) {
                        roundSlider.setValue(0.5f);
                    }
                }
            });
            this.volumeSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    RoundSlider roundSlider = (RoundSlider)changeEvent.getSource();
                    MainForm.this.currentVolume = roundSlider.getValue();
                    if (MainForm.this.currentVolume < 0.0f) {
                        MainForm.this.currentVolume = 0.0f;
                    } else if (MainForm.this.currentVolume > 1.0f) {
                        MainForm.this.currentVolume = 1.0f;
                    }
                    roundSlider.setToolTipText(String.valueOf(Float.toString(MainForm.this.currentVolume * 100.0f)) + '%');
                    MainForm.this.doSetVoumeValue();
                }
            });
        }
        return this.volumeSlider;
    }

    public JLabel getBalanceLabel() {
        if (this.balanceLabel == null) {
            this.balanceLabel = new JLabel("Balance");
            this.balanceLabel.setFont(Helpers.DIALOG_FONT);
        }
        return this.balanceLabel;
    }

    public RoundSlider getBalanceSlider() {
        if (this.balanceSlider == null) {
            this.balanceSlider = new RoundSlider();
            this.balanceSlider.setSize(new Dimension(20, 20));
            this.balanceSlider.setMinimumSize(new Dimension(20, 20));
            this.balanceSlider.setMaximumSize(new Dimension(20, 20));
            this.balanceSlider.setPreferredSize(new Dimension(20, 20));
            this.balanceSlider.setValue((this.currentBalance + 1.0f) / 2.0f);
            this.balanceSlider.setToolTipText(String.valueOf(Float.toString(this.currentBalance * 100.0f)) + '%');
            this.balanceSlider.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    RoundSlider roundSlider = (RoundSlider)mouseEvent.getSource();
                    if (mouseEvent.getClickCount() == 2) {
                        roundSlider.setValue(0.5f);
                    }
                }
            });
            this.balanceSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    RoundSlider roundSlider = (RoundSlider)changeEvent.getSource();
                    MainForm.this.currentBalance = roundSlider.getValue() * 2.0f - 1.0f;
                    roundSlider.setToolTipText(String.valueOf(Float.toString(MainForm.this.currentBalance * 100.0f)) + '%');
                    MainForm.this.doSetBalanceValue();
                }
            });
        }
        return this.balanceSlider;
    }

    @Override
    public void currentSampleChanged(float[] fArray, float[] fArray2) {
        this.getVULMeterPanel().setVUMeter(fArray);
        this.getVURMeterPanel().setVUMeter(fArray2);
        this.getSALMeterPanel().setMeter(fArray);
        this.getSARMeterPanel().setMeter(fArray2);
    }

    @Override
    public void multimediaContainerEventOccured(MultimediaContainerEvent multimediaContainerEvent) {
        if (multimediaContainerEvent.getType() == MultimediaContainerEvent.SONG_NAME_CHANGED) {
            this.getLEDScrollPanel().addScrollText(String.valueOf(multimediaContainerEvent.getEvent().toString()) + "     ");
        } else if (multimediaContainerEvent.getType() == MultimediaContainerEvent.SONG_NAME_CHANGED_OLD_INVALID) {
            this.getLEDScrollPanel().setScrollTextTo(String.valueOf(multimediaContainerEvent.getEvent().toString()) + "     ");
        }
        this.getTrayIcon().setToolTip(multimediaContainerEvent.getEvent().toString());
    }

    @Override
    public void playThreadEventOccured(PlayThread playThread) {
        if (playThread.isRunning()) {
            this.getButton_Play().setIcon(this.buttonPlay_Active);
        } else {
            boolean bl;
            this.getButton_Play().setIcon(this.buttonPlay_normal);
            if (playThread.getHasFinishedNormaly() && !(bl = this.doNextPlayListEntry())) {
                this.doStopPlaying();
            }
        }
        Mixer mixer = playThread.getCurrentMixer();
        if (mixer != null) {
            if (mixer.isPaused()) {
                this.getButton_Pause().setIcon(this.buttonPause_Active);
            } else {
                this.getButton_Pause().setIcon(this.buttonPause_normal);
            }
        }
    }

    private void setPlayListIcons() {
        if (this.currentPlayList == null) {
            this.getButton_Prev().setEnabled(false);
            this.getButton_Next().setEnabled(false);
        } else {
            this.getButton_Prev().setEnabled(this.currentPlayList.hasPrevious());
            this.getButton_Next().setEnabled(this.currentPlayList.hasNext());
        }
        this.getPrevItem().setEnabled(this.getButton_Prev().isEnabled());
        this.getNextItem().setEnabled(this.getButton_Next().isEnabled());
    }

    private void doClose() {
        if (this.useSystemTray && (this.getExtendedState() & 1) != 0) {
            this.setVisible(true);
        }
        this.doStopPlaying();
        this.getSeekBarPanel().pauseThread();
        this.getVULMeterPanel().pauseThread();
        this.getVURMeterPanel().pauseThread();
        this.getSALMeterPanel().pauseThread();
        this.getSARMeterPanel().pauseThread();
        this.getLEDScrollPanel().pauseThread();
        this.writePropertyFile();
        if (this.audioProcessor != null) {
            this.audioProcessor.removeListener(this);
        }
        MultimediaContainerManager.removeMultimediaContainerEventListener(this);
        this.useSystemTray = false;
        this.setSystemTray();
        this.getJavaModAbout().setVisible(false);
        this.getModInfoDialog().setVisible(false);
        this.getPlayerSetUpDialog().setVisible(false);
        this.getURLDialog().setVisible(false);
        this.getShowVersion_Text().setVisible(false);
        this.getPlaylistDialog().setVisible(false);
        this.getEffectDialog().setVisible(false);
        this.setVisible(false);
        Log.removeLogListener(this);
        this.getJavaModAbout().dispose();
        this.getModInfoDialog().dispose();
        this.getPlayerSetUpDialog().dispose();
        this.getURLDialog().dispose();
        this.getShowVersion_Text().dispose();
        this.getPlaylistDialog().dispose();
        this.getEffectDialog().dispose();
        this.dispose();
    }

    private void doOpenFile() {
        FileChooserResult fileChooserResult = Helpers.selectFileNameFor(this, this.searchPath, "Load a Sound-File", fileFilterLoad, 0, true);
        if (fileChooserResult != null) {
            this.doOpenFile(fileChooserResult.getSelectedFiles());
        }
    }

    public void doOpenFile(File[] fileArray) {
        if (fileArray != null) {
            if (fileArray.length == 1) {
                File file = fileArray[0];
                if (file.isFile()) {
                    String string = file.getAbsolutePath();
                    int n = string.lastIndexOf(File.separatorChar);
                    this.searchPath = string.substring(0, n);
                    this.loadMultimediaOrPlayListFile(Helpers.createURLfromFile(file));
                } else if (file.isDirectory()) {
                    this.searchPath = file.getAbsolutePath();
                }
            } else {
                this.playlistRecieved(null, PlayList.createNewListWithFiles(fileArray, false, false), null);
            }
        }
    }

    private void doOpenURL() {
        this.getURLDialog().setVisible(true);
        String string = this.getURLDialog().getURL();
        if (string != null && string.length() != 0) {
            this.doOpenURL(string);
        }
    }

    public void doOpenURL(String string) {
        if (string != null) {
            this.loadMultimediaOrPlayListFile(Helpers.createURLfromString(string));
        }
    }

    private void doExportToWave() {
        this.doStopPlaying();
        if (this.currentContainer != null) {
            block3: {
                int n;
                File file;
                block4: {
                    int n2;
                    do {
                        String string = Helpers.createLocalFileStringFromURL(this.currentContainer.getFileURL(), true);
                        string = string.substring(string.lastIndexOf(File.separatorChar) + 1);
                        String string2 = String.valueOf(this.exportPath) + File.separatorChar + string + ".WAV";
                        FileChooserResult fileChooserResult = Helpers.selectFileNameFor(this, string2, "Export to wave", fileFilterExport, 1, false);
                        if (fileChooserResult == null || (file = fileChooserResult.getSelectedFile()) == null) break block3;
                        if (!file.exists()) break block4;
                        n2 = JOptionPane.showConfirmDialog(this, "File already exists! Overwrite?", "Overwrite confirmation", 1, 3);
                        if (n2 != 2) continue;
                        return;
                    } while (n2 == 1);
                    n = file.delete() ? 1 : 0;
                    if (n == 0) {
                        JOptionPane.showMessageDialog(this, "Overwrite failed. Is file write protected or in use?", "Failed", 0);
                        return;
                    }
                }
                String string = file.getAbsolutePath();
                n = string.lastIndexOf(File.separatorChar);
                this.exportPath = string.substring(0, n);
                int n3 = JOptionPane.showConfirmDialog(this, "Continue playback while exporting?", "Playback?", 0, 3);
                Mixer mixer = this.createNewMixer();
                mixer.setPlayDuringExport(n3 == 0);
                mixer.setExportFile(file);
                this.playerThread = new PlayThread(mixer, this);
                this.playerThread.start();
                this.inExportMode = true;
            }
            return;
        }
        JOptionPane.showMessageDialog(this, "You need to load a file first!", "Ups!", 0);
    }

    private SimpleTextViewerDialog getShowVersion_Text() {
        if (this.simpleTextViewerDialog == null) {
            this.simpleTextViewerDialog = new SimpleTextViewerDialog(this, true);
        }
        this.simpleTextViewerDialog.setLocation(Helpers.getFrameCenteredLocation(this.simpleTextViewerDialog, this));
        return this.simpleTextViewerDialog;
    }

    private void doCheckUpdate() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                String string = Helpers.getCurrentServerVersion();
                int n = Helpers.compareVersions("V2.0", string);
                if (n < 0) {
                    int n2;
                    File file = new File(".");
                    String string2 = file.getAbsolutePath();
                    int n3 = JOptionPane.showConfirmDialog(MainForm.this, "There is a new version available!\n\nYour version: V2.0 - online verison: " + string + "\n\nWatch version history?\n\n", "New Version", 0, 3);
                    if (n3 == 0) {
                        SimpleTextViewerDialog simpleTextViewerDialog = MainForm.this.getShowVersion_Text();
                        simpleTextViewerDialog.setDisplayTextFromURL("http://www.quippy.de/download.php?file=./modplayer/javamod_version.txt");
                        simpleTextViewerDialog.setVisible(true);
                    }
                    if ((n2 = JOptionPane.showConfirmDialog(MainForm.this, "Your version: V2.0 - online verison: " + string + "\n\nShould I start the download?\n\n", "New Version", 0, 3)) == 0) {
                        int n4;
                        File file2;
                        block12: {
                            JFileChooser jFileChooser = new JFileChooser();
                            jFileChooser.setDialogTitle("Select download destination");
                            jFileChooser.setFileSelectionMode(1);
                            jFileChooser.setAcceptAllFileFilterUsed(false);
                            jFileChooser.setApproveButtonText("Save here");
                            while (true) {
                                if (jFileChooser.showOpenDialog(MainForm.this) != 0) {
                                    continue;
                                }
                                File file3 = jFileChooser.getSelectedFile();
                                file2 = new File(String.valueOf(file3.getAbsolutePath()) + File.separatorChar + "javamod.jar");
                                if (!file2.exists()) break block12;
                                int n5 = JOptionPane.showConfirmDialog(MainForm.this, "File already exists! Overwrite?", "Overwrite confirmation", 1, 3);
                                if (n5 == 2) {
                                    return;
                                }
                                if (n5 != 1) break;
                            }
                            n4 = file2.delete() ? 1 : 0;
                            if (n4 == 0) {
                                JOptionPane.showMessageDialog(MainForm.this, "Overwrite failed. Is file write protected or in use?", "Failed", 0);
                                return;
                            }
                        }
                        JProgressBar jProgressBar = MainForm.this.getDownloadProgressBar();
                        jProgressBar.setValue(0);
                        MainForm.this.getDownloadDialog().setVisible(true);
                        n4 = Helpers.downloadJavaMod(file2, jProgressBar);
                        MainForm.this.getDownloadDialog().setVisible(false);
                        if (n4 == -1) {
                            JOptionPane.showMessageDialog(MainForm.this, "Download failed!\n" + file2, "Failed", 0);
                        } else {
                            JOptionPane.showMessageDialog(MainForm.this, "Saved " + n4 + " bytes successfully to\n" + file2 + "\n\nNow exit JavaMod, move the downloaded file to\n" + string2 + "\nand restart javamod.\n\n", "Success", 1);
                        }
                        return;
                    }
                } else if (n > 0) {
                    JOptionPane.showMessageDialog(MainForm.this, "Your version of JavaMod is newer!", "Newer version", 1);
                } else {
                    JOptionPane.showMessageDialog(MainForm.this, "Your version of JavaMod is up-to-date.", "Up-To-Date", 1);
                }
            }
        }).start();
    }

    private void doShowAbout() {
        this.getJavaModAbout().setVisible(true);
    }

    public void doStartPlaying() {
        this.doStartPlaying(false, 0L);
    }

    public void doStartPlaying(boolean bl, long l) {
        if (this.currentContainer != null) {
            if (this.playerThread != null && !bl) {
                this.playerThread.stopMod();
                this.removeMixer();
                this.playerThread = null;
            }
            if (this.inExportMode) {
                this.inExportMode = false;
                this.doExportToWave();
            }
            if (this.playerThread == null) {
                Mixer mixer = this.createNewMixer();
                if (mixer != null) {
                    if (l > 0L) {
                        mixer.setMillisecondPosition(l);
                    }
                    this.playerThread = new PlayThread(mixer, this);
                    this.playerThread.start();
                }
            } else {
                this.playerThread.getCurrentMixer().setMillisecondPosition(l);
            }
        }
    }

    private void doStopPlaying() {
        if (this.playerThread != null) {
            this.playerThread.stopMod();
            this.getSoundOutputStream().closeAllDevices();
            this.playerThread = null;
            this.removeMixer();
        }
    }

    private void doPausePlaying() {
        if (this.playerThread != null) {
            this.playerThread.pausePlay();
        }
    }

    private boolean doNextPlayListEntry() {
        boolean bl = false;
        while (this.currentPlayList != null && this.currentPlayList.hasNext() && !bl) {
            this.currentPlayList.next();
            bl = this.loadMultimediaFile(this.currentPlayList.getCurrentEntry());
        }
        return bl;
    }

    private boolean doPrevPlayListEntry() {
        boolean bl = false;
        while (this.currentPlayList != null && this.currentPlayList.hasPrevious() && !bl) {
            this.currentPlayList.previous();
            bl = this.loadMultimediaFile(this.currentPlayList.getCurrentEntry());
        }
        return bl;
    }

    @Override
    public void userSelectedPlaylistEntry() {
        boolean bl = false;
        while (this.currentPlayList != null && !bl) {
            PlayListEntry playListEntry = this.currentPlayList.getCurrentEntry();
            bl = this.loadMultimediaFile(playListEntry);
            if (!bl) {
                this.currentPlayList.next();
                continue;
            }
            if (this.playerThread != null) continue;
            this.doStartPlaying(true, playListEntry.getTimeIndex());
        }
    }

    private void doSetVoumeValue() {
        if (this.playerThread != null) {
            Mixer mixer = this.playerThread.getCurrentMixer();
            mixer.setVolume(this.currentVolume);
        }
    }

    private void doSetBalanceValue() {
        if (this.playerThread != null) {
            Mixer mixer = this.playerThread.getCurrentMixer();
            mixer.setBalance(this.currentBalance);
        }
    }

    private SoundOutputStream getSoundOutputStream() {
        if (this.soundOutputStream == null) {
            this.soundOutputStream = new GaplessSoundOutputStreamImpl();
        }
        return this.soundOutputStream;
    }

    private Mixer createNewMixer() {
        Mixer mixer = this.getCurrentContainer().createNewMixer();
        if (mixer != null) {
            mixer.setAudioProcessor(this.audioProcessor);
            mixer.setVolume(this.currentVolume);
            mixer.setBalance(this.currentBalance);
            mixer.setSoundOutputStream(this.getSoundOutputStream());
            this.getSeekBarPanel().setCurrentMixer(mixer);
        }
        return mixer;
    }

    private void removeMixer() {
        this.getSeekBarPanel().setCurrentMixer(null);
    }

    private boolean loadMultimediaOrPlayListFile(URL uRL) {
        Log.info("");
        this.addFileToLastLoaded(uRL);
        this.currentPlayList = null;
        try {
            this.currentPlayList = PlayList.createFromFile(uRL, false, false);
            if (this.currentPlayList != null) {
                this.getPlaylistGUI().setNewPlaylist(this.currentPlayList);
                return this.doNextPlayListEntry();
            }
        }
        catch (Throwable throwable) {
            Log.error("[MainForm::loadMultimediaOrPlayListFile]", throwable);
            this.currentPlayList = null;
        }
        return false;
    }

    private boolean loadMultimediaFile(PlayListEntry playListEntry) {
        boolean bl;
        URL uRL = playListEntry.getFile();
        boolean bl2 = bl = this.currentContainer != null && Helpers.isEqualURL(this.currentContainer.getFileURL(), uRL) && this.playerThread != null && this.playerThread.isRunning();
        if (!bl) {
            try {
                MultimediaContainer multimediaContainer;
                if (uRL != null && (multimediaContainer = MultimediaContainerManager.getMultimediaContainer(uRL)) != null) {
                    this.currentContainer = multimediaContainer;
                    this.getLEDScrollPanel().setScrollTextTo(String.valueOf(this.currentContainer.getSongName()) + "     ");
                    this.getTrayIcon().setToolTip(this.currentContainer.getSongName());
                }
            }
            catch (Throwable throwable) {
                Log.error("[MainForm::loadMultimediaFile] Loading of " + uRL + " failed!", throwable);
                return false;
            }
            this.changeInfoPane();
            this.changeConfigPane();
            this.changeExportMenu();
        }
        this.setPlayListIcons();
        if (this.playerThread != null) {
            this.doStartPlaying(bl, playListEntry.getTimeIndex());
        }
        return true;
    }

    private void addFileToLastLoaded(URL uRL) {
        if (this.lastLoaded.contains(uRL)) {
            this.lastLoaded.remove(uRL);
        }
        this.lastLoaded.add(0, uRL);
        this.createRecentFileMenuItems();
    }

    private MultimediaContainer getCurrentContainer() {
        if (this.currentContainer == null) {
            try {
                this.currentContainer = MultimediaContainerManager.getMultimediaContainerForType("mod");
            }
            catch (Exception exception) {
                Log.error("getCurrentContainer()", exception);
            }
        }
        return this.currentContainer;
    }

    private synchronized void showMessage(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainForm.this.getMessages().setText(string);
            }
        });
    }

    @Override
    public void error(String string, Throwable throwable) {
        if (throwable != null) {
            this.showMessage(String.valueOf(string) + '|' + throwable.toString());
            throwable.printStackTrace(System.err);
        } else {
            this.showMessage(string);
        }
    }

    @Override
    public void info(String string) {
        this.showMessage(string);
    }

    private final class LookAndFeelChanger
    implements ActionListener {
        private String uiClassName;
        private JCheckBoxMenuItem parent;

        public LookAndFeelChanger(JCheckBoxMenuItem jCheckBoxMenuItem, String string) {
            this.uiClassName = string;
            this.parent = jCheckBoxMenuItem;
        }

        private void setSelection() {
            int n = 0;
            while (n < MainForm.this.menu_LookAndFeel_Items.length) {
                if (MainForm.this.menu_LookAndFeel_Items[n] == this.parent) {
                    MainForm.this.menu_LookAndFeel_Items[n].setSelected(true);
                } else {
                    MainForm.this.menu_LookAndFeel_Items[n].setSelected(false);
                }
                ++n;
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.setSelection();
            MainForm.this.uiClassName = this.uiClassName;
            MainForm.this.updateLookAndFeel(this.uiClassName);
        }
    }

    private final class MakeMainWindowVisible
    implements WindowFocusListener {
        private MakeMainWindowVisible() {
        }

        @Override
        public void windowLostFocus(WindowEvent windowEvent) {
        }

        @Override
        public void windowGainedFocus(WindowEvent windowEvent) {
            MainForm.this.setFocusableWindowState(false);
            MainForm.this.toFront();
            MainForm.this.setFocusableWindowState(true);
        }
    }

    private final class MouseWheelVolumeControl
    implements MouseWheelListener {
        private MouseWheelVolumeControl() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            if (!mouseWheelEvent.isConsumed() && mouseWheelEvent.getScrollType() == 0) {
                RoundSlider roundSlider = MainForm.this.getVolumeSlider();
                roundSlider.setValue(roundSlider.getValue() + (float)mouseWheelEvent.getWheelRotation() / 100.0f);
                mouseWheelEvent.consume();
            }
        }
    }
}

