/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.io.wav;

import de.quippy.javamod.io.wav.RiffFile;
import java.io.File;
import javax.sound.sampled.AudioFormat;

public class WaveFile
extends RiffFile {
    private WaveFormat_Chunk wave_format = new WaveFormat_Chunk();
    private RiffFile.RiffChunkHeader pcm_data = new RiffFile.RiffChunkHeader();
    private long pcm_data_offset;

    public WaveFile() {
        this.pcm_data.ckID = WaveFile.fourCC("data");
        this.pcm_data.ckSize = 0;
    }

    public int openForWrite(File file, AudioFormat audioFormat) {
        return this.openForWrite(file.getAbsolutePath(), (int)audioFormat.getSampleRate(), (short)audioFormat.getSampleSizeInBits(), (short)audioFormat.getChannels());
    }

    public int openForWrite(String string, WaveFile waveFile) {
        return this.openForWrite(string, waveFile.getSamplingRate(), waveFile.getBitsPerSample(), waveFile.getNumChannels());
    }

    public int openForWrite(String string, int n, short s, short s2) {
        byte[] byArray;
        if (string == null) {
            return 4;
        }
        this.wave_format.data.config(n, s, s2);
        int n2 = this.open(string, 1);
        if (n2 == 0 && (n2 = this.write(byArray = new byte[]{87, 65, 86, 69}, 4)) == 0) {
            this.writeHeader(this.wave_format.header);
            this.write(this.wave_format.data.wFormatTag, 2);
            this.write(this.wave_format.data.nChannels, 2);
            this.write(this.wave_format.data.nSamplesPerSec, 4);
            this.write(this.wave_format.data.nAvgBytesPerSec, 4);
            this.write(this.wave_format.data.nBlockAlign, 2);
            this.write(this.wave_format.data.nBitsPerSample, 2);
            if (n2 == 0) {
                this.pcm_data_offset = this.currentFilePosition();
                n2 = this.writeHeader(this.pcm_data);
            }
        }
        return n2;
    }

    public int writeSamples(byte[] byArray, int n, int n2) {
        this.pcm_data.ckSize += n2;
        return this.write(byArray, n, n2);
    }

    public int writeSamples(byte[] byArray, int n) {
        this.pcm_data.ckSize += n;
        return this.write(byArray, n);
    }

    public int writeSamples(short[] sArray, int n) {
        int n2 = n << 1;
        byte[] byArray = new byte[n2];
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            byArray[n3] = (byte)(sArray[n4] & 0xFF);
            byArray[n3 + 1] = (byte)(sArray[n4++] >>> 8 & 0xFF);
            n3 += 2;
        }
        return this.write(byArray, n2);
    }

    @Override
    public int close() {
        int n = 0;
        if (this.fmode == 1) {
            n = this.backpatchHeader(this.pcm_data_offset, this.pcm_data);
        }
        n = super.close();
        return n;
    }

    public int getSamplingRate() {
        return this.wave_format.data.nSamplesPerSec;
    }

    public short getBitsPerSample() {
        return this.wave_format.data.nBitsPerSample;
    }

    public short getNumChannels() {
        return this.wave_format.data.nChannels;
    }

    private static class WaveFormat_Chunk {
        public RiffFile.RiffChunkHeader header = new RiffFile.RiffChunkHeader();
        public WaveFormat_ChunkData data;

        public WaveFormat_Chunk() {
            this.header.ckID = WaveFile.fourCC("fmt ");
            this.header.ckSize = 16;
            this.data = new WaveFormat_ChunkData();
        }
    }

    private static class WaveFormat_ChunkData {
        public short wFormatTag = 1;
        public short nChannels;
        public int nSamplesPerSec;
        public int nAvgBytesPerSec;
        public short nBlockAlign;
        public short nBitsPerSample;

        public WaveFormat_ChunkData() {
            this.config(44100, (short)16, (short)1);
        }

        public void config(int n, short s, short s2) {
            this.nSamplesPerSec = n;
            this.nChannels = s2;
            this.nBitsPerSample = s;
            this.nAvgBytesPerSec = this.nChannels * this.nSamplesPerSec * this.nBitsPerSample / 8;
            this.nBlockAlign = (short)(this.nChannels * this.nBitsPerSample / 8);
        }
    }
}

