/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.io.wav;

import java.io.IOException;
import java.io.RandomAccessFile;

public class RiffFile {
    public static final int DDC_SUCCESS = 0;
    public static final int DDC_FAILURE = 1;
    public static final int DDC_OUT_OF_MEMORY = 2;
    public static final int DDC_FILE_ERROR = 3;
    public static final int DDC_INVALID_CALL = 4;
    public static final int DDC_USER_ABORT = 5;
    public static final int DDC_INVALID_FILE = 6;
    public static final int RFM_UNKNOWN = 0;
    public static final int RFM_WRITE = 1;
    public static final int RFM_READ = 2;
    private RiffChunkHeader riff_header = new RiffChunkHeader();
    protected int fmode = 0;
    protected RandomAccessFile file = null;

    public RiffFile() {
        this.riff_header.ckID = RiffFile.fourCC("RIFF");
        this.riff_header.ckSize = 0;
    }

    public int currentFileMode() {
        return this.fmode;
    }

    public int open(String string, int n) {
        int n2 = 0;
        if (this.fmode != 0) {
            n2 = this.close();
        }
        if (n2 == 0) {
            switch (n) {
                case 1: {
                    try {
                        this.file = new RandomAccessFile(string, "rw");
                        this.fmode = 1;
                        if (this.writeHeader_internally(this.riff_header) == 0) break;
                        this.file.close();
                        this.fmode = 0;
                    }
                    catch (IOException iOException) {
                        this.fmode = 0;
                        n2 = 3;
                    }
                    break;
                }
                case 2: {
                    try {
                        this.file = new RandomAccessFile(string, "r");
                        try {
                            byte[] byArray = new byte[8];
                            this.file.read(byArray, 0, 8);
                            this.fmode = 2;
                            this.riff_header.ckID = byArray[0] << 24 & 0xFF000000 | byArray[1] << 16 & 0xFF0000 | byArray[2] << 8 & 0xFF00 | byArray[3] & 0xFF;
                            this.riff_header.ckSize = byArray[7] << 24 & 0xFF000000 | byArray[6] << 16 & 0xFF0000 | byArray[5] << 8 & 0xFF00 | byArray[4] & 0xFF;
                        }
                        catch (IOException iOException) {
                            this.file.close();
                            this.fmode = 0;
                        }
                    }
                    catch (IOException iOException) {
                        this.fmode = 0;
                        n2 = 3;
                    }
                    break;
                }
                default: {
                    n2 = 4;
                }
            }
        }
        return n2;
    }

    public int write(byte[] byArray, int n) {
        return this.write(byArray, 0, n);
    }

    public int write(byte[] byArray, int n, int n2) {
        if (this.fmode != 1) {
            return 4;
        }
        try {
            this.file.write(byArray, n, n2);
            this.fmode = 1;
        }
        catch (IOException iOException) {
            return 3;
        }
        this.riff_header.ckSize += n2 - n;
        return 0;
    }

    public int writeHeader_internally(RiffChunkHeader riffChunkHeader) {
        byte[] byArray = new byte[8];
        byArray[0] = (byte)(riffChunkHeader.ckID >>> 24 & 0xFF);
        byArray[1] = (byte)(riffChunkHeader.ckID >>> 16 & 0xFF);
        byArray[2] = (byte)(riffChunkHeader.ckID >>> 8 & 0xFF);
        byArray[3] = (byte)(riffChunkHeader.ckID & 0xFF);
        byArray[7] = (byte)(riffChunkHeader.ckSize >>> 24 & 0xFF);
        byArray[6] = (byte)(riffChunkHeader.ckSize >>> 16 & 0xFF);
        byArray[5] = (byte)(riffChunkHeader.ckSize >>> 8 & 0xFF);
        byArray[4] = (byte)(riffChunkHeader.ckSize & 0xFF);
        try {
            this.file.write(byArray, 0, 8);
        }
        catch (IOException iOException) {
            return 3;
        }
        return 0;
    }

    public int writeHeader(RiffChunkHeader riffChunkHeader) {
        if (this.fmode != 1) {
            return 4;
        }
        int n = this.writeHeader_internally(riffChunkHeader);
        if (n == 0) {
            this.riff_header.ckSize += 8;
        }
        return n;
    }

    public int write(short s, int n) {
        short s2 = (short)(s >>> 8 & 0xFF | s << 8 & 0xFF00);
        if (this.fmode != 1) {
            return 4;
        }
        try {
            this.file.writeShort(s2);
            this.fmode = 1;
        }
        catch (IOException iOException) {
            return 3;
        }
        this.riff_header.ckSize += n;
        return 0;
    }

    public int write(int n, int n2) {
        short s = (short)(n >>> 16 & 0xFFFF);
        short s2 = (short)(n & 0xFFFF);
        short s3 = (short)(s >>> 8 & 0xFF | s << 8 & 0xFF00);
        short s4 = (short)(s2 >>> 8 & 0xFF | s2 << 8 & 0xFF00);
        int n3 = s4 << 16 & 0xFFFF0000 | s3 & 0xFFFF;
        if (this.fmode != 1) {
            return 4;
        }
        try {
            this.file.writeInt(n3);
            this.fmode = 1;
        }
        catch (IOException iOException) {
            return 3;
        }
        this.riff_header.ckSize += n2;
        return 0;
    }

    public int read(byte[] byArray, int n) {
        int n2 = 0;
        try {
            this.file.read(byArray, 0, n);
        }
        catch (IOException iOException) {
            n2 = 3;
        }
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int expect(String string, int n) {
        byte by = 0;
        int n2 = 0;
        try {
            do {
                if (n-- != 0) continue;
                return 0;
            } while ((by = this.file.readByte()) == string.charAt(n2++));
            return 3;
        }
        catch (IOException iOException) {
            return 3;
        }
    }

    public int close() {
        int n = 0;
        switch (this.fmode) {
            case 1: {
                try {
                    this.file.seek(0L);
                    try {
                        this.writeHeader_internally(this.riff_header);
                        this.file.close();
                    }
                    catch (IOException iOException) {
                        n = 3;
                    }
                }
                catch (IOException iOException) {
                    n = 3;
                }
                break;
            }
            case 2: {
                try {
                    this.file.close();
                    break;
                }
                catch (IOException iOException) {
                    n = 3;
                }
            }
        }
        this.file = null;
        this.fmode = 0;
        return n;
    }

    public long currentFilePosition() {
        long l;
        try {
            l = this.file.getFilePointer();
        }
        catch (IOException iOException) {
            l = -1L;
        }
        return l;
    }

    public int backpatchHeader(long l, RiffChunkHeader riffChunkHeader) {
        if (this.file == null) {
            return 4;
        }
        try {
            this.file.seek(l);
        }
        catch (IOException iOException) {
            return 3;
        }
        return this.writeHeader_internally(riffChunkHeader);
    }

    public int backpatch(long l, byte[] byArray, int n) {
        if (this.file == null) {
            return 4;
        }
        try {
            this.file.seek(l);
        }
        catch (IOException iOException) {
            return 3;
        }
        return this.write(byArray, n);
    }

    protected int seek(long l) {
        int n;
        try {
            this.file.seek(l);
            n = 0;
        }
        catch (IOException iOException) {
            n = 3;
        }
        return n;
    }

    public static int fourCC(String string) {
        byte[] byArray = new byte[]{32, 32, 32, 32};
        System.arraycopy(string.getBytes(), 0, byArray, 0, 4);
        int n = byArray[0] << 24 & 0xFF000000 | byArray[1] << 16 & 0xFF0000 | byArray[2] << 8 & 0xFF00 | byArray[3] & 0xFF;
        return n;
    }

    protected static class RiffChunkHeader {
        public int ckID = 0;
        public int ckSize = 0;
    }
}

