/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.io;

import de.quippy.javamod.io.FileOrPackedInputStream;
import de.quippy.javamod.io.RandomAccessInputStream;
import de.quippy.javamod.system.Log;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UTFDataFormatException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;

public class RandomAccessInputStreamImpl
extends InputStream
implements RandomAccessInputStream {
    protected RandomAccessFile raFile = null;
    protected File localFile = null;
    protected File tmpFile = null;
    protected int mark = 0;
    protected byte[] buffer = null;
    protected int readPointer = 0;
    protected int bufferLength = 0;

    public RandomAccessInputStreamImpl(File file) throws IOException, FileNotFoundException {
        if (!file.exists()) {
            file = this.unpackFromZIPFile(file.toURI().toURL());
        }
        this.localFile = file;
        this.raFile = new RandomAccessFile(this.localFile, "r");
    }

    public RandomAccessInputStreamImpl(String string) throws IOException, FileNotFoundException {
        this(new File(string));
    }

    public RandomAccessInputStreamImpl(URL uRL) throws IOException, FileNotFoundException {
        if (uRL.getProtocol().equalsIgnoreCase("file")) {
            try {
                File file = new File(uRL.toURI());
                if (!file.exists()) {
                    file = this.unpackFromZIPFile(uRL);
                }
                this.localFile = file;
                this.raFile = new RandomAccessFile(this.localFile, "r");
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new MalformedURLException(uRISyntaxException.getMessage());
            }
        }
        FileOrPackedInputStream fileOrPackedInputStream = new FileOrPackedInputStream(uRL);
        try {
            this.tmpFile = this.copyFullStream(fileOrPackedInputStream);
            try {
                ((InputStream)fileOrPackedInputStream).close();
            }
            catch (IOException iOException) {
                Log.error("IGNORED", iOException);
            }
            this.localFile = this.tmpFile;
            this.raFile = new RandomAccessFile(this.localFile, "r");
        }
        catch (Throwable throwable) {
            int n = ((InputStream)fileOrPackedInputStream).available();
            if (n < 1024) {
                n = 1024;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
            this.copyFullStream(fileOrPackedInputStream, byteArrayOutputStream);
            ((InputStream)fileOrPackedInputStream).close();
            byteArrayOutputStream.close();
            this.buffer = byteArrayOutputStream.toByteArray();
            this.bufferLength = this.buffer.length;
            this.readPointer = 0;
            this.raFile = null;
            this.localFile = null;
        }
    }

    private File unpackFromZIPFile(URL uRL) throws IOException, FileNotFoundException {
        FileOrPackedInputStream fileOrPackedInputStream = new FileOrPackedInputStream(uRL);
        return this.copyFullStream(fileOrPackedInputStream);
    }

    private File copyFullStream(InputStream inputStream) throws IOException {
        this.tmpFile = File.createTempFile("JavaMod", "ReadFile");
        this.tmpFile.deleteOnExit();
        FileOutputStream fileOutputStream = new FileOutputStream(this.tmpFile);
        this.copyFullStream(inputStream, fileOutputStream);
        fileOutputStream.close();
        return this.tmpFile;
    }

    private void copyFullStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[8192];
        while ((n = inputStream.read(byArray, 0, 8192)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    @Override
    public File getFile() {
        return this.localFile;
    }

    @Override
    public int available() throws IOException {
        if (this.raFile != null) {
            return (int)(this.raFile.length() - this.raFile.getFilePointer());
        }
        return this.bufferLength - this.readPointer;
    }

    @Override
    public void close() throws IOException {
        boolean bl;
        if (this.raFile != null) {
            this.raFile.close();
        }
        super.close();
        if (this.tmpFile != null && !(bl = this.tmpFile.delete())) {
            Log.error("Could not delete temporary file: " + this.tmpFile.getCanonicalPath());
        }
        this.raFile = null;
        this.buffer = null;
        this.bufferLength = 0;
        this.readPointer = 0;
    }

    @Override
    public synchronized void mark(int n) {
        try {
            this.mark = this.raFile != null ? (int)this.raFile.getFilePointer() : this.readPointer;
        }
        catch (IOException iOException) {}
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() throws IOException {
        if (this.raFile != null) {
            return this.raFile.read();
        }
        return this.readPointer < this.bufferLength ? this.buffer[this.readPointer++] & 0xFF : -1;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.raFile != null) {
            return this.raFile.read(byArray, n, n2);
        }
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.readPointer >= this.bufferLength) {
            return -1;
        }
        if (this.readPointer + n2 > this.bufferLength) {
            n2 = this.bufferLength - this.readPointer;
        }
        if (n2 <= 0) {
            return 0;
        }
        System.arraycopy(this.buffer, this.readPointer, byArray, n, n2);
        this.readPointer += n2;
        return n2;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.raFile != null) {
            this.raFile.seek(this.mark);
        } else {
            this.readPointer = this.mark;
        }
    }

    @Override
    public long skip(long l) throws IOException {
        if (this.raFile != null) {
            return this.raFile.skipBytes((int)l);
        }
        if ((long)this.readPointer + l > (long)this.bufferLength) {
            l = this.bufferLength - this.readPointer;
        }
        if (l < 0L) {
            return 0L;
        }
        this.readPointer = (int)((long)this.readPointer + l);
        return l;
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return (int)this.skip(n);
    }

    @Override
    public long getFilePointer() throws IOException {
        if (this.raFile != null) {
            return this.raFile.getFilePointer();
        }
        return this.readPointer;
    }

    @Override
    public void seek(long l) throws IOException {
        if (this.raFile != null) {
            this.raFile.seek(l);
        } else {
            this.readPointer = (int)l;
        }
    }

    @Override
    public byte readByte() throws IOException {
        if (this.raFile != null) {
            return this.raFile.readByte();
        }
        return (byte)this.read();
    }

    @Override
    public long getLength() throws IOException {
        if (this.raFile != null) {
            return this.raFile.length();
        }
        return this.bufferLength;
    }

    @Override
    public long length() throws IOException {
        return this.getLength();
    }

    @Override
    public int readFully(byte[] byArray) throws IOException {
        if (this.raFile != null) {
            this.raFile.readFully(byArray);
            return byArray.length;
        }
        return this.read(byArray);
    }

    @Override
    public int readFully(byte[] byArray, int n, int n2) throws IOException {
        if (this.raFile != null) {
            this.raFile.readFully(byArray, n, n2);
            return n2;
        }
        return this.read(byArray, n, n2);
    }

    @Override
    public boolean readBoolean() throws IOException {
        if (this.raFile != null) {
            return this.raFile.readBoolean();
        }
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n != 0;
    }

    @Override
    public char readChar() throws IOException {
        int n;
        if (this.raFile != null) {
            return this.raFile.readChar();
        }
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (char)(n2 << 8 | n);
    }

    @Override
    public short readShort() throws IOException {
        int n;
        if (this.raFile != null) {
            return this.raFile.readShort();
        }
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (short)(n2 << 8 | n);
    }

    @Override
    public double readDouble() throws IOException {
        if (this.raFile != null) {
            return this.raFile.readDouble();
        }
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public float readFloat() throws IOException {
        if (this.raFile != null) {
            return this.raFile.readFloat();
        }
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public int readInt() throws IOException {
        int n;
        int n2;
        int n3;
        if (this.raFile != null) {
            return this.raFile.readInt();
        }
        int n4 = this.read();
        if ((n4 | (n3 = this.read()) | (n2 = this.read()) | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return n4 << 24 | n3 << 16 | n2 << 8 | n;
    }

    @Override
    public String readLine() throws IOException {
        if (this.raFile != null) {
            return this.raFile.readLine();
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = -1;
        boolean bl = false;
        block4: while (!bl) {
            n = this.read();
            switch (n) {
                case -1: 
                case 10: {
                    bl = true;
                    break;
                }
                case 13: {
                    bl = true;
                    long l = this.getFilePointer();
                    if (this.read() == 10) continue block4;
                    this.seek(l);
                    break;
                }
                default: {
                    stringBuffer.append((char)n);
                }
            }
        }
        if (n == -1 && stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    @Override
    public long readLong() throws IOException {
        if (this.raFile != null) {
            return this.raFile.readLong();
        }
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    @Override
    public int readUnsignedByte() throws IOException {
        if (this.raFile != null) {
            return this.raFile.readUnsignedByte();
        }
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    @Override
    public int readUnsignedShort() throws IOException {
        int n;
        if (this.raFile != null) {
            return this.raFile.readUnsignedShort();
        }
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return n2 << 8 | n;
    }

    @Override
    public String readUTF() throws IOException {
        int n;
        if (this.raFile != null) {
            return this.raFile.readUTF();
        }
        int n2 = this.readUnsignedShort();
        byte[] byArray = new byte[n2];
        char[] cArray = new char[n2];
        int n3 = 0;
        int n4 = 0;
        this.readFully(byArray, 0, n2);
        while (n3 < n2) {
            n = byArray[n3] & 0xFF;
            if (n > 127) break;
            ++n3;
            cArray[n4++] = (char)n;
        }
        while (n3 < n2) {
            n = byArray[n3] & 0xFF;
            switch (n >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++n3;
                    cArray[n4++] = (char)n;
                    break;
                }
                case 12: 
                case 13: {
                    if ((n3 += 2) > n2) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte by = byArray[n3 - 1];
                    if ((by & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + n3);
                    }
                    cArray[n4++] = (char)((n & 0x1F) << 6 | by & 0x3F);
                    break;
                }
                case 14: {
                    if ((n3 += 3) > n2) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte by = byArray[n3 - 2];
                    byte by2 = byArray[n3 - 1];
                    if ((by & 0xC0) != 128 || (by2 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + (n3 - 1));
                    }
                    cArray[n4++] = (char)((n & 0xF) << 12 | (by & 0x3F) << 6 | (by2 & 0x3F) << 0);
                    break;
                }
                default: {
                    throw new UTFDataFormatException("malformed input around byte " + n3);
                }
            }
        }
        return new String(cArray, 0, n4);
    }
}

