/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.ui.graph;

import ch.oli4.ui.graph.UiPlotEvent;
import ch.oli4.ui.graph.UiPlotListener;
import ch.oli4.ui.graph.UiPlotModel;
import java.awt.Color;
import java.awt.Dimension;
import java.util.Vector;
import javax.swing.JPanel;

public abstract class UiPlot
extends JPanel
implements UiPlotListener {
    protected Vector models;
    protected Color dataLabelColor;
    protected Color pLabelColor;
    protected Color pAxisColor;
    protected boolean dataVisible;
    protected boolean dataLabelVisible;
    protected boolean pLabelVisible;
    protected boolean pAxisVisible;
    public int pScaleMin;
    public int pScaleMax;
    public boolean pAutoScale;

    public UiPlot() {
        this.setPreferredSize(new Dimension(150, 100));
        this.dataLabelColor = this.getBackground().darker();
        this.pLabelColor = this.getBackground().darker();
        this.pAxisColor = this.getBackground().darker();
        this.dataVisible = true;
        this.dataLabelVisible = false;
        this.pLabelVisible = true;
        this.pAxisVisible = true;
        this.pScaleMin = 0;
        this.pScaleMax = 50;
        this.pAutoScale = true;
        this.models = new Vector();
    }

    protected UiPlotModel getModel(int index) {
        return (UiPlotModel)this.models.get(index);
    }

    protected int getNumberOfModels() {
        return this.models.toArray().length;
    }

    public void addModel(UiPlotModel m) {
        this.models.add(m);
        m.addPlotListener(this);
    }

    public void removeModel(UiPlotModel m) {
        this.models.remove(m);
        m.removePlotListener(this);
    }

    public void setDataLabelColor(Color c) {
        this.dataLabelColor = c;
        this.repaintPlot();
    }

    public Color getDataLabelColor() {
        return this.dataLabelColor;
    }

    public void setPLabelColor(Color c) {
        this.pLabelColor = c;
        this.repaintPlot();
    }

    public Color getPLabelColor() {
        return this.pLabelColor;
    }

    public void setPAxisColor(Color c) {
        this.pAxisColor = c;
        this.repaintPlot();
    }

    public Color getPAxisColor() {
        return this.pAxisColor;
    }

    public void setDataVisible(boolean b) {
        this.dataVisible = b;
        this.repaintPlot();
    }

    public boolean getDataVisible() {
        return this.dataVisible;
    }

    public void setDataLabelVisible(boolean b) {
        this.dataLabelVisible = b;
        this.repaintPlot();
    }

    public boolean getDataLabelVisible() {
        return this.dataLabelVisible;
    }

    public void setPLabelVisible(boolean b) {
        this.pLabelVisible = b;
        this.repaintPlot();
    }

    public boolean getPLabelVisible() {
        return this.pLabelVisible;
    }

    public void setPAxisVisible(boolean b) {
        this.pAxisVisible = b;
        this.repaintPlot();
    }

    public boolean getPAxisVisible() {
        return this.pAxisVisible;
    }

    public void setPScale(int min, int max) {
        this.pAutoScale = false;
        this.pScaleMin = min < 0 ? 0 : min;
        this.pScaleMax = max;
        if (this.pScaleMax <= this.pScaleMin) {
            this.pScaleMax = this.pScaleMin + 1;
        }
        this.repaintPlot();
    }

    public void setPAutoScale(boolean b) {
        this.pAutoScale = b;
        this.repaintPlot();
    }

    protected void doPAutoScale() {
        if (this.pAutoScale) {
            double d = Double.MAX_VALUE;
            int i = 0;
            while (i < this.getNumberOfModels()) {
                d = Math.min(d, (double)((int)((UiPlotModel)this.models.get(i)).getPMin()));
                ++i;
            }
            this.pScaleMin = (int)d;
            d = Double.MIN_VALUE;
            i = 0;
            while (i < this.getNumberOfModels()) {
                d = Math.max(d, (double)((int)((UiPlotModel)this.models.get(i)).getPMax()));
                ++i;
            }
            this.pScaleMax = (int)d;
        }
    }

    public void repaintPlot() {
        this.doPAutoScale();
        this.repaint();
    }

    public void onPlotDataChange(UiPlotEvent e) {
        this.repaintPlot();
    }
}

