/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.ui.control;

import ch.oli4.ui.control.UiControlDouble;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class UiControlWheel
extends UiControlDouble
implements MouseListener,
MouseMotionListener {
    private double minorTickSpacing = 5.0;
    private int dragResolution = 3;
    private boolean clickPulse;
    private static final int clickPeriod = 150;
    private int oldPosition;
    private int orientation;
    public static final int HORIZONTAL = 1;
    public static final int VERTICAL = 2;
    private int hoehe;
    private int breite;
    private int clickShift;
    private int numberOfProfiles;
    private static final int numberOfMovingSteps = 4;
    private int actualMovingStep;

    public UiControlWheel() {
        this.doDataChanged(this.snapData(this.getData()));
        this.setPreferredSize(new Dimension(50, 28));
        this.orientation = 2;
        this.clickPulse = false;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setMinorTickSpacing(double s) {
        this.minorTickSpacing = s;
    }

    public double getMinorTickSpacing() {
        return this.minorTickSpacing;
    }

    public void setDragResolution(int d) {
        this.dragResolution = d;
    }

    public int getDragResolution() {
        return this.dragResolution;
    }

    public void mousePressed(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            this.oldPosition = e.getY();
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.oldPosition != e.getY()) {
            this.doDataChanged(this.getData());
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e) && this.enable) {
            final UiControlWheel w = this;
            Timer clickTimer = new Timer(150, new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    UiControlWheel.this.clickPulse = false;
                    UiControlWheel.this.repaint();
                    UiControlWheel.this.fireValidateEvent(w);
                }
            });
            this.clickPulse = true;
            this.repaint();
            clickTimer.setRepeats(false);
            clickTimer.setCoalesce(true);
            clickTimer.start();
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e) && this.enable) {
            if (e.getY() > this.oldPosition + this.dragResolution) {
                this.goDown();
                this.oldPosition = e.getY();
            } else if (e.getY() < this.oldPosition - this.dragResolution) {
                this.goUp();
                this.oldPosition = e.getY();
            }
        }
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void setOrientation(int o) {
        this.orientation = o;
    }

    public int getOrientation() {
        return this.orientation;
    }

    private void goUp() {
        this.doDataChanging(this.getData() + this.minorTickSpacing);
        this.actualMovingStep = (this.actualMovingStep - 1) % 4;
    }

    private void goDown() {
        this.doDataChanging(this.getData() - this.minorTickSpacing);
        this.actualMovingStep = (this.actualMovingStep + 1) % 4;
    }

    private double snapData(double d) {
        return this.minorTickSpacing * (double)((int)(d / this.minorTickSpacing));
    }

    protected void paintComponent(Graphics g) {
        Color color = this.getForeground();
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        Color lineColor = this.enable ? Color.black : Color.gray;
        if (!this.clickPulse) {
            this.breite = this.getWidth();
            this.hoehe = this.getHeight() - 1;
            this.clickShift = 0;
        } else {
            this.breite = this.getWidth();
            this.hoehe = this.getHeight() - 1;
            this.clickShift = 2;
        }
        this.numberOfProfiles = this.hoehe / 6;
        switch (this.orientation) {
            case 2: {
                g2d.setColor(color);
                g2d.setPaint(new GradientPaint(0.0f, 0.0f, color.brighter(), 0.0f, this.hoehe, color.darker()));
                g2d.fillOval(-this.breite / 2, this.clickShift, this.breite * 2, this.hoehe - 2 * this.clickShift);
                g2d.setPaint(new GradientPaint(0.0f, 0.0f, color, 0.0f, this.hoehe, color.darker().darker().darker()));
                g2d.setStroke(new BasicStroke(1.0f));
                int i = 0;
                while (i < this.numberOfProfiles) {
                    double angle = (double)i * Math.PI / (double)(this.numberOfProfiles * 2);
                    double movingAngle = (double)this.actualMovingStep / (double)(this.numberOfProfiles * 2);
                    g2d.drawOval(-this.breite / 2, (int)((double)this.hoehe - (double)this.hoehe * Math.cos(angle + movingAngle)) / 2 + 1 + this.clickShift, this.breite * 2, (int)((double)this.hoehe * Math.cos(angle)) - 2 - 2 * this.clickShift);
                    ++i;
                }
                g2d.setStroke(new BasicStroke(1.0f));
                g2d.setColor(color.darker().darker());
                g2d.drawArc(-this.breite / 2, this.clickShift, this.breite * 2, this.hoehe - 2 * this.clickShift, 0, 180);
                g2d.setColor(lineColor);
                g2d.drawArc(-this.breite / 2, this.clickShift, this.breite * 2, this.hoehe - 2 * this.clickShift, 180, 180);
                g2d.setColor(this.getBackground());
                g2d.fillRect(-10, 0, 15, this.hoehe);
                g2d.fillRect(this.breite - 5, 0, 10, this.hoehe);
                double lineBorder = 0.057;
                g2d.setColor(color.darker().darker());
                g2d.drawLine(5, (int)(lineBorder * (double)this.hoehe + (double)this.clickShift), 5, (int)((double)this.hoehe - lineBorder * (double)this.hoehe - (double)this.clickShift));
                g2d.drawLine(4, (int)(lineBorder * (double)this.hoehe + 3.0 + (double)this.clickShift), 4, (int)((double)this.hoehe - lineBorder * (double)this.hoehe - 3.0 - (double)this.clickShift));
                g2d.drawLine(3, (int)(lineBorder * (double)this.hoehe + 6.0), 3, (int)((double)this.hoehe - lineBorder * (double)this.hoehe - 6.0));
                g2d.setColor(lineColor);
                g2d.drawLine(this.breite - 5, (int)(lineBorder * (double)this.hoehe + (double)this.clickShift), this.breite - 5, (int)((double)this.hoehe - lineBorder * (double)this.hoehe - (double)this.clickShift));
                g2d.drawLine(this.breite - 4, (int)(lineBorder * (double)this.hoehe + 3.0 + (double)this.clickShift), this.breite - 4, (int)((double)this.hoehe - lineBorder * (double)this.hoehe - 3.0 - (double)this.clickShift));
                g2d.drawLine(this.breite - 3, (int)(lineBorder * (double)this.hoehe + 6.0), this.breite - 3, (int)((double)this.hoehe - lineBorder * (double)this.hoehe - 6.0));
                break;
            }
        }
    }

    public static void main(String[] arg) {
        JFrame f = new JFrame();
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        UiControlWheel c = new UiControlWheel();
        c.setEnabled(true);
        c.setDataRange(0.0, 1.5);
        c.setMinorTickSpacing(0.02);
        c.setForeground(new Color(0xFFFF88));
        p.add((Component)c, "Center");
        f.getContentPane().add(p);
        f.setSize(new Dimension(50, 100));
        f.setVisible(true);
    }
}

