/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.ui.browser;

import ch.oli4.text.Language;
import ch.oli4.ui.UiToolkit;
import ch.oli4.ui.browser.UiHtmlEvent;
import ch.oli4.ui.browser.UiHtmlListener;
import ch.oli4.ui.browser.UiHtmlPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JToolBar;

class UiHtmlToolBar
extends JToolBar
implements UiHtmlListener,
ActionListener {
    private UiHtmlPanel htmlPanel;
    protected JButton backwardButton;
    protected JButton forwardButton;
    protected JButton homeButton;
    protected JLabel urlLabel;
    protected JTextField urlTextField;

    public UiHtmlToolBar(UiHtmlPanel htmlPanel) {
        this.htmlPanel = htmlPanel;
        htmlPanel.addHtmlListener(this);
        this.backwardButton = new JButton(UiToolkit.loadIcon(this, "icons/left.png"));
        this.backwardButton.setToolTipText(Language.getInstance().translate("back"));
        this.backwardButton.addActionListener(this);
        this.add(this.backwardButton);
        this.forwardButton = new JButton(UiToolkit.loadIcon(this, "icons/right.png"));
        this.forwardButton.setToolTipText(Language.getInstance().translate("forward"));
        this.forwardButton.addActionListener(this);
        this.add(this.forwardButton);
        this.addSeparator();
        this.homeButton = new JButton(UiToolkit.loadIcon(this, "icons/home.png"));
        this.homeButton.setToolTipText(Language.getInstance().translate("home"));
        this.homeButton.addActionListener(this);
        this.add(this.homeButton);
        this.addSeparator();
        this.urlLabel = new JLabel(" URL ");
        this.add(this.urlLabel);
        this.urlTextField = new JTextField();
        this.urlTextField.addActionListener(this);
        this.add(this.urlTextField);
        this.setFloatable(false);
    }

    public void setUrlEditable(boolean b) {
        this.urlLabel.setVisible(b);
        this.urlTextField.setVisible(b);
    }

    public void historyChanged(UiHtmlEvent e) {
        this.backwardButton.setEnabled(this.htmlPanel.isBackwardAvailable());
        this.forwardButton.setEnabled(this.htmlPanel.isForwardAvailable());
        this.urlTextField.setText(e.getURL().toString());
    }

    public void possibleLinkChanged(UiHtmlEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.backwardButton) {
            this.htmlPanel.goBackward();
        } else if (e.getSource() == this.forwardButton) {
            this.htmlPanel.goForward();
        } else if (e.getSource() == this.homeButton) {
            this.htmlPanel.goHome();
        } else if (e.getSource() == this.urlTextField) {
            try {
                this.htmlPanel.setPage(new URL(((JTextField)e.getSource()).getText()));
            }
            catch (MalformedURLException ue) {
                ue.printStackTrace();
            }
        }
    }
}

