/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.ui;

import java.applet.AudioClip;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

public class UiSound {
    private AudioClip loopClip;
    private AudioClip endClip;
    private Timer loopTimer;
    private boolean looping;

    public UiSound(AudioClip loopClip, AudioClip endClip) {
        this.loopClip = loopClip;
        this.endClip = endClip;
        this.looping = false;
    }

    public void play() {
        this.play(0);
    }

    public void play(int loopTime) {
        if (loopTime == 0) {
            this.endClip.play();
        } else {
            this.loop();
            this.loopTimer = new Timer(loopTime, new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    UiSound.this.loopTimer.stop();
                    UiSound.this.stop();
                }
            });
            this.loopTimer.setRepeats(true);
            this.loopTimer.setCoalesce(true);
            this.loopTimer.start();
        }
    }

    public void loop() {
        if (!this.looping) {
            this.looping = true;
            this.loopClip.loop();
        }
    }

    public void stop() {
        if (this.looping) {
            this.looping = false;
            this.endClip.play();
            this.loopClip.stop();
        }
    }

    public static void main(String[] arg) {
    }
}

