/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.trace;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

public class Trace {
    private static Trace trace;
    private List entries = new LinkedList();
    private int maxNumberOfEntries = 10000;
    private int verboseLevel = 0;
    private static DateFormat dateFormat;
    private OutputStream outputStream;
    private static final byte[] b0;
    private static final byte[] b1;
    private static final byte[] b2;
    private int autoFlushBlockSize = 0;

    static {
        dateFormat = DateFormat.getDateTimeInstance(2, 2, Locale.GERMAN);
        b0 = "<e t=\"".getBytes();
        b1 = "\" m=\"".getBytes();
        b2 = "\"/>\r\n".getBytes();
    }

    private Trace() {
    }

    public static Trace getInstance() {
        if (trace == null) {
            trace = new Trace();
        }
        return trace;
    }

    public int getMaxNumberOfBufferedEntries() {
        return this.maxNumberOfEntries;
    }

    public void setMaxNumberOfBufferedEntries(int maxNumberOfEntries) {
        this.maxNumberOfEntries = maxNumberOfEntries;
    }

    private void tryToFlush() {
        if (this.autoFlushBlockSize > 0 && this.entries.size() >= this.autoFlushBlockSize) {
            this.flush();
        }
    }

    public void addEntry(String message) {
        if (this.entries.size() < this.maxNumberOfEntries) {
            this.entries.add(new TraceEntry(message));
            this.tryToFlush();
        } else if (this.entries.size() == this.maxNumberOfEntries) {
            this.entries.add(new TraceEntry("..."));
        }
    }

    public void addEntry(int level, String message) {
        if (this.isVerboseLevel(level)) {
            this.addEntry(message);
        }
    }

    public void addEntry(Throwable exception) {
        if (this.entries.size() < this.maxNumberOfEntries) {
            StringBuffer sb = new StringBuffer();
            sb.append(exception.toString());
            this.entries.add(new TraceEntry(new String(sb)));
            this.tryToFlush();
        } else if (this.entries.size() == this.maxNumberOfEntries) {
            this.entries.add(new TraceEntry("..."));
        }
    }

    public void addEntry(int level, Throwable exception) {
        if (this.isVerboseLevel(level)) {
            this.addEntry(exception);
        }
    }

    public void setVerboseLevel(int level) {
        this.verboseLevel = level;
        this.addEntry("set trace verbose-level " + level);
    }

    public boolean isVerboseLevel(int level) {
        return level <= this.verboseLevel;
    }

    public static String timeStampToString(long timeStamp) {
        return dateFormat.format(new Date(timeStamp));
    }

    public void flush() {
        try {
            while (this.entries.size() > 0) {
                TraceEntry e = (TraceEntry)this.entries.remove(0);
                this.outputStream.write(b0);
                this.outputStream.write(Trace.timeStampToString(e.timeStamp).getBytes());
                this.outputStream.write(b1);
                this.outputStream.write(e.message.getBytes());
                this.outputStream.write(b2);
            }
            this.outputStream.flush();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void setAutoFlushBlockSize(int blockSize) {
        this.autoFlushBlockSize = blockSize;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(OutputStream os) {
        this.outputStream = os;
    }

    public void setOutputFile(String fileName) {
        if (fileName != null) {
            try {
                File f = new File(fileName);
                if ((double)f.length() > 1.0E7) {
                    f.delete();
                }
                f.createNewFile();
                this.setOutputStream(new FileOutputStream(f, true));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public class TraceEntry {
        public long timeStamp = System.currentTimeMillis();
        public String message;

        public TraceEntry(String message) {
            this.message = message;
        }
    }
}

