/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.os;

import ch.oli4.os.OStatemachine;
import ch.oli4.os.OTimer;
import ch.oli4.os.OTimerListener;

class OTest
implements OTimerListener {
    private OStatemachine sm;
    private OStatemachine.State init;
    private OStatemachine.State halt;
    private OStatemachine.State accelerate;
    private OStatemachine.State run;
    private OStatemachine.State deccelerate;
    private OStatemachine.Event timeout;
    private OStatemachine.Event signal;
    private boolean running = false;
    private OTimer t1 = new OTimer(this);

    public void onTimeout(OTimer timer) {
        this.sm.step(this.timeout);
    }

    public OTest() {
        this.sm = new OStatemachine("machine");
        this.sm.setVerbose(true);
        this.sm.setVerboseStream(System.out);
        this.init = new StInit("init");
        this.halt = new StHalt("halt");
        this.accelerate = new StAccelerate("accelerate");
        this.run = new StRun("run");
        this.deccelerate = new StDeccelerate("deccelerate");
        this.timeout = new OStatemachine.Event("timeout");
        this.signal = new OStatemachine.Event("signal");
        this.sm.addState(this.init);
        this.sm.addState(this.halt);
        this.sm.addState(this.accelerate);
        this.sm.addState(this.run);
        this.sm.addState(this.deccelerate);
        this.sm.start();
        try {
            Thread.sleep(2000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.running = true;
        this.sm.step(this.signal);
        try {
            Thread.sleep(5000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.running = false;
        this.sm.step(this.signal);
        try {
            Thread.sleep(5000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.running = true;
        this.sm.step(this.signal);
        try {
            Thread.sleep(500L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.running = false;
        this.sm.step(this.signal);
        try {
            Thread.sleep(50L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.running = true;
        this.sm.step(this.signal);
    }

    public static void main(String[] arg) {
        new OTest();
    }

    class StAccelerate
    extends OStatemachine.State {
        public StAccelerate(String name) {
            super(name);
        }

        public void entry() {
            OTest.this.t1.start(2000);
        }

        public OStatemachine.State transit(OStatemachine.Event event) {
            if (!OTest.this.running) {
                return OTest.this.deccelerate;
            }
            if (event == OTest.this.timeout) {
                return OTest.this.run;
            }
            return null;
        }

        public void exit() {
            OTest.this.t1.stop();
        }
    }

    class StDeccelerate
    extends OStatemachine.State {
        public StDeccelerate(String name) {
            super(name);
        }

        public void entry() {
            OTest.this.t1.start(1000);
        }

        public OStatemachine.State transit(OStatemachine.Event event) {
            if (event == OTest.this.timeout) {
                return OTest.this.halt;
            }
            return null;
        }

        public void exit() {
            OTest.this.t1.stop();
        }
    }

    class StHalt
    extends OStatemachine.State {
        public StHalt(String name) {
            super(name);
        }

        public void entry() {
        }

        public OStatemachine.State transit(OStatemachine.Event event) {
            if (OTest.this.running) {
                return OTest.this.accelerate;
            }
            return null;
        }

        public void exit() {
        }
    }

    class StInit
    extends OStatemachine.State {
        public StInit(String name) {
            super(name);
        }

        public void entry() {
        }

        public OStatemachine.State transit(OStatemachine.Event event) {
            return OTest.this.halt;
        }

        public void exit() {
        }
    }

    class StRun
    extends OStatemachine.State {
        public StRun(String name) {
            super(name);
        }

        public void entry() {
        }

        public OStatemachine.State transit(OStatemachine.Event event) {
            if (!OTest.this.running) {
                return OTest.this.deccelerate;
            }
            return null;
        }

        public void exit() {
        }
    }
}

