/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.mmedia;

import ch.oli4.mmedia.MPanel;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;

class MImageCache {
    private MPanel panel;
    private List<String> history;
    private Map<String, ImageIcon> images;
    private int maxLength = 20;

    public MImageCache(MPanel panel, int maxLength) {
        this.panel = panel;
        this.maxLength = maxLength;
        this.history = new LinkedList<String>();
        this.images = new HashMap<String, ImageIcon>();
    }

    public ImageIcon get(String name) {
        ImageIcon i;
        if (!this.images.containsKey(name)) {
            i = this.createImage(name);
            this.images.put(name, i);
            this.history.add(name);
            if (this.history.size() > this.maxLength) {
                String n = this.history.remove(0);
                this.images.remove(n);
            }
        } else {
            i = this.images.get(name);
        }
        return i;
    }

    private ImageIcon createImage(String name) {
        ImageIcon i = new ImageIcon(name);
        if (this.panel.getScaleFactor() != 1.0) {
            ImageIcon i2 = new ImageIcon(i.getImage().getScaledInstance((int)((double)i.getIconWidth() * this.panel.getScaleFactor()), (int)((double)i.getIconHeight() * this.panel.getScaleFactor()), 2));
            return i2;
        }
        return i;
    }

    public void dispose() {
        this.images.clear();
        this.history.clear();
    }
}

