/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.io.hexfile;

import ch.oli4.io.hexfile.HexRecData;
import ch.oli4.io.hexfile.HexRecEof;
import ch.oli4.io.hexfile.HexRecExtLinAddr;

public class HexRecord {
    protected int dataLength;
    protected int address;
    protected int type;
    public static final int DATA_TYPE = 0;
    public static final int EOF_TYPE = 1;
    public static final int EXT_LIN_ADDR_TYPE = 4;
    protected int[] data;
    protected int checksum;
    protected static final char bor = ':';

    protected HexRecord(int dataLength, int address, int type, int[] data, int checksum) {
        this.dataLength = dataLength;
        this.address = address;
        this.type = type;
        this.data = data;
        this.checksum = checksum;
    }

    public static HexRecord parse(byte[] d, int offset, int length) {
        int dataLength = HexRecord.byte2ToInt(d[offset + 1], d[offset + 2]);
        int address = HexRecord.byte4ToInt(d[offset + 3], d[offset + 4], d[offset + 5], d[offset + 6]);
        int type = HexRecord.byte2ToInt(d[offset + 7], d[offset + 8]);
        int[] data = new int[dataLength];
        int i = 0;
        while (i < dataLength) {
            data[i] = HexRecord.byte2ToInt(d[offset + 9 + i * 2], d[offset + 10 + i * 2]);
            ++i;
        }
        int checksum = HexRecord.byte2ToInt(d[offset + 9 + dataLength * 2], d[offset + 10 + dataLength * 2]);
        switch (type) {
            case 0: {
                return new HexRecData(dataLength, address, type, data, checksum);
            }
            case 1: {
                return new HexRecEof(dataLength, address, type, data, checksum);
            }
            case 4: {
                return new HexRecExtLinAddr(dataLength, address, type, data, checksum);
            }
        }
        return new HexRecord(dataLength, address, type, data, checksum);
    }

    protected static int byte2ToInt(byte b1, byte b0) {
        byte[] b = new byte[]{b1, b0};
        return Integer.parseInt(new String(b), 16);
    }

    protected static int byte4ToInt(byte b3, byte b2, byte b1, byte b0) {
        byte[] b = new byte[]{b3, b2, b1, b0};
        return Integer.parseInt(new String(b), 16);
    }

    protected static void intToByte2(int i, byte[] b, int offset) {
        String s = Integer.toHexString(i);
        if (s.length() == 1) {
            s = "0" + s;
        }
        byte[] sb = s.getBytes();
        int j = 0;
        while (j < sb.length) {
            b[offset + j] = sb[j];
            ++j;
        }
    }

    protected static void intToByte4(int i, byte[] b, int offset) {
        String s = Integer.toHexString(i);
        if (s.length() == 1) {
            s = "000" + s;
        } else if (s.length() == 2) {
            s = "00" + s;
        } else if (s.length() == 3) {
            s = "0" + s;
        }
        byte[] sb = s.getBytes();
        int j = 0;
        while (j < sb.length) {
            b[offset + j] = sb[j];
            ++j;
        }
    }

    public int getType() {
        return this.type;
    }

    public boolean isSameType(HexRecord r) {
        return r.getType() == this.type;
    }

    public boolean isEofType() {
        return this.type == 1;
    }

    public boolean isExtLinAddrType() {
        return this.type == 4;
    }

    public boolean isDataType() {
        return this.type == 0;
    }

    public static char getBeginOfRecord() {
        return ':';
    }

    public int toBytes(byte[] d) {
        d[0] = 58;
        HexRecord.intToByte2(this.dataLength, d, 1);
        HexRecord.intToByte4(this.address, d, 3);
        HexRecord.intToByte2(this.type, d, 7);
        int i = 0;
        while (i < this.dataLength) {
            HexRecord.intToByte2(this.data[i], d, 9 + 2 * i);
            ++i;
        }
        HexRecord.intToByte2(this.checksum, d, 9 + this.dataLength * 2);
        d[11 + this.dataLength * 2] = 13;
        d[12 + this.dataLength * 2] = 10;
        return this.dataLength * 2 + 13;
    }

    public String toString() {
        byte[] b = new byte[200];
        return new String(b, 0, this.toBytes(b));
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public int getAddress() {
        return this.address;
    }

    public int[] getData() {
        return this.data;
    }

    public int getChecksum() {
        return this.checksum;
    }

    public boolean isKnownRecord() {
        return this.type == 0 || this.type == 1 || this.type == 4;
    }

    protected void generateChecksum() {
        int chk = 0;
        chk += this.dataLength & 0xFF;
        chk += this.address >> 8 & 0xFF;
        chk += this.address & 0xFF;
        chk += this.type & 0xFF;
        int i = 0;
        while (i < this.data.length) {
            chk += this.data[i] & 0xFF;
            ++i;
        }
        chk = ~chk + 1;
        this.checksum = chk & 0xFF;
    }
}

