/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.io.hexfile;

import ch.oli4.io.hexfile.HexFile;
import ch.oli4.io.hexfile.HexRecExtLinAddr;
import ch.oli4.io.hexfile.HexRecord;

public class HexMemory {
    public void eraseMemory(byte clearValue, byte[] memory, int offset, int length) {
        int i = offset;
        while (i < offset + length) {
            memory[i] = clearValue;
            ++i;
        }
    }

    public void fillMemory(HexFile hexFile, byte[] memory, int offset, int length) {
        int extLinAddr = 0;
        int recordAddr = 0;
        int i = 0;
        while (i < hexFile.getNumberOfRecords()) {
            HexRecord r = hexFile.getRecord(i);
            if (r.isExtLinAddrType()) {
                extLinAddr = ((HexRecExtLinAddr)r).getExtendedLinearAddress() << 16;
            } else if (r.isDataType()) {
                recordAddr = r.getAddress();
                int j = 0;
                while (j < r.getDataLength()) {
                    int addr = extLinAddr + recordAddr + j;
                    if (addr >= offset && addr < offset + length) {
                        memory[addr] = (byte)(r.getData()[j] & 0xFF);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private String toI32Hex(int i) {
        return new String(String.valueOf(Integer.toString(i & 0xFFFFFFFF, 16)) + "h");
    }

    private String toI16Hex(int i) {
        return new String(String.valueOf(Integer.toString(i & 0xFFFF, 16)) + "h");
    }

    private String toI8Hex(int i) {
        return new String(String.valueOf(Integer.toString(i & 0xFF, 16)) + "h");
    }

    private void pAddr(byte[] memory, int addr) {
        System.out.println("addr:" + this.toI32Hex(addr) + " data:" + this.toI8Hex(memory[addr]));
    }
}

