/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class Base64InputStream
extends FilterInputStream {
    private int converter;
    private byte[] inGroup = new byte[4];
    private byte[] outGroup = new byte[3];
    private int outGroupLength = 0;
    private int outGroupIndex = 0;
    private static final char padding = '=';
    private static final byte[] decodingTable;

    static {
        byte[] byArray = new byte[123];
        byArray[43] = 62;
        byArray[47] = 63;
        byArray[48] = 52;
        byArray[49] = 53;
        byArray[50] = 54;
        byArray[51] = 55;
        byArray[52] = 56;
        byArray[53] = 57;
        byArray[54] = 58;
        byArray[55] = 59;
        byArray[56] = 60;
        byArray[57] = 61;
        byArray[66] = 1;
        byArray[67] = 2;
        byArray[68] = 3;
        byArray[69] = 4;
        byArray[70] = 5;
        byArray[71] = 6;
        byArray[72] = 7;
        byArray[73] = 8;
        byArray[74] = 9;
        byArray[75] = 10;
        byArray[76] = 11;
        byArray[77] = 12;
        byArray[78] = 13;
        byArray[79] = 14;
        byArray[80] = 15;
        byArray[81] = 16;
        byArray[82] = 17;
        byArray[83] = 18;
        byArray[84] = 19;
        byArray[85] = 20;
        byArray[86] = 21;
        byArray[87] = 22;
        byArray[88] = 23;
        byArray[89] = 24;
        byArray[90] = 25;
        byArray[97] = 26;
        byArray[98] = 27;
        byArray[99] = 28;
        byArray[100] = 29;
        byArray[101] = 30;
        byArray[102] = 31;
        byArray[103] = 32;
        byArray[104] = 33;
        byArray[105] = 34;
        byArray[106] = 35;
        byArray[107] = 36;
        byArray[108] = 37;
        byArray[109] = 38;
        byArray[110] = 39;
        byArray[111] = 40;
        byArray[112] = 41;
        byArray[113] = 42;
        byArray[114] = 43;
        byArray[115] = 44;
        byArray[116] = 45;
        byArray[117] = 46;
        byArray[118] = 47;
        byArray[119] = 48;
        byArray[120] = 49;
        byArray[121] = 50;
        byArray[122] = 51;
        decodingTable = byArray;
    }

    public Base64InputStream(InputStream in) {
        super(in);
    }

    public int read() throws IOException {
        if (this.outGroupIndex == this.outGroupLength) {
            this.inGroup[0] = (byte)this.in.read();
            this.inGroup[1] = (byte)this.in.read();
            this.inGroup[2] = (byte)this.in.read();
            this.inGroup[3] = (byte)this.in.read();
            if (this.inGroup[0] == -1) {
                return -1;
            }
            this.converter = 0;
            int nonPaddingCounter = 0;
            if (this.inGroup[0] != 61 && this.inGroup[0] != -1) {
                this.converter |= (decodingTable[this.inGroup[0]] & 0x3F) << 18;
                ++nonPaddingCounter;
                if (this.inGroup[1] != 61 && this.inGroup[1] != -1) {
                    this.converter |= (decodingTable[this.inGroup[1]] & 0x3F) << 12;
                    ++nonPaddingCounter;
                    if (this.inGroup[2] != 61 && this.inGroup[2] != -1) {
                        this.converter |= (decodingTable[this.inGroup[2]] & 0x3F) << 6;
                        ++nonPaddingCounter;
                        if (this.inGroup[3] != 61 && this.inGroup[3] != -1) {
                            this.converter |= (decodingTable[this.inGroup[3]] & 0x3F) << 0;
                            ++nonPaddingCounter;
                        }
                    }
                }
            }
            switch (nonPaddingCounter) {
                case 3: 
                case 4: {
                    this.outGroup[0] = (byte)(this.converter >> 16 & 0xFF);
                    this.outGroup[1] = (byte)(this.converter >> 8 & 0xFF);
                    this.outGroup[2] = (byte)(this.converter & 0xFF);
                    this.outGroupLength = 3;
                    break;
                }
                case 2: {
                    this.outGroup[0] = (byte)(this.converter >> 16 & 0xFF);
                    this.outGroup[1] = (byte)(this.converter >> 8 & 0xFF);
                    this.outGroupLength = 2;
                    break;
                }
                case 1: {
                    this.outGroup[0] = (byte)(this.converter >> 16 & 0xFF);
                    this.outGroupLength = 1;
                }
            }
            this.outGroupIndex = 0;
        }
        return this.outGroup[this.outGroupIndex++];
    }
}

