/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.ui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public abstract class GToolkit {
    public static ImageIcon loadIcon(Object object, String string) {
        URL uRL = object.getClass().getResource(string);
        if (uRL == null && (uRL = object.getClass().getResource(string + ".gif")) == null && (uRL = object.getClass().getResource(string + ".png")) == null) {
            uRL = object.getClass().getResource(string + ".jpg");
        }
        if (uRL != null) {
            return new ImageIcon(uRL);
        }
        return null;
    }

    public static Cursor createCustomCursor(Object object, String string) {
        try {
            Dimension dimension = Toolkit.getDefaultToolkit().getBestCursorSize(32, 32);
            int n = Toolkit.getDefaultToolkit().getMaximumCursorColors();
            Image image = null;
            switch (dimension.width) {
                case 32: {
                    image = GToolkit.loadIcon(object, string + "32").getImage();
                    break;
                }
                case 64: {
                    image = GToolkit.loadIcon(object, string + "64").getImage();
                    break;
                }
                default: {
                    return new Cursor(0);
                }
            }
            if (image == null) {
                return new Cursor(0);
            }
            Point point = new Point(4, 4);
            return Toolkit.getDefaultToolkit().createCustomCursor(image, point, string);
        }
        catch (Exception exception) {
            return new Cursor(0);
        }
    }

    public static Color mixColors(Color color, Color color2, float f) {
        float[] fArray = color.getRGBComponents(null);
        float[] fArray2 = color2.getRGBComponents(null);
        for (int i = 0; i < 4; ++i) {
            fArray[i] = fArray[i] * (1.0f - f) + fArray2[i] * f;
        }
        return new Color(fArray[0], fArray[1], fArray[2], fArray[3]);
    }

    public static Color setGamma(Color color, float f) {
        float[] fArray = color.getRGBComponents(null);
        if (f <= 0.5f) {
            for (int i = 0; i < 3; ++i) {
                fArray[i] = fArray[i] * f * 2.0f;
            }
        } else {
            for (int i = 0; i < 3; ++i) {
                float f2 = f * 2.0f - 1.0f;
                fArray[i] = fArray[i] * (1.0f - f2) + f2;
            }
        }
        return new Color(fArray[0], fArray[1], fArray[2]);
    }

    public static Color setSaturation(Color color, float f) {
        float[] fArray = color.getRGBComponents(null);
        float f2 = (fArray[0] + fArray[1] + fArray[2]) / 3.0f;
        for (int i = 0; i < 3; ++i) {
            fArray[i] = fArray[i] * f + f2 * (1.0f - f);
        }
        return new Color(fArray[0], fArray[1], fArray[2]);
    }

    public static String getFileExtension(File file) {
        String string = file.getName();
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return null;
        }
        String string2 = string.substring(n + 1);
        return string2;
    }

    public static String getFileDotExtension(File file) {
        String string = file.getName();
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return null;
        }
        String string2 = string.substring(n);
        return string2;
    }

    public static boolean isShiftKey(MouseEvent mouseEvent) {
        return mouseEvent.isShiftDown();
    }

    public static boolean isShiftKey(ActionEvent actionEvent) {
        return (actionEvent.getModifiers() & 1) != 0;
    }

    public static boolean isCtrlKey(MouseEvent mouseEvent) {
        if (System.getProperty("os.name").toLowerCase().contains("mac")) {
            return mouseEvent.isMetaDown();
        }
        return mouseEvent.isControlDown();
    }

    public static boolean isCtrlKey(ActionEvent actionEvent) {
        if (System.getProperty("os.name").toLowerCase().contains("mac")) {
            return (actionEvent.getModifiers() & 4) != 0;
        }
        return (actionEvent.getModifiers() & 2) != 0;
    }

    public static boolean isAltKey(MouseEvent mouseEvent) {
        return mouseEvent.isAltDown();
    }

    public static boolean isAltKey(ActionEvent actionEvent) {
        return (actionEvent.getModifiers() & 8) != 0;
    }

    public static boolean isButton1(MouseEvent mouseEvent) {
        return (mouseEvent.getModifiers() & 0x10) != 0;
    }

    public static boolean isButton2(MouseEvent mouseEvent) {
        return (mouseEvent.getModifiers() & 8) != 0;
    }

    public static boolean isButton3(MouseEvent mouseEvent) {
        return (mouseEvent.getModifiers() & 4) != 0;
    }

    public static String getLaoeInstallationPath() {
        return System.getProperty("user.dir") + System.getProperty("file.separator");
    }

    public static String getLaoeUserHomePath() {
        return System.getProperty("user.home") + System.getProperty("file.separator") + ".laoe" + System.getProperty("file.separator");
    }

    public static void setFrameInMiddleOfScreen(JFrame jFrame) {
        Dimension dimension = jFrame.getSize();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        jFrame.setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
    }
}

