/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.ui;

import ch.laoe.operation.AOToolkit;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GToolkit;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class GColorPicker
extends JButton
implements MouseListener {
    private JFrame frame;
    private ColorPanel colorPanel;
    private Color selectedColor;

    public GColorPicker(String string, String string2) {
        super(string);
        this.frame = new JFrame(string2);
        this.colorPanel = new ColorPanel(this);
        this.frame.getContentPane().add(this.colorPanel);
        this.frame.setResizable(false);
        this.frame.setAlwaysOnTop(true);
        this.frame.pack();
        this.selectedColor = Color.BLUE;
        this.addMouseListener(this);
        this.setBackground(this.selectedColor);
        this.setEnabled(false);
    }

    private void updateRootComponent(boolean bl) {
        this.frame.setVisible(false);
        this.setBackground(this.selectedColor);
        this.validate();
        this.repaint();
        Debug.println(6, this.frame.getTitle() + " color picked = 0x" + Integer.toHexString(this.selectedColor.getRGB()));
        if (bl) {
            this.fireActionPerformed(new ActionEvent(this, 0, "color chosen"));
        }
    }

    public Color getSelectedColor() {
        return this.selectedColor;
    }

    public void setSelectedColor(Color color) {
        this.selectedColor = color;
        this.updateRootComponent(false);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.frame.setLocationRelativeTo(this);
        this.frame.setVisible(true);
    }

    private class ColorPanel
    extends JLabel
    implements MouseListener {
        private GColorPicker chooser;
        private final float[] rCurve = new float[]{1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f};
        private final float[] gCurve = new float[]{0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        private final float[] bCurve = new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f};

        public ColorPanel(GColorPicker gColorPicker2) {
            this.chooser = gColorPicker2;
            this.setPreferredSize(new Dimension(333, 155));
            this.setCursor(Cursor.getPredefinedCursor(1));
            this.addMouseListener(this);
        }

        @Override
        public void paintComponent(Graphics graphics) {
            int n = 128;
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n; ++j) {
                    float f = (float)i / (float)n;
                    float f2 = (float)j / (float)n;
                    graphics.setColor(this.coordToColor(f, f2));
                    graphics.fillRect(this.getWidth() * i / n, this.getHeight() * j / n, this.getWidth() / n + 1, this.getHeight() / n + 1);
                }
            }
        }

        private Color coordToColor(float f, float f2) {
            int n = ((int)(AOToolkit.interpolate1(this.rCurve, f * 8.0f) * 255.0f) << 16) + ((int)(AOToolkit.interpolate1(this.gCurve, f * 8.0f) * 255.0f) << 8) + ((int)(AOToolkit.interpolate1(this.bCurve, f * 8.0f) * 255.0f) << 0);
            return GToolkit.setGamma(new Color(n), (float)Math.pow(f2, 1.0));
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.chooser.selectedColor = this.coordToColor((float)mouseEvent.getX() / (float)this.getWidth(), (float)mouseEvent.getY() / (float)this.getHeight());
            this.chooser.updateRootComponent(true);
        }
    }
}

