/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.ui;

import ch.laoe.audio.Audio;
import ch.laoe.audio.AudioException;
import ch.laoe.clip.AClip;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GClipFrame;
import ch.laoe.ui.GClipPanel;
import ch.laoe.ui.Laoe;
import java.awt.BorderLayout;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;

public class GClipEditor
extends GClipPanel
implements Runnable,
MouseListener,
MouseMotionListener,
MouseWheelListener,
KeyListener {
    protected Thread thread;
    private boolean running;
    private int whenInactiveCounter;
    private static final int numberOfRepaintWhenInactive = 40;

    public GClipEditor(GClipFrame gClipFrame, AClip aClip) {
        super(aClip);
        this.setLayout(new BorderLayout());
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        gClipFrame.setJMenuBar(Laoe.getInstance().getPluginHandler().createClipMenuBar());
        this.thread = new Thread(this);
        this.running = true;
        this.thread.start();
        this.addKeyListener(this);
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                this.whenInactiveCounter = this.clip.getAudio().isActive() ? 40 : --this.whenInactiveCounter;
                if (this.whenInactiveCounter >= 0) {
                    Laoe.getInstance().getFocussedClipFrame().getStatusBar().update();
                    this.repaint();
                }
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                Debug.printStackTrace(6, exception);
            }
        }
    }

    public void destroy() {
        this.running = false;
        this.clip.destroy();
    }

    @Override
    protected void paintFullClip(Graphics2D graphics2D) {
        Debug.println(7, "clip editor " + this.getClip().getName() + ", paint when clip changed ");
        Rectangle rectangle = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        this.clipPlotter.paintFullClip(this.bgGraphics, rectangle);
    }

    @Override
    protected void paintTopComponentsOnly(Graphics2D graphics2D) {
        Debug.println(7, "clip editor " + this.getClip().getName() + ", paint clip always ");
        Rectangle rectangle = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        this.clipPlotter.paintDetailsOfSelectedLayer(graphics2D, rectangle);
        graphics2D.setClip(rectangle);
        Laoe.getInstance().getPluginHandler().paintOntoClip(graphics2D, rectangle);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (!mouseEvent.isPopupTrigger() && !this.isButton2Or3(mouseEvent)) {
            Laoe.getInstance().getPluginHandler().mouseClicked(mouseEvent);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (!mouseEvent.isPopupTrigger() && !this.isButton2Or3(mouseEvent)) {
            Laoe.getInstance().getPluginHandler().mouseEntered(mouseEvent);
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (!mouseEvent.isPopupTrigger() && !this.isButton2Or3(mouseEvent)) {
            Laoe.getInstance().getPluginHandler().mouseExited(mouseEvent);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (!mouseEvent.isPopupTrigger() && !this.isButton2Or3(mouseEvent)) {
            Laoe.getInstance().getPluginHandler().mousePressed(mouseEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!mouseEvent.isPopupTrigger() && !this.isButton2Or3(mouseEvent)) {
            Laoe.getInstance().getPluginHandler().mouseReleased(mouseEvent);
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.isFocussed() && !mouseEvent.isPopupTrigger() && !this.isButton2Or3(mouseEvent)) {
            Laoe.getInstance().getPluginHandler().mouseMoved(mouseEvent);
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (!mouseEvent.isPopupTrigger() && !this.isButton2Or3(mouseEvent)) {
            Laoe.getInstance().getPluginHandler().mouseDragged(mouseEvent);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (!mouseWheelEvent.isPopupTrigger() && !this.isButton2Or3(mouseWheelEvent)) {
            Laoe.getInstance().getPluginHandler().mouseWheelMoved(mouseWheelEvent);
        }
    }

    private boolean isFocussed() {
        return Laoe.getInstance().getFocussedClipEditor() == this;
    }

    private boolean isButton2Or3(MouseEvent mouseEvent) {
        return false;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        Audio audio = this.clip.getAudio();
        switch (keyEvent.getKeyCode()) {
            case 77: {
                Debug.println(1, "plugin " + this.getName() + " m key pressed");
                this.clip.getSelectedLayer().getSelectedChannel().getMarker().addMarker(audio.getPlayPointer());
                this.repaint();
                break;
            }
            case 32: {
                try {
                    Debug.println(1, "plugin " + this.getName() + " space key pressed");
                    if (!audio.isActive()) {
                        audio.play();
                        break;
                    }
                    audio.pause();
                }
                catch (AudioException audioException) {
                    Debug.printStackTrace(1, audioException);
                }
                break;
            }
            case 37: {
                Debug.println(1, "plugin " + this.getName() + " left arrow key pressed");
                audio.stop();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }
}

