/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.ui;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;

public class Debug {
    private static int verboseLevel = 0;
    private static int lineCounter = 0;
    private static boolean timeStampEnable = false;
    private static DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2, Locale.GERMAN);
    private static File outputFile = null;
    private static FileOutputStream fOutputStream;
    private static PrintStream pOutputStream;

    public static void setVerboseLevel(int n) {
        verboseLevel = n;
    }

    public static void setOutputFile(String string) {
        if (string != null) {
            try {
                outputFile = new File(string);
                if ((double)outputFile.length() > 1.0E7) {
                    outputFile.delete();
                }
                outputFile.createNewFile();
                fOutputStream = new FileOutputStream(outputFile, true);
                pOutputStream = new PrintStream(fOutputStream);
                System.setOut(pOutputStream);
                System.setErr(pOutputStream);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void setTimeStampEnabled(boolean bl) {
        timeStampEnable = bl;
    }

    public static void println(int n, String string) {
        if (verboseLevel != 0) {
            if (lineCounter++ == 0) {
                System.out.println("debug logging:");
                if (timeStampEnable) {
                    System.out.println("date");
                    System.out.println("|          time");
                    System.out.println("|          |         level");
                    System.out.println("|          |         |  text");
                    System.out.println("|          |         |  |");
                } else {
                    System.out.println("level");
                    System.out.println("| text");
                    System.out.println("|  |");
                }
            }
            if (n <= verboseLevel) {
                if (timeStampEnable) {
                    System.out.print(dateFormat.format(new Date()) + "  ");
                }
                System.out.print("" + n + "  ");
                System.out.println(string);
            }
        }
    }

    public static void printStackTrace(int n, Exception exception) {
        if (verboseLevel != 0 && n <= verboseLevel) {
            if (timeStampEnable) {
                System.out.print(dateFormat.format(new Date()) + "  ");
            }
            System.out.println("" + n + " exception thrown below:");
            exception.printStackTrace();
        }
    }
}

