/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.plugin;

import ch.laoe.audio.Audio;
import ch.laoe.audio.AudioException;
import ch.laoe.audio.AudioListener;
import ch.laoe.clip.AChannel;
import ch.laoe.clip.AChannelPlotter;
import ch.laoe.clip.AChannelSelection;
import ch.laoe.clip.AClip;
import ch.laoe.clip.ALayer;
import ch.laoe.plugin.GPMeasure;
import ch.laoe.plugin.GPluginFrame;
import ch.laoe.plugin.GPluginHandler;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GClipPanel;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.GToolkit;
import ch.oli4.persistence.Persistence;
import ch.oli4.ui.UiCartesianLayout;
import ch.oli4.ui.control.UiControlEvent;
import ch.oli4.ui.control.UiControlListener;
import ch.oli4.ui.control.UiControlText;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class GPPlayLoopRec
extends GPluginFrame {
    private int selectedPointer;
    private static final int NO_POINTER = 0;
    private static final int LOOP_START_POINTER = 1;
    private static final int LOOP_END_POINTER = 2;
    private Cursor defaultCursor;
    private Cursor placeCursor;
    private Cursor scratchCursor;
    private JButton stopButton;
    private JButton pauseButton;
    private JButton rewButton;
    private JButton playButton;
    private JButton forwButton;
    private JButton recButton;
    private JCheckBox loop;
    private JCheckBox autoGrow;
    private ImageIcon pausePassive;
    private ImageIcon pauseActive;
    private ImageIcon playPassive;
    private ImageIcon playActive;
    private ImageIcon recPassive;
    private ImageIcon recActive;
    private UiControlText sampleRate;
    private UiControlText playBlockSize;
    private UiControlText captureBlockSize;
    private UiControlText playPointerAdjustment;
    private UiControlText capturePointerAdjustment;
    private JComboBox loopPointerSettings;
    private EventDispatcher eventDispatcher;

    public GPPlayLoopRec(GPluginHandler gPluginHandler) {
        super(gPluginHandler);
        this.initCursors();
        this.initGui();
    }

    @Override
    public void onBackup(Persistence persistence) {
        super.onBackup(persistence);
        persistence.setInt("plugin." + this.getName() + ".playBlockSize", Audio.getPlayBlockSize());
        persistence.setInt("plugin." + this.getName() + ".captureBlockSize", Audio.getCaptureBlockSize());
        persistence.setInt("plugin." + this.getName() + ".playPointerAdjustment", Audio.getPlayPointerAdjustment());
        persistence.setInt("plugin." + this.getName() + ".capturePointerAdjustment", Audio.getCapturePointerAdjustment());
    }

    @Override
    public String getName() {
        return "playLoopRec";
    }

    @Override
    public JMenuItem createMenuItem() {
        return super.createMenuItem(80);
    }

    @Override
    public void reload() {
        super.reload();
        try {
            this.playBlockSize.setData(Audio.getPlayBlockSize());
            this.captureBlockSize.setData(Audio.getCaptureBlockSize());
            this.playPointerAdjustment.setData(Audio.getPlayPointerAdjustment());
            this.capturePointerAdjustment.setData(Audio.getCapturePointerAdjustment());
            Audio audio = this.getFocussedClip().getAudio();
            this.loop.setSelected(audio.isLooping());
            this.loop.setEnabled(!audio.isAutoGrowing());
            this.autoGrow.setSelected(audio.isAutoGrowing());
            this.sampleRate.setData(this.getFocussedClip().getSampleRate());
            this.getFocussedClip().getAudio().limitLoopPointers();
            this.getFocussedClip().getAudio().setAudioListener(this.eventDispatcher);
            this.updateButtons();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    protected boolean isFocussingMouseEvents() {
        return true;
    }

    private void initCursors() {
        this.defaultCursor = new Cursor(0);
        this.placeCursor = new Cursor(12);
        this.scratchCursor = this.createCustomCursor("scratchPlayCursor");
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        AClip aClip = ((GClipPanel)mouseEvent.getSource()).getClip();
        int n = mouseEvent.getPoint().x;
        int n2 = Math.abs(aClip.getAudio().getPlotter().getXLoopStartPointer() - n);
        int n3 = Math.abs(aClip.getAudio().getPlotter().getXLoopEndPointer() - n);
        this.selectedPointer = 0;
        if (n3 < 5) {
            this.selectedPointer = 2;
            ((Component)mouseEvent.getSource()).setCursor(this.placeCursor);
        } else if (n2 < 5) {
            this.selectedPointer = 1;
            ((Component)mouseEvent.getSource()).setCursor(this.placeCursor);
        } else {
            ((Component)mouseEvent.getSource()).setCursor(this.defaultCursor);
        }
        if (GToolkit.isShiftKey(mouseEvent)) {
            ((Component)mouseEvent.getSource()).setCursor(this.scratchCursor);
            ALayer aLayer = this.getFocussedClip().getSelectedLayer();
            int n4 = aLayer.getPlotter().getInsideChannelIndex(mouseEvent.getPoint());
            if (n4 >= 0) {
                AChannel aChannel = aLayer.getChannel(n4);
                AChannelPlotter aChannelPlotter = aChannel.getPlotter();
                int n5 = (int)aChannelPlotter.graphToSampleX(mouseEvent.getPoint().x);
                this.pluginHandler.getFocussedClip().getAudio().scratch(n5);
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.selectedPointer != 0) {
            AClip aClip = ((GClipPanel)mouseEvent.getSource()).getClip();
            int n = (int)aClip.getSelectedLayer().getChannel(0).getPlotter().graphToSampleX(mouseEvent.getPoint().x);
            switch (this.selectedPointer) {
                case 1: {
                    aClip.getAudio().setLoopStartPointer(n);
                    break;
                }
                case 2: {
                    aClip.getAudio().setLoopEndPointer(n);
                }
            }
            this.repaintFocussedClipEditor();
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        int n = mouseWheelEvent.getWheelRotation();
        int n2 = (int)(this.getFocussedClip().getSampleRate() * 1.0f);
        this.getFocussedClip().getAudio().scratch(this.getFocussedClip().getAudio().getPlayPointer() + (n > 0 ? n2 : -n2));
    }

    private void updateButtons() {
        switch (this.getFocussedClip().getAudio().getState()) {
            case 2: {
                this.pauseButton.setIcon(this.pausePassive);
                this.playButton.setIcon(this.playActive);
                this.recButton.setIcon(this.recPassive);
                break;
            }
            case 3: {
                this.pauseButton.setIcon(this.pauseActive);
                this.playButton.setIcon(this.playPassive);
                this.recButton.setIcon(this.recPassive);
                break;
            }
            case 4: {
                this.pauseButton.setIcon(this.pausePassive);
                this.playButton.setIcon(this.playPassive);
                this.recButton.setIcon(this.recActive);
                break;
            }
            default: {
                this.pauseButton.setIcon(this.pausePassive);
                this.playButton.setIcon(this.playPassive);
                this.recButton.setIcon(this.recPassive);
            }
        }
    }

    private void initGui() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.pauseActive = this.loadIcon("pauseActive");
        this.pausePassive = this.loadIcon("pausePassive");
        this.playActive = this.loadIcon("playActive");
        this.playPassive = this.loadIcon("playPassive");
        this.recActive = this.loadIcon("recActive");
        this.recPassive = this.loadIcon("recPassive");
        this.stopButton = new JButton(this.loadIcon("stop"));
        this.stopButton.setToolTipText(GLanguage.translate("stop"));
        this.stopButton.setPreferredSize(new Dimension(26, 26));
        this.pauseButton = new JButton(this.pausePassive);
        this.pauseButton.setToolTipText(GLanguage.translate("pause"));
        this.pauseButton.setPreferredSize(new Dimension(26, 26));
        this.rewButton = new JButton(this.loadIcon("rewind"));
        this.rewButton.setToolTipText(GLanguage.translate("rewind"));
        this.rewButton.setPreferredSize(new Dimension(26, 26));
        this.playButton = new JButton(this.playPassive);
        this.playButton.setToolTipText(GLanguage.translate("play"));
        this.playButton.setPreferredSize(new Dimension(26, 26));
        this.forwButton = new JButton(this.loadIcon("forwind"));
        this.forwButton.setToolTipText(GLanguage.translate("forwind"));
        this.forwButton.setPreferredSize(new Dimension(26, 26));
        this.recButton = new JButton(this.recPassive);
        this.recButton.setToolTipText(GLanguage.translate("record"));
        this.recButton.setPreferredSize(new Dimension(26, 26));
        this.loop = new JCheckBox(GLanguage.translate("loop"));
        this.autoGrow = new JCheckBox(GLanguage.translate("autoGrow"));
        JPanel jPanel = new JPanel();
        UiCartesianLayout uiCartesianLayout = new UiCartesianLayout(jPanel, 14, 2);
        uiCartesianLayout.setPreferredCellSize(new Dimension(35, 35));
        jPanel.setLayout(uiCartesianLayout);
        jPanel.add((Component)this.stopButton, new Rectangle(0, 0, 1, 1));
        jPanel.add((Component)this.pauseButton, new Rectangle(1, 0, 1, 1));
        jPanel.add((Component)this.rewButton, new Rectangle(3, 0, 1, 1));
        jPanel.add((Component)this.playButton, new Rectangle(4, 0, 1, 1));
        jPanel.add((Component)this.forwButton, new Rectangle(5, 0, 1, 1));
        jPanel.add((Component)this.recButton, new Rectangle(7, 0, 1, 1));
        jPanel.add((Component)this.loop, new Rectangle(8, 0, 2, 1));
        jPanel.add((Component)this.autoGrow, new Rectangle(10, 0, 3, 1));
        jPanel.add((Component)new JLabel(GLanguage.translate("sampleRate")), new Rectangle(0, 1, 3, 1));
        this.sampleRate = new UiControlText(15, true, false);
        this.sampleRate.setDataRange(100.0, 48000.0);
        jPanel.add((Component)this.sampleRate, new Rectangle(3, 1, 4, 1));
        jPanel.add((Component)new JLabel(GLanguage.translate("loopPoints")), new Rectangle(7, 1, 3, 1));
        String[] stringArray = new String[]{GLanguage.translate("wholeClip"), GLanguage.translate("zoomedRange"), GLanguage.translate("selection"), GLanguage.translate("measurePoints")};
        this.loopPointerSettings = new JComboBox<String>(stringArray);
        jPanel.add((Component)this.loopPointerSettings, new Rectangle(10, 1, 4, 1));
        jTabbedPane.add(GLanguage.translate("control"), jPanel);
        JPanel jPanel2 = new JPanel();
        UiCartesianLayout uiCartesianLayout2 = new UiCartesianLayout(jPanel2, 12, 2);
        uiCartesianLayout2.setPreferredCellSize(new Dimension(35, 35));
        jPanel2.setLayout(uiCartesianLayout2);
        jPanel2.add((Component)new JLabel(GLanguage.translate("playBlockSize")), new Rectangle(0, 0, 3, 1));
        this.playBlockSize = new UiControlText(15, true, false);
        this.playBlockSize.setDataRange(100.0, 10000.0);
        jPanel2.add((Component)this.playBlockSize, new Rectangle(3, 0, 3, 1));
        jPanel2.add((Component)new JLabel(GLanguage.translate("captureBlockSize")), new Rectangle(0, 1, 3, 1));
        this.captureBlockSize = new UiControlText(15, true, false);
        this.captureBlockSize.setDataRange(100.0, 10000.0);
        jPanel2.add((Component)this.captureBlockSize, new Rectangle(3, 1, 3, 1));
        jPanel2.add((Component)new JLabel(GLanguage.translate("playPointerAdjustment")), new Rectangle(6, 0, 3, 1));
        this.playPointerAdjustment = new UiControlText(15, true, false);
        this.playPointerAdjustment.setDataRange(-100000.0, 100000.0);
        jPanel2.add((Component)this.playPointerAdjustment, new Rectangle(9, 0, 3, 1));
        jPanel2.add((Component)new JLabel(GLanguage.translate("capturePointerAdjustment")), new Rectangle(6, 1, 3, 1));
        this.capturePointerAdjustment = new UiControlText(15, true, false);
        this.capturePointerAdjustment.setDataRange(-100000.0, 100000.0);
        jPanel2.add((Component)this.capturePointerAdjustment, new Rectangle(9, 1, 3, 1));
        Audio.setPlayBlockSize(this.persistance.getInt("plugin." + this.getName() + ".playBlockSize", 3000));
        Audio.setCaptureBlockSize(this.persistance.getInt("plugin." + this.getName() + ".captureBlockSize", 3000));
        Audio.setPlayPointerAdjustment(this.persistance.getInt("plugin." + this.getName() + ".playPointerAdjustment", -30000));
        Audio.setCapturePointerAdjustment(this.persistance.getInt("plugin." + this.getName() + ".capturePointerAdjustment", -3000));
        jTabbedPane.add(GLanguage.translate("configure"), jPanel2);
        this.frame.getContentPane().add(jTabbedPane);
        this.pack();
        this.eventDispatcher = new EventDispatcher();
        this.stopButton.addActionListener(this.eventDispatcher);
        this.pauseButton.addActionListener(this.eventDispatcher);
        this.rewButton.addActionListener(this.eventDispatcher);
        this.playButton.addActionListener(this.eventDispatcher);
        this.forwButton.addActionListener(this.eventDispatcher);
        this.recButton.addActionListener(this.eventDispatcher);
        this.loop.addActionListener(this.eventDispatcher);
        this.autoGrow.addActionListener(this.eventDispatcher);
        this.sampleRate.addControlListener(this.eventDispatcher);
        this.playBlockSize.addControlListener(this.eventDispatcher);
        this.captureBlockSize.addControlListener(this.eventDispatcher);
        this.playPointerAdjustment.addControlListener(this.eventDispatcher);
        this.capturePointerAdjustment.addControlListener(this.eventDispatcher);
        this.loopPointerSettings.addActionListener(this.eventDispatcher);
    }

    private class EventDispatcher
    implements ActionListener,
    UiControlListener,
    AudioListener {
        private boolean recording = false;

        private EventDispatcher() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GPPlayLoopRec.this.getFocussedClip().getAudio().setAudioListener(GPPlayLoopRec.this.eventDispatcher);
            try {
                if (actionEvent.getSource() == GPPlayLoopRec.this.stopButton) {
                    Debug.println(1, "plugin " + GPPlayLoopRec.this.getName() + " [stop] clicked");
                    GPPlayLoopRec.this.getFocussedClip().getAudio().stop();
                } else if (actionEvent.getSource() == GPPlayLoopRec.this.pauseButton) {
                    Debug.println(1, "plugin " + GPPlayLoopRec.this.getName() + " [pause] clicked");
                    GPPlayLoopRec.this.getFocussedClip().getAudio().pause();
                } else if (actionEvent.getSource() == GPPlayLoopRec.this.rewButton) {
                    Debug.println(1, "plugin " + GPPlayLoopRec.this.getName() + " [rew] clicked");
                    GPPlayLoopRec.this.getFocussedClip().getAudio().rewind();
                } else if (actionEvent.getSource() == GPPlayLoopRec.this.playButton) {
                    try {
                        Debug.println(1, "plugin " + GPPlayLoopRec.this.getName() + " [play] clicked");
                        GPPlayLoopRec.this.getFocussedClip().getAudio().play();
                    }
                    catch (AudioException audioException) {
                        GPPlayLoopRec.this.showErrorDialog("audioError", audioException.getMessage());
                    }
                } else if (actionEvent.getSource() == GPPlayLoopRec.this.forwButton) {
                    Debug.println(1, "plugin " + GPPlayLoopRec.this.getName() + " [forwind] clicked");
                    GPPlayLoopRec.this.getFocussedClip().getAudio().forwind();
                } else if (actionEvent.getSource() == GPPlayLoopRec.this.recButton) {
                    try {
                        Debug.println(1, "plugin " + GPPlayLoopRec.this.getName() + " [rec] clicked");
                        GPPlayLoopRec.this.getFocussedClip().getAudio().rec();
                    }
                    catch (AudioException audioException) {
                        GPPlayLoopRec.this.showErrorDialog("audioError", audioException.getMessage());
                    }
                } else if (actionEvent.getSource() == GPPlayLoopRec.this.loop) {
                    Debug.println(1, "plugin " + GPPlayLoopRec.this.getName() + " [loop] clicked");
                    GPPlayLoopRec.this.getFocussedClip().getAudio().setLooping(GPPlayLoopRec.this.loop.isSelected());
                } else if (actionEvent.getSource() == GPPlayLoopRec.this.autoGrow) {
                    Debug.println(1, "plugin " + GPPlayLoopRec.this.getName() + " [autoGrow] clicked");
                    GPPlayLoopRec.this.getFocussedClip().getAudio().setAutoGrowing(GPPlayLoopRec.this.autoGrow.isSelected());
                    GPPlayLoopRec.this.reload();
                } else if (actionEvent.getSource() == GPPlayLoopRec.this.loopPointerSettings) {
                    Debug.println(1, "plugin " + GPPlayLoopRec.this.getName() + " [loop pointer settings] clicked");
                    AClip aClip = GPPlayLoopRec.this.getFocussedClip();
                    Audio audio = aClip.getAudio();
                    AChannelPlotter aChannelPlotter = aClip.getSelectedLayer().getChannel(0).getPlotter();
                    AChannelSelection aChannelSelection = aClip.getSelectedLayer().getChannel(0).getSelection();
                    switch (GPPlayLoopRec.this.loopPointerSettings.getSelectedIndex()) {
                        case 0: {
                            audio.setLoopStartPointer(0);
                            audio.setLoopEndPointer(aClip.getMaxSampleLength());
                            break;
                        }
                        case 1: {
                            audio.setLoopStartPointer((int)aChannelPlotter.getXOffset());
                            audio.setLoopEndPointer((int)(aChannelPlotter.getXOffset() + aChannelPlotter.getXLength()));
                            break;
                        }
                        case 2: {
                            audio.setLoopStartPointer(aChannelSelection.getOffset());
                            audio.setLoopEndPointer(aChannelSelection.getOffset() + aChannelSelection.getLength());
                            break;
                        }
                        case 3: {
                            audio.setLoopStartPointer((int)GPMeasure.getLowerCursor());
                            audio.setLoopEndPointer((int)GPMeasure.getHigherCursor());
                        }
                    }
                    GPPlayLoopRec.this.repaintFocussedClipEditor();
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            GPPlayLoopRec.this.updateButtons();
        }

        @Override
        public void onDataChanging(UiControlEvent uiControlEvent) {
        }

        @Override
        public void onDataChanged(UiControlEvent uiControlEvent) {
            if (uiControlEvent.getSource() == GPPlayLoopRec.this.sampleRate) {
                Debug.println(1, "plugin " + GPPlayLoopRec.this.getName() + " [samplerate] changed");
                GPPlayLoopRec.this.getFocussedClip().setSampleRate((float)GPPlayLoopRec.this.sampleRate.getData());
            } else if (uiControlEvent.getSource() == GPPlayLoopRec.this.playBlockSize) {
                Audio.setPlayBlockSize((int)GPPlayLoopRec.this.playBlockSize.getData());
            } else if (uiControlEvent.getSource() == GPPlayLoopRec.this.captureBlockSize) {
                Audio.setCaptureBlockSize((int)GPPlayLoopRec.this.captureBlockSize.getData());
            } else if (uiControlEvent.getSource() == GPPlayLoopRec.this.playPointerAdjustment) {
                Audio.setPlayPointerAdjustment((int)GPPlayLoopRec.this.playPointerAdjustment.getData());
            } else if (uiControlEvent.getSource() == GPPlayLoopRec.this.capturePointerAdjustment) {
                Audio.setCapturePointerAdjustment((int)GPPlayLoopRec.this.capturePointerAdjustment.getData());
            }
        }

        @Override
        public void onValidate(UiControlEvent uiControlEvent) {
        }

        @Override
        public void onStateChange(int n) {
            GPPlayLoopRec.this.updateButtons();
            switch (n) {
                case 2: {
                    this.recording = false;
                    break;
                }
                case 3: {
                    if (this.recording) {
                        GPPlayLoopRec.this.reloadFocussedClipEditor();
                        GPPlayLoopRec.this.updateHistory(GLanguage.translate(GPPlayLoopRec.this.getName()));
                        Debug.println(1, "on state change: pause");
                    }
                    this.recording = false;
                    break;
                }
                case 4: {
                    this.recording = true;
                    break;
                }
                default: {
                    if (this.recording) {
                        GPPlayLoopRec.this.autoScaleFocussedClip();
                        GPPlayLoopRec.this.getFocussedClip().getAudio().setLoopEndPointer(GPPlayLoopRec.this.getFocussedClip().getMaxSampleLength());
                        GPPlayLoopRec.this.reloadFocussedClipEditor();
                        GPPlayLoopRec.this.updateHistory(GLanguage.translate(GPPlayLoopRec.this.getName()));
                        Debug.println(1, "on state change: others");
                    }
                    this.recording = false;
                }
            }
        }
    }
}

