/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.plugin;

import ch.laoe.clip.AChannel;
import ch.laoe.clip.AChannelSelection;
import ch.laoe.clip.MMArray;
import ch.laoe.operation.AOToolkit;
import ch.laoe.plugin.GPluginFrame;
import ch.laoe.plugin.GPluginHandler;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GControlTextX;
import ch.laoe.ui.GControlTextY;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.LProgressViewer;
import ch.laoe.ui.Laoe;
import ch.oli4.ui.UiCartesianLayout;
import ch.oli4.ui.control.UiControlText;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class GPFind
extends GPluginFrame {
    private JComboBox findAbsolute;
    private JComboBox findRelative;
    private UiControlText silenceThreshold;
    private UiControlText minimumWidth;
    private JButton find;
    private JButton previous;
    private JButton next;
    private EventDispatcher eventDispatcher;

    public GPFind(GPluginHandler gPluginHandler) {
        super(gPluginHandler);
        this.initGui();
    }

    @Override
    public String getName() {
        return "find";
    }

    @Override
    public JMenuItem createMenuItem() {
        return super.createMenuItem(70);
    }

    private void initGui() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        JPanel jPanel = new JPanel();
        UiCartesianLayout uiCartesianLayout = new UiCartesianLayout(jPanel, 10, 4);
        uiCartesianLayout.setPreferredCellSize(new Dimension(25, 35));
        jPanel.setLayout(uiCartesianLayout);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("find")), 0, 0, 3, 1);
        String[] stringArray = new String[]{GLanguage.translate("minimumValue"), GLanguage.translate("maximumValue")};
        this.findAbsolute = new JComboBox<String>(stringArray);
        uiCartesianLayout.add(this.findAbsolute, 3, 0, 7, 1);
        this.find = new JButton(GLanguage.translate("find"));
        uiCartesianLayout.add(this.find, 3, 3, 4, 1);
        jTabbedPane.add(GLanguage.translate("absolute"), jPanel);
        JPanel jPanel2 = new JPanel();
        UiCartesianLayout uiCartesianLayout2 = new UiCartesianLayout(jPanel2, 10, 4);
        uiCartesianLayout2.setPreferredCellSize(new Dimension(25, 35));
        jPanel2.setLayout(uiCartesianLayout2);
        uiCartesianLayout2.add(new JLabel(GLanguage.translate("find")), 0, 0, 3, 1);
        String[] stringArray2 = new String[]{GLanguage.translate("noise"), GLanguage.translate("silence"), GLanguage.translate("clipped")};
        this.findRelative = new JComboBox<String>(stringArray2);
        uiCartesianLayout2.add(this.findRelative, 3, 0, 7, 1);
        this.previous = new JButton(GLanguage.translate("previous"), this.loadIcon("left"));
        uiCartesianLayout2.add(this.previous, 1, 3, 4, 1);
        this.next = new JButton(GLanguage.translate("next"), this.loadIcon("right"));
        uiCartesianLayout2.add(this.next, 5, 3, 4, 1);
        jTabbedPane.add(GLanguage.translate("relative"), jPanel2);
        JPanel jPanel3 = new JPanel();
        UiCartesianLayout uiCartesianLayout3 = new UiCartesianLayout(jPanel3, 10, 4);
        uiCartesianLayout3.setPreferredCellSize(new Dimension(25, 35));
        jPanel3.setLayout(uiCartesianLayout3);
        uiCartesianLayout3.add(new JLabel(GLanguage.translate("silenceThreshold")), 0, 0, 5, 1);
        this.silenceThreshold = new GControlTextY(Laoe.getInstance(), 9, true, true);
        this.silenceThreshold.setDataRange(0.0, 1.0E9);
        this.silenceThreshold.setData(33.0);
        uiCartesianLayout3.add(this.silenceThreshold, 5, 0, 5, 1);
        uiCartesianLayout3.add(new JLabel(GLanguage.translate("minimumWidth")), 0, 1, 5, 1);
        this.minimumWidth = new GControlTextX(Laoe.getInstance(), 9, true, true);
        this.minimumWidth.setDataRange(1.0, 1.0E9);
        this.minimumWidth.setData(100.0);
        uiCartesianLayout3.add(this.minimumWidth, 5, 1, 5, 1);
        jTabbedPane.add(GLanguage.translate("parameter"), jPanel3);
        this.frame.getContentPane().add(jTabbedPane);
        this.pack();
        this.eventDispatcher = new EventDispatcher();
        this.find.addActionListener(this.eventDispatcher);
        this.previous.addActionListener(this.eventDispatcher);
        this.next.addActionListener(this.eventDispatcher);
    }

    @Override
    public void reload() {
        super.reload();
        this.silenceThreshold.refresh();
        this.minimumWidth.refresh();
    }

    private void onFind() {
        AChannel aChannel = this.getFocussedClip().getSelectedLayer().getSelectedChannel();
        AChannelSelection aChannelSelection = aChannel.getNonEmptySelection();
        MMArray mMArray = aChannel.getSamples();
        int n = aChannelSelection.getOffset();
        int n2 = aChannelSelection.getLength();
        switch (this.findAbsolute.getSelectedIndex()) {
            case 0: {
                aChannel.setSelection(new AChannelSelection(aChannel, AOToolkit.getNegativePeakIndex(mMArray, n, n2), 1));
                break;
            }
            case 1: {
                aChannel.setSelection(new AChannelSelection(aChannel, AOToolkit.getPositivePeakIndex(mMArray, n, n2), 1));
            }
        }
    }

    private void onPrevious() {
        AChannel aChannel = this.getFocussedClip().getSelectedLayer().getSelectedChannel();
        AChannelSelection aChannelSelection = aChannel.getNonEmptySelection();
        MMArray mMArray = aChannel.getSamples();
        int n = aChannelSelection.getOffset();
        float f = (float)this.silenceThreshold.getData();
        int n2 = (int)this.minimumWidth.getData();
        int n3 = 1 << this.getFocussedClip().getSampleWidth() - 1;
        switch (this.findRelative.getSelectedIndex()) {
            case 0: {
                aChannel.setSelection(AOToolkit.expandNoise(new AChannelSelection(aChannel, AOToolkit.getNextLowerNoiseIndex(mMArray, n - 1, n - 1, f, n2), 1), f, n2));
                break;
            }
            case 1: {
                aChannel.setSelection(AOToolkit.expandSilence(new AChannelSelection(aChannel, AOToolkit.getNextLowerSilenceIndex(mMArray, n - 1, n - 1, f, n2), 1), f, n2));
                break;
            }
            case 2: {
                aChannel.setSelection(AOToolkit.expandNoise(new AChannelSelection(aChannel, AOToolkit.getNextLowerNoiseIndex(mMArray, n - 1, n - 1, n3, 1), 1), n3, 1));
            }
        }
    }

    private void onNext() {
        AChannel aChannel = this.getFocussedClip().getSelectedLayer().getSelectedChannel();
        AChannelSelection aChannelSelection = aChannel.getNonEmptySelection();
        MMArray mMArray = aChannel.getSamples();
        int n = aChannelSelection.getOffset();
        int n2 = aChannelSelection.getLength();
        float f = (float)this.silenceThreshold.getData();
        int n3 = (int)this.minimumWidth.getData();
        int n4 = 1 << this.getFocussedClip().getSampleWidth() - 1;
        switch (this.findRelative.getSelectedIndex()) {
            case 0: {
                aChannel.setSelection(AOToolkit.expandNoise(new AChannelSelection(aChannel, AOToolkit.getNextUpperNoiseIndex(mMArray, n + n2 + 1, mMArray.getLength() - n - n2 - 1, f, n3), 1), f, n3));
                break;
            }
            case 1: {
                aChannel.setSelection(AOToolkit.expandSilence(new AChannelSelection(aChannel, AOToolkit.getNextUpperSilenceIndex(mMArray, n + n2 + 1, mMArray.getLength() - n - n2 - 1, f, n3), 1), f, n3));
                break;
            }
            case 2: {
                aChannel.setSelection(AOToolkit.expandNoise(new AChannelSelection(aChannel, AOToolkit.getNextUpperNoiseIndex(mMArray, n + n2 + 1, mMArray.getLength() - n - n2 - 1, n4, 1), 1), n4, 1));
            }
        }
    }

    private class EventDispatcher
    implements ActionListener {
        private EventDispatcher() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LProgressViewer.getInstance().entrySubProgress(0.7);
            if (actionEvent.getSource() == GPFind.this.find) {
                Debug.println(1, "plugin " + GPFind.this.getName() + " [find] clicked");
                GPFind.this.onFind();
            } else if (actionEvent.getSource() == GPFind.this.previous) {
                Debug.println(1, "plugin " + GPFind.this.getName() + " [previous] clicked");
                GPFind.this.onPrevious();
            } else if (actionEvent.getSource() == GPFind.this.next) {
                Debug.println(1, "plugin " + GPFind.this.getName() + " [next] clicked");
                GPFind.this.onNext();
            }
            GPFind.this.repaintFocussedClipEditor();
            LProgressViewer.getInstance().exitSubProgress();
        }
    }
}

