/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.plugin;

import ch.laoe.clip.AClip;
import ch.laoe.plugin.GPluginFrame;
import ch.laoe.plugin.GPluginHandler;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.GPersistence;
import ch.laoe.ui.LProgressViewer;
import ch.laoe.ui.Laoe;
import ch.oli4.ui.UiCartesianLayout;
import ch.oli4.ui.control.UiControlText;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;

public class GPFileNew
extends GPluginFrame {
    protected UiControlText samples;
    protected UiControlText sampleRate;
    protected UiControlText sampleWidth;
    protected UiControlText channels;
    protected UiControlText layers;
    protected JTextArea comments;
    protected JButton apply;
    private EventDispatcher eventDispatcher;

    public GPFileNew(GPluginHandler gPluginHandler) {
        super(gPluginHandler);
        this.initGui();
    }

    @Override
    public String getName() {
        return "new";
    }

    @Override
    public JMenuItem createMenuItem() {
        return super.createMenuItem(78);
    }

    protected void initGui() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JTabbedPane jTabbedPane = new JTabbedPane();
        JPanel jPanel2 = new JPanel();
        UiCartesianLayout uiCartesianLayout = new UiCartesianLayout(jPanel2, 16, 3);
        uiCartesianLayout.setPreferredCellSize(new Dimension(25, 35));
        jPanel2.setLayout(uiCartesianLayout);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("samples")), 0, 0, 4, 1);
        this.samples = new SamplesControl(10, true, true);
        this.samples.setUnit("s");
        this.samples.setDataRange(0.0, 1.0E10);
        uiCartesianLayout.add(this.samples, 4, 0, 6, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("sampleRate")), 0, 1, 4, 1);
        this.sampleRate = new UiControlText(8, true, false);
        this.sampleRate.setNumberFormat(1);
        this.sampleRate.setDataRange(100.0, 100000.0);
        uiCartesianLayout.add(this.sampleRate, 4, 1, 4, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("width")), 11, 1, 2, 1);
        this.sampleWidth = new UiControlText(3, true, false);
        this.sampleWidth.setNumberFormat(2);
        this.sampleWidth.setDataRange(1.0, 32.0);
        uiCartesianLayout.add(this.sampleWidth, 13, 1, 3, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("layers")), 0, 2, 4, 1);
        this.layers = new UiControlText(3, true, false);
        this.layers.setNumberFormat(2);
        this.layers.setDataRange(1.0, 32.0);
        uiCartesianLayout.add(this.layers, 4, 2, 3, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("channels")), 10, 2, 3, 1);
        this.channels = new UiControlText(3, true, false);
        this.channels.setNumberFormat(2);
        this.channels.setDataRange(1.0, 32.0);
        uiCartesianLayout.add(this.channels, 13, 2, 3, 1);
        jTabbedPane.addTab(GLanguage.translate("data"), jPanel2);
        JPanel jPanel3 = new JPanel();
        UiCartesianLayout uiCartesianLayout2 = new UiCartesianLayout(jPanel3, 15, 3);
        uiCartesianLayout2.setPreferredCellSize(new Dimension(25, 35));
        jPanel3.setLayout(uiCartesianLayout2);
        this.comments = new JTextArea(7, 35);
        this.comments.setLineWrap(true);
        this.comments.setWrapStyleWord(true);
        JScrollPane jScrollPane = new JScrollPane(this.comments);
        uiCartesianLayout2.add(jScrollPane, 0, 0, 15, 3);
        jTabbedPane.addTab(GLanguage.translate("comments"), jPanel3);
        jPanel.add((Component)jTabbedPane, "Center");
        JPanel jPanel4 = new JPanel();
        this.apply = new JButton(GLanguage.translate("apply"));
        jPanel4.add(this.apply);
        jPanel.add((Component)jPanel4, "South");
        this.samples.setEditable(true);
        this.sampleRate.setEditable(true);
        this.sampleWidth.setEditable(true);
        this.channels.setEditable(true);
        this.layers.setEditable(true);
        this.comments.setEditable(true);
        this.comments.setText(GPersistence.createPersistance().getString("clip.defaultComment"));
        this.samples.setData(10.0);
        this.sampleRate.setData(44100.0);
        this.sampleWidth.setData(16.0);
        this.channels.setData(2.0);
        this.layers.setData(1.0);
        this.eventDispatcher = new EventDispatcher();
        this.apply.addActionListener(this.eventDispatcher);
        this.frame.getContentPane().add(jPanel);
        this.pack();
    }

    @Override
    public void reload() {
        super.reload();
        this.samples.refresh();
        this.sampleRate.refresh();
        this.sampleWidth.refresh();
        this.channels.refresh();
        this.layers.refresh();
    }

    protected void storeValues() {
        int n;
        LProgressViewer.getInstance().entrySubProgress(this.getName());
        switch (this.samples.getUnitIndex()) {
            case 0: {
                n = (int)this.samples.getData();
                break;
            }
            case 1: {
                n = (int)(this.samples.getData() * this.sampleRate.getData());
                break;
            }
            case 2: {
                n = (int)(this.samples.getData() * this.sampleRate.getData() / 1000.0);
                break;
            }
            default: {
                n = (int)this.samples.getData();
            }
        }
        AClip aClip = new AClip((int)this.layers.getData(), (int)this.channels.getData(), n);
        aClip.setSampleRate((float)this.sampleRate.getData());
        aClip.setSampleWidth((int)this.sampleWidth.getData());
        aClip.setComments(this.comments.getText());
        Laoe.getInstance().addClipFrame(aClip);
        aClip.getPlotter().autoScaleX();
        int n2 = 1 << aClip.getSampleWidth();
        aClip.getPlotter().setYRange(-n2 / 2, n2);
        LProgressViewer.getInstance().exitSubProgress();
    }

    protected void loadValues() {
        try {
            this.samples.setData(this.pluginHandler.getFocussedClip().getMaxSampleLength());
            this.sampleRate.setData(this.pluginHandler.getFocussedClip().getSampleRate());
            this.sampleWidth.setData(this.pluginHandler.getFocussedClip().getSampleWidth());
            this.channels.setData(this.pluginHandler.getFocussedClip().getMaxNumberOfChannels());
            this.layers.setData(this.pluginHandler.getFocussedClip().getNumberOfLayers());
            this.comments.setText(this.pluginHandler.getFocussedClip().getComments());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private class SamplesControl
    extends UiControlText {
        public SamplesControl(int n, boolean bl, boolean bl2) {
            super(n, bl, bl2);
        }

        @Override
        protected void fillUnits() {
            this.addUnit(" ");
            this.addUnit("s");
            this.addUnit("ms");
        }
    }

    private class EventDispatcher
    implements ActionListener {
        private EventDispatcher() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == GPFileNew.this.apply) {
                Debug.println(1, "plugin " + GPFileNew.this.getName() + " [apply] clicked");
                GPFileNew.this.storeValues();
                GPFileNew.this.autoCloseNow();
            }
        }
    }
}

