/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.plugin;

import ch.laoe.clip.AClip;
import ch.laoe.clip.AClipSelection;
import ch.laoe.clip.ALayerSelection;
import ch.laoe.operation.AODistort;
import ch.laoe.plugin.GPluginFrame;
import ch.laoe.plugin.GPluginHandler;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GClipLayerChooser;
import ch.laoe.ui.GControlTextX;
import ch.laoe.ui.GControlTextY;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.LProgressViewer;
import ch.laoe.ui.LWorker;
import ch.laoe.ui.Laoe;
import ch.oli4.ui.UiCartesianLayout;
import ch.oli4.ui.control.UiControlText;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class GPDistortion
extends GPluginFrame {
    private String[] distortionTypeItem = new String[]{GLanguage.translate("clamping"), GLanguage.translate("noiseGate")};
    private JComboBox distortionType;
    private UiControlText threshold;
    private UiControlText clamping;
    private GClipLayerChooser layerChooser;
    private JButton applyConst;
    private JButton applyVar;
    private EventDispatcher eventDispatcher;

    public GPDistortion(GPluginHandler gPluginHandler) {
        super(gPluginHandler);
        this.initGui();
    }

    @Override
    public String getName() {
        return "distortion";
    }

    private void initGui() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        JPanel jPanel = new JPanel();
        UiCartesianLayout uiCartesianLayout = new UiCartesianLayout(jPanel, 10, 4);
        uiCartesianLayout.setPreferredCellSize(new Dimension(25, 35));
        jPanel.setLayout(uiCartesianLayout);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("mode")), 0, 0, 4, 1);
        this.distortionType = new JComboBox<String>(this.distortionTypeItem);
        uiCartesianLayout.add(this.distortionType, 4, 0, 6, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("threshold")), 0, 1, 4, 1);
        this.threshold = new GControlTextY(Laoe.getInstance(), 6, true, true);
        this.threshold.setDataRange(0.0, 1000000.0);
        this.threshold.setData(33.0);
        uiCartesianLayout.add(this.threshold, 4, 1, 6, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("clamping")), 0, 2, 4, 1);
        this.clamping = new GControlTextX(Laoe.getInstance(), 6, true, true);
        this.clamping.setDataRange(0.0, 1000000.0);
        this.clamping.setData(50.0);
        uiCartesianLayout.add(this.clamping, 4, 2, 6, 1);
        this.applyConst = new JButton(GLanguage.translate("apply"));
        uiCartesianLayout.add(this.applyConst, 3, 3, 4, 1);
        jTabbedPane.add(GLanguage.translate("constant"), jPanel);
        JPanel jPanel2 = new JPanel();
        UiCartesianLayout uiCartesianLayout2 = new UiCartesianLayout(jPanel2, 10, 4);
        uiCartesianLayout2.setPreferredCellSize(new Dimension(25, 35));
        jPanel2.setLayout(uiCartesianLayout2);
        this.layerChooser = new GClipLayerChooser(Laoe.getInstance(), "transferFunction");
        uiCartesianLayout2.add(this.layerChooser, 0, 0, 10, 3);
        this.applyVar = new JButton(GLanguage.translate("apply"));
        uiCartesianLayout2.add(this.applyVar, 3, 3, 4, 1);
        jTabbedPane.add(GLanguage.translate("f(amplitude)"), jPanel2);
        this.frame.getContentPane().add(jTabbedPane);
        this.pack();
        this.eventDispatcher = new EventDispatcher();
        this.applyConst.addActionListener(new LWorker(this.eventDispatcher));
        this.applyVar.addActionListener(new LWorker(this.eventDispatcher));
    }

    @Override
    public void start() {
        super.start();
    }

    @Override
    public void reload() {
        super.reload();
        this.layerChooser.reload();
        this.threshold.refresh();
        this.clamping.refresh();
    }

    private void onApplyConst() {
        ALayerSelection aLayerSelection = this.getFocussedClip().getSelectedLayer().getSelection();
        switch (this.distortionType.getSelectedIndex()) {
            case 0: {
                aLayerSelection.operateEachChannel(new AODistort((float)this.threshold.getData(), (float)this.clamping.getData(), 1));
                break;
            }
            case 1: {
                aLayerSelection.operateEachChannel(new AODistort((float)this.threshold.getData(), (float)this.clamping.getData(), 2));
            }
        }
    }

    private void onApplyVar() {
        ALayerSelection aLayerSelection = this.getFocussedClip().getSelectedLayer().getSelection();
        ALayerSelection aLayerSelection2 = this.layerChooser.getSelectedLayer().createSelection();
        AClipSelection aClipSelection = new AClipSelection(new AClip());
        aClipSelection.addLayerSelection(aLayerSelection);
        aClipSelection.addLayerSelection(aLayerSelection2);
        aClipSelection.operateLayer0WithLayer1(new AODistort());
    }

    private class EventDispatcher
    implements ActionListener {
        private EventDispatcher() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LProgressViewer.getInstance().entrySubProgress(GPDistortion.this.getName());
            LProgressViewer.getInstance().entrySubProgress(0.7);
            if (actionEvent.getSource() == GPDistortion.this.applyConst) {
                Debug.println(1, "plugin " + GPDistortion.this.getName() + " [apply const] clicked");
                GPDistortion.this.onApplyConst();
                GPDistortion.this.autoCloseNow();
            } else if (actionEvent.getSource() == GPDistortion.this.applyVar) {
                Debug.println(1, "plugin " + GPDistortion.this.getName() + " [apply var] clicked");
                GPDistortion.this.onApplyVar();
                GPDistortion.this.autoCloseNow();
            }
            GPDistortion.this.updateHistory(GLanguage.translate(GPDistortion.this.getName()));
            LProgressViewer.getInstance().exitSubProgress();
            LProgressViewer.getInstance().exitSubProgress();
            GPDistortion.this.reloadFocussedClipEditor();
        }
    }
}

